# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class OperationIncrementalPullMode(str, enum.Enum):
    """
    Strategy for fetching data from the source API.
    """

    INCREMENTAL = "incremental"
    """
    Fetch only data changed since last execution (default, more efficient).
    """

    FULL_SNAPSHOT = "full_snapshot"
    """
    Fetch all data every time (useful for small datasets or when changes are hard to track).
    """

    _UNKNOWN = "__OPERATIONINCREMENTALPULLMODE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "OperationIncrementalPullMode":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        incremental: typing.Callable[[], T_Result],
        full_snapshot: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is OperationIncrementalPullMode.INCREMENTAL:
            return incremental()
        if self is OperationIncrementalPullMode.FULL_SNAPSHOT:
            return full_snapshot()
        return _unknown_member(self._value_)
