# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...organization_base.types.environment import Environment
from ...organization_webhook_base.types.webhook_filter import WebhookFilter
from .organization_webhook_secret import OrganizationWebhookSecret
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateOrganizationWebhookRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly slug for this webhook
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Fullname for this webhook
    """

    environment: typing.Optional[Environment] = pydantic.Field(default=None)
    """
    Environment that the webhook is configured for. Only events for accounts associated with this environment will trigger the webhook.
    """

    filters: typing.List[WebhookFilter] = pydantic.Field()
    """
    Specifies which Webhooks to send.
    """

    url: str = pydantic.Field()
    """
    URL that webhooks will be sent to.
    """

    secret: OrganizationWebhookSecret = pydantic.Field()
    """
    Secret used for signing webhooks. This value is used to verify the authenticity of the webhook payload.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
