# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from ...organization_webhook_base.types.webhook_id import WebhookId
import pydantic
from ...organization_base.types.environment import Environment
import typing
from ...organization_webhook_base.types.webhook_filter import WebhookFilter
from ...credentials.types.credential_id import CredentialId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OrganizationWebhook(Base):
    id: WebhookId
    fullname: str = pydantic.Field()
    """
    Human friendly slug for this webhook
    """

    environment: Environment = pydantic.Field()
    """
    Environment that the webhook is configured for. Only events associated with this environment will trigger the webhook.
    """

    filters: typing.List[WebhookFilter] = pydantic.Field()
    """
    Specifies which Webhooks to send.
    """

    url: str = pydantic.Field()
    """
    URL that webhooks will be sent to
    """

    credential_id: CredentialId = pydantic.Field()
    """
    Credential contain secret
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
