# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...role_base.types.role_name import RoleName
import pydantic
from ...role_base.types.adhoc_role import AdhocRole
from ...common.types.id import Id
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Permission(UncheckedBaseModel):
    role_binding: typing.Optional[typing.List[RoleName]] = pydantic.Field(default=None)
    """
    Roles granted to this token.
    """

    adhoc_role: typing.Optional[AdhocRole] = pydantic.Field(default=None)
    """
    Adhoc role granted to this token.
    """

    resource_id: Id = pydantic.Field()
    """
    ID of the resource that this permission grants access to.
    """

    resource_type: str = pydantic.Field()
    """
    Type of the resource that this permission grants access to. Must be one of the following: "organization, "integration"
    """

    parent_id: Id = pydantic.Field()
    """
    Token parentId
    """

    id: Id = pydantic.Field()
    """
    Token Id
    """

    organization_id: Id = pydantic.Field()
    """
    Token organizationId
    """

    root_organization_id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    Token root organizationId
    """

    member_id: Id = pydantic.Field()
    """
    Token memberId
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
