# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...permissionset_base.types.permissions import Permissions
import typing
import pydantic
from .resource_restrictions import ResourceRestrictions
from .api_permission_map import ApiPermissionMap
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PermissionSet(UncheckedBaseModel):
    name: Permissions
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of when the permission set should be used and what permissions are granted by the permission set.
    """

    resource_restrictions: typing.Optional[typing.List[ResourceRestrictions]] = (
        pydantic.Field(default=None)
    )
    """
    Resources that can be used with this permission set
    """

    permissions: ApiPermissionMap = pydantic.Field()
    """
    API permissions granted by the permission set.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
