# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .aws_provider_credential import AwsProviderCredential
from .aws_region import AwsRegion
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AppsecAmazonInspector(UncheckedBaseModel):
    """
    Configuration for Amazon Inspector as an application security provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/amazon-inspector-appsec-setup)
    """

    credential: AwsProviderCredential
    region: AwsRegion = pydantic.Field()
    """
    The [AWS region](https://docs.aws.amazon.com/global-infrastructure/latest/regions/aws-regions.html) to use for the Amazon Inspector provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
