# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .open_text_core_application_security_credential import (
    OpenTextCoreApplicationSecurityCredential,
)
import pydantic
from .open_text_core_application_security_url import OpenTextCoreApplicationSecurityUrl
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AppsecOpenTextCoreApplicationSecurity(UncheckedBaseModel):
    """
    Configuration for OpenText Core Application Security (formerly Fortify On Demand) as an application security provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/opentext-core-applicationsecurity-appsec-setup)
    """

    credential: OpenTextCoreApplicationSecurityCredential = pydantic.Field()
    """
    Credentials used for accessing the OpenText Core Application Security API.
    """

    url: OpenTextCoreApplicationSecurityUrl = pydantic.Field()
    """
    Base URL for the OpenText Core Application Security API. This URL should be the same as the URL used to access the OpenText Core Application Security web interface.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
