# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ...credentials.types.aws_credential_id import AwsCredentialId
from ...credentials.types.basic_credential_id import BasicCredentialId
from ...credentials.types.o_auth_client_credential_id import OAuthClientCredentialId
from ...credentials.types.secret_credential_id import SecretCredentialId
from ...credentials.types.token_credential_id import TokenCredentialId
import typing_extensions
from ...core.unchecked_base_model import UnionMetadata


class CustomCredential_Aws(UncheckedBaseModel):
    type: typing.Literal["aws"] = "aws"
    access_key_id: str
    secret_access_key: str
    session: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CustomCredential_AwsId(UncheckedBaseModel):
    value: AwsCredentialId
    type: typing.Literal["aws_id"] = "aws_id"

    class Config:
        smart_union = True


class CustomCredential_Basic(UncheckedBaseModel):
    type: typing.Literal["basic"] = "basic"
    username: str
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CustomCredential_BasicId(UncheckedBaseModel):
    value: BasicCredentialId
    type: typing.Literal["basic_id"] = "basic_id"

    class Config:
        smart_union = True


class CustomCredential_OAuthClient(UncheckedBaseModel):
    type: typing.Literal["o_auth_client"] = "o_auth_client"
    token_url: typing.Optional[str] = None
    client_id: str
    client_secret: str
    extra: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CustomCredential_OAuthClientId(UncheckedBaseModel):
    value: OAuthClientCredentialId
    type: typing.Literal["o_auth_client_id"] = "o_auth_client_id"

    class Config:
        smart_union = True


class CustomCredential_Secret(UncheckedBaseModel):
    type: typing.Literal["secret"] = "secret"
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CustomCredential_SecretId(UncheckedBaseModel):
    value: SecretCredentialId
    type: typing.Literal["secret_id"] = "secret_id"

    class Config:
        smart_union = True


class CustomCredential_Token(UncheckedBaseModel):
    type: typing.Literal["token"] = "token"
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class CustomCredential_TokenId(UncheckedBaseModel):
    value: TokenCredentialId
    type: typing.Literal["token_id"] = "token_id"

    class Config:
        smart_union = True


CustomCredential = typing_extensions.Annotated[
    typing.Union[
        CustomCredential_Aws,
        CustomCredential_AwsId,
        CustomCredential_Basic,
        CustomCredential_BasicId,
        CustomCredential_OAuthClient,
        CustomCredential_OAuthClientId,
        CustomCredential_Secret,
        CustomCredential_SecretId,
        CustomCredential_Token,
        CustomCredential_TokenId,
    ],
    UnionMetadata(discriminant="type"),
]
