# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ...credentials.types.basic_credential_id import BasicCredentialId
from ...credentials.types.o_auth_client_credential_id import OAuthClientCredentialId
from ...credentials.types.token_credential_id import TokenCredentialId
import typing_extensions
from ...core.unchecked_base_model import UnionMetadata


class ElasticsearchCredential_Basic(UncheckedBaseModel):
    type: typing.Literal["basic"] = "basic"
    username: str
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ElasticsearchCredential_BasicId(UncheckedBaseModel):
    value: BasicCredentialId
    type: typing.Literal["basic_id"] = "basic_id"

    class Config:
        smart_union = True


class ElasticsearchCredential_OAuthClient(UncheckedBaseModel):
    type: typing.Literal["o_auth_client"] = "o_auth_client"
    token_url: typing.Optional[str] = None
    client_id: str
    client_secret: str
    extra: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ElasticsearchCredential_OAuthClientId(UncheckedBaseModel):
    value: OAuthClientCredentialId
    type: typing.Literal["o_auth_client_id"] = "o_auth_client_id"

    class Config:
        smart_union = True


class ElasticsearchCredential_Token(UncheckedBaseModel):
    type: typing.Literal["token"] = "token"
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class ElasticsearchCredential_TokenId(UncheckedBaseModel):
    value: TokenCredentialId
    type: typing.Literal["token_id"] = "token_id"

    class Config:
        smart_union = True


ElasticsearchCredential = typing_extensions.Annotated[
    typing.Union[
        ElasticsearchCredential_Basic,
        ElasticsearchCredential_BasicId,
        ElasticsearchCredential_OAuthClient,
        ElasticsearchCredential_OAuthClientId,
        ElasticsearchCredential_Token,
        ElasticsearchCredential_TokenId,
    ],
    UnionMetadata(discriminant="type"),
]
