# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .open_search_credential import OpenSearchCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SiemOpenSearch(UncheckedBaseModel):
    """
    Configuration for OpenSearch search and analytics engine. Supports both managed and self-hosted OpenSearch deployments
    """

    create_index: typing.Optional[str] = pydantic.Field(default=None)
    """
    The index or data stream to use when writing events. Defaults to the 'index' setting if not set.
    """

    credential: OpenSearchCredential
    index: typing.Optional[str] = pydantic.Field(default=None)
    """
    The index, data stream, or index alias to read events from.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the OpenSearch TLS certificate.
    """

    url: str = pydantic.Field()
    """
    Base URL for the OpenSearch API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
