# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .google_chronicle_credential import GoogleChronicleCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SinkGoogleSecOps(UncheckedBaseModel):
    """
    Configuration for Google Security Operations (formerly Google Chronicle) as a Sink Provider connecting via the older Malachite API.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-chronicle-setup)
    """

    credential: GoogleChronicleCredential = pydantic.Field()
    """
    Credentials used when writing events.
    """

    customer_id: str = pydantic.Field()
    """
    The customer ID reported when writing events.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Google SecOps Ingestion API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
