# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SinkQRadar(UncheckedBaseModel):
    """
    Configuration for IBM QRadar Sink.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/qradar-sink-setup)
    """

    collection_port: int = pydantic.Field()
    """
    Port used by QRadar to accept incoming HTTP Receiver events.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the QRadar TLS certificate. This should only be used for testing purposes and is not recommended in production environments.
    """

    url: str = pydantic.Field()
    """
    Base URL for the QRadar API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
