# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .aws_s_3_credential import AwsS3Credential
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class StorageAwsS3(UncheckedBaseModel):
    """
    Configuration for Amazon S3.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/aws-s3-storage-setup)
    """

    bucket: str = pydantic.Field()
    """
    Name of the Amazon S3 bucket where files are stored.
    """

    credential: AwsS3Credential
    endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    Endpoint used for connecting to Amazon S3 the external service. If not provided, the default Amazon S3 endpoint will be used.
    """

    region: str = pydantic.Field()
    """
    AWS region where the Amazon S3 bucket is located.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
