# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .gcs_credential import GcsCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class StorageGcs(UncheckedBaseModel):
    """
    Configuration for Google Cloud Storage for storing unstructured data

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-gcs-storage-setup)
    """

    bucket: str = pydantic.Field()
    """
    Name of the bucket where files are stored.
    """

    credential: GcsCredential
    region: str = pydantic.Field()
    """
    Google Cloud region where the bucket is located.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
