# Changelog

## [integrations/nvidia-v0.3.0] - 2025-06-20

### 🐛 Bug Fixes

- Fix Nvidia types + add py.typed (#1970)

### 🧹 Chores

- Align core-integrations Hatch scripts (#1898)
- Update md files for new hatch scripts (#1911)

## [integrations/nvidia-v0.2.0] - 2025-06-05

### 🚀 Features

- Add NvidiaChatGenerator based on OpenAIChatGenerator (#1776)


## [integrations/nvidia-v0.1.8] - 2025-05-28

### 🌀 Miscellaneous

- Add pins for Nvidia (#1846)

## [integrations/nvidia-v0.1.7] - 2025-04-03


### 🧪 Testing

- Reduce Nvidia API calls in integration tests (#1432)
- Add test cases for all utils methods for Nvidia integration (#1458)
- Add unit tests for Nvidia NimBackend (#1546)

### ⚙️ CI

- Review testing workflows (#1541)

### 🧹 Chores

- Remove Python 3.8 support (#1421)

### 🌀 Miscellaneous

- Fix: nvidia-haystack remove init files to make them namespace packages (#1594)

## [integrations/nvidia-v0.1.6] - 2025-02-11

### 🚀 Features

- Add nvidia latest embedding models (#1364)


## [integrations/nvidia-v0.1.5] - 2025-02-04

### 🌀 Miscellaneous

- Client Reject Incompatible models (#1056)
- Base url validation fix and cleanup (#1349)

## [integrations/nvidia-v0.1.4] - 2025-01-08

### 🌀 Miscellaneous

- Feat: add nv-rerank-qa-mistral-4b:1 reranker (#1278)

## [integrations/nvidia-v0.1.3] - 2025-01-02

### 🚀 Features

- Improvements to NvidiaRanker and adding user input timeout (#1193)
- Add model `nvidia/llama-3.2-nv-rerankqa-1b-v2` to `_MODEL_ENDPOINT_MAP` (#1260)

### 🧹 Chores

- Fix linting/isort (#1215)


## [integrations/nvidia-v0.1.1] - 2024-11-14

### 🐛 Bug Fixes

- Fixes to NvidiaRanker (#1191)


## [integrations/nvidia-v0.1.0] - 2024-11-13

### 🚀 Features

- Update default embedding model to nvidia/nv-embedqa-e5-v5 (#1015)
- Add NVIDIA NIM ranker support (#1023)
- Raise error when attempting to embed empty documents/strings with Nvidia embedders (#1118)

### 🐛 Bug Fixes

- Lints in `nvidia-haystack` (#993)
- Missing Nvidia embedding truncate mode (#1043)

### 🚜 Refactor

- Remove deprecated Nvidia Cloud Functions backend and related code. (#803)

### 📚 Documentation

- Update Nvidia API docs (#1031)

### 🧪 Testing

- Do not retry tests in `hatch run test` command (#954)

### ⚙️ CI

- Retry tests to reduce flakyness (#836)
- Adopt uv as installer (#1142)

### 🧹 Chores

- Update ruff invocation to include check parameter (#853)
- Update ruff linting scripts and settings (#1105)

### 🌀 Miscellaneous

- Fix: make hosted nim default (#734)
- Fix: align tests and docs on NVIDIA_API_KEY (instead of NVIDIA_CATALOG_API_KEY) (#731)
- Ci: install `pytest-rerunfailures` where needed; add retry config to `test-cov` script (#845)
- Raise warning for base_url ../embeddings .../completions .../rankings (#922)
- Update NvidiaGenerator docstrings (#966)
-  Add default model for NVIDIA HayStack local NIM endpoints (#915)
- Feat: add nvidia/llama-3.2-nv-rerankqa-1b-v1 to set of known ranking models (#1183)

## [integrations/nvidia-v0.0.3] - 2024-05-22

### 📚 Documentation

- Update docstrings of Nvidia integrations (#599)

### ⚙️ CI

- Add generate docs to Nvidia workflow (#603)

### 🌀 Miscellaneous

- Remove references to Python 3.7 (#601)
- Chore: add license classifiers (#680)
- Chore: change the pydoc renderer class (#718)
- Update Nvidia integration to support new endpoints (#701)
- Docs: add missing api references (#728)
- Update _nim_backend.py (#744)

## [integrations/nvidia-v0.0.2] - 2024-03-18

### 📚 Documentation

- Disable-class-def (#556)

### 🌀 Miscellaneous

- Make tests show coverage (#566)
- Add NIM backend support (#597)

## [integrations/nvidia-v0.0.1] - 2024-03-07

### 🚀 Features

- Add `NvidiaTextEmbedder`, `NvidiaDocumentEmbedder` and co. (#537)

### 🐛 Bug Fixes

- `nvidia-haystack`- Handle non-strict env var secrets correctly (#543)

### 🌀 Miscellaneous

- Add `NvidiaGenerator` (#557)
- Add missing import in NvidiaGenerator docstring (#559)

## [integrations/nvidia-v0.0.0] - 2024-03-01

### 🌀 Miscellaneous

- Add Nvidia integration scaffold (#515)

<!-- generated by git-cliff -->
