# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AdminRoleTargetsArgs', 'AdminRoleTargets']

@pulumi.input_type
class AdminRoleTargetsArgs:
    def __init__(__self__, *,
                 role_type: pulumi.Input[_builtins.str],
                 user_id: pulumi.Input[_builtins.str],
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AdminRoleTargets resource.
        :param pulumi.Input[_builtins.str] role_type: Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        :param pulumi.Input[_builtins.str] user_id: User associated with the role
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups: List of group IDs. Conflicts with apps
        """
        pulumi.set(__self__, "role_type", role_type)
        pulumi.set(__self__, "user_id", user_id)
        if apps is not None:
            pulumi.set(__self__, "apps", apps)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[_builtins.str]:
        """
        User associated with the role
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter
    def apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        """
        return pulumi.get(self, "apps")

    @apps.setter
    def apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "apps", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of group IDs. Conflicts with apps
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups", value)


@pulumi.input_type
class _AdminRoleTargetsState:
    def __init__(__self__, *,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdminRoleTargets resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups: List of group IDs. Conflicts with apps
        :param pulumi.Input[_builtins.str] role_id: ID of a role
        :param pulumi.Input[_builtins.str] role_type: Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        :param pulumi.Input[_builtins.str] user_id: User associated with the role
        """
        if apps is not None:
            pulumi.set(__self__, "apps", apps)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        """
        return pulumi.get(self, "apps")

    @apps.setter
    def apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "apps", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of group IDs. Conflicts with apps
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a role
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_type", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User associated with the role
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("okta:index/adminRoleTargets:AdminRoleTargets")
class AdminRoleTargets(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages targets for administrator roles.

        This resource allows you to define permissions for admin roles into a smaller subset of Groups or Apps within your org.
        You can define admin roles to target Groups, Applications, and Application Instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AdminRoleTargets("example",
            user_id="<user_id>",
            role_type="APP_ADMIN",
            apps=[
                "oidc_client.<app_id>",
                "facebook",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/adminRoleTargets:AdminRoleTargets example <user_id>/<role_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups: List of group IDs. Conflicts with apps
        :param pulumi.Input[_builtins.str] role_type: Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        :param pulumi.Input[_builtins.str] user_id: User associated with the role
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdminRoleTargetsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages targets for administrator roles.

        This resource allows you to define permissions for admin roles into a smaller subset of Groups or Apps within your org.
        You can define admin roles to target Groups, Applications, and Application Instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.AdminRoleTargets("example",
            user_id="<user_id>",
            role_type="APP_ADMIN",
            apps=[
                "oidc_client.<app_id>",
                "facebook",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/adminRoleTargets:AdminRoleTargets example <user_id>/<role_type>
        ```

        :param str resource_name: The name of the resource.
        :param AdminRoleTargetsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdminRoleTargetsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdminRoleTargetsArgs.__new__(AdminRoleTargetsArgs)

            __props__.__dict__["apps"] = apps
            __props__.__dict__["groups"] = groups
            if role_type is None and not opts.urn:
                raise TypeError("Missing required property 'role_type'")
            __props__.__dict__["role_type"] = role_type
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["role_id"] = None
        super(AdminRoleTargets, __self__).__init__(
            'okta:index/adminRoleTargets:AdminRoleTargets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_type: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AdminRoleTargets':
        """
        Get an existing AdminRoleTargets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] apps: List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups: List of group IDs. Conflicts with apps
        :param pulumi.Input[_builtins.str] role_id: ID of a role
        :param pulumi.Input[_builtins.str] role_type: Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        :param pulumi.Input[_builtins.str] user_id: User associated with the role
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdminRoleTargetsState.__new__(_AdminRoleTargetsState)

        __props__.__dict__["apps"] = apps
        __props__.__dict__["groups"] = groups
        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["role_type"] = role_type
        __props__.__dict__["user_id"] = user_id
        return AdminRoleTargets(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def apps(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
        """
        return pulumi.get(self, "apps")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of group IDs. Conflicts with apps
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a role
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the role that is assigned to the user and supports optional targets. See [API Docs](https://developer.okta.com/docs/api/openapi/okta-management/guides/roles/#standard-roles)
        """
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        User associated with the role
        """
        return pulumi.get(self, "user_id")

