# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SocialArgs', 'Social']

@pulumi.input_type
class SocialArgs:
    def __init__(__self__, *,
                 scopes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 apple_kid: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Social resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[_builtins.str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[_builtins.str] apple_private_key: The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        :param pulumi.Input[_builtins.str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[_builtins.str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "type", type)
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if apple_kid is not None:
            pulumi.set(__self__, "apple_kid", apple_kid)
        if apple_private_key is not None:
            pulumi.set(__self__, "apple_private_key", apple_private_key)
        if apple_team_id is not None:
            pulumi.set(__self__, "apple_team_id", apple_team_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The scopes of the IdP.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_link_action", value)

    @_builtins.property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @_builtins.property
    @pulumi.getter(name="appleKid")
    def apple_kid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client
        """
        return pulumi.get(self, "apple_kid")

    @apple_kid.setter
    def apple_kid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apple_kid", value)

    @_builtins.property
    @pulumi.getter(name="applePrivateKey")
    def apple_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        """
        return pulumi.get(self, "apple_private_key")

    @apple_private_key.setter
    def apple_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apple_private_key", value)

    @_builtins.property
    @pulumi.getter(name="appleTeamId")
    def apple_team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Team ID associated with your Apple developer account
        """
        return pulumi.get(self, "apple_team_id")

    @apple_team_id.setter
    def apple_team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apple_team_id", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client secret issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @_builtins.property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_filters", value)

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_mode", value)

    @_builtins.property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_clock_skew", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "profile_master", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_action", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_type", value)

    @_builtins.property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suspended_action", value)

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_template", value)


@pulumi.input_type
class _SocialState:
    def __init__(__self__, *,
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 apple_kid: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_url: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 token_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 token_url: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_audience: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_kid: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_revocation: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_revocation_cache_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Social resources.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[_builtins.str] apple_private_key: The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        :param pulumi.Input[_builtins.str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[_builtins.str] authorization_binding: The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[_builtins.str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[_builtins.str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] token_binding: The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[_builtins.str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[_builtins.str] trust_audience: Trust audience for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] trust_issuer: Trust issuer for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] trust_kid: Trust kid for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] trust_revocation: Trust revocation for the Okta IdP instance.
        :param pulumi.Input[_builtins.int] trust_revocation_cache_lifetime: Trust revocation cache lifetime for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if apple_kid is not None:
            pulumi.set(__self__, "apple_kid", apple_kid)
        if apple_private_key is not None:
            pulumi.set(__self__, "apple_private_key", apple_private_key)
        if apple_team_id is not None:
            pulumi.set(__self__, "apple_team_id", apple_team_id)
        if authorization_binding is not None:
            pulumi.set(__self__, "authorization_binding", authorization_binding)
        if authorization_url is not None:
            pulumi.set(__self__, "authorization_url", authorization_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if token_binding is not None:
            pulumi.set(__self__, "token_binding", token_binding)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if trust_audience is not None:
            pulumi.set(__self__, "trust_audience", trust_audience)
        if trust_issuer is not None:
            pulumi.set(__self__, "trust_issuer", trust_issuer)
        if trust_kid is not None:
            pulumi.set(__self__, "trust_kid", trust_kid)
        if trust_revocation is not None:
            pulumi.set(__self__, "trust_revocation", trust_revocation)
        if trust_revocation_cache_lifetime is not None:
            pulumi.set(__self__, "trust_revocation_cache_lifetime", trust_revocation_cache_lifetime)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_link_action", value)

    @_builtins.property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @_builtins.property
    @pulumi.getter(name="appleKid")
    def apple_kid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client
        """
        return pulumi.get(self, "apple_kid")

    @apple_kid.setter
    def apple_kid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apple_kid", value)

    @_builtins.property
    @pulumi.getter(name="applePrivateKey")
    def apple_private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        """
        return pulumi.get(self, "apple_private_key")

    @apple_private_key.setter
    def apple_private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apple_private_key", value)

    @_builtins.property
    @pulumi.getter(name="appleTeamId")
    def apple_team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Team ID associated with your Apple developer account
        """
        return pulumi.get(self, "apple_team_id")

    @apple_team_id.setter
    def apple_team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apple_team_id", value)

    @_builtins.property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "authorization_binding")

    @authorization_binding.setter
    def authorization_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_binding", value)

    @_builtins.property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        """
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_url", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client secret issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @_builtins.property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_filters", value)

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_mode", value)

    @_builtins.property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_clock_skew", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "profile_master", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_action", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The scopes of the IdP.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_type", value)

    @_builtins.property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suspended_action", value)

    @_builtins.property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "token_binding")

    @token_binding.setter
    def token_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_binding", value)

    @_builtins.property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        """
        return pulumi.get(self, "token_url")

    @token_url.setter
    def token_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_url", value)

    @_builtins.property
    @pulumi.getter(name="trustAudience")
    def trust_audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust audience for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_audience")

    @trust_audience.setter
    def trust_audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_audience", value)

    @_builtins.property
    @pulumi.getter(name="trustIssuer")
    def trust_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust issuer for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_issuer")

    @trust_issuer.setter
    def trust_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_issuer", value)

    @_builtins.property
    @pulumi.getter(name="trustKid")
    def trust_kid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust kid for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_kid")

    @trust_kid.setter
    def trust_kid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_kid", value)

    @_builtins.property
    @pulumi.getter(name="trustRevocation")
    def trust_revocation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Trust revocation for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_revocation")

    @trust_revocation.setter
    def trust_revocation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_revocation", value)

    @_builtins.property
    @pulumi.getter(name="trustRevocationCacheLifetime")
    def trust_revocation_cache_lifetime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Trust revocation cache lifetime for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_revocation_cache_lifetime")

    @trust_revocation_cache_lifetime.setter
    def trust_revocation_cache_lifetime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "trust_revocation_cache_lifetime", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_template", value)


@pulumi.type_token("okta:idp/social:Social")
class Social(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 apple_kid: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Social Identity Provider. This resource allows you to create and configure a Social Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Social("example",
            type="FACEBOOK",
            protocol_type="OAUTH2",
            name="testAcc_facebook_replace_with_uuid",
            scopes=[
                "public_profile",
                "email",
            ],
            client_id="abcd123",
            client_secret="abcd123",
            username_template="idpuser.email")
        ```

        ## Import

        ```sh
        $ pulumi import okta:idp/social:Social example <idp_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[_builtins.str] apple_private_key: The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        :param pulumi.Input[_builtins.str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[_builtins.str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SocialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Social Identity Provider. This resource allows you to create and configure a Social Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Social("example",
            type="FACEBOOK",
            protocol_type="OAUTH2",
            name="testAcc_facebook_replace_with_uuid",
            scopes=[
                "public_profile",
                "email",
            ],
            client_id="abcd123",
            client_secret="abcd123",
            username_template="idpuser.email")
        ```

        ## Import

        ```sh
        $ pulumi import okta:idp/social:Social example <idp_id>
        ```

        :param str resource_name: The name of the resource.
        :param SocialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SocialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 apple_kid: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 apple_team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SocialArgs.__new__(SocialArgs)

            __props__.__dict__["account_link_action"] = account_link_action
            __props__.__dict__["account_link_group_includes"] = account_link_group_includes
            __props__.__dict__["apple_kid"] = apple_kid
            __props__.__dict__["apple_private_key"] = None if apple_private_key is None else pulumi.Output.secret(apple_private_key)
            __props__.__dict__["apple_team_id"] = apple_team_id
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["deprovisioned_action"] = deprovisioned_action
            __props__.__dict__["groups_action"] = groups_action
            __props__.__dict__["groups_assignments"] = groups_assignments
            __props__.__dict__["groups_attribute"] = groups_attribute
            __props__.__dict__["groups_filters"] = groups_filters
            __props__.__dict__["issuer_mode"] = issuer_mode
            __props__.__dict__["max_clock_skew"] = max_clock_skew
            __props__.__dict__["name"] = name
            __props__.__dict__["profile_master"] = profile_master
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["provisioning_action"] = provisioning_action
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["status"] = status
            __props__.__dict__["subject_match_attribute"] = subject_match_attribute
            __props__.__dict__["subject_match_type"] = subject_match_type
            __props__.__dict__["suspended_action"] = suspended_action
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["username_template"] = username_template
            __props__.__dict__["authorization_binding"] = None
            __props__.__dict__["authorization_url"] = None
            __props__.__dict__["token_binding"] = None
            __props__.__dict__["token_url"] = None
            __props__.__dict__["trust_audience"] = None
            __props__.__dict__["trust_issuer"] = None
            __props__.__dict__["trust_kid"] = None
            __props__.__dict__["trust_revocation"] = None
            __props__.__dict__["trust_revocation_cache_lifetime"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["applePrivateKey", "clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Social, __self__).__init__(
            'okta:idp/social:Social',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
            account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            apple_kid: Optional[pulumi.Input[_builtins.str]] = None,
            apple_private_key: Optional[pulumi.Input[_builtins.str]] = None,
            apple_team_id: Optional[pulumi.Input[_builtins.str]] = None,
            authorization_binding: Optional[pulumi.Input[_builtins.str]] = None,
            authorization_url: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
            groups_action: Optional[pulumi.Input[_builtins.str]] = None,
            groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
            max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
            protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
            provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
            suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
            token_binding: Optional[pulumi.Input[_builtins.str]] = None,
            token_url: Optional[pulumi.Input[_builtins.str]] = None,
            trust_audience: Optional[pulumi.Input[_builtins.str]] = None,
            trust_issuer: Optional[pulumi.Input[_builtins.str]] = None,
            trust_kid: Optional[pulumi.Input[_builtins.str]] = None,
            trust_revocation: Optional[pulumi.Input[_builtins.str]] = None,
            trust_revocation_cache_lifetime: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            username_template: Optional[pulumi.Input[_builtins.str]] = None) -> 'Social':
        """
        Get an existing Social resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] apple_kid: The Key ID that you obtained from Apple when you created the private key for the client
        :param pulumi.Input[_builtins.str] apple_private_key: The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        :param pulumi.Input[_builtins.str] apple_team_id: The Team ID associated with your Apple developer account
        :param pulumi.Input[_builtins.str] authorization_binding: The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[_builtins.str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[_builtins.str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] protocol_type: The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: The scopes of the IdP.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] token_binding: The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        :param pulumi.Input[_builtins.str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[_builtins.str] trust_audience: Trust audience for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] trust_issuer: Trust issuer for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] trust_kid: Trust kid for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] trust_revocation: Trust revocation for the Okta IdP instance.
        :param pulumi.Input[_builtins.int] trust_revocation_cache_lifetime: Trust revocation cache lifetime for the Okta IdP instance.
        :param pulumi.Input[_builtins.str] type: Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SocialState.__new__(_SocialState)

        __props__.__dict__["account_link_action"] = account_link_action
        __props__.__dict__["account_link_group_includes"] = account_link_group_includes
        __props__.__dict__["apple_kid"] = apple_kid
        __props__.__dict__["apple_private_key"] = apple_private_key
        __props__.__dict__["apple_team_id"] = apple_team_id
        __props__.__dict__["authorization_binding"] = authorization_binding
        __props__.__dict__["authorization_url"] = authorization_url
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["deprovisioned_action"] = deprovisioned_action
        __props__.__dict__["groups_action"] = groups_action
        __props__.__dict__["groups_assignments"] = groups_assignments
        __props__.__dict__["groups_attribute"] = groups_attribute
        __props__.__dict__["groups_filters"] = groups_filters
        __props__.__dict__["issuer_mode"] = issuer_mode
        __props__.__dict__["max_clock_skew"] = max_clock_skew
        __props__.__dict__["name"] = name
        __props__.__dict__["profile_master"] = profile_master
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["provisioning_action"] = provisioning_action
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["status"] = status
        __props__.__dict__["subject_match_attribute"] = subject_match_attribute
        __props__.__dict__["subject_match_type"] = subject_match_type
        __props__.__dict__["suspended_action"] = suspended_action
        __props__.__dict__["token_binding"] = token_binding
        __props__.__dict__["token_url"] = token_url
        __props__.__dict__["trust_audience"] = trust_audience
        __props__.__dict__["trust_issuer"] = trust_issuer
        __props__.__dict__["trust_kid"] = trust_kid
        __props__.__dict__["trust_revocation"] = trust_revocation
        __props__.__dict__["trust_revocation_cache_lifetime"] = trust_revocation_cache_lifetime
        __props__.__dict__["type"] = type
        __props__.__dict__["username_template"] = username_template
        return Social(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @_builtins.property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @_builtins.property
    @pulumi.getter(name="appleKid")
    def apple_kid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client
        """
        return pulumi.get(self, "apple_kid")

    @_builtins.property
    @pulumi.getter(name="applePrivateKey")
    def apple_private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Key ID that you obtained from Apple when you created the private key for the client. PrivateKey is required when resource is first created. For all consecutive updates, it can be empty/omitted and keeps the existing value if it is empty/omitted. PrivateKey isn't returned when importing this resource.
        """
        return pulumi.get(self, "apple_private_key")

    @_builtins.property
    @pulumi.getter(name="appleTeamId")
    def apple_team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Team ID associated with your Apple developer account
        """
        return pulumi.get(self, "apple_team_id")

    @_builtins.property
    @pulumi.getter(name="authorizationBinding")
    def authorization_binding(self) -> pulumi.Output[_builtins.str]:
        """
        The method of making an authorization request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "authorization_binding")

    @_builtins.property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> pulumi.Output[_builtins.str]:
        """
        IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        """
        return pulumi.get(self, "authorization_url")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Client secret issued by AS for the Okta IdP instance.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @_builtins.property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @_builtins.property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @_builtins.property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @_builtins.property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `ORG_URL` or `CUSTOM_URL`. Default: `ORG_URL`
        """
        return pulumi.get(self, "issuer_mode")

    @_builtins.property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of protocol to use. It can be `OIDC` or `OAUTH2`. Default: `OAUTH2`
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The scopes of the IdP.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @_builtins.property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @_builtins.property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @_builtins.property
    @pulumi.getter(name="tokenBinding")
    def token_binding(self) -> pulumi.Output[_builtins.str]:
        """
        The method of making a token request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`.
        """
        return pulumi.get(self, "token_binding")

    @_builtins.property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> pulumi.Output[_builtins.str]:
        """
        IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        """
        return pulumi.get(self, "token_url")

    @_builtins.property
    @pulumi.getter(name="trustAudience")
    def trust_audience(self) -> pulumi.Output[_builtins.str]:
        """
        Trust audience for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_audience")

    @_builtins.property
    @pulumi.getter(name="trustIssuer")
    def trust_issuer(self) -> pulumi.Output[_builtins.str]:
        """
        Trust issuer for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_issuer")

    @_builtins.property
    @pulumi.getter(name="trustKid")
    def trust_kid(self) -> pulumi.Output[_builtins.str]:
        """
        Trust kid for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_kid")

    @_builtins.property
    @pulumi.getter(name="trustRevocation")
    def trust_revocation(self) -> pulumi.Output[_builtins.str]:
        """
        Trust revocation for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_revocation")

    @_builtins.property
    @pulumi.getter(name="trustRevocationCacheLifetime")
    def trust_revocation_cache_lifetime(self) -> pulumi.Output[_builtins.int]:
        """
        Trust revocation cache lifetime for the Okta IdP instance.
        """
        return pulumi.get(self, "trust_revocation_cache_lifetime")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Identity Provider Types: https://developer.okta.com/docs/reference/api/idps/#identity-provider-type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

