# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserBaseSchemaPropertyArgs', 'UserBaseSchemaProperty']

@pulumi.input_type
class UserBaseSchemaPropertyArgs:
    def __init__(__self__, *,
                 index: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserBaseSchemaProperty resource.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        :param pulumi.Input[_builtins.str] pattern: The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "type", type)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Input[_builtins.str]:
        """
        Subschema unique string identifier
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        Subschema title (display name)
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the subschema is required
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User type ID. By default, it is `default`
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.input_type
class _UserBaseSchemaPropertyState:
    def __init__(__self__, *,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserBaseSchemaProperty resources.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        :param pulumi.Input[_builtins.str] pattern: The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        if index is not None:
            pulumi.set(__self__, "index", index)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter
    def index(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subschema unique string identifier
        """
        return pulumi.get(self, "index")

    @index.setter
    def index(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index", value)

    @_builtins.property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master", value)

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the subschema is required
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "required", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subschema title (display name)
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User type ID. By default, it is `default`
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("okta:index/userBaseSchemaProperty:UserBaseSchemaProperty")
class UserBaseSchemaProperty(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a User Base Schema property. This resource allows you to configure a base user schema property.

        ## IMPORTANT NOTE:

        Based on the [official documentation](https://developer.okta.com/docs/reference/api/schemas/#user-profile-base-subschema)
        base properties can not be modified, except to update permissions, to change the nullability of `firstName` and
        `lastName` (`required` property) or to specify a `pattern` for `login`. Currently, `title` and `type` are required, so
        they should be set to the current values of the base property. This will be fixed in the future releases, as this is
        a breaking change.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.UserBaseSchemaProperty("example",
            index="firstName",
            title="First name",
            type="string",
            required=True,
            master="OKTA",
            user_type=example_okta_user_type["id"])
        ```

        ## Import

        ### User schema property of default user type can be imported via the property index.

        ```sh
        $ pulumi import okta:index/userBaseSchemaProperty:UserBaseSchemaProperty example <property_name>
        ```

        ### User schema property of custom user type can be imported via user type id and property index

        ```sh
        $ pulumi import okta:index/userBaseSchemaProperty:UserBaseSchemaProperty example <user_type_id>.<property name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        :param pulumi.Input[_builtins.str] pattern: The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserBaseSchemaPropertyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a User Base Schema property. This resource allows you to configure a base user schema property.

        ## IMPORTANT NOTE:

        Based on the [official documentation](https://developer.okta.com/docs/reference/api/schemas/#user-profile-base-subschema)
        base properties can not be modified, except to update permissions, to change the nullability of `firstName` and
        `lastName` (`required` property) or to specify a `pattern` for `login`. Currently, `title` and `type` are required, so
        they should be set to the current values of the base property. This will be fixed in the future releases, as this is
        a breaking change.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.UserBaseSchemaProperty("example",
            index="firstName",
            title="First name",
            type="string",
            required=True,
            master="OKTA",
            user_type=example_okta_user_type["id"])
        ```

        ## Import

        ### User schema property of default user type can be imported via the property index.

        ```sh
        $ pulumi import okta:index/userBaseSchemaProperty:UserBaseSchemaProperty example <property_name>
        ```

        ### User schema property of custom user type can be imported via user type id and property index

        ```sh
        $ pulumi import okta:index/userBaseSchemaProperty:UserBaseSchemaProperty example <user_type_id>.<property name>
        ```

        :param str resource_name: The name of the resource.
        :param UserBaseSchemaPropertyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserBaseSchemaPropertyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 index: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 required: Optional[pulumi.Input[_builtins.bool]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserBaseSchemaPropertyArgs.__new__(UserBaseSchemaPropertyArgs)

            if index is None and not opts.urn:
                raise TypeError("Missing required property 'index'")
            __props__.__dict__["index"] = index
            __props__.__dict__["master"] = master
            __props__.__dict__["pattern"] = pattern
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["required"] = required
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_type"] = user_type
        super(UserBaseSchemaProperty, __self__).__init__(
            'okta:index/userBaseSchemaProperty:UserBaseSchemaProperty',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            index: Optional[pulumi.Input[_builtins.str]] = None,
            master: Optional[pulumi.Input[_builtins.str]] = None,
            pattern: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[_builtins.str]] = None,
            required: Optional[pulumi.Input[_builtins.bool]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserBaseSchemaProperty':
        """
        Get an existing UserBaseSchemaProperty resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] index: Subschema unique string identifier
        :param pulumi.Input[_builtins.str] master: Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        :param pulumi.Input[_builtins.str] pattern: The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        :param pulumi.Input[_builtins.str] permissions: Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        :param pulumi.Input[_builtins.bool] required: Whether the subschema is required
        :param pulumi.Input[_builtins.str] title: Subschema title (display name)
        :param pulumi.Input[_builtins.str] type: The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        :param pulumi.Input[_builtins.str] user_type: User type ID. By default, it is `default`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserBaseSchemaPropertyState.__new__(_UserBaseSchemaPropertyState)

        __props__.__dict__["index"] = index
        __props__.__dict__["master"] = master
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["required"] = required
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        __props__.__dict__["user_type"] = user_type
        return UserBaseSchemaProperty(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def index(self) -> pulumi.Output[_builtins.str]:
        """
        Subschema unique string identifier
        """
        return pulumi.get(self, "index")

    @_builtins.property
    @pulumi.getter
    def master(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Master priority for the user schema property. It can be set to `PROFILE_MASTER` or `OKTA`. Default: `PROFILE_MASTER`
        """
        return pulumi.get(self, "master")

    @_builtins.property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The validation pattern to use for the subschema. Must be in form of '.+', or '[\\n\\n]+' if present.'
        """
        return pulumi.get(self, "pattern")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access control permissions for the property. It can be set to `READ_WRITE`, `READ_ONLY`, `HIDE`. Default: `READ_ONLY`
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the subschema is required
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        Subschema title (display name)
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the schema property. It can be `string`, `boolean`, `number`, `integer`, `array`, or `object`
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User type ID. By default, it is `default`
        """
        return pulumi.get(self, "user_type")

