/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"988b553afa": function _(a,e,t,c,o){c();const r=a("d75d4bd830");o("DataPipe",r.DataPipe);const p=a("790a872eb0");o("ImagePipe",p.ImagePipe);const D=a("1fa92ac597");o("ImageDataSource",D.ImageDataSource);const S=a("e5ac72e4af");o("SpectraDataSource",S.SpectraDataSource);(0,a("@bokehjs/base").register_models)({DataPipe:r.DataPipe,ImagePipe:p.ImagePipe,ImageDataSource:D.ImageDataSource,SpectraDataSource:S.SpectraDataSource})},
"d75d4bd830": function _(e,i,s,t,n){t();const a=e("@bokehjs/models/sources/data_source"),d=e("@bokehjs/core/util/serialization");class c extends a.DataSource{constructor(e){super(e),this.send_queue={},this.pending={},this.incoming_callbacks={};let i=`ws://${this.address[0]}:${this.address[1]}`;console.log("imagepipe url:",i),this.websocket=new WebSocket(i),this.websocket.binaryType="arraybuffer",this.websocket.onmessage=e=>{if("string"==typeof e.data||e.data instanceof String){let i=function e(i){const s=Array.isArray(i)?new Array:{};for(const t in i){let n=i[t];if((0,d.is_NDArray_ref)(n)){const e=new Map;s[t]=(0,d.decode_NDArray)(n,e)}else s[t]="object"==typeof n&&null!==n?e(n):n}return s}(JSON.parse(e.data));if("id"in i&&"direction"in i&&"message"in i){let{id:e,message:s,direction:t}=i;if("j2p"==t)if(e in this.pending){let{cb:i}=this.pending[e];if(delete this.pending[e],e in this.send_queue&&this.send_queue[e].length>0){let{cb:i,msg:s}=this.send_queue[e].shift();this.pending[e]={cb:i},this.websocket.send(JSON.stringify(s))}i(s)}else console.log("message received but could not find id");else if(e in this.incoming_callbacks){let i=this.incoming_callbacks[e](s);this.websocket.send(JSON.stringify({id:e,direction:t,message:i}))}}else console.log(`datapipe received message without one of 'id', 'message' or 'direction': ${i}`)}else console.log("datapipe received binary data",e.data.byteLength,"bytes")}}initialize(){super.initialize()}register(e,i){this.incoming_callbacks[e]=i}send(e,i,s){let t={id:e,message:i,direction:"j2p"};if(e in this.pending)e in this.send_queue?this.send_queue[e].push({cb:s,msg:t}):this.send_queue[e]=[{cb:s,msg:t}];else if(e in this.send_queue&&this.send_queue[e].length>0){this.send_queue[e].push({cb:s,msg:t});{let{cb:i,msg:s}=this.send_queue[e].shift();this.pending[e]={cb:i},this.websocket.send(JSON.stringify(s))}}else this.pending[e]={cb:s},this.websocket.send(JSON.stringify(t))}static init_DataPipe(){this.define((({Tuple:e,String:i,Number:s})=>({address:[e(i,s)]})))}}s.DataPipe=c,c.__name__="DataPipe",c.init_DataPipe()},
"790a872eb0": function _(e,i,s,n,t){n();const a=e("@bokehjs/models/sources/data_source"),d=e("@bokehjs/core/util/serialization");class o extends a.DataSource{constructor(e){super(e),this.queue={},this.pending={},this.position={};let i=`ws://${this.address[0]}:${this.address[1]}`;console.log("imagepipe url:",i),this.websocket=new WebSocket(i),this.websocket.binaryType="arraybuffer",this.websocket.onmessage=e=>{if("string"==typeof e.data||e.data instanceof String){let i=function e(i){const s=Array.isArray(i)?new Array:{};for(const n in i){let t=i[n];if((0,d.is_NDArray_ref)(t)){const e=new Map;s[n]=(0,d.decode_NDArray)(t,e)}else s[n]="object"==typeof t&&null!==t?e(t):t}return s}(JSON.parse(e.data));if("id"in i&&"message"in i){let{id:e,message:s}=i,{cb:n,index:t}=this.pending[e];if(delete this.pending[e],e in this.queue){let{cb:i,message:s,index:n}=this.queue[e];delete this.queue[e],this.pending[e]={cb:i,index:n},this.websocket.send(JSON.stringify(s))}this.position[e]={index:t},n(s)}else console.log(`imagepipe received data without 'id' and/or 'message' field: ${i}`)}else console.log("imagepipe received binary data",e.data.byteLength,"bytes")}}initialize(){super.initialize()}channel(e,i,s){let n={action:"channel",index:e,id:s};s in this.pending?this.queue[s]={cb:i,message:n,index:e}:(this.websocket.send(JSON.stringify(n)),this.pending[s]={cb:i,index:e})}spectra(e,i,s){let n={action:"spectra",index:e,id:s};s in this.pending?this.queue[s]={cb:i,message:n,index:e}:(this.websocket.send(JSON.stringify(n)),this.pending[s]={cb:i,index:e})}refresh(e,i,s=[]){let{index:n}=i in this.position?this.position[i]:{index:s};if(2===n.length){let s={action:"channel",index:n,id:i};i in this.pending?this.queue[i]={cb:e,message:s,index:n}:(this.websocket.send(JSON.stringify(s)),this.pending[i]={cb:e,index:n})}else if(3===n.length){let s={action:"spectra",index:n,id:i};i in this.pending?this.queue[i]={cb:e,message:s,index:n}:(this.websocket.send(JSON.stringify(s)),this.pending[i]={cb:e,index:n})}}static init_ImagePipe(){this.define((({Tuple:e,String:i,Number:s})=>({address:[e(i,s)],shape:[e(s,s,s,s)]})))}}s.ImagePipe=o,o.__name__="ImagePipe",o.init_ImagePipe()},
"1fa92ac597": function _(i,e,t,a,s){a();const c=i("@bokehjs/models/sources/column_data_source"),n=i("@bokehjs/core/util/string"),r=i("790a872eb0");class u extends c.ColumnDataSource{constructor(i){super(i),this.imid=(0,n.uuid4)()}initialize(){super.initialize();(()=>{null!=this.init_script&&this.init_script.execute(this)})()}channel(i,e=0,t){this.image_source.channel([e,i],(a=>{this.cur_chan=[e,i],t&&t(a),this.data=a.chan}),this.imid)}refresh(i){this.image_source.refresh((e=>{i&&i(e),this.data=e.chan}),this.imid,[0,0])}static init_ImageDataSource(){this.define((({Tuple:i,Number:e,String:t,Ref:a,Any:s})=>({init_script:[s],image_source:[a(r.ImagePipe)],num_chans:[i(e,e)],cur_chan:[i(e,e)],init:[t]})))}}t.ImageDataSource=u,u.__name__="ImageDataSource",u.init_ImageDataSource()},
"e5ac72e4af": function _(e,i,t,s,a){s();const r=e("@bokehjs/models/sources/column_data_source"),c=e("@bokehjs/core/util/string"),o=e("790a872eb0");class u extends r.ColumnDataSource{constructor(e){super(e),this.imid=(0,c.uuid4)(),console.log("spectra data source id:",this.imid)}initialize(){super.initialize()}spectra(e,i,t=0){this.image_source.spectra([e,i,t],(e=>this.data=e.spectrum),this.imid)}refresh(){this.image_source.refresh((e=>this.data=e.spectrum),this.imid,[0,0,0])}static init_SpectraDataSource(){this.define((({Ref:e})=>({image_source:[e(o.ImagePipe)]})))}}t.SpectraDataSource=u,u.__name__="SpectraDataSource",u.init_SpectraDataSource()},
}, "988b553afa", {"index":"988b553afa","src/bokeh/sources/data_pipe":"d75d4bd830","src/bokeh/sources/image_pipe":"790a872eb0","src/bokeh/sources/image_data_source":"1fa92ac597","src/bokeh/sources/spectra_data_source":"e5ac72e4af"}, {});});
