########################################################################
#
# Copyright (C) 2024
# Associated Universities, Inc. Washington DC, USA.
#
# This script is free software; you can redistribute it and/or modify it
# under the terms of the GNU Library General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# This library is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
# License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 675 Massachusetts Ave, Cambridge, MA 02139, USA.
#
# Correspondence concerning AIPS++ should be adressed as follows:
#        Internet email: casa-feedback@nrao.edu.
#        Postal address: AIPS++ Project Office
#                        National Radio Astronomy Observatory
#                        520 Edgemont Road
#                        Charlottesville, VA 22903-2475 USA
#
########################################################################
##################### generated by xml-casa (v2) from tclean.xml
##################### 214e4c0dbbbeb35a4a041ccbbea77d9a ##############################
from __future__ import absolute_import
from casashell.private.stack_manip import find_local as __sf__
from casashell.private.stack_manip import find_frame as _find_frame
from casatools.typecheck import validator as _pc
from casatools.coercetype import coerce as _coerce
from casatools.errors import create_error_string
from casatasks.private.task_logging import start_log as _start_log
from casatasks.private.task_logging import end_log as _end_log
from cubevis.private.apps import InteractiveClean
from collections import OrderedDict
import numpy
import sys
import os

import shutil

def static_var(varname, value):
    def decorate(func):
        setattr(func, varname, value)
        return func
    return decorate


def _iclean_t( *args, **kwargs ):
    ic = InteractiveClean( *args, **kwargs )
    return ic( )


class _iclean:
    r"""
    tclean ---- Radio Interferometric Image Reconstruction

    Form images from visibilities and reconstruct a sky model.
    This task handles continuum images and spectral line cubes,
    supports outlier fields, contains standard clean based algorithms
    along with algorithms for multi-scale and wideband image
    reconstruction, widefield imaging correcting for the w-term,
    full primary-beam imaging and joint mosaic imaging (with
    heterogeneous array support for ALMA).

    --------- parameter descriptions ---------------------------------------------

    vis                  Name(s) of input visibility file(s)
                         default: none;
                         example: vis='ngc5921.ms'
                                  vis=['ngc5921a.ms','ngc5921b.ms']; multiple MSs
    selectdata           Enable data selection parameters.
    field                to image or mosaic.  Use field id(s) or name(s).
                            ['go listobs' to obtain the list id's or names]
                         default: ''= all fields.
                           If field string is a non-negative integer, it is assumed to
                           be a field index, otherwise it is assumed to be a
                           field name.
                           field='0~2'; field ids 0,1,2.
                           field='0,4,5~7'; field ids 0,4,5,6,7.
                           field='3C286,3C295'; field names 3C286 and 3C295.
                           field = '3,4C\*'; field id 3, all names starting with 4C.
                           For multiple MS input, a list of field strings can be used:
                           field = ['0~2','0~4']; field ids 0-2 for the first MS and 0-4
                                   for the second.
                           field = '0~2'; field ids 0-2 for all input MSs.
    spw                  l window/channels.
                         NOTE: channels not selected here will contain all zeros if
                                   selected by other subparameters.
                         default: ''=all spectral windows and channels.
                           spw='0~2,4'; spectral windows 0,1,2,4 (all channels).
                           spw='0:5~61'; spw 0, channels 5 to 61.
                           spw='<2';   spectral windows less than 2 (i.e. 0,1).
                           spw='0,10,3:3~45'; spw 0,10 all channels, and spw 3
                                              channels 3 to 45.
                           spw='0~2:2~6'; spw 0,1,2 with channels 2 through 6 in each.
                           For multiple MS input, a list of spw strings can be used:
                           spw=['0','0~3']; spw ids 0 for the first MS and 0-3 for the second.
                           spw='0~3' spw ids 0-3 for all input MS.
                           spw='3:10~20;50~60' for multiple channel ranges within spw id 3.
                           spw='3:10~20;50~60,4:0~30' for different channel ranges for spw ids 3 and 4.
                           spw='0:0~10,1:20~30,2:1;2;3'; spw 0, channels 0-10,
                                spw 1, channels 20-30, and spw 2, channels, 1,2 and 3.
                           spw='1~4;6:15~48' for channels 15 through 48 for spw ids 1,2,3,4 and 6.
    timerange            Range of time to select from data

                         default: '' (all); examples,
                         timerange = 'YYYY/MM/DD/hh:mm:ss~YYYY/MM/DD/hh:mm:ss'
                         Note: if YYYY/MM/DD is missing date defaults to first
                               day in data set.
                         timerange='09:14:0~09:54:0' picks 40 min on first day.
                         timerange='25:00:00~27:30:00' picks 1 hr to 3 hr
                                   30min on NEXT day.
                         timerange='09:44:00' pick data within one integration
                                   of time.
                         timerange='> 10:24:00' data after this time.
                         For multiple MS input, a list of timerange strings can be
                         used:
                         timerange=['09:14:0~09:54:0','> 10:24:00'].
                         timerange='09:14:0~09:54:0''; apply the same timerange for
                                                       all input MSs.
    uvrange              Select data within uvrange (default unit is meters)
                         default: '' (all); example:
                         uvrange='0~1000klambda'; uvrange from 0-1000 kilo-lambda.
                         uvrange='> 4klambda';uvranges greater than 4 kilo lambda.
                         For multiple MS input, a list of uvrange strings can be
                         used:
                         uvrange=['0~1000klambda','100~1000klamda'].
                         uvrange='0~1000klambda'; apply 0-1000 kilo-lambda for all
                         input MSs.
                         		   uvrange='0~1000'; apply 0-1000 meter for all input MSs.
    antenna              Select data based on antenna/baseline

                         default: '' (all)
                         If antenna string is a non-negative integer, it is
                         assumed to be an antenna index, otherwise, it is
                         considered an antenna name.
                         antenna='5\&6'; baseline between antenna index 5 and
                                       index 6.
                         antenna='VA05\&VA06'; baseline between VLA antenna 5
                                             and 6.
                         antenna='5\&6;7\&8'; baselines 5-6 and 7-8.
                         antenna='5'; all baselines with antenna index 5.
                         antenna='05'; all baselines with antenna number 05
                                      (VLA old name).
                         antenna='5,6,9'; all baselines with antennas 5,6,9
                                         index number.
                         For multiple MS input, a list of antenna strings can be
                         used:
                         antenna=['5','5\&6'];
                         antenna='5'; antenna index 5 for all input MSs.
                         antenna='!DV14'; use all antennas except DV14.
    scan                 Scan number range

                         default: '' (all).
                         example: scan='1~5'.
                         For multiple MS input, a list of scan strings can be used:
                         scan=['0~100','10~200'].
                         scan='0~100; scan ids 0-100 for all input MSs.
    observation          Observation ID range
                         default: '' (all).
                         example: observation='1~5'.
    intent               Scan Intent(s)

                         default: '' (all).
                         example: intent='TARGET_SOURCE'.
                         example: intent='TARGET_SOURCE1,TARGET_SOURCE2'.
                         example: intent='TARGET_POINTING\*'.
    datacolumn           Data column to image (data or observed, corrected)
                         default:'corrected'
                         ( If 'corrected' does not exist, it will use 'data' instead )
    imagename            Pre-name of output images

                         example : imagename='try'

                         Output images will be (a subset of) :

                         try.psf           - Point Spread Function (PSF).
                         try.residual      - Residual image.
                         try.image         - Restored image.
                         try.model         - Model image (contains only flux components).
                         try.sumwt         - Single pixel image containing sum-of-weights.
                                                   (for natural weighting, sensitivity=1/sqrt(sumwt)).
                         try.pb            - Primary Beam (PB) model (values depend on the gridder used).

                         A-projection algorithms (gridder=mosaic,awproject, awp2) will
                         compute the following images too.

                         try.weight        - FT of gridded weights or the
                                                   un-normalized sum of PB-square (for all pointings).
                                                   Here, PB = sqrt(weight) normalized to a maximum of 1.0.

                         For multi-term wideband imaging, all relevant images above will
                         have additional .tt0,.tt1, etc suffixes to indicate Taylor terms,
                         plus the following extra output images.
                         try.alpha            - spectral index.
                         try.alpha.error   - estimate of error on spectral index.
                         try.beta              - spectral curvature (if nterms \> 2).

                         Tip : Include a directory name in 'imagename' for all
                                 output images to be sent there instead of the
                                 current working directory : imagename='mydir/try'.

                         Tip : Restarting an imaging run without changing 'imagename'
                                 implies continuation from the existing model image on disk.
                                  - If 'startmodel' was initially specified it needs to be set to ""
                                    for the restart run (or tclean will exit with an error message).
                                  - By default, the residual image and psf will be recomputed
                                    but if no changes were made to relevant parameters between
                                    the runs, set calcres=False, calcpsf=False to resume directly from
                                    the minor cycle without the (unnecessary) first major cycle.
                                  To automatically change 'imagename' with a numerical
                                  increment, set restart=False (see tclean docs for 'restart').

                          Note : All imaging runs will by default produce restored images.
                                    For a niter=0 run, this will be redundant and can optionally
                                    be turned off via the 'restoration=T/F' parameter.
    imsize               Number of pixels
                         example:

                         imsize = [350,250].
                         imsize = 500 is equivalent to [500,500].

                         To take proper advantage of internal optimized FFT routines, the
                         number of pixels must be even and factorizable by 2,3,5 only.
                         To find the nearest optimal imsize to that desired by the user, please use the following tool method:

                         from casatools import synthesisutils
                         su = synthesisutils()
                         su.getOptimumSize(345)
                         Output :  360
    cell                 Cell size
                         example: cell=['0.5arcsec,'0.5arcsec'] or
                         cell=['1arcmin', '1arcmin'].
                         cell = '1arcsec' is equivalent to ['1arcsec','1arcsec'].
    phasecenter          Phase center of the image (string or field id); if the phasecenter is the name known major solar system object ('MERCURY', 'VENUS', 'MARS', 'JUPITER', 'SATURN', 'URANUS', 'NEPTUNE', 'PLUTO', 'SUN', 'MOON') or is an ephemerides table then that source is tracked and the background sources get smeared. There is a special case, when phasecenter='TRACKFIELD', which will use the ephemerides or polynomial phasecenter in the FIELD table of the MS's as the source center to track.

                              Note : If unspecified, tclean will use the phase-center from the first data field of the MS (or list of MSs) selected for imaging.

                         			example: phasecenter='6'.
                         phasecenter='J2000 19h30m00 -40d00m00'.
                         phasecenter='J2000 292.5deg  -40.0deg'.
                         phasecenter='J2000 5.105rad  -0.698rad'.
                         phasecenter='ICRS 13:05:27.2780 -049.28.04.458'.
                         phasecenter='myComet_ephem.tab'.
                         phasecenter='MOON'.
                         phasecenter='TRACKFIELD'.
    stokes               Stokes Planes to make
                         default='I'; example: stokes='IQUV';
                           Options: 'I','Q','U','V','IV','QU','IQ','UV','IQUV','RR','LL','XX','YY','RRLL','XXYY','pseudoI'

                                       Note : Due to current internal code constraints, if any correlation pair
                                                  is flagged, by default, no data for that row in the MS will be used.
                                                  So, in an MS with XX,YY, if only YY is flagged, neither a
                                                  Stokes I image nor an XX image can be made from those data points.
                                                  In such a situation, please split out only the unflagged correlation into
                                                  a separate MS, or use the option 'pseudoI'.

                                       Note : The 'pseudoI' option is a partial solution, allowing Stokes I imaging
                                              when either of the parallel-hand correlations are unflagged.

                                       The remaining constraints shall be removed (where logical) in a future release.
    projection           Coordinate projection
                         Examples : SIN,   NCP.
                         A list of supported (but untested) projections can be found here :
                         http://casa.nrao.edu/active/docs/doxygen/html/classcasa_1_1Projection.html#a3d5f9ec787e4eabdce57ab5edaf7c0cd
    startmodel           Name of starting model image

                         The contents of the supplied starting model image will be
                         copied to the imagename.model before the run begins.

                         example : startmodel = 'singledish.im'.

                         For deconvolver='mtmfs', one image per Taylor term must be provided.
                         example : startmodel = ['try.model.tt0', 'try.model.tt1'].
                                         startmodel = ['try.model.tt0']  will use a starting model only
                                                              for the zeroth order term.
                                         startmodel = ['','try.model.tt1']  will use a starting model only
                                                              for the first order term.

                          This starting model can be of a different image shape and size from
                          what is currently being imaged. If so, an image regrid is first triggered
                          to resample the input image onto the target coordinate system.

                          A common usage is to set this parameter equal to a single dish image.

                          Negative components in the model image will be included as is.

                         Note : If an error occurs during image resampling/regridding,
                                      please try using task imregrid to resample the starting model
                                      image onto a CASA image with the target shape and
                                      coordinate system before supplying it via startmodel.
    specmode             Spectral definition mode (mfs,cube,cubedata, cubesource, mvc)

                         specmode='mfs' : Continuum imaging with only one output image channel.
                                                        (mode='cont' can also be used here)

                         specmode='cube' : Spectral line imaging with one or more channels.
                                                        Parameters start, width,and nchan define the spectral
                                                       coordinate system and can be specified either in terms
                                                       of channel numbers, frequency or velocity in whatever
                                                       spectral frame is specified in 'outframe'.
                                                       All internal and output images are made with outframe as the
                                                       base spectral frame. However imaging code internally uses the fixed
                                                       spectral frame, LSRK for automatic internal software
                                                       Doppler correction, so that a spectral line observed over an
                                                       extended time range will line up appropriately.
                                                       Therefore the output images have additional spectral frame conversion
                                                        layer in LSRK on the top the base frame.




                          specmode='cubedata' : Spectral line imaging with one or more channels.
                                                          There is no internal software Doppler correction, so
                                                          a spectral line observed over an extended time range
                                                          may be smeared out in frequency. There is strictly
                                                          no valid spectral frame with which to associate with the
                                                          output images, thus the image spectral  frame will
                                                          be labelled  "Undefined".


                          specmode='cubesource': Spectral line imaging while
                                                          tracking moving source (near field or solar system
                                                          objects). The velocity of the source is accounted
                                                          and the frequency reported is in the source frame.
                                                          As there is no "SOURCE" frame defined in CASA,
                                                          the frame in the image will be labelled "REST" (but do note the
                                                          velocity of a given line reported may be different from the rest frame
                                                          velocity if the emission region is moving w.r.t the systemic
                                                          velocity frame of the source).

                          specmode='mvc' : Multiterm continuum imaging with cube major cycles.
                                                          This mode requires deconvolver='mtmfs' with nterms>1
                                                          and user-set choices of 'reffreq' and 'nchan'.

                                                          The output images and minor cycle are similar to specmode='mfs'
                                                          with deconvolver='mtmfs', but the major cycles are done in
                                                          cube mode (and require a setting of 'reffreq' and 'nchan').
                                                          By default, frequency-dependent primary beam correction is
                                                          applied to each channel, before being combined across frequency
                                                          to make the inputs to the 'mtmfs' deconvolver.  This results in
                                                          implicit wideband pb-correction, with the deconvolver seeing only
                                                          the sky spectral structure.

                                                          Note : There is currently no option to turn off wideband pb correction
                                                          as part of the flat-sky normalization between the major and minor cycles.
                                                          Therefore, 'mvc' with the 'standard' and 'wproject' gridders will also apply
                                                          pblimits per channel, masking all regions outside of pblimit.
                                                          An option to retain sources outside the pblimit will be added in a future release.

                                                          Note : Below is some guidance for choosing 'nchan' and 'reffreq' :

                                                          The cube produced by the major cycle is used in a linear least square fits for Taylor
                                                          polynomials per pixel. Therefore, one only needs as many channels in the cube, as
                                                          required for an accurate polynomial fit for sources that have the strongest
                                                          spectral structure.

                                                          In general, 'nchan' needs to be greater than or equal to 'nterms', and the
                                                          frequency range selected by the data will be evenly split into nchan channels.
                                                          For a low-order polynomial fit, only a small number (around 10)
                                                          channels are typically needed (for VLA/ALMA bandwidth ratios).
                                                          'nchan=-1' applies a heuristic that results in a default of 10 cube channels
                                                          for a 2:1 bandwidth ratio.

                                                          nchan = MAX( bandwidth/(0.1*startfreq) ,  nterms+1 )

                                                          Note: When running in parallel, the nchan selected may limit the speedup if it
                                                          is smaller than the number of processes used.

                                                          The 'reffreq' is the reference frequency used for the Taylor polynomial expansion.
                                                          By default, in specmode='mvc', reffreq is set to the middle of the selected
                                                          frequency range.
    reffreq              Reference frequency of the output image coordinate system.

                         Example :  reffreq='1.5GHz'    as a string with units.

                         By default, it is calculated as the middle of the selected frequency range.

                         For deconvolver='mtmfs' the Taylor expansion is also done about
                         this specified reference frequency.
    nchan                Number of channels in the output image.
                         For default (=-1), the number of channels will be automatically determined
                         based on data selected by 'spw' with 'start' and 'width'.
                         It is often easiest to leave nchan at the default value.
                         example: nchan=100
    start                First channel (e.g. start=3,start=\'1.1GHz\',start=\'15343km/s\')
                         of output cube images specified by data channel number (integer),
                         velocity (string with a unit),  or frequency (string with a unit).
                         Default:''; The first channel is automatically determined based on
                         the 'spw' channel selection and 'width'.
                         channels in 'spw'.
                         Since the integer number in 'start' represents the data channel number,
                         when the channel number is used along with the spectral window id selection
                         in 'spw', 'start' specified as an integer should be carefully set otherwise
                         it may result in the blank image channels if the 'start' channel (i.e. absolute
                         channel number) is outside of the channel range specified in 'spw'.
                         In such a case, 'start' can be left as a default (='') to ensure
                         matching with the data spectral channel selection.
                         For specmode='cube', when velocity or frequency is used it is
                         interpreted with the frame defined in outframe. [The parameters of
                         the desired output cube can be estimated by using the 'transform'
                         functionality of 'plotms'].
                         examples: start='5.0km/s'; 1st channel, 5.0km/s in outframe.
                                   start='22.3GHz'; 1st channel, 22.3GHz in outframe.
    width                Channel width (e.g. width=2,width=\'0.1MHz\',width=\'10km/s\') of output cube images
                         specified by data channel number (integer), velocity (string with a unit), or
                         or frequency (string with a unit).
                         Default:''; data channel width.
                         The sign of width defines the direction of the channels to be incremented.
                         For width specified in velocity or frequency with '-' in front  gives image channels in
                         decreasing velocity or frequency, respectively.
                         For specmode='cube', when velocity or frequency is used it is interpreted with
                         the reference frame defined in outframe.
                         examples: width='2.0km/s'; results in channels with increasing velocity.
                                   width='-2.0km/s';  results in channels with decreasing velocity.
                                   width='40kHz'; results in channels with increasing frequency.
                                   width=-2; results in channels averaged of 2 data channels incremented from
                                             high to low channel numbers.
    outframe             Spectral reference frame in which to interpret \'start\' and \'width\'
                          Options: '','LSRK','LSRD','BARY','GEO','TOPO','GALACTO','LGROUP','CMB'
                          example: outframe='bary' for Barycentric frame.

                          REST -- Rest frequency.
                          LSRD -- Local Standard of Rest (J2000).
                                   -- as the dynamical definition (IAU, [9,12,7] km/s in galactic coordinates).
                          LSRK -- LSR as a kinematical (radio) definition.
                                   -- 20.0 km/s in direction ra,dec = [270,+30] deg (B1900.0).
                          BARY -- Barycentric (J2000).
                          GEO --- Geocentric.
                          TOPO -- Topocentric.
                          GALACTO -- Galacto centric (with rotation of 220 km/s in direction l,b = [90,0] deg.
                          LGROUP -- Local group velocity -- 308km/s towards l,b = [105,-7] deg (F. Ghigo).
                         CMB -- CMB velocity -- 369.5km/s towards l,b = [264.4, 48.4] deg (F. Ghigo).
                         DEFAULT = LSRK.
    veltype              Velocity type (radio, z, ratio, beta, gamma, optical)
                         For 'start' and/or 'width' specified in velocity, specifies the velocity definition
                         Options: 'radio','optical','z','beta','gamma','optical'
                         NOTE: the viewer always defaults to displaying the 'radio' frame,
                           but that can be changed in the position tracking pull down.

                          The different types (with F = f/f0, the frequency ratio), are:

                         Z = (-1 + 1/F).
                         RATIO = (F) \*.
                         RADIO = (1 - F).
                         OPTICAL == Z.
                         BETA = ((1 - F^2)/(1 + F^2)).
                         GAMMA = ((1 + F^2)/2F) \*.
                         RELATIVISTIC == BETA (== v/c).
                         DEFAULT == RADIO.
                         Note that the ones with an '\*' have no real interpretation
                         (although the calculation will proceed) if given as a velocity.
    restfreq             List of rest frequencies or a rest frequency in a string.
                         Specify rest frequency to use for output image.

                         		      Currently it uses the first rest frequency in the list for translation of
                         velocities. The list will be stored in the output images.
                         Default: []; look for the rest frequency stored in the MS, if not available,
                         use center frequency of the selected channels.
                         examples: restfreq=['1.42GHz'].
                                   restfreq='1.42GHz'.
    interpolation        Spectral interpolation (nearest,linear,cubic)

                          Interpolation rules to use when binning data channels onto image channels
                          and evaluating visibility values at the centers of image channels.

                         Note : 'linear' and 'cubic' interpolation requires data points on both sides of
                           each image frequency. Errors  are therefore possible at edge  channels, or near
                           flagged data channels. When image channel width is much larger than the data
                           channel width there is nothing much to be gained using linear or cubic thus
                           not worth the extra computation involved.
    perchanweightdensity When calculating weight density for Briggs
                         style weighting in a cube, this parameter
                         determines whether to calculate the weight
                         density for each channel independently
                         (the default, True)
                         or a common weight density for all of the selected
                         data. This parameter has no
                         meaning for continuum (specmode='mfs') imaging
                         or for natural and radial weighting schemes.
                         For cube imaging
                         perchanweightdensity=True is a recommended
                         option that provides more uniform
                         sensitivity per channel for cubes, but with
                         generally larger psfs than the
                         perchanweightdensity=False (prior behavior)
                         option. When using Briggs style weight with
                         perchanweightdensity=True, the imaging weight
                         density calculations use only the weights of
                         data that contribute specifically to that
                         channel. On the other hand, when
                         perchanweightdensity=False, the imaging
                         weight density calculations sum all of the
                         weights from all of the data channels
                         selected whose (u,v) falls in a given uv cell
                         on the weight density grid. Since the
                         aggregated weights, in any given uv cell,
                         will change depending on the number of
                         channels included when imaging, the psf
                         calculated for a given frequency channel will
                         also necessarily change, resulting in
                         variability in the psf for a given frequency
                         channel when perchanweightdensity=False. In
                         general, perchanweightdensity=False results
                         in smaller psfs for the same value of
                         robustness compared to
                         perchanweightdensity=True, but the rms noise
                         as a function of channel varies and increases
                         toward the edge channels;
                         perchanweightdensity=True provides more
                         uniform sensitivity per channel for
                         cubes. This may make it harder to find
                         estimates of continuum when
                         perchanweightdensity=False. If you intend to
                         image a large cube in many smaller subcubes
                         and subsequently concatenate, it is advisable
                         to use perchanweightdensity=True to avoid
                         surprisingly varying sensitivity and psfs
                         across the concatenated cube.
    gridder              Gridding options (standard, wproject, widefield, mosaic, awproject, awp2, awphpg)


                                The following options choose different gridding convolution
                                functions for the process of convolutional resampling of the measured
                                visibilities onto a regular uv-grid prior to an inverse FFT.
                                Model prediction (degridding) also uses these same functions.
                                Several wide-field effects can be accounted for via careful choices of
                                convolution functions. Gridding (degridding) runtime will rise in
                                proportion to the support size of these convolution functions (in uv-pixels).

                                standard : Prolate Spheroid with 7x7 uv pixel support size.

                                                 [ This mode can also be invoked using 'ft' or 'gridft' ]

                                wproject : W-Projection algorithm to correct for the widefield
                                                    non-coplanar baseline effect. [Cornwell et.al 2008]

                                                    wprojplanes is the number of distinct w-values at
                                                    which to compute and use different gridding convolution
                                                    functions (see help for wprojplanes).
                                                   Convolution function support size can range
                                                    from 5x5 to few 100 x few 100.

                                                 [ This mode can also be invoked using 'wprojectft' ]

                                widefield : Facetted imaging with or without W-Projection per facet.

                                                 A set of facets x facets subregions of the specified image
                                                 are gridded separately using their respective phase centers
                                                 (to minimize max W). Deconvolution is done on the joint
                                                 full size image, using a PSF from the first subregion.

                                                 wprojplanes=1 : standard prolate spheroid gridder per facet.
                                                 wprojplanes > 1 : W-Projection gridder per facet.
                                                 nfacets=1, wprojplanes > 1 : Pure W-Projection and no facetting.
                                                 nfacets=1, wprojplanes=1 : Same as standard,ft,gridft.

                                                 A combination of facetting and W-Projection is relevant only for
                                                 very large fields of view. (In our current version of tclean, this
                         					combination runs only with parallel=False.

                                mosaic : A-Projection with azimuthally symmetric beams without
                                                 sidelobes, beam rotation or squint correction.
                                                 Gridding convolution functions per visibility are computed
                                                 from FTs of PB models per antenna.
                                                 This gridder can be run on single fields as well as mosaics.

                                                VLA : PB polynomial fit model (Napier and Rots, 1982).
                                                EVLA : PB polynomial fit model (Perley, 2015).
                                                ALMA : Airy disks for a 10.7m dish (for 12m dishes) and
                                                            6.25m dish (for 7m dishes) each with 0.75m
                                                            blockages (Hunter/Brogan 2011). Joint mosaic
                                                            imaging supports heterogeneous arrays for ALMA.

                                                Typical gridding convolution function support sizes are
                                                between 7 and 50 depending on the desired
                                                accuracy (given by the uv cell size or image field of view).

                                                 [ This mode can also be invoked using 'mosaicft' or 'ftmosaic' ]

                                awproject : A-Projection with azimuthally asymmetric beams and
                                                     including beam rotation, squint correction,
                                                     conjugate frequency beams and W-projection.
                                                     [Bhatnagar et.al, 2008]

                                                     Gridding convolution functions are computed from
                                                     aperture illumination models per antenna and optionally
                                                     combined with W-Projection kernels and a prolate spheroid.
                                                     This gridder can be run on single fields as well as mosaics.

                                                 VLA : Uses ray traced model (VLA and EVLA) including feed
                                                          leg and subreflector shadows, off-axis feed location
                                                          (for beam squint and other polarization effects), and
                                                          a Gaussian fit for the feed beams (Brisken 2009)
                                                 ALMA : Similar ray-traced model as above (but the correctness
                                                             of its polarization properties remains un-verified).

                                                Typical gridding convolution function support sizes are
                                                between 7 and 50 depending on the desired
                                                accuracy (given by the uv cell size or image field of view).
                                                When combined with W-Projection they can be significantly larger.

                                                [ This mode can also be invoked using 'awprojectft' ]


                                awp2 : A-Projection with azimuthally asymmetric beams and
                                                     including beam rotation, squint correction and W-projection.
                                                     [Bhatnagar et.al, 2008]

                                                     Gridding convolution functions are computed from
                                                     aperture illumination models (assuming similar antennas) and optionally
                                                     combined with W-Projection kernels.
                                                     This gridder can be run on single fields as well as mosaics.
                                                     The other sub-parameters that are of significance when using this gridder
                                                     are wprojplanes, computepastep, mosweight, usepointing, pblimit and normtype.

                                                 Only supports VLA : Uses ray traced model (VLA and EVLA) including feed
                                                          leg and subreflector shadows, off-axis feed location
                                                          (for beam squint and other polarization effects), and
                                                          a Gaussian fit for the feed beams (Ref: Brisken 2009)

                                                          For squint correction the value passed in computepastep has to be smaller than 180.
                                                          Anything larger awp2 will use an average of LL and RR beams. If computepastep=5, for
                                                          e.g., PB every 5 degrees, over the range of parallactic angle covered by the data, will be calculated
                                                          and the nearest beam to every integration will be used to correct for the squint between the L and R beams.

                                                          NOTE : For mtmfs with nterms >1 and using awp2 gridder, for accurate results  always use specmode="mvc"
                                                          as awp2 with specmode="mfs" does not use  conjugate beams to remove the spectral
                                                          index of the primary beam.

                                awphpg : Implementation of the high performance gridder (HPG; Pokorny, ngVLA Computing Memo #5).
                                                     For CASA 6.7.0 this mode is only available on the internal VLASS release of CASA.
                                                     It will be made available for general use in a future CASA release.


                                imagemosaic : (untested implementation).

                                                        Grid and iFT each pointing separately and combine the
                                                        images as a linear mosaic (weighted by a PB model) in
                                                        the image domain before a joint minor cycle.

                                                        VLA/ALMA PB models are same as for gridder='mosaicft'.

                           ------ Notes on PB models :

                                (1) Several different sources of PB models are used in the modes
                                     listed above. This is partly for reasons of algorithmic flexibility
                                     and partly due to the current  lack of a common beam model
                                     repository or consensus on what beam models are most appropriate.

                                (2) For ALMA and gridder='mosaic', ray-traced (TICRA) beams
                                     are also available via the vpmanager tool.
                                     For example, call the following before the tclean run.
                                    vp.setpbimage(telescope="ALMA",
                                    compleximage='/home/casa/data/trunk/alma/responses/ALMA_0_DV__0_0_360_0_45_90_348.5_373_373_GHz_ticra2007_VP.im',
                                    antnames=['DV'+'%02d'%k for k in range(25)])
                                    vp.saveastable('mypb.tab')
                                    Then, supply vptable='mypb.tab' to tclean.
                                    ( Currently this will work only for non-parallel runs )


                         ------ Note on PB masks :

                                  In tclean, A-Projection gridders (mosaic, awproject, and awp2) produce a
                                  .pb image and use the 'pblimit' subparameter to decide normalization
                                  cutoffs and construct an internal T/F mask in the .pb and .image images.
                                  However, this T/F mask cannot directly be used during deconvolution
                                  (which needs a 1/0 mask). There are two options for making a pb based
                                  deconvolution mask.
                                     -- Run tclean with niter=0 to produce the .pb, construct a 1/0 image
                                  with the desired threshold (using ia.open('newmask.im');
                                  ia.calc('iif("xxx.pb">0.3,1.0,0.0)');ia.close() for example),
                                  and supply it via the 'mask' parameter in a subsequent run
                                  (with calcres=F and calcpsf=F to restart directly from the minor cycle).
                                     -- Run tclean with usemask='pb' for it to automatically construct
                                  a 1/0 mask from the internal T/F mask from .pb at a fixed 0.2 threshold.


                         ----- Making PBs for gridders other than mosaic, awproject, awp2

                               After the PSF generation, a PB is constructed using the same
                               models used in gridder='mosaic' but just evaluated in the image
                               domain without consideration to weights.
    facets               Number of facets on a side

                         A set of (facets x facets) subregions of the specified image
                         are gridded separately using their respective phase centers
                         (to minimize max W). Deconvolution is done on the joint
                         full size image, using a PSF from the first subregion/facet.

                         		       In our current version of tclean, facets>1 may be used only
                         		       with parallel=False.
    psfphasecenter       For mosaic use psf centered on this
                         optional direction. You may need to use
                         this if for example the mosaic does not
                         have any pointing in the center of the
                         image. Another reason; as the psf is
                         approximate for a mosaic, this may help
                         to deconvolve a non central bright source
                         well and quickly.

                         example:

                            psfphasecenter='6' #center psf on field 6.
                            psfphasecenter='J2000 19h30m00 -40d00m00'.
                            psfphasecenter='J2000 292.5deg -40.0deg'.
                            psfphasecenter='J2000 5.105rad -0.698rad'.
                            psfphasecenter='ICRS 13:05:27.2780 -049.28.04.458'.
    wprojplanes          Number of distinct w-values at which to compute and use different
                         gridding convolution functions for W-Projection

                         An appropriate value of wprojplanes depends on the presence/absence
                         of a bright source far from the phase center, the desired dynamic
                         range of an image in the presence of a bright far out source,
                         the maximum w-value in the measurements, and the desired trade off
                         between accuracy and computing cost.

                         As a (rough) guide, VLA L-Band D-config may require a
                         value of 128 for a source 30arcmin away from the phase
                         center. A-config may require 1024 or more. To converge to an
                         appropriate value, try starting with 128 and then increasing
                         it if artifacts persist. W-term artifacts (for the VLA) typically look
                         like arc-shaped smears in a synthesis image or a shift in source
                         position between images made at different times. These artifacts
                         are more pronounced the further the source is from the phase center.

                         There is no harm in simply always choosing a large value (say, 1024)
                         but there will be a significant performance cost to doing so, especially
                         for gridder='awproject' where it is combined with A-Projection.

                         wprojplanes=-1 is an option for gridder='widefield' or 'wproject'
                         in which the number of planes is automatically computed.
    vptable              vpmanager

                         vptable="" : Choose default beams for different telescopes.
                                             ALMA : Airy disks.
                                             EVLA : old VLA models.

                         Other primary beam models can be chosen via the vpmanager tool.

                         Step 1 :  Set up the vpmanager tool and save its state in a table.

                                       vp.setpbpoly(telescope='EVLA', coeff=[1.0, -1.529e-3, 8.69e-7, -1.88e-10])
                                       vp.saveastable('myvp.tab')

                         Step 2 : Supply the name of that table in tclean.

                                      tclean(....., vptable='myvp.tab',....)

                         Please see the documentation for the vpmanager for more details on how to
                         choose different beam models. Work is in progress to update the defaults
                         for EVLA and ALMA.

                         Note : AWProjection currently does not use this mechanism to choose
                                   beam models. It instead uses ray-traced beams computed from
                                   parameterized aperture illumination functions, which are not
                                   available via the vpmanager. So, gridder='awproject' does not allow
                                   the user to set this parameter.
    mosweight            When doing Brigg's style weighting (including uniform) to perform the weight density calculation for each field indepedently if True. If False the weight density is calculated from the average uv distribution of all the fields.
    aterm                Use aperture illumination functions during gridding.

                         This parameter turns on the A-term of the AW-Projection gridder.
                         Gridding convolution functions are constructed from aperture illumination
                         function models of each antenna.
    psterm               Include the Prolate Spheroidal (PS) funtion as the anti-aliasing
                         operator in the gridding convolution functions used for gridding.

                         Setting this parameter to true is necessary when aterm is set to
                         false.  It can be set to false when aterm is set to true, though
                         with this setting effects of aliasing may be there in the image,
                         particularly near the edges.

                         When set to true, the .pb images will contain the fourier transform
                         of the of the PS funtion.

                         			For more information on the functional
                         effects of the psterm, aterm and wprojplanes settings, see the
                         'Wide-field Imaging' pages in CASA Docs (https://casadocs.readthedocs.io).
    wbawp                Use frequency dependent A-terms.
                         Scale aperture illumination functions appropriately with frequency
                         when gridding and combining data from multiple channels.
    conjbeams            Use conjugate frequency for wideband A-terms.

                         While gridding data from one frequency channel, choose a convolution
                         function from a 'conjugate' frequency such that the resulting baseline
                         primary beam is approximately constant across frequency. For a system in
                         which the primary beam scales with frequency, this step will eliminate
                         instrumental spectral structure from the measured data and leave only the
                         sky spectrum for the minor cycle to model and reconstruct [Bhatnagar et al., ApJ, 2013].

                         As a rough guideline for when this is relevant, a source at the half power
                         point of the PB at the center frequency will see an artificial spectral
                         index of -1.4 due to the frequency dependence of the PB [Sault and Wieringa, 1994].
                         If left uncorrected during gridding, this spectral structure must be modeled
                         in the minor cycle (using the mtmfs algorithm) to avoid dynamic range limits
                         (of a few hundred for a 2:1 bandwidth).
                         This works for specmode='mfs' and its value is ignored for cubes.
    cfcache              Convolution function cache directory name.

                         Name of a directory in which to store gridding convolution functions.
                         This cache is filled at the beginning of an imaging run. This step can be time
                         consuming but the cache can be reused across multiple imaging runs that
                         use the same image parameters (cell size, image size , spectral data
                         selections, wprojplanes, wbawp, psterm, aterm).  The effect of the wbawp,
                         psterm and aterm settings is frozen-in in the cfcache. Using an existing cfcache
                         made with a different setting of these parameters will not reflect the current
                         settings.

                         In a parallel execution, the construction of the cfcache is also parallelized
                         and the time to compute scales close to linearly with the number of compute
                         cores used.   With the re-computation of Convolution Functions (CF) due to PA
                         rotation turned-off (the computepastep parameter), the total number of in the
                         cfcache can be computed as [No. of wprojplanes x No. of selected spectral windows x 4]

                         By default, cfcache = imagename + '.cf'
    usepointing          The usepointing flag informs the gridder that it should utilize the pointing table
                         to use the correct direction in which the antenna is pointing with respect to the pointing phasecenter.
    computepastep        Parallactic angle interval after the AIFs are recomputed (deg).

                         This parameter controls the accuracy of the aperture illumination function
                         used with AProjection for alt-az mount dishes where the AIF rotates on the
                         sky as the synthesis image is built up.  Once the PA in the data changes by
                         the given interval, AIFs are re-computed at the new PA.

                         A value of 360.0 deg (the default) implies no re-computation due to PA rotation.
                         AIFs are computed for the PA value of the first valid data received and used for
                         all of the data.

                         For gridder=awp2 a value of 180.0 deg or larger implies no squint correction will be
                         attempted i.e an average beam of the left hand and right hand polarization will be calculated
    rotatepastep         Parallactic angle interval after which the nearest AIF is rotated (deg)

                         Instead of recomputing the AIF for every timestep's parallactic angle,
                         the nearest existing AIF is used and rotated
                         after the PA changed by rotatepastep value.

                         A value of 360.0 deg (the default) disables rotation of the AIF.

                         For example, computepastep=360.0 and rotatepastep=5.0 will compute
                         the AIFs at only the starting parallactic angle and all other timesteps will
                         use a rotated version of that AIF at the nearest 5.0 degree point.
    pointingoffsetsigdev Corrections for heterogenous and time-dependent pointing
                          offsets via AWProjection are controlled by this parameter.
                          It is a vector of 2 ints or doubles each of which is interpreted
                          in units of arcsec. Based on the first threshold, a clustering
                          algorithm is applied to entries from the POINTING subtable
                          of the MS to determine how distinct antenna groups for which
                          the pointing offset must be computed separately.  The second
                          number controls how much a pointing change across time can
                          be ignored and after which an antenna rebinning is required.


                         Note : The default value of this parameter is [], due a programmatic constraint.
                                    If run with this value, it will internally pick [600,600] and exercise the
                                    option of using large tolerances (10arcmin) on both axes. Please choose
                                    a setting explicitly for runs that need to use this parameter.

                         	                Note : This option is available only for gridder='awproject' and usepointing=True and
                                    and has been validated primarily with VLASS on-the-fly mosaic data
                                    where POINTING subtables have been modified after the data are recorded.


                         		        Examples of parameter usage :

                         [100.0,100.0] : Pointing offsets of 100 arcsec or less are considered
                                                 small enough to be ignored.  Using large values for both
                                                 indicates a homogeneous array.


                         [10.0, 100.0] : Based on entries in the POINTING subtable, antennas
                                                are grouped into clusters based on a 10arcsec bin size.
                                                All antennas in a bin are given a pointing offset calculated
                                                as the average of the offsets of all antennas in the bin.
                                                On the time axis, offset changes upto 100 arcsec will be ignored.

                         [10.0,10.0] : Calculate separate pointing offsets for each antenna group
                                              (with a 10 arcsec bin size). As a function of time, recalculate
                                              the antenna binning if the POINTING table entries change by
                                              more than 10 arcsec w.r.to the previously computed binning.

                         [1.0, 1.0] :  Tight tolerances will imply a fully heterogenous situation where
                                            each antenna gets its own pointing offset. Also, time-dependent
                                            offset changes greater than 1 arcsec will trigger recomputes of
                                            the phase gradients. This is the most general situation and is also
                                            the most expensive option as it constructs and uses separate
                                            phase gradients for all baselines and timesteps.

                         For VLASS 1.1 data with two kinds of pointing offsets, the recommended
                         setting is [ 30.0, 30.0 ].

                         For VLASS 1.2 data with only the time-dependent pointing offsets, the
                         recommended setting is [ 300.0, 30.0 ] to turn off the antenna grouping
                         but to retain the time dependent corrections required from one timestep
                         to the next.
    pblimit              PB gain level at which to cut off normalizations.

                          Divisions by .pb during normalizations have a cut off at a .pb gain
                          level given by pblimit. Outside this limit, image values are set to zero.
                          Additionally, by default, an internal T/F mask is applied to the .pb, .image and
                          .residual images to mask out (T) all invalid pixels outside the pblimit area.

                         Note : This internal T/F mask cannot be used as a deconvolution mask.
                                    To do so, please follow the steps listed above in the Notes for the
                                    'gridder' parameter.

                         Note : To prevent the internal T/F mask from appearing in anything other
                                    than the .pb and .image.pbcor images, 'pblimit' can be set to a
                                    negative number.
                                    The absolute value will still be used as a valid 'pblimit' for normalization
                                    purposes. So, for example, pick pblimit=-0.1 (and not pblimit=-1).
                                    A tclean restart using existing output images on disk that already
                                    have this T/F mask in the .residual and .image but only pblimit set
                                    to a negative value, will remove this mask after the next major cycle.

                         Note : An existing internal T/F mask may be removed from an image as
                                    follows (without needing to re-run tclean itself).
                                          ia.open('test.image');
                                          ia.maskhandler(op='set', name='');
                                          ia.done()
    normtype             Normalization type (flatnoise, flatsky, pbsquare).

                          Gridded (and FT'd) images represent the PB-weighted sky image.
                          Qualitatively it can be approximated as two instances of the PB
                          applied to the sky image (one naturally present in the data
                          and one introduced during gridding via the convolution functions).

                          xxx.weight : Weight image approximately equal to sum ( square ( pb ) )
                          xxx.pb : Primary beam calculated as  sqrt ( xxx.weight )

                          normtype='flatnoise' : Divide the raw image by sqrt(.weight) so that
                                                              the input to the minor cycle represents the
                                                              product of the sky and PB. The noise is 'flat'
                                                              across the region covered by each PB.

                         normtype='flatsky' : Divide the raw image by .weight so that the input
                                                          to the minor cycle represents only the sky.
                                                          The noise is higher in the outer regions of the
                                                          primary beam where the sensitivity is low.

                         normtype='pbsquare' : No normalization after gridding and FFT.
                                                               The minor cycle sees the sky times pb square
    deconvolver          Name of minor cycle algorithm (hogbom,clark,multiscale,mtmfs,mem,clarkstokes,asp)

                         Each of the following algorithms operate on residual images and PSFs
                         from the gridder and produce output model and restored images.
                         Minor cycles stop and a major cycle is triggered when cyclethreshold
                         or cycleniter are reached. For all methods, components are picked from
                         the entire extent of the image or (if specified) within a mask.

                         hogbom : An adapted version of Hogbom Clean [Hogbom, 1974].
                                         - Find the location of the peak residual.
                                         - Add this delta function component to the model image.
                                         - Subtract a scaled and shifted PSF of the same size as the image
                                           from regions of the residual image where the two overlap.
                                         - Repeat.

                         clark : An adapted version of Clark Clean [Clark, 1980].
                                         - Find the location of max(I^2+Q^2+U^2+V^2).
                                         - Add delta functions to each stokes plane of the model image.
                                         - Subtract a scaled and shifted PSF within a small patch size
                                           from regions of the residual image where the two overlap.
                                         - After several iterations trigger a Clark major cycle to subtract
                                           components from the visibility domain, but without de-gridding.
                                         - Repeat.

                                        ( Note : 'clark' maps to imagermode='' in the old clean task.
                                                     'clark_exp' is another implementation that maps to
                                                      imagermode='mosaic' or 'csclean' in the old clean task
                                                      but the behavior is not identical. For now, please
                                                      use deconvolver='hogbom' if you encounter problems. )

                         clarkstokes : Clark Clean operating separately per Stokes plane.

                                    (Note : 'clarkstokes_exp' is an alternate version. See above.)

                         multiscale : MultiScale Clean [Cornwell, 2008].
                                         - Smooth the residual image to multiple scale sizes.
                                         - Find the location and scale at which the peak occurs.
                                         - Add this multiscale component to the model image.
                                         - Subtract a scaled,smoothed,shifted PSF (within a small
                                           patch size per scale) from all residual images.
                                         - Repeat from step 2.

                         mtmfs : Multi-term (Multi Scale) Multi-Frequency Synthesis [Rau and Cornwell, 2011].
                                         - Smooth each Taylor residual image to multiple scale sizes.
                                         - Solve a NTxNT system of equations per scale size to compute
                                           Taylor coefficients for components at all locations.
                                         - Compute gradient chi-square and pick the Taylor coefficients
                                            and scale size at the location with maximum reduction in
                                            chi-square.
                                         - Add multi-scale components to each Taylor-coefficient
                                           model image.
                                         - Subtract scaled,smoothed,shifted PSF (within a small patch size
                                           per scale) from all smoothed Taylor residual images.
                                         - Repeat from step 2.


                         mem : Maximum Entropy Method [Cornwell and Evans, 1985].
                                         - Iteratively solve for values at all individual pixels via the
                                           MEM method. It minimizes an objective function of
                                            chi-square plus entropy (here, a measure of difference
                                           between the current model and a flat prior model).

                                           (Note : This MEM implementation is not very robust.
                                                        Improvements will be made in the future.)

                         asp : Adaptive Scale Pixel algorithm [Bhatnagar and Cornwell, 2004].
                                         - Define a set of initial scales defined as 0, W, 2W 4W and 8W.
                                           where W is a 2D Gaussian fitting width to the PSF.
                                         - Smooth the residual image by a Gaussian beam at initial scales.
                                         - Search for the global peak (F) among these smoothed residual images.
                                         - form an active Aspen set: amplitude(F), amplitude location(x,y).
                                         - Optimize the Aspen set by minimizing the objective function RI-Aspen*PSF,
                                           where RI is the residual image and * is the convulition operation.
                                         - Compute the model image and update the residual image
                                         - Repeat from step 2
    scales               List of scale sizes (in pixels) for multi-scale and mtmfs algorithms.
                         -->  scales=[0,6,20]
                         This set of scale sizes should represent the sizes
                         (diameters in units of number of pixels)
                         of dominant features in the image being reconstructed.

                         The smallest scale size is recommended to be 0 (point source),
                         the second being the size of the synthesized beam and the third being 3-5
                         times the synthesized beam, etc. For example, if the synthesized
                         beam is 10" FWHM and cell=2",try scales = [0,5,15].

                         For numerical stability, the largest scale must be
                         smaller than the image (or mask) size and smaller than or
                         comparable to the scale corresponding to the lowest measured
                         spatial frequency (as a scale size much larger than what the
                         instrument is sensitive to is unconstrained by the data making
                         it harder to recover from errors during the minor cycle).
    nterms               Number of Taylor coefficients in the spectral model.

                         - nterms=1 : Assume flat spectrum source.
                         - nterms=2 : Spectrum is a straight line with a slope.
                         - nterms=N : A polynomial of order N-1.

                         From a Taylor expansion of the expression of a power law, the
                         spectral index is derived as alpha = taylorcoeff_1 / taylorcoeff_0.

                         Spectral curvature is similarly derived when possible.

                         The optimal number of Taylor terms depends on the available
                         signal to noise ratio, bandwidth ratio, and spectral shape of the
                         source as seen by the telescope (sky spectrum x PB spectrum).

                         nterms=2 is a good starting point for wideband EVLA imaging
                         and the lower frequency bands of ALMA (when fractional bandwidth
                         is greater than 10%) and if there is at least one bright source for
                         which a dynamic range of greater than few 100 is desired.

                         Spectral artifacts for the VLA often look like spokes radiating out from
                         a bright source (i.e. in the image made with standard mfs imaging).
                         If increasing the number of terms does not eliminate these artifacts,
                         check the data for inadequate bandpass calibration. If the source is away
                         from the pointing center, consider including wide-field corrections too.

                         (Note : In addition to output Taylor coefficient images .tt0,.tt1,etc
                                     images of spectral index (.alpha), an estimate of error on
                                     spectral index (.alpha.error) and spectral curvature (.beta,
                                     if nterms is greater than 2) are produced.
                                     - These alpha, alpha.error and beta images contain
                                       internal T/F masks based on a threshold computed
                                       as peakresidual/10. Additional masking based on
                                      .alpha/.alpha.error may be desirable.
                                     - .alpha.error is a purely empirical estimate derived
                                       from the propagation of error during the division of
                                       two noisy numbers (alpha = xx.tt1/xx.tt0) where the
                                       'error' on tt1 and tt0 are simply the values picked from
                                       the corresponding residual images. The absolute value
                                       of the error is not always accurate and it is best to interpret
                                       the errors across the image only in a relative sense.
    smallscalebias       A numerical control to bias the scales when using multi-scale or mtmfs algorithms.
                         The peak from each scale's smoothed residual is
                         multiplied by ( 1 - smallscalebias \* scale/maxscale )
                         to increase or decrease the amplitude relative to other scales,
                         before the scale with the largest peak is chosen.
                         Smallscalebias can be varied between -1.0 and 1.0.
                         A score of 0.0 gives all scales equal weight (default).
                         		      A score larger than 0.0 will bias the solution towards smaller scales.
                         		      A score smaller than 0.0 will bias the solution towards larger scales.
                         		      The effect of smallscalebias is more pronounced when using multi-scale relative to mtmfs.
    fusedthreshold       ring Hogbom Clean (number in units of Jy).

                         fusedthreshold = 0.0001  : 0.1 mJy.

                         This is a subparameter of the Asp Clean deconvolver. When peak residual
                         is lower than the threshold, Asp Clean is "switched to Hogbom Clean" (i.e. only use the 0 scale for cleaning) for
                         the following number of iterations until it switches back to Asp Clean.

                         NumberIterationsInHogbom = 50 + 2 * (exp(0.05 * NthHogbom) - 1)

                         , where NthHogbom is the number of times Hogbom Clean has been triggered.

                         When the Asp Clean detects it is approaching convergence, it uses only the 0 scale for the following number of iterations for better computational efficiency.

                         NumberIterationsInHogbom = 500 + 2 * (exp(0.05 * NthHogbom) - 1)

                         Set 'fusedthreshold = -1' to make the Asp Clean deconvolver never "switch" to Hogbom Clean.
    largestscale         xels) allowed for the initial guess for the Asp Clean deconvolver.

                         largestscale = 100

                         The default initial scale sizes used by Asp Clean is [0, w, 2w, 4w, 8w],
                         		     where `w` is the PSF width. The default `largestscale` is -1 which indicates
                         		     users accept these initial scales. If `largestscale` is set, the initial scales
                         		     would be [0, w, ... up to the `largestscale`]. This is only an initial guess,
                         		     and actual fitted scale sizes may evolve from these initial values.

                         		     It is recommended not to set `largestscale` unless Asp Clean picks a large
                         		     scale that has no constraints from the data (the UV hole issue).
    restoration          e.

                         Construct a restored image : imagename.image by convolving the model
                         image with a clean beam and adding the residual image to the result.
                         If a restoringbeam is specified, the residual image is also
                         smoothed to that target resolution before adding it in.

                         If a .model does not exist, it will make an empty one and create
                         the restored image from the residuals ( with additional smoothing if needed ).
                         With algorithm='mtmfs', this will construct Taylor coefficient maps from
                         the residuals and compute .alpha and .alpha.error.
    restoringbeam        ize to use.

                         - restoringbeam='' or [''].
                           A Gaussian fitted to the PSF main lobe (separately per image plane).

                         - restoringbeam='10.0arcsec'.
                           Use a circular Gaussian of this width for all planes.

                         - restoringbeam=['8.0arcsec','10.0arcsec','45deg'].
                           Use this elliptical Gaussian for all planes.

                         - restoringbeam='common'.
                           Automatically estimate a common beam shape/size appropriate for
                           all planes. This option can be used when the beam shape is different as a function of frequency, and will smooth all planes to a single beam, defined by the largest beam in the cube.

                         Note : For any restoring beam different from the native resolution
                                    the model image is convolved with the beam and added to
                                    residuals that have been convolved to the same target resolution.
    pbcor                the output restored image.

                         A new image with extension .image.pbcor will be created from
                         the evaluation of   .image / .pb  for all pixels above the specified pblimit.

                         Note : Stand-alone PB-correction can be triggered by re-running
                                   tclean with the appropriate imagename and with
                                   niter=0, calcpsf=False, calcres=False, pbcor=True, vptable='vp.tab'
                                   ( where vp.tab is the name of the vpmanager file;
                                      see the inline help for the 'vptable' parameter ). Alternatively, task impbcor can be used for primary beam correction using the .image and .pb files.

                         Note : For deconvolver='mtmfs', pbcor will divide each Taylor term image by the .tt0 average PB.
                                    For all gridders, this calculation is accurate for small fractional bandwidths.

                                    For large fractional bandwidths, please use one of the following options.

                                    (a) For single pointings, run the tclean task with specmode='mfs', deconvolver='mtmfs',
                                          and gridder='standard' with pbcor=True or False.
                                          If a PB-corrected spectral index is required,
                                          please use the widebandpbcor task to apply multi-tern PB-correction.

                                    (b) For mosaics, run tclean task with specmode='mfs', deconvolver='mtmfs',
                                          and gridder='awproject' , wbawp=True, conjbeams=True, with pbcor=True.
                                          This option applies wideband PB correction as part of the gridding step and
                                          pbcor=True will be accurate because the spectral index map will already
                                          be PB-corrected.

                                    (c) For mosaics, run tclean with specmode='mvc', deconvolver='mtmfs',
                                          and gridder='mosaic' or 'awp2' with pbcor=True.
                                          This option applies wideband PB-correction to channelized residual images
                                          prior to the minor cycle and pbcor=True will be accurate because the spectral
                                          index map will already be PB-corrected.

                          Note : Frequency-dependent PB corrections are typically required for full-band imaging with the VLA.
                                      Wideband PB corrections are required when the amplitude of the
                                      brightest source is known accurately enough to be sensitive
                                      to the difference in the PB gain between the upper and lower
                                      end of the band at its location. As a guideline, the artificial spectral
                                      index due to the PB is -1.4 at the 0.5 gain level and less than -0.2
                                      at the 0.9 gain level at the middle frequency )
    outlierfile          Name of outlier-field image definitions.

                         A text file containing sets of parameter=value pairs,
                         one set per outlier field.

                         Example :   outlierfile='outs.txt'

                                            Contents of outs.txt :

                                                      imagename=tst1
                                                      nchan=1
                                                      imsize=[80,80]
                                                      cell=[8.0arcsec,8.0arcsec]
                                                      phasecenter=J2000 19:58:40.895 +40.55.58.543
                                                      mask=circle[[40pix,40pix],10pix]

                                                      imagename=tst2
                                                      nchan=1
                                                      imsize=[100,100]
                                                      cell=[8.0arcsec,8.0arcsec]
                                                      phasecenter=J2000 19:58:40.895 +40.56.00.000
                                                      mask=circle[[60pix,60pix],20pix]

                            The following parameters are currently allowed to be different between
                            the main field and the outlier fields (i.e. they will be recognized if found
                            in the outlier text file). If a parameter is not listed, the value is picked from
                            what is defined in the main task input.

                                imagename, imsize, cell, phasecenter, startmodel, mask
                                specmode, nchan, start, width, nterms, reffreq,
                                gridder, deconvolver, wprojplanes.

                            Note : 'specmode' is an option, so combinations of mfs and cube
                                       for different image fields, for example, are supported.
                                      'deconvolver' and 'gridder' are also options that allow different
                                       imaging or deconvolution algorithm per image field.

                                       For example, multiscale with wprojection and 16 w-term planes
                                       on the main field and mtmfs with nterms=3 and wprojection
                                       with 64 planes on a bright outlier source for which the frequency
                                       dependence of the primary beam produces a strong effect that
                                       must be modeled.   The traditional alternative to this approach is
                                       to first image the outlier, subtract it out of the data (uvsub) and
                                       then image the main field.
    weighting            Weighting scheme (natural,uniform,briggs,superuniform,radial, briggsabs, briggsbwtaper).

                                 During gridding of the dirty or residual image, each visibility value is
                                 multiplied by a weight before it is accumulated on the uv-grid.
                                 The PSF's uv-grid is generated by gridding only the weights (weightgrid).

                                 weighting='natural' : Gridding weights are identical to the data weights
                                                                   from the MS. For visibilities with similar data weights,
                                                                   the weightgrid will follow the sample density
                                                                   pattern on the uv-plane. This weighting scheme
                                                                   provides the maximum imaging sensitivity at the
                                                                   expense of a PSF with possibly wider main lobes and high sidelobes.
                                                                   It is most appropriate for detection experiments
                                                                   where sensitivity is most important.

                                 weighting='uniform' : Gridding weights per visibility data point are the
                                                                    original data weights divided by the total weight of
                                                                    all data points that map to the same uv grid cell :
                                                                    ' data_weight / total_wt_per_cell '.

                                                                    The weightgrid is as close to flat as possible resulting
                                                                    in a PSF with a narrow main lobe and suppressed
                                                                    sidelobes. However, since heavily sampled areas of
                                                                    the uv-plane get down-weighted, the imaging
                                                                    sensitivity is not as high as with natural weighting.
                                                                    It is most appropriate for imaging experiments where
                                                                    a well behaved PSF can help the reconstruction.

                                 weighting='briggs' :  Gridding weights per visibility data point are given by
                                                                   'data_weight / ( A \* total_wt_per_cell + B ) ' where
                                                                   A and B vary according to the 'robust' parameter.

                                                                   robust = -2.0 maps to A=1,B=0 or uniform weighting.
                                                                   robust = +2.0 maps to natural weighting.
                                                                   (robust=0.5 is equivalent to robust=0.0 in AIPS IMAGR.)

                                                                   Robust/Briggs weighting generates a PSF that can
                                                                   vary smoothly between 'natural' and 'uniform' and
                                                                   allow customized trade-offs between PSF shape and
                                                                   imaging sensitivity.
                                  weighting='briggsabs' : Experimental option.
                                                                   Same as Briggs except the formula is different A=
                                                                   robust\*robust and B is dependent on the
                                                                   noise per visibility estimated. Giving noise='0Jy'
                                                                   is a not a reasonable option.
                                                                   In this mode (or formula)  robust values
                                                                   from -2.0 to 0.0 only make sense (2.0 and
                                                                   -2.0 will get the same weighting)

                                 weighting='superuniform' : This is similar to uniform weighting except that
                                                                              the total_wt_per_cell is replaced by the
                                                                              total_wt_within_NxN_cells around the uv cell of
                                                                              interest. N=7 is the default (when the
                         								    parameter 'npixels' is set to 0 with 'superuniform')

                                                                             This method tends to give a PSF with inner
                                                                             sidelobes that are suppressed as in uniform
                                                                             weighting but with far-out sidelobes closer to
                                                                             natural weighting. The peak sensitivity is also
                                                                             closer to natural weighting.

                                 weighting='radial' : Gridding weights are given by ' data_weight \* uvdistance '
                                                                This method approximately minimizes rms sidelobes
                                                                for an east-west synthesis array.

                                 weighting='briggsbwtaper' : A modified version of Briggs weighting for cubes where an inverse uv taper,
                                                                   which is proportional to the fractional bandwidth of the entire cube,
                                                                   is applied per channel. The objective is to modify cube (perchanweightdensity = True)
                                                                   imaging weights to have a similar density to that of the continuum imaging weights.
                                                                   This is currently an experimental weighting scheme being developed for ALMA.

                         For more details on weighting please see Chapter3
                         of Dan Briggs' thesis (http://www.aoc.nrao.edu/dissertations/dbriggs)
    robust               Robustness parameter for Briggs weighting.

                         robust = -2.0 maps to uniform weighting.
                         robust = +2.0 maps to natural weighting.
                         (robust=0.5 is equivalent to robust=0.0 in AIPS IMAGR.)
    noise                noise parameter for briggs abs mode weighting
    npixels              Number of pixels to determine uv-cell size for super-uniform weighting
                          (0 defaults to -/+ 3 pixels).

                         npixels -- uv-box used for weight calculation
                                        a box going from -npixel/2 to +npixel/2 on each side
                                       around a point is used to calculate weight density.

                         npixels=2 goes from -1 to +1 and covers 3 pixels on a side.

                         npixels=0 implies a single pixel, which does not make sense for
                                         superuniform weighting. Therefore, for 'superuniform'
                         				     weighting, if npixels=0 it will be forced to 6 (or a box
                         				     of -3pixels to +3pixels) to cover 7 pixels on a side.
    uvtaper              uv-taper on outer baselines in uv-plane.

                                          Apply a Gaussian taper in addition to the weighting scheme specified
                                          via the 'weighting' parameter. Higher spatial frequencies are weighted
                                          down relative to lower spatial frequencies to suppress artifacts
                                          arising from poorly sampled areas of the uv-plane. It is equivalent to
                                          smoothing the PSF obtained by other weighting schemes and can be
                                          specified either as the HWHM of a Gaussian in uv-space (eg. units of lambda)
                                          or as the FWHM of a Gaussian in the image domain (eg. angular units like arcsec).

                                          uvtaper = [bmaj, bmin, bpa].

                         		   Note : FWHM_uv_lambda = (4 log2) / ( pi * FWHM_lm_radians ).

                         		   A FWHM_lm of 100.000 arcsec maps to a HWHM_uv of 910.18 lambda.
                                          A FWHM_lm of 1 arcsec maps to a HWHM_uv of 91 klambda.

                                          default: uvtaper=[]; no Gaussian taper applied.
                                          example: uvtaper=['5klambda']  circular taper of  HWHM=5 kilo-lambda.
                                                   uvtaper=['5klambda','3klambda','45.0deg'] uv-domain HWHM.
                         			    uvtaper=['50arcsec','30arcsec','30.0deg'] : image domain FWHM.
                                                   uvtaper=['10arcsec'] : image domain FWHM.
                                                   uvtaper=['300.0'] default units are lambda in aperture plane.
    niter                Maximum number of iterations.

                         A stopping criterion based on total iteration count.
                         Currently the parameter type is defined as an integer therefore the integer value
                         larger than 2147483647 will not be set properly as it causes an overflow.

                         Iterations are typically defined as the selecting one flux component
                         and partially subtracting it out from the residual image.

                         niter=0 : Do only the initial major cycle (make dirty image, psf, pb, etc).

                         niter larger than zero : Run major and minor cycles.

                         Note : Global stopping criteria vs major-cycle triggers.

                                    In addition to global stopping criteria, the following rules are
                                    used to determine when to terminate a set of minor cycle iterations
                                    and trigger major cycles [derived from Cotton-Schwab Clean, 1984].

                                    'cycleniter' : controls the maximum number of iterations per image
                                                        plane before triggering a major cycle.
                                    'cyclethreshold' : Automatically computed threshold related to the
                                                                max sidelobe level of the PSF and peak residual.
                                     Divergence, detected as an increase of 10% in peak residual from the
                                     minimum so far (during minor cycle iterations).

                                     The first criterion to be satisfied takes precedence.

                         Note :  Iteration counts for cubes or multi-field images :
                                     For images with multiple planes (or image fields) on which the
                                     deconvolver operates in sequence, iterations are counted across
                                     all planes (or image fields). The iteration count is compared with
                                     'niter' only after all channels/planes/fields have completed their
                                     minor cycles and exited either due to 'cycleniter' or 'cyclethreshold'.
                                     Therefore, the actual number of iterations reported in the logger
                                     can sometimes be larger than the user specified value in 'niter'.
                                     For example, with niter=100, cycleniter=20,nchan=10,threshold=0,
                                     a total of 200 iterations will be done in the first set of minor cycles
                                     before the total is compared with niter=100 and it exits.

                          Note : Additional global stopping criteria include:
                                    - no change in peak residual across two major cycles.
                                    - a 50% or more increase in peak residual across one major cycle.
    gain                 Loop gain.

                         Fraction of the source flux to subtract out of the residual image
                         for the CLEAN algorithm and its variants.

                         A low value (0.2 or less) is recommended when the sky brightness
                         distribution is not well represented by the basis functions used by
                         the chosen deconvolution algorithm. A higher value can be tried when
                         there is a good match between the true sky brightness structure and
                         the basis function shapes.  For example, for extended emission,
                         multiscale clean with an appropriate set of scale sizes will tolerate
                         a higher loop gain than Clark clean.
    threshold            Stopping threshold (number in units of Jy, or string).

                         A global stopping threshold that the peak residual (within clean mask)
                         across all image planes is compared to.

                         threshold = 0.005  : 5mJy
                         threshold = '5.0mJy'

                         Note : A 'cyclethreshold' is internally computed and used as a major cycle
                                    trigger. It is related to what fraction of the PSF can be reliably
                                    used during minor cycle updates of the residual image. By default
                                    the minor cycle iterations terminate once the peak residual reaches
                                    the first sidelobe level of the brightest source.

                                    'cyclethreshold' is computed as follows using the settings in
                                     parameters 'cyclefactor','minpsffraction','maxpsffraction','threshold' :

                                   psf_fraction = max_psf_sidelobe_level \* 'cyclefactor'
                                   psf_fraction = max(psf_fraction, 'minpsffraction');
                                   psf_fraction = min(psf_fraction, 'maxpsffraction');
                                   cyclethreshold = peak_residual \* psf_fraction
                                   cyclethreshold = max( cyclethreshold, 'threshold' )

                                   If nsigma is set (>0.0), the N-sigma threshold is calculated (see
                                   the description under nsigma), then cyclethreshold is further modified as,

                                   cyclethreshold = max( cyclethreshold, nsgima_threshold ).


                                   'cyclethreshold' is made visible and editable only in the
                                   interactive GUI when tclean is run with interactive=True.
    nsigma               Multiplicative factor for rms-based threshold stopping.

                         N-sigma threshold is calculated as nsigma \* rms value per image plane determined
                         from a robust statistics. For nsigma > 0.0, in a minor cycle, a maximum of the two values,
                         the N-sigma threshold and cyclethreshold, is used to trigger a major cycle
                         (see also the descreption under 'threshold').
                         Set nsigma=0.0 to preserve the previous tclean behavior without this feature.
                         The top level parameter, fastnoise is relevant for the rms noise calculation which is used
                         to determine the threshold.

                         		       The parameter 'nsigma' may be an int, float, or a double.
    cycleniter           Maximum number of minor-cycle iterations (per plane) before triggering
                         a major cycle.

                         For example, for a single plane image, if niter=100 and cycleniter=20,
                         there will be 5 major cycles after the initial one (assuming there is no
                         threshold based stopping criterion). At each major cycle boundary, if
                         the number of iterations left over (to reach niter) is less than cycleniter,
                         it is set to the difference.

                         Note : cycleniter applies per image plane, even if cycleniter x nplanes
                                    gives a total number of iterations greater than 'niter'. This is to
                                    preserve consistency across image planes within one set of minor
                                    cycle iterations.
    cyclefactor          Scaling on PSF sidelobe level to compute the minor-cycle stopping threshold.

                         Please refer to the Note under the documentation for 'threshold' that
                         discussed the calculation of 'cyclethreshold'.

                         cyclefactor=1.0 results in a cyclethreshold at the first sidelobe level of
                         the brightest source in the residual image before the minor cycle starts.

                         cyclefactor=0.5 allows the minor cycle to go deeper.
                         cyclefactor=2.0 triggers a major cycle sooner.
    minpsffraction       PSF fraction that marks the max depth of cleaning in the minor cycle.

                         Please refer to the Note under the documentation for 'threshold' that
                         discussed the calculation of 'cyclethreshold'.

                         For example, minpsffraction=0.5 will stop cleaning at half the height of
                         the peak residual and trigger a major cycle earlier.
    maxpsffraction       PSF fraction that marks the minimum depth of cleaning in the minor cycle.

                         Please refer to the Note under the documentation for 'threshold' that
                         discussed the calculation of 'cyclethreshold'.

                         For example, maxpsffraction=0.8 will ensure that at least the top 20
                         percent of the source will be subtracted out in the minor cycle even if
                         the first PSF sidelobe is at the 0.9 level (an extreme example), or if the
                         cyclefactor is set too high for anything to get cleaned.
    nmajor               The nmajor parameter limits the number of minor and major cycle sets
                         that tclean executes. It is defined as the number of major cycles after the
                         initial set of minor cycle iterations. In other words, the count of nmajor does
                         not include the initial residual calculation that occurs when calcres=True.

                         A setting of nmajor=-1 implies no limit (default -1).
                         A setting of nmajor=0 implies nothing other than the initial residual calculation
                         A setting of nmajor>0 imples that nmajor sets of minor and major cycles will
                         be done in addition to the initial residual calculation.

                         If the major cycle limit is reached, stopcode 9 will be returned. Other stopping
                         criteria (such as threshold) could cause tclean to stop in fewer than this
                         number of major cycles. If tclean reaches another stopping criteria, first
                         or at the same time as nmajor, then that stopcode will be returned instead.

                         Note however that major cycle ids in the log messages as well as in the return
                         dictionary do begin with 1 for the initial residual calculation, when it exists.

                         Example 1 : A tclean run with 'nmajor=5' and 'calcres=True' will iterate for
                         5 major cycles (not counting the initial residual calculation). But, the return
                         dictionary will show 'nmajordone:6'.  If 'calcres=False', then the return
                         dictionary will show 'nmajordone:5'.

                         Example 2 : For both the following cases, there will be a printout in the logs
                         "Running Major Cycle 1" and the return value will include "nmajordone: 1",
                         however there is a difference in the purpose of the major cycle and the
                         number of minor cycles executed:
                             Case 1; nmajor=0, calcres=True:  The major cycle done is for the creation
                                         of the residual, and no minor cycles are executed.
                             Case 2; nmajor=1, calcres=False: The major cycle is done as part of the
                                         major/minor cycle loop, and 1 minor cycle will be executed.
    usemask              Type of mask(s) to be used for deconvolution.

                          user: (default) mask image(s) or user specified region file(s) or string CRTF expression(s).
                            subparameters: mask, pbmask.
                          pb: primary beam mask.
                            subparameter: pbmask.

                              Example: usemask="pb", pbmask=0.2.
                                                Construct a mask at the 0.2 pb gain level.
                                                (Currently, this option will work only with

                                                gridders that produce .pb (i.e. mosaic, awp2 and awproject)
                                                or if an externally produced .pb image exists on disk)


                          auto-multithresh : auto-masking by multiple thresholds for deconvolution.
                             subparameters : sidelobethreshold, noisethreshold, lownoisethreshold, negativethrehsold,  smoothfactor,
                                             minbeamfrac, cutthreshold, pbmask, growiterations, dogrowprune, minpercentchange, verbose.
                             Additional top level parameter relevant to auto-multithresh: fastnoise.

                             if pbmask is >0.0, the region outside the specified pb gain level is excluded from
                             image statistics in determination of the threshold.




                          Note: By default the intermediate mask generated by automask at each deconvolution cycle
                                is over-written in the next cycle but one can save them by setting
                                the environment variable, SAVE_ALL_AUTOMASKS="true".
                                (e.g. in the CASA prompt, os.environ['SAVE_ALL_AUTOMASKS']="true" )
                                The saved CASA mask image name will be imagename.mask.autothresh#, where
                                # is the iteration cycle number.
    mask                 Mask (a list of image name(s) or region file(s) or region string(s).


                                            The name of a CASA image or region file or region string that specifies
                                            a 1/0 mask to be used for deconvolution. Only locations with value 1 will
                                            be considered for the centers of flux components in the minor cycle.
                                            If regions specified fall completely outside of the image, tclean will throw an error.

                                            Manual mask options/examples :

                                            mask='xxx.mask'  : Use this CASA image named xxx.mask and containing
                                                                            ones and zeros as the mask.
                                                                            If the mask is only different in spatial coordinates from what is being made
                                                                            it will be resampled to the target coordinate system before being used.
                                                                            The mask has to have the same shape in velocity and Stokes planes
                                                                            as the output image. Exceptions are single velocity and/or single
                                                                            Stokes plane masks. They will be expanded to cover all velocity and/or
                                                                            Stokes planes of the output cube.

                                                                            [ Note : If an error occurs during image resampling or
                                                                                        if the expected mask does not appear, please try
                                                                                        using tasks 'imregrid' or 'makemask' to resample
                                                                                        the mask image onto a CASA image with the target
                                                                                        shape and coordinates and supply it via the 'mask'
                                                                                        parameter. ]


                                            mask='xxx.crtf' : A text file with region strings and the following on the first line
                                                                       ( #CRTFv0 CASA Region Text Format version 0 )
                                                                       This is the format of a file created via the viewer's region
                                                                       tool when saved in CASA region file format.

                                            mask='circle[[40pix,40pix],10pix]'  : A CASA region string.

                                            mask=['xxx.mask','xxx.crtf', 'circle[[40pix,40pix],10pix]']  : a list of masks.





                                            Note : Mask images for deconvolution must contain 1 or 0 in each pixel.
                                                       Such a mask is different from an internal T/F mask that can be
                                                       held within each CASA image. These two types of masks are not
                                                       automatically interchangeable, so please use the makemask task
                                                       to copy between them if you need to construct a 1/0 based mask
                                                       from a T/F one.

                                            Note : Work is in progress to generate more flexible masking options and
                                                       enable more controls.
    pbmask               Sub-parameter for usemask: primary beam mask.

                         Examples : pbmask=0.0 (default, no pb mask).
                                    pbmask=0.2 (construct a mask at the 0.2 pb gain level).
    sidelobethreshold    Sub-parameter for "auto-multithresh":  mask threshold based on sidelobe levels:  sidelobethreshold \* max_sidelobe_level \* peak residual.
    noisethreshold       Sub-parameter for "auto-multithresh":  mask threshold based on the noise level: noisethreshold \* rms + location (=median).

                         The rms is calculated from the median absolute deviation (MAD), with rms = 1.4826\*MAD.
    lownoisethreshold    Sub-parameter for "auto-multithresh":  mask threshold to grow previously masked regions via binary dilation:   lownoisethreshold \* rms in residual image + location (=median).

                         The rms is calculated from the median absolute deviation (MAD), with rms = 1.4826\*MAD.
    negativethreshold    Sub-parameter for "auto-multithresh": mask threshold  for negative features: -1.0* negativethreshold \* rms + location(=median).

                         The rms is calculated from the median absolute deviation (MAD), with rms = 1.4826\*MAD.
    smoothfactor         Sub-parameter for "auto-multithresh":  smoothing factor in a unit of the beam.
    minbeamfrac          Sub-parameter for "auto-multithresh":  minimum beam fraction in size to prune masks smaller than mimbeamfrac \* beam
                         <=0.0 : No pruning
    cutthreshold         Sub-parameter for "auto-multithresh": threshold to cut the smoothed mask to create a final mask: cutthreshold \* peak of the smoothed mask.
    growiterations       Sub-parameter for "auto-multithresh": Maximum number of iterations to perform using binary dilation for growing the mask.
    dogrowprune          Experimental sub-parameter for "auto-multithresh": Do pruning on the grow mask.
    minpercentchange     If the change in the mask size in a particular channel is less than minpercentchange, stop masking that channel in subsequent cycles. This check is only applied when noise based threshold is used and when the previous clean major cycle had a cyclethreshold value equal to the clean threshold. Values equal to -1.0 (or any value less than 0.0) will turn off this check (the default). Automask will still stop masking if the current channel mask is an empty mask and the noise threshold was used to determine the mask.
    verbose              he summary of automasking at the end of each automasking process
                         is printed in the logger.  Following information per channel will be listed in the summary.

                         chan: channel number.
                         masking?: F - stop updating automask for the subsequent iteration cycles.
                         RMS: robust rms noise.
                         peak: peak in residual image.
                         thresh_type: type of threshold used (noise or sidelobe).
                         thresh_value: the value of threshold used.
                         N_reg: number of the automask regions.
                         N_pruned: number of the automask regions removed by pruning.
                         N_grow: number of the grow mask regions.
                         N_grow_pruned: number of the grow mask regions removed by pruning.
                         N_neg_pix: number of pixels for negative mask regions.

                         Note that for a large cube, extra logging may slow down the process.
    fastnoise            Only relevant when automask (user='multi-autothresh') and/or n-sigma stopping threshold (nsigma>0.0) are/is used. If it is set to True,  a simpler but faster noise calucation is used.
                                                In this case, the threshold values are determined based on classic statistics (using all
                                                unmasked pixels for the calculations).

                                                If it is set to False,  the new noise calculation
                                                method is used based on pre-existing mask.

                                                Case 1: no exiting mask.
                                                Calculate image statistics using Chauvenet algorithm.

                                                Case 2: there is an existing mask.
                                                Calculate image statistics by classical method on the region
                                                outside the mask and inside the primary beam mask.

                                                In all cases above RMS noise is calculated from the median absolute deviation (MAD).
    restart              images (and start from an existing model image)
                         or automatically increment the image name and make a new image set.

                         True : Re-use existing images. If imagename.model exists the subsequent
                                   run will start from this model (i.e. predicting it using current gridder
                                   settings and starting from the residual image).  Care must be taken
                                   when combining this option with startmodel. Currently, only one or
                                   the other can be used.

                                   startmodel='', imagename.model exists :
                                             - Start from imagename.model.
                                   startmodel='xxx', imagename.model does not exist :
                                             - Start from startmodel.
                                   startmodel='xxx', imagename.model exists :
                                             - Exit with an error message requesting the user to pick
                                               only one model.  This situation can arise when doing one
                                               run with startmodel='xxx' to produce an output
                                               imagename.model that includes the content of startmodel,
                                               and wanting to restart a second run to continue deconvolution.
                                               Startmodel should be set to '' before continuing.

                                    If any change in the shape or coordinate system of the image is
                                    desired during the restart, please change the image name and
                                    use the startmodel (and mask) parameter(s) so that the old model
                                    (and mask) can be regridded to the new coordinate system before starting.

                          False : A convenience feature to increment imagename with '_1', '_2',
                                     etc as suffixes so that all runs of tclean are fresh starts (without
                                     having to change the imagename parameter or delete images).

                                     This mode will search the current directory for all existing
                                     imagename extensions, pick the maximum, and adds 1.
                                     For imagename='try' it will make try.psf, try_2.psf, try_3.psf, etc.

                                     This also works if you specify a directory name in the path :
                                     imagename='outdir/try'.  If './outdir' does not exist, it will create it.
                                     Then it will search for existing filenames inside that directory.

                                     If outlier fields are specified, the incrementing happens for each
                                     of them (since each has its own 'imagename').  The counters are
                                     synchronized across imagefields, to make it easier to match up sets
                                     of output images.  It adds 1 to the 'max id' from all outlier names
                                     on disk.  So, if you do two runs with only the main field
                                    (imagename='try'), and in the third run you add an outlier with
                                    imagename='outtry', you will get the following image names
                                    for the third run :  'try_3' and 'outtry_3' even though
                                    'outry' and 'outtry_2' have not been used.
    savemodel            Options to save model visibilities (none, virtual, modelcolumn).

                         Often, model visibilities must be created and saved in the MS
                         to be later used for self-calibration (or to just plot and view them).

                            none : Do not save any model visibilities in the MS. The MS is opened
                                       in readonly mode.

                                       Model visibilities can be predicted in a separate step by
                                       restarting tclean with niter=0,savemodel=virtual or modelcolumn
                                       and not changing any image names so that it finds the .model on
                                       disk (or by changing imagename and setting startmodel to the
                                       original imagename).

                            virtual : In the last major cycle, save the image model and state of the
                                         gridder used during imaging within the SOURCE subtable of the
                                         MS. Images required for de-gridding will also be stored internally.
                                         All future references to model visibilities will activate the
                                         (de)gridder to compute them on-the-fly.  This mode is useful
                                         when the dataset is large enough that an additional model data
                                         column on disk may be too much extra disk I/O, when the
                                         gridder is simple enough that on-the-fly recomputing of the
                                         model visibilities is quicker than disk I/O.
                                         For e.g. that gridder='awproject' and 'awp2' does not support virtual model.

                            modelcolumn : In the last major cycle, save predicted model visibilities
                                        in the MODEL_DATA column of the MS. This mode is useful when
                                        the de-gridding cost to produce the model visibilities is higher
                                        than the I/O required to read the model visibilities from disk.
                                        This mode is currently required for gridder='awproject' and 'awp2'.
                                        This mode is also required for the ability to later pull out
                                        model visibilities from the MS into a python array for custom
                                        processing.

                          Note 1 : The imagename.model  image on disk will always be constructed
                                        if the minor cycle runs. This savemodel parameter applies only to
                                        model visibilities created by de-gridding the model image.

                          Note 2 :  It is possible for an MS to have both a virtual model
                                        as well as a model_data column, but under normal operation,
                                        the last used mode will get triggered.  Use the delmod task to
                                        clear out existing models from an MS if confusion arises.
                         Note 3:    when parallel=True, use savemodel='none'; Other options are not yet ready
                                    for use in parallel. If model visibilities need to be saved (virtual or modelcolumn):
                                    please run tclean in serial mode with niter=0; after the parallel run
    calcres              Calculate initial residual image.

                         This parameter controls what the first major cycle does.

                         calcres=False with niter greater than 0 will assume that
                         a .residual image already exists  and that the minor cycle can
                         begin without recomputing it.

                         calcres=False with niter=0 implies that only the PSF will be made
                         and no data will be gridded.

                         calcres=True requires that calcpsf=True or that the .psf and .sumwt
                         images already exist on disk (for normalization purposes).

                         Usage example : For large runs (or a pipeline scripts) it may be
                                                     useful to first run tclean with niter=0 to create
                                                     an initial .residual to look at and perhaps make
                                                     a custom mask for. Imaging can be resumed
                                                     without recomputing it.
    calcpsf              Calculate PSF

                         This parameter controls what the first major cycle does.

                         calcpsf=False will assume that a .psf image already exists
                         and that the minor cycle can begin without recomputing it.
    psfcutoff            When the .psf image is created a 2 dimensional Gaussian is fit to the main lobe of the PSF.
                         Which pixels in the PSF are fitted is determined by psfcutoff.
                         The default value of psfcutoff is 0.35 and can varied from 0.01 to 0.99.
                         Fitting algorithm:
                             - A region of 41 x 41 pixels around the peak of the PSF is compared against the psfcutoff.
                                 Sidelobes are ignored by radially searching from the PSF peak.
                             - Calculate the bottom left corner (blc) and top right corner (trc) from the points. Expand blc and trc with a number of pixels (5).
                             - Create a new sub-matrix from blc and trc.
                             - Interpolate matrix to a target number of points (3001) using CUBIC spline.
                             - All the non-sidelobe points, in the interpolated matrix, that are above the psfcutoff are used to fit a Gaussian.
                                 A Levenberg-Marquardt algorithm is used.
                             - If the fitting fails the algorithm is repeated with the psfcutoff decreased (psfcutoff=psfcutoff/1.5).
                                 A message in the log will apear if the fitting fails along with the new value of psfcutoff.
                                 This will be done up to 50 times if fitting fails.
                         This Gaussian beam is defined by a major axis, minor axis, and position angle.
                         During the restoration process, this Gaussian beam is used as the Clean beam.
                         Varying psfcutoff might be useful for producing a better fit for highly non-Gaussian PSFs, however, the resulting fits should be carefully checked.
                         This parameter should rarely be changed.

                         (This is not the support size for clark clean.)
    parallel             Run major cycles in parallel.

                          Parallel tclean will run only if casa has already been started using mpirun.
                          Please refer to external resources on high performance computing for details on how to start this on your system.

                          Example :  mpirun -n 3 -xterm 0 `which casa`

                          Continuum Imaging :
                             -  Data are partitioned (in time) into NProc pieces.
                             -  Gridding/iFT is done separately per partition.
                             -  Images (and weights) are gathered and then normalized.
                             - One non-parallel minor cycle is run.
                             - Model image is scattered to all processes.
                             - Major cycle is done in parallel per partition.

                         Cube Imaging :
                             - Data and Image coordinates are partitioned (in freq) into NProc pieces.
                             - Each partition is processed independently (major and minor cycles).
                             - All processes are synchronized at major cycle boundaries for convergence checks.
                             - At the end, cubes from all partitions are concatenated along the spectral axis.

                         Note 1 :  Iteration control for cube imaging is independent per partition.
                                       - There is currently no communication between them to synchronize
                                          information such as peak residual and cyclethreshold. Therefore,
                                          different chunks may trigger major cycles at different levels.
                                      (Proper synchronization of iteration control is work in progress.)
    [1;42mRETURNS[1;m                 void

    --------- examples -----------------------------------------------------------



    For more information, see the task pages of tclean in CASA Docs:

    https://casadocs.readthedocs.io





    """

    _info_group_ = """imaging"""
    _info_desc_ = """Radio Interferometric Image Reconstruction w/ interactive masking"""

    __schema = { 'vis': {'anyof': [{'type': 'cReqPath', 'coerce': _coerce.expand_path}, {'type': 'cReqPathVec', 'coerce': [_coerce.to_list,_coerce.expand_pathvec]}]}, 'selectdata': {'type': 'cBool'}, 'field': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'spw': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'timerange': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'uvrange': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'antenna': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'scan': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'observation': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cInt'}]}, 'intent': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'datacolumn': {'type': 'cStr', 'coerce': _coerce.to_str}, 'imagename': {'anyof': [{'type': 'cInt'}, {'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'imsize': {'anyof': [{'type': 'cInt'}, {'type': 'cIntVec', 'coerce': [_coerce.to_list,_coerce.to_intvec]}]}, 'cell': {'anyof': [{'type': 'cIntVec', 'coerce': [_coerce.to_list,_coerce.to_intvec]}, {'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cFloat', 'coerce': _coerce.to_float}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}, {'type': 'cInt'}, {'type': 'cFloatVec', 'coerce': [_coerce.to_list,_coerce.to_floatvec]}]}, 'phasecenter': {'anyof': [{'type': 'cInt'}, {'type': 'cStr', 'coerce': _coerce.to_str}]}, 'stokes': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'I', 'IQUV', 'UV', 'RRLL', 'IQ', 'V', 'pseudoI', 'QU', 'YY', 'RR', 'Q', 'U', 'IV', 'XX', 'XXYY', 'LL' ]}, 'projection': {'type': 'cStr', 'coerce': _coerce.to_str}, 'startmodel': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'specmode': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'cont', 'cubedata', 'cube', 'cubesource', 'mfs', 'mvc' ]}, 'reffreq': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'nchan': {'type': 'cInt'}, 'start': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'width': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'outframe': {'type': 'cStr', 'coerce': _coerce.to_str}, 'veltype': {'type': 'cStr', 'coerce': _coerce.to_str}, 'restfreq': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'interpolation': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'nearest', 'linear', 'cubic' ]}, 'perchanweightdensity': {'type': 'cBool'}, 'gridder': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'widefield', 'wproject', 'awphpg', 'imagemosaic', 'standard', 'awproject', 'wprojectft', 'mosaicft', 'ft', 'ftmosaic', 'mosaic', 'awprojectft', 'gridft', 'awp2' ]}, 'facets': {'type': 'cInt'}, 'psfphasecenter': {'anyof': [{'type': 'cInt'}, {'type': 'cStr', 'coerce': _coerce.to_str}]}, 'wprojplanes': {'type': 'cInt'}, 'vptable': {'type': 'cStr', 'coerce': _coerce.to_str}, 'mosweight': {'type': 'cBool'}, 'aterm': {'type': 'cBool'}, 'psterm': {'type': 'cBool'}, 'wbawp': {'type': 'cBool'}, 'conjbeams': {'type': 'cBool'}, 'cfcache': {'type': 'cStr', 'coerce': _coerce.to_str}, 'usepointing': {'type': 'cBool'}, 'computepastep': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'rotatepastep': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'pointingoffsetsigdev': {'anyof': [{'type': 'cIntVec', 'coerce': [_coerce.to_list,_coerce.to_intvec]}, {'type': 'cFloatVec', 'coerce': [_coerce.to_list,_coerce.to_floatvec]}]}, 'pblimit': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'normtype': {'type': 'cStr', 'coerce': _coerce.to_str}, 'deconvolver': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'clarkstokes_exp', 'mtmfs', 'mem', 'clarkstokes', 'hogbom', 'clark_exp', 'clark', 'asp', 'multiscale' ]}, 'scales': {'anyof': [{'type': 'cIntVec', 'coerce': [_coerce.to_list,_coerce.to_intvec]}, {'type': 'cFloatVec', 'coerce': [_coerce.to_list,_coerce.to_floatvec]}]}, 'nterms': {'type': 'cInt'}, 'smallscalebias': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'fusedthreshold': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'largestscale': {'type': 'cInt'}, 'restoration': {'type': 'cBool'}, 'restoringbeam': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'pbcor': {'type': 'cBool'}, 'outlierfile': {'type': 'cStr', 'coerce': _coerce.to_str}, 'weighting': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'briggsabs', 'briggs', 'briggsbwtaper', 'natural', 'radial', 'superuniform', 'uniform' ]}, 'robust': {'type': 'cFloat', 'coerce': _coerce.to_float, 'min': -2.0, 'max': 2.0}, 'noise': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'npixels': {'type': 'cInt'}, 'uvtaper': {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}, 'niter': {'type': 'cInt'}, 'gain': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'threshold': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'nsigma': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'cycleniter': {'type': 'cInt'}, 'cyclefactor': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'minpsffraction': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'maxpsffraction': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'nmajor': {'type': 'cInt'}, 'usemask': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'user', 'pb', 'auto-multithresh' ]}, 'mask': {'anyof': [{'type': 'cStr', 'coerce': _coerce.to_str}, {'type': 'cStrVec', 'coerce': [_coerce.to_list,_coerce.to_strvec]}]}, 'pbmask': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'sidelobethreshold': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'noisethreshold': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'lownoisethreshold': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'negativethreshold': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'smoothfactor': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'minbeamfrac': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'cutthreshold': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'growiterations': {'type': 'cInt'}, 'dogrowprune': {'type': 'cBool'}, 'minpercentchange': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'verbose': {'type': 'cBool'}, 'fastnoise': {'type': 'cBool'}, 'restart': {'type': 'cBool'}, 'savemodel': {'type': 'cStr', 'coerce': _coerce.to_str, 'allowed': [ 'none', 'virtual', 'modelcolumn' ]}, 'calcres': {'type': 'cBool'}, 'calcpsf': {'type': 'cBool'}, 'psfcutoff': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'parallel': {'type': 'cBool'},  }

    def __init__(self):
        self.__stdout = None
        self.__stderr = None
        self.__root_frame_ = None

    def __globals_(self):
        if self.__root_frame_ is None:
            self.__root_frame_ = _find_frame( )
            assert self.__root_frame_ is not None, "could not find CASAshell global frame"
        return self.__root_frame_

    def __to_string_(self,value):
        if type(value) is str:
            return "'%s'" % value
        else:
            return str(value)

    def __validate_(self,doc,schema):
        return _pc.validate(doc,schema)

    def __do_inp_output(self,param_prefix,description_str,formatting_chars):
        out = self.__stdout or sys.stdout
        description = description_str.split( )
        prefix_width = 23 + 23 + 4
        output = [ ]
        addon = ''
        first_addon = True
        if len(description) == 0:
            out.write(param_prefix + " #\n")
            return
        while len(description) > 0:
            ## starting a new line.....................................................................
            if len(output) == 0:
                ## for first line add parameter information............................................
                if len(param_prefix)-formatting_chars > prefix_width - 1:
                    output.append(param_prefix)
                    continue
                addon = param_prefix + ' #'
                first_addon = True
                addon_formatting = formatting_chars
            else:
                ## for subsequent lines space over prefix width........................................
                addon = (' ' * prefix_width) + '#'
                first_addon = False
                addon_formatting = 0
            ## if first word of description puts us over the screen width, bail........................
            if len(addon + description[0]) - addon_formatting + 1 > self.term_width:
                ## if we're doing the first line make sure it's output.................................
                if first_addon: output.append(addon)
                break
            while len(description) > 0:
                ## if the next description word puts us over break for the next line...................
                if len(addon + description[0]) - addon_formatting + 1 > self.term_width: break
                addon = addon + ' ' + description[0]
                description.pop(0)
            output.append(addon)
        out.write('\n'.join(output) + '\n')

    #--------- go functions -----------------------------------------------------------
    def __vis_dflt( self, glb ):
        return ''

    def __vis( self, glb ):
        if 'vis' in glb: return glb['vis']
        return ''

    def __vis_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__vis_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = 'Name of input visibility file(s)'
        value = self.__vis( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'vis': value},{'vis': self.__schema['vis']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('vis',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __selectdata_dflt( self, glb ):
        return True

    def __selectdata( self, glb ):
        if 'selectdata' in glb: return glb['selectdata']
        return True

    def __selectdata_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__selectdata_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = 'Enable data selection parameters'
        value = self.__selectdata( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'selectdata': value},{'selectdata': self.__schema['selectdata']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('selectdata',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __field_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __field( self, glb ):
        if 'field' in glb: return glb['field']
        dflt = self.__field_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __field_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__field_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__field_dflt( self.__globals_( ) ) is not None:
             description = 'field(s) to select'
             value = self.__field( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'field': value},{'field': self.__schema['field']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('field',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __spw_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __spw( self, glb ):
        if 'spw' in glb: return glb['spw']
        dflt = self.__spw_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __spw_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__spw_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__spw_dflt( self.__globals_( ) ) is not None:
             description = 'spw(s)/channels to select'
             value = self.__spw( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'spw': value},{'spw': self.__schema['spw']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('spw',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __timerange_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __timerange( self, glb ):
        if 'timerange' in glb: return glb['timerange']
        dflt = self.__timerange_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __timerange_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__timerange_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__timerange_dflt( self.__globals_( ) ) is not None:
             description = 'Range of time to select from data'
             value = self.__timerange( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'timerange': value},{'timerange': self.__schema['timerange']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('timerange',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __uvrange_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __uvrange( self, glb ):
        if 'uvrange' in glb: return glb['uvrange']
        dflt = self.__uvrange_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __uvrange_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__uvrange_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__uvrange_dflt( self.__globals_( ) ) is not None:
             description = 'Select data within uvrange'
             value = self.__uvrange( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'uvrange': value},{'uvrange': self.__schema['uvrange']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('uvrange',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __antenna_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __antenna( self, glb ):
        if 'antenna' in glb: return glb['antenna']
        dflt = self.__antenna_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __antenna_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__antenna_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__antenna_dflt( self.__globals_( ) ) is not None:
             description = 'Select data based on antenna/baseline'
             value = self.__antenna( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'antenna': value},{'antenna': self.__schema['antenna']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('antenna',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __scan_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __scan( self, glb ):
        if 'scan' in glb: return glb['scan']
        dflt = self.__scan_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __scan_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__scan_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__scan_dflt( self.__globals_( ) ) is not None:
             description = 'Scan number range'
             value = self.__scan( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'scan': value},{'scan': self.__schema['scan']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('scan',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __observation_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __observation( self, glb ):
        if 'observation' in glb: return glb['observation']
        dflt = self.__observation_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __observation_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__observation_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__observation_dflt( self.__globals_( ) ) is not None:
             description = 'Observation ID range'
             value = self.__observation( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'observation': value},{'observation': self.__schema['observation']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('observation',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __intent_dflt( self, glb ):
        if self.__selectdata( glb ) == bool(True): return ""
        return None

    def __intent( self, glb ):
        if 'intent' in glb: return glb['intent']
        dflt = self.__intent_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __intent_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__intent_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__intent_dflt( self.__globals_( ) ) is not None:
             description = 'Scan Intent(s)'
             value = self.__intent( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'intent': value},{'intent': self.__schema['intent']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('intent',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __datacolumn_dflt( self, glb ):
        return 'corrected'

    def __datacolumn( self, glb ):
        if 'datacolumn' in glb: return glb['datacolumn']
        return 'corrected'

    def __datacolumn_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__datacolumn_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'corrected'
        description = 'Data column to image(data,corrected)'
        value = self.__datacolumn( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'datacolumn': value},{'datacolumn': self.__schema['datacolumn']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('datacolumn',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __imagename_dflt( self, glb ):
        return ''

    def __imagename( self, glb ):
        if 'imagename' in glb: return glb['imagename']
        return ''

    def __imagename_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__imagename_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = 'Pre-name of output images'
        value = self.__imagename( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'imagename': value},{'imagename': self.__schema['imagename']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('imagename',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __imsize_dflt( self, glb ):
        return [ int(100) ]

    def __imsize( self, glb ):
        if 'imsize' in glb: return glb['imsize']
        return [ int(100) ]

    def __imsize_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__imsize_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [ int(100) ]
        description = 'Number of pixels'
        value = self.__imsize( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'imsize': value},{'imsize': self.__schema['imsize']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('imsize',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __cell_dflt( self, glb ):
        return [  ]

    def __cell( self, glb ):
        if 'cell' in glb: return glb['cell']
        return [  ]

    def __cell_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__cell_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [  ]
        description = 'Cell size'
        value = self.__cell( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'cell': value},{'cell': self.__schema['cell']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('cell',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __phasecenter_dflt( self, glb ):
        return ''

    def __phasecenter( self, glb ):
        if 'phasecenter' in glb: return glb['phasecenter']
        return ''

    def __phasecenter_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__phasecenter_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = 'Phase center of the image'
        value = self.__phasecenter( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'phasecenter': value},{'phasecenter': self.__schema['phasecenter']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('phasecenter',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __stokes_dflt( self, glb ):
        return 'I'

    def __stokes( self, glb ):
        if 'stokes' in glb: return glb['stokes']
        return 'I'

    def __stokes_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__stokes_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'I'
        description = 'Stokes Planes to make'
        value = self.__stokes( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'stokes': value},{'stokes': self.__schema['stokes']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('stokes',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __projection_dflt( self, glb ):
        return 'SIN'

    def __projection( self, glb ):
        if 'projection' in glb: return glb['projection']
        return 'SIN'

    def __projection_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__projection_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'SIN'
        description = 'Coordinate projection'
        value = self.__projection( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'projection': value},{'projection': self.__schema['projection']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('projection',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __startmodel_dflt( self, glb ):
        return ''

    def __startmodel( self, glb ):
        if 'startmodel' in glb: return glb['startmodel']
        return ''

    def __startmodel_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__startmodel_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = 'Name of starting model image'
        value = self.__startmodel( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'startmodel': value},{'startmodel': self.__schema['startmodel']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('startmodel',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __specmode_dflt( self, glb ):
        return 'mfs'

    def __specmode( self, glb ):
        if 'specmode' in glb: return glb['specmode']
        return 'mfs'

    def __specmode_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__specmode_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'mfs'
        description = 'Spectral definition mode (mfs,cube,cubedata, cubesource,mvc)'
        value = self.__specmode( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'specmode': value},{'specmode': self.__schema['specmode']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('specmode',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __reffreq_dflt( self, glb ):
        if self.__specmode( glb ) == "mfs": return ""
        if self.__specmode( glb ) == "mvc": return ""
        return None

    def __reffreq( self, glb ):
        if 'reffreq' in glb: return glb['reffreq']
        dflt = self.__reffreq_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __reffreq_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__reffreq_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__reffreq_dflt( self.__globals_( ) ) is not None:
             description = 'Reference frequency'
             value = self.__reffreq( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'reffreq': value},{'reffreq': self.__schema['reffreq']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('reffreq',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __nchan_dflt( self, glb ):
        if self.__specmode( glb ) == "mvc": return int(-1)
        if self.__specmode( glb ) == "cube": return int(-1)
        if self.__specmode( glb ) == "cubesource": return int(-1)
        if self.__specmode( glb ) == "cubedata": return int(-1)
        return None

    def __nchan( self, glb ):
        if 'nchan' in glb: return glb['nchan']
        dflt = self.__nchan_dflt( glb )
        if dflt is not None: return dflt
        return int(-1)

    def __nchan_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__nchan_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(-1)
        if self.__nchan_dflt( self.__globals_( ) ) is not None:
             description = 'Number of channels in the output image'
             value = self.__nchan( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'nchan': value},{'nchan': self.__schema['nchan']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('nchan',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __start_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return ""
        if self.__specmode( glb ) == "cubesource": return ""
        if self.__specmode( glb ) == "cubedata": return ""
        return None

    def __start( self, glb ):
        if 'start' in glb: return glb['start']
        dflt = self.__start_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __start_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__start_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__start_dflt( self.__globals_( ) ) is not None:
             description = 'First channel (e.g. start=3,start=\'1.1GHz\',start=\'15343km/s\')'
             value = self.__start( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'start': value},{'start': self.__schema['start']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('start',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __width_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return ""
        if self.__specmode( glb ) == "cubesource": return ""
        if self.__specmode( glb ) == "cubedata": return ""
        return None

    def __width( self, glb ):
        if 'width' in glb: return glb['width']
        dflt = self.__width_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __width_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__width_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__width_dflt( self.__globals_( ) ) is not None:
             description = 'Channel width (e.g. width=2,width=\'0.1MHz\',width=\'10km/s\')'
             value = self.__width( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'width': value},{'width': self.__schema['width']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('width',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __outframe_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return ""
        if self.__specmode( glb ) == "cubesource": return "REST"
        return None

    def __outframe( self, glb ):
        if 'outframe' in glb: return glb['outframe']
        dflt = self.__outframe_dflt( glb )
        if dflt is not None: return dflt
        return 'LSRK'

    def __outframe_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outframe_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'LSRK'
        if self.__outframe_dflt( self.__globals_( ) ) is not None:
             description = 'Spectral reference frame in which to interpret \'start\' and \'width\''
             value = self.__outframe( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outframe': value},{'outframe': self.__schema['outframe']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('outframe',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __veltype_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return "radio"
        if self.__specmode( glb ) == "cubesource": return "radio"
        if self.__specmode( glb ) == "cubedata": return "radio"
        return None

    def __veltype( self, glb ):
        if 'veltype' in glb: return glb['veltype']
        dflt = self.__veltype_dflt( glb )
        if dflt is not None: return dflt
        return 'radio'

    def __veltype_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__veltype_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'radio'
        if self.__veltype_dflt( self.__globals_( ) ) is not None:
             description = 'Velocity type (radio, z, ratio, beta, gamma, optical)'
             value = self.__veltype( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'veltype': value},{'veltype': self.__schema['veltype']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('veltype',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __restfreq_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return []
        if self.__specmode( glb ) == "cubesource": return []
        if self.__specmode( glb ) == "cubedata": return []
        return None

    def __restfreq( self, glb ):
        if 'restfreq' in glb: return glb['restfreq']
        dflt = self.__restfreq_dflt( glb )
        if dflt is not None: return dflt
        return [  ]

    def __restfreq_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__restfreq_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [  ]
        if self.__restfreq_dflt( self.__globals_( ) ) is not None:
             description = 'List of rest frequencies'
             value = self.__restfreq( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'restfreq': value},{'restfreq': self.__schema['restfreq']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('restfreq',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __interpolation_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return "linear"
        if self.__specmode( glb ) == "cubesource": return "linear"
        if self.__specmode( glb ) == "cubedata": return "linear"
        return None

    def __interpolation( self, glb ):
        if 'interpolation' in glb: return glb['interpolation']
        dflt = self.__interpolation_dflt( glb )
        if dflt is not None: return dflt
        return 'linear'

    def __interpolation_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__interpolation_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'linear'
        if self.__interpolation_dflt( self.__globals_( ) ) is not None:
             description = 'Spectral interpolation (nearest,linear,cubic)'
             value = self.__interpolation( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'interpolation': value},{'interpolation': self.__schema['interpolation']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('interpolation',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __perchanweightdensity_dflt( self, glb ):
        if self.__specmode( glb ) == "cube": return bool(True)
        if self.__specmode( glb ) == "cubesource": return bool(True)
        if self.__specmode( glb ) == "cubedata": return bool(False)
        return None

    def __perchanweightdensity( self, glb ):
        if 'perchanweightdensity' in glb: return glb['perchanweightdensity']
        dflt = self.__perchanweightdensity_dflt( glb )
        if dflt is not None: return dflt
        return True

    def __perchanweightdensity_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__perchanweightdensity_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        if self.__perchanweightdensity_dflt( self.__globals_( ) ) is not None:
             description = 'whether to calculate weight density per channel in Briggs style weighting or not'
             value = self.__perchanweightdensity( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'perchanweightdensity': value},{'perchanweightdensity': self.__schema['perchanweightdensity']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('perchanweightdensity',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __gridder_dflt( self, glb ):
        return 'standard'

    def __gridder( self, glb ):
        if 'gridder' in glb: return glb['gridder']
        return 'standard'

    def __gridder_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__gridder_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'standard'
        description = 'Gridding options (standard, wproject, widefield, mosaic, awproject, awp2)'
        value = self.__gridder( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'gridder': value},{'gridder': self.__schema['gridder']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('gridder',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __facets_dflt( self, glb ):
        if self.__gridder( glb ) == "widefield": return int(1)
        return None

    def __facets( self, glb ):
        if 'facets' in glb: return glb['facets']
        dflt = self.__facets_dflt( glb )
        if dflt is not None: return dflt
        return int(1)

    def __facets_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__facets_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(1)
        if self.__facets_dflt( self.__globals_( ) ) is not None:
             description = 'Number of facets on a side'
             value = self.__facets( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'facets': value},{'facets': self.__schema['facets']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('facets',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __psfphasecenter_dflt( self, glb ):
        if self.__gridder( glb ) == "mosaic": return ""
        if self.__gridder( glb ) == "mosaicft": return ""
        return None

    def __psfphasecenter( self, glb ):
        if 'psfphasecenter' in glb: return glb['psfphasecenter']
        dflt = self.__psfphasecenter_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __psfphasecenter_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__psfphasecenter_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__psfphasecenter_dflt( self.__globals_( ) ) is not None:
             description = 'optional direction to calculate psf for mosaic (default is image phasecenter)'
             value = self.__psfphasecenter( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'psfphasecenter': value},{'psfphasecenter': self.__schema['psfphasecenter']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('psfphasecenter',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __wprojplanes_dflt( self, glb ):
        if self.__gridder( glb ) == "widefield": return int(1)
        if self.__gridder( glb ) == "wproject": return int(1)
        if self.__gridder( glb ) == "wprojectft": return int(1)
        if self.__gridder( glb ) == "imagemosaic": return int(1)
        if self.__gridder( glb ) == "awproject": return int(1)
        if self.__gridder( glb ) == "awphpg": return int(1)
        if self.__gridder( glb ) == "awprojectft": return int(1)
        if self.__gridder( glb ) == "awp2": return int(1)
        return None

    def __wprojplanes( self, glb ):
        if 'wprojplanes' in glb: return glb['wprojplanes']
        dflt = self.__wprojplanes_dflt( glb )
        if dflt is not None: return dflt
        return int(1)

    def __wprojplanes_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__wprojplanes_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(1)
        if self.__wprojplanes_dflt( self.__globals_( ) ) is not None:
             description = 'Number of distinct w-values for convolution functions'
             value = self.__wprojplanes( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'wprojplanes': value},{'wprojplanes': self.__schema['wprojplanes']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('wprojplanes',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __vptable_dflt( self, glb ):
        if self.__gridder( glb ) == "standard": return ""
        if self.__gridder( glb ) == "widefield": return ""
        if self.__gridder( glb ) == "wproject": return ""
        if self.__gridder( glb ) == "wprojectft": return ""
        if self.__gridder( glb ) == "mosaic": return ""
        if self.__gridder( glb ) == "mosaicft": return ""
        if self.__gridder( glb ) == "ftmosaic": return ""
        if self.__gridder( glb ) == "imagemosaic": return ""
        return None

    def __vptable( self, glb ):
        if 'vptable' in glb: return glb['vptable']
        dflt = self.__vptable_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __vptable_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__vptable_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__vptable_dflt( self.__globals_( ) ) is not None:
             description = 'Name of Voltage Pattern table'
             value = self.__vptable( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'vptable': value},{'vptable': self.__schema['vptable']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('vptable',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __mosweight_dflt( self, glb ):
        if self.__gridder( glb ) == "mosaic": return bool(True)
        if self.__gridder( glb ) == "ftmosaic": return bool(True)
        if self.__gridder( glb ) == "awproject": return bool(False)
        if self.__gridder( glb ) == "awphpg": return bool(False)
        if self.__gridder( glb ) == "awprojectft": return bool(False)
        if self.__gridder( glb ) == "awp2": return bool(False)
        return None

    def __mosweight( self, glb ):
        if 'mosweight' in glb: return glb['mosweight']
        dflt = self.__mosweight_dflt( glb )
        if dflt is not None: return dflt
        return True

    def __mosweight_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__mosweight_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        if self.__mosweight_dflt( self.__globals_( ) ) is not None:
             description = 'Independently weight each field in a mosaic'
             value = self.__mosweight( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'mosweight': value},{'mosweight': self.__schema['mosweight']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('mosweight',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __aterm_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return bool(True)
        if self.__gridder( glb ) == "awprojectft": return bool(True)
        return None

    def __aterm( self, glb ):
        if 'aterm' in glb: return glb['aterm']
        dflt = self.__aterm_dflt( glb )
        if dflt is not None: return dflt
        return True

    def __aterm_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__aterm_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        if self.__aterm_dflt( self.__globals_( ) ) is not None:
             description = 'Use aperture illumination functions during gridding'
             value = self.__aterm( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'aterm': value},{'aterm': self.__schema['aterm']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('aterm',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __psterm_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return bool(False)
        if self.__gridder( glb ) == "awprojectft": return bool(False)
        return None

    def __psterm( self, glb ):
        if 'psterm' in glb: return glb['psterm']
        dflt = self.__psterm_dflt( glb )
        if dflt is not None: return dflt
        return False

    def __psterm_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__psterm_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        if self.__psterm_dflt( self.__globals_( ) ) is not None:
             description = 'Use prolate spheroidal during gridding'
             value = self.__psterm( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'psterm': value},{'psterm': self.__schema['psterm']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('psterm',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __wbawp_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return bool(True)
        if self.__gridder( glb ) == "awprojectft": return bool(True)
        return None

    def __wbawp( self, glb ):
        if 'wbawp' in glb: return glb['wbawp']
        dflt = self.__wbawp_dflt( glb )
        if dflt is not None: return dflt
        return True

    def __wbawp_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__wbawp_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        if self.__wbawp_dflt( self.__globals_( ) ) is not None:
             description = 'Use wideband A-terms'
             value = self.__wbawp( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'wbawp': value},{'wbawp': self.__schema['wbawp']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('wbawp',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __conjbeams_dflt( self, glb ):
        if self.__gridder( glb ) == "mosaic": return bool(False)
        if self.__gridder( glb ) == "mosaicft": return bool(False)
        if self.__gridder( glb ) == "awproject": return bool(False)
        if self.__gridder( glb ) == "awprojectft": return bool(False)
        return None

    def __conjbeams( self, glb ):
        if 'conjbeams' in glb: return glb['conjbeams']
        dflt = self.__conjbeams_dflt( glb )
        if dflt is not None: return dflt
        return False

    def __conjbeams_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__conjbeams_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        if self.__conjbeams_dflt( self.__globals_( ) ) is not None:
             description = 'Use conjugate frequency for wideband A-terms'
             value = self.__conjbeams( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'conjbeams': value},{'conjbeams': self.__schema['conjbeams']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('conjbeams',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __cfcache_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return ""
        if self.__gridder( glb ) == "awprojectft": return ""
        return None

    def __cfcache( self, glb ):
        if 'cfcache' in glb: return glb['cfcache']
        dflt = self.__cfcache_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __cfcache_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__cfcache_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__cfcache_dflt( self.__globals_( ) ) is not None:
             description = 'Convolution function cache directory name'
             value = self.__cfcache( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'cfcache': value},{'cfcache': self.__schema['cfcache']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('cfcache',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __usepointing_dflt( self, glb ):
        if self.__gridder( glb ) == "mosaic": return bool(False)
        if self.__gridder( glb ) == "mosaicft": return bool(False)
        if self.__gridder( glb ) == "ftmosaic": return bool(False)
        if self.__gridder( glb ) == "awproject": return bool(False)
        if self.__gridder( glb ) == "awphpg": return bool(False)
        if self.__gridder( glb ) == "awprojectft": return bool(False)
        if self.__gridder( glb ) == "awp2": return bool(False)
        return None

    def __usepointing( self, glb ):
        if 'usepointing' in glb: return glb['usepointing']
        dflt = self.__usepointing_dflt( glb )
        if dflt is not None: return dflt
        return False

    def __usepointing_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__usepointing_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        if self.__usepointing_dflt( self.__globals_( ) ) is not None:
             description = 'The parameter makes the gridder utilize the pointing table phase directions while computing the residual image.'
             value = self.__usepointing( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'usepointing': value},{'usepointing': self.__schema['usepointing']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('usepointing',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __computepastep_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return float(360.0)
        if self.__gridder( glb ) == "awprojectft": return float(360.0)
        if self.__gridder( glb ) == "awp2": return float(360.0)
        return None

    def __computepastep( self, glb ):
        if 'computepastep' in glb: return glb['computepastep']
        dflt = self.__computepastep_dflt( glb )
        if dflt is not None: return dflt
        return float(360.0)

    def __computepastep_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__computepastep_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(360.0)
        if self.__computepastep_dflt( self.__globals_( ) ) is not None:
             description = 'Parallactic angle interval after the AIFs are recomputed (deg)'
             value = self.__computepastep( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'computepastep': value},{'computepastep': self.__schema['computepastep']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('computepastep',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __rotatepastep_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return float(360.0)
        if self.__gridder( glb ) == "awprojectft": return float(360.0)
        return None

    def __rotatepastep( self, glb ):
        if 'rotatepastep' in glb: return glb['rotatepastep']
        dflt = self.__rotatepastep_dflt( glb )
        if dflt is not None: return dflt
        return float(360.0)

    def __rotatepastep_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__rotatepastep_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(360.0)
        if self.__rotatepastep_dflt( self.__globals_( ) ) is not None:
             description = 'Parallactic angle interval after which the nearest AIF is rotated (deg)'
             value = self.__rotatepastep( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'rotatepastep': value},{'rotatepastep': self.__schema['rotatepastep']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('rotatepastep',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __pointingoffsetsigdev_dflt( self, glb ):
        if self.__gridder( glb ) == "awproject": return []
        if self.__gridder( glb ) == "awprojectft": return []
        return None

    def __pointingoffsetsigdev( self, glb ):
        if 'pointingoffsetsigdev' in glb: return glb['pointingoffsetsigdev']
        dflt = self.__pointingoffsetsigdev_dflt( glb )
        if dflt is not None: return dflt
        return [  ]

    def __pointingoffsetsigdev_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__pointingoffsetsigdev_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [  ]
        if self.__pointingoffsetsigdev_dflt( self.__globals_( ) ) is not None:
             description = 'Pointing offset threshold to determine heterogeneity of pointing corrections for the AWProject gridder'
             value = self.__pointingoffsetsigdev( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'pointingoffsetsigdev': value},{'pointingoffsetsigdev': self.__schema['pointingoffsetsigdev']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('pointingoffsetsigdev',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __pblimit_dflt( self, glb ):
        if self.__gridder( glb ) == "awphpg": return float(0.2)
        return None

    def __pblimit( self, glb ):
        if 'pblimit' in glb: return glb['pblimit']
        return float(0.2)

    def __pblimit_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__pblimit_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.2)
        description = 'PB gain level at which to cut off normalizations'
        value = self.__pblimit( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'pblimit': value},{'pblimit': self.__schema['pblimit']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('pblimit',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __normtype_dflt( self, glb ):
        if self.__gridder( glb ) == "mosaic": return "flatnoise"
        if self.__gridder( glb ) == "mosaicft": return "flatnoise"
        if self.__gridder( glb ) == "ftmosaic": return "flatnoise"
        if self.__gridder( glb ) == "imagemosaic": return "flatnoise"
        if self.__gridder( glb ) == "awproject": return "flatnoise"
        if self.__gridder( glb ) == "awphpg": return "flatnoise"
        if self.__gridder( glb ) == "awprojectft": return "flatnoise"
        if self.__gridder( glb ) == "awp2": return "flatnoise"
        return None

    def __normtype( self, glb ):
        if 'normtype' in glb: return glb['normtype']
        dflt = self.__normtype_dflt( glb )
        if dflt is not None: return dflt
        return 'flatnoise'

    def __normtype_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__normtype_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'flatnoise'
        if self.__normtype_dflt( self.__globals_( ) ) is not None:
             description = 'Normalization type (flatnoise, flatsky,pbsquare)'
             value = self.__normtype( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'normtype': value},{'normtype': self.__schema['normtype']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('normtype',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __deconvolver_dflt( self, glb ):
        return 'hogbom'

    def __deconvolver( self, glb ):
        if 'deconvolver' in glb: return glb['deconvolver']
        return 'hogbom'

    def __deconvolver_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__deconvolver_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'hogbom'
        description = 'Minor cycle algorithm (hogbom,clark,multiscale,mtmfs,mem,clarkstokes,asp)'
        value = self.__deconvolver( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'deconvolver': value},{'deconvolver': self.__schema['deconvolver']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('deconvolver',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __scales_dflt( self, glb ):
        if self.__deconvolver( glb ) == "multiscale": return []
        if self.__deconvolver( glb ) == "mtmfs": return []
        return None

    def __scales( self, glb ):
        if 'scales' in glb: return glb['scales']
        dflt = self.__scales_dflt( glb )
        if dflt is not None: return dflt
        return [  ]

    def __scales_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__scales_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [  ]
        if self.__scales_dflt( self.__globals_( ) ) is not None:
             description = 'List of scale sizes (in pixels) for multi-scale algorithms'
             value = self.__scales( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'scales': value},{'scales': self.__schema['scales']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('scales',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __nterms_dflt( self, glb ):
        if self.__deconvolver( glb ) == "mtmfs": return int(2)
        return None

    def __nterms( self, glb ):
        if 'nterms' in glb: return glb['nterms']
        dflt = self.__nterms_dflt( glb )
        if dflt is not None: return dflt
        return int(2)

    def __nterms_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__nterms_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(2)
        if self.__nterms_dflt( self.__globals_( ) ) is not None:
             description = 'Number of Taylor coefficients in the spectral model'
             value = self.__nterms( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'nterms': value},{'nterms': self.__schema['nterms']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('nterms',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __smallscalebias_dflt( self, glb ):
        if self.__deconvolver( glb ) == "multiscale": return float(0.0)
        if self.__deconvolver( glb ) == "mtmfs": return float(0.0)
        return None

    def __smallscalebias( self, glb ):
        if 'smallscalebias' in glb: return glb['smallscalebias']
        dflt = self.__smallscalebias_dflt( glb )
        if dflt is not None: return dflt
        return float(0.0)

    def __smallscalebias_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__smallscalebias_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.0)
        if self.__smallscalebias_dflt( self.__globals_( ) ) is not None:
             description = 'Biases the scale selection when using multi-scale or mtmfs deconvolvers'
             value = self.__smallscalebias( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'smallscalebias': value},{'smallscalebias': self.__schema['smallscalebias']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('smallscalebias',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __fusedthreshold_dflt( self, glb ):
        if self.__deconvolver( glb ) == "asp": return float(0.0)
        return None

    def __fusedthreshold( self, glb ):
        if 'fusedthreshold' in glb: return glb['fusedthreshold']
        dflt = self.__fusedthreshold_dflt( glb )
        if dflt is not None: return dflt
        return float(0.0)

    def __fusedthreshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__fusedthreshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.0)
        if self.__fusedthreshold_dflt( self.__globals_( ) ) is not None:
             description = 'Threshold for triggering Hogbom Clean'
             value = self.__fusedthreshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'fusedthreshold': value},{'fusedthreshold': self.__schema['fusedthreshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('fusedthreshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __largestscale_dflt( self, glb ):
        if self.__deconvolver( glb ) == "asp": return int(-1)
        return None

    def __largestscale( self, glb ):
        if 'largestscale' in glb: return glb['largestscale']
        dflt = self.__largestscale_dflt( glb )
        if dflt is not None: return dflt
        return int(-1)

    def __largestscale_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__largestscale_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(-1)
        if self.__largestscale_dflt( self.__globals_( ) ) is not None:
             description = 'Largest scale allowed for the Asp Clean deconvolver'
             value = self.__largestscale( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'largestscale': value},{'largestscale': self.__schema['largestscale']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('largestscale',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __restoration_dflt( self, glb ):
        return True

    def __restoration( self, glb ):
        if 'restoration' in glb: return glb['restoration']
        return True

    def __restoration_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__restoration_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = 'Do restoration steps (or not)'
        value = self.__restoration( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'restoration': value},{'restoration': self.__schema['restoration']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('restoration',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __restoringbeam_dflt( self, glb ):
        if self.__restoration( glb ) == bool(True): return []
        return None

    def __restoringbeam( self, glb ):
        if 'restoringbeam' in glb: return glb['restoringbeam']
        dflt = self.__restoringbeam_dflt( glb )
        if dflt is not None: return dflt
        return [  ]

    def __restoringbeam_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__restoringbeam_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [  ]
        if self.__restoringbeam_dflt( self.__globals_( ) ) is not None:
             description = 'Restoring beam shape to use. Default is the PSF main lobe'
             value = self.__restoringbeam( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'restoringbeam': value},{'restoringbeam': self.__schema['restoringbeam']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('restoringbeam',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __pbcor_dflt( self, glb ):
        if self.__restoration( glb ) == bool(True): return bool(False)
        return None

    def __pbcor( self, glb ):
        if 'pbcor' in glb: return glb['pbcor']
        dflt = self.__pbcor_dflt( glb )
        if dflt is not None: return dflt
        return False

    def __pbcor_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__pbcor_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        if self.__pbcor_dflt( self.__globals_( ) ) is not None:
             description = 'Apply PB correction on the output restored image'
             value = self.__pbcor( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'pbcor': value},{'pbcor': self.__schema['pbcor']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('pbcor',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __outlierfile_dflt( self, glb ):
        return ''

    def __outlierfile( self, glb ):
        if 'outlierfile' in glb: return glb['outlierfile']
        return ''

    def __outlierfile_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outlierfile_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = 'Name of outlier-field image definitions'
        value = self.__outlierfile( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outlierfile': value},{'outlierfile': self.__schema['outlierfile']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('outlierfile',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __weighting_dflt( self, glb ):
        return 'natural'

    def __weighting( self, glb ):
        if 'weighting' in glb: return glb['weighting']
        return 'natural'

    def __weighting_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__weighting_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'natural'
        description = 'Weighting scheme (natural,uniform,briggs, superuniform, radial, briggsabs[experimental], briggsbwtaper[experimental])'
        value = self.__weighting( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'weighting': value},{'weighting': self.__schema['weighting']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('weighting',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __robust_dflt( self, glb ):
        if self.__weighting( glb ) == "briggs": return float(0.5)
        if self.__weighting( glb ) == "briggsabs": return float(0.5)
        if self.__weighting( glb ) == "briggsbwtaper": return float(0.5)
        return None

    def __robust( self, glb ):
        if 'robust' in glb: return glb['robust']
        dflt = self.__robust_dflt( glb )
        if dflt is not None: return dflt
        return float(0.5)

    def __robust_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__robust_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.5)
        if self.__robust_dflt( self.__globals_( ) ) is not None:
             description = 'Robustness parameter'
             value = self.__robust( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'robust': value},{'robust': self.__schema['robust']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('robust',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __noise_dflt( self, glb ):
        if self.__weighting( glb ) == "briggsabs": return "1.0Jy"
        return None

    def __noise( self, glb ):
        if 'noise' in glb: return glb['noise']
        dflt = self.__noise_dflt( glb )
        if dflt is not None: return dflt
        return '1.0Jy'

    def __noise_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__noise_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return '1.0Jy'
        if self.__noise_dflt( self.__globals_( ) ) is not None:
             description = 'noise parameter for briggs abs mode weighting'
             value = self.__noise( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'noise': value},{'noise': self.__schema['noise']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('noise',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __npixels_dflt( self, glb ):
        if self.__weighting( glb ) == "briggs": return int(0)
        if self.__weighting( glb ) == "briggsabs": return int(0)
        return None

    def __npixels( self, glb ):
        if 'npixels' in glb: return glb['npixels']
        dflt = self.__npixels_dflt( glb )
        if dflt is not None: return dflt
        return int(0)

    def __npixels_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__npixels_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(0)
        if self.__npixels_dflt( self.__globals_( ) ) is not None:
             description = 'Number of pixels to determine uv-cell size'
             value = self.__npixels( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'npixels': value},{'npixels': self.__schema['npixels']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('npixels',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __uvtaper_dflt( self, glb ):
        if self.__weighting( glb ) == "natural": return []
        if self.__weighting( glb ) == "uniform": return []
        if self.__weighting( glb ) == "superuniform": return []
        if self.__weighting( glb ) == "radial": return []
        if self.__weighting( glb ) == "briggs": return []
        if self.__weighting( glb ) == "briggsabs": return []
        if self.__weighting( glb ) == "briggsbwtaper": return []
        return None

    def __uvtaper( self, glb ):
        if 'uvtaper' in glb: return glb['uvtaper']
        dflt = self.__uvtaper_dflt( glb )
        if dflt is not None: return dflt
        return [ '' ]

    def __uvtaper_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__uvtaper_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return [ '' ]
        if self.__uvtaper_dflt( self.__globals_( ) ) is not None:
             description = 'uv-taper on outer baselines in uv-plane'
             value = self.__uvtaper( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'uvtaper': value},{'uvtaper': self.__schema['uvtaper']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('uvtaper',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __niter_dflt( self, glb ):
        return int(0)

    def __niter( self, glb ):
        if 'niter' in glb: return glb['niter']
        return int(0)

    def __niter_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__niter_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(0)
        description = 'Maximum number of iterations'
        value = self.__niter( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'niter': value},{'niter': self.__schema['niter']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('niter',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __gain_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return float(0.1)
        return None

    def __gain( self, glb ):
        if 'gain' in glb: return glb['gain']
        dflt = self.__gain_dflt( glb )
        if dflt is not None: return dflt
        return float(0.1)

    def __gain_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__gain_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.1)
        if self.__gain_dflt( self.__globals_( ) ) is not None:
             description = 'Loop gain'
             value = self.__gain( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'gain': value},{'gain': self.__schema['gain']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('gain',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __threshold_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return 0.0
        return None

    def __threshold( self, glb ):
        if 'threshold' in glb: return glb['threshold']
        dflt = self.__threshold_dflt( glb )
        if dflt is not None: return dflt
        return float(0.0)

    def __threshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__threshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.0)
        if self.__threshold_dflt( self.__globals_( ) ) is not None:
             description = 'Stopping threshold'
             value = self.__threshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'threshold': value},{'threshold': self.__schema['threshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('threshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __nsigma_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return float(0.0)
        return None

    def __nsigma( self, glb ):
        if 'nsigma' in glb: return glb['nsigma']
        dflt = self.__nsigma_dflt( glb )
        if dflt is not None: return dflt
        return float(0.0)

    def __nsigma_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__nsigma_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.0)
        if self.__nsigma_dflt( self.__globals_( ) ) is not None:
             description = 'Multiplicative factor for rms-based threshold stopping'
             value = self.__nsigma( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'nsigma': value},{'nsigma': self.__schema['nsigma']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('nsigma',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __cycleniter_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return int(-1)
        return None

    def __cycleniter( self, glb ):
        if 'cycleniter' in glb: return glb['cycleniter']
        dflt = self.__cycleniter_dflt( glb )
        if dflt is not None: return dflt
        return int(-1)

    def __cycleniter_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__cycleniter_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(-1)
        if self.__cycleniter_dflt( self.__globals_( ) ) is not None:
             description = 'Maximum number of minor-cycle iterations'
             value = self.__cycleniter( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'cycleniter': value},{'cycleniter': self.__schema['cycleniter']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('cycleniter',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __cyclefactor_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return float(1.0)
        return None

    def __cyclefactor( self, glb ):
        if 'cyclefactor' in glb: return glb['cyclefactor']
        dflt = self.__cyclefactor_dflt( glb )
        if dflt is not None: return dflt
        return float(1.0)

    def __cyclefactor_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__cyclefactor_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(1.0)
        if self.__cyclefactor_dflt( self.__globals_( ) ) is not None:
             description = 'Scaling on PSF sidelobe level to compute the minor-cycle stopping threshold.'
             value = self.__cyclefactor( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'cyclefactor': value},{'cyclefactor': self.__schema['cyclefactor']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('cyclefactor',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __minpsffraction_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return float(0.05)
        return None

    def __minpsffraction( self, glb ):
        if 'minpsffraction' in glb: return glb['minpsffraction']
        dflt = self.__minpsffraction_dflt( glb )
        if dflt is not None: return dflt
        return float(0.05)

    def __minpsffraction_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__minpsffraction_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.05)
        if self.__minpsffraction_dflt( self.__globals_( ) ) is not None:
             description = 'PSF fraction that marks the max depth of cleaning in the minor cycle'
             value = self.__minpsffraction( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'minpsffraction': value},{'minpsffraction': self.__schema['minpsffraction']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('minpsffraction',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __maxpsffraction_dflt( self, glb ):
        if self.__niter( glb ) != int(0): return float(0.8)
        return None

    def __maxpsffraction( self, glb ):
        if 'maxpsffraction' in glb: return glb['maxpsffraction']
        dflt = self.__maxpsffraction_dflt( glb )
        if dflt is not None: return dflt
        return float(0.8)

    def __maxpsffraction_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__maxpsffraction_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.8)
        if self.__maxpsffraction_dflt( self.__globals_( ) ) is not None:
             description = 'PSF fraction that marks the minimum depth of cleaning in the minor cycle'
             value = self.__maxpsffraction( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'maxpsffraction': value},{'maxpsffraction': self.__schema['maxpsffraction']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('maxpsffraction',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __nmajor_dflt( self, glb ):
        return int(-1)

    def __nmajor( self, glb ):
        if 'nmajor' in glb: return glb['nmajor']
        return int(-1)

    def __nmajor_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__nmajor_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(-1)
        description = 'Maximum number of major cycles to evaluate'
        value = self.__nmajor( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'nmajor': value},{'nmajor': self.__schema['nmajor']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('nmajor',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __usemask_dflt( self, glb ):
        return 'user'

    def __usemask( self, glb ):
        if 'usemask' in glb: return glb['usemask']
        return 'user'

    def __usemask_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__usemask_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'user'
        description = 'Type of mask(s) for deconvolution:  user, pb, or auto-multithresh'
        value = self.__usemask( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'usemask': value},{'usemask': self.__schema['usemask']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('usemask',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __mask_dflt( self, glb ):
        if self.__usemask( glb ) == "user": return ""
        return None

    def __mask( self, glb ):
        if 'mask' in glb: return glb['mask']
        dflt = self.__mask_dflt( glb )
        if dflt is not None: return dflt
        return ''

    def __mask_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__mask_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        if self.__mask_dflt( self.__globals_( ) ) is not None:
             description = 'Mask (a list of image name(s) or region file(s) or region string(s) )'
             value = self.__mask( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'mask': value},{'mask': self.__schema['mask']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('mask',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __pbmask_dflt( self, glb ):
        if self.__usemask( glb ) == "user": return float(0.0)
        if self.__usemask( glb ) == "pb": return float(0.2)
        if self.__usemask( glb ) == "auto-multithresh": return float(0.2)
        return None

    def __pbmask( self, glb ):
        if 'pbmask' in glb: return glb['pbmask']
        dflt = self.__pbmask_dflt( glb )
        if dflt is not None: return dflt
        return float(0.0)

    def __pbmask_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__pbmask_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.0)
        if self.__pbmask_dflt( self.__globals_( ) ) is not None:
             description = 'primary beam mask'
             value = self.__pbmask( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'pbmask': value},{'pbmask': self.__schema['pbmask']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('pbmask',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __sidelobethreshold_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(3.0)
        return None

    def __sidelobethreshold( self, glb ):
        if 'sidelobethreshold' in glb: return glb['sidelobethreshold']
        dflt = self.__sidelobethreshold_dflt( glb )
        if dflt is not None: return dflt
        return float(3.0)

    def __sidelobethreshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__sidelobethreshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(3.0)
        if self.__sidelobethreshold_dflt( self.__globals_( ) ) is not None:
             description = 'sidelobethreshold \*  the max sidelobe level \* peak residual'
             value = self.__sidelobethreshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'sidelobethreshold': value},{'sidelobethreshold': self.__schema['sidelobethreshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('sidelobethreshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __noisethreshold_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(5.0)
        return None

    def __noisethreshold( self, glb ):
        if 'noisethreshold' in glb: return glb['noisethreshold']
        dflt = self.__noisethreshold_dflt( glb )
        if dflt is not None: return dflt
        return float(5.0)

    def __noisethreshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__noisethreshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(5.0)
        if self.__noisethreshold_dflt( self.__globals_( ) ) is not None:
             description = 'noisethreshold \* rms in residual image + location(median)'
             value = self.__noisethreshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'noisethreshold': value},{'noisethreshold': self.__schema['noisethreshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('noisethreshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __lownoisethreshold_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(1.5)
        return None

    def __lownoisethreshold( self, glb ):
        if 'lownoisethreshold' in glb: return glb['lownoisethreshold']
        dflt = self.__lownoisethreshold_dflt( glb )
        if dflt is not None: return dflt
        return float(1.5)

    def __lownoisethreshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__lownoisethreshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(1.5)
        if self.__lownoisethreshold_dflt( self.__globals_( ) ) is not None:
             description = 'lownoisethreshold \* rms in residual image + location(median)'
             value = self.__lownoisethreshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'lownoisethreshold': value},{'lownoisethreshold': self.__schema['lownoisethreshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('lownoisethreshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __negativethreshold_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(0.0)
        return None

    def __negativethreshold( self, glb ):
        if 'negativethreshold' in glb: return glb['negativethreshold']
        dflt = self.__negativethreshold_dflt( glb )
        if dflt is not None: return dflt
        return float(0.0)

    def __negativethreshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__negativethreshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.0)
        if self.__negativethreshold_dflt( self.__globals_( ) ) is not None:
             description = 'negativethreshold \* rms in residual image + location(median)'
             value = self.__negativethreshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'negativethreshold': value},{'negativethreshold': self.__schema['negativethreshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('negativethreshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __smoothfactor_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(1.0)
        return None

    def __smoothfactor( self, glb ):
        if 'smoothfactor' in glb: return glb['smoothfactor']
        dflt = self.__smoothfactor_dflt( glb )
        if dflt is not None: return dflt
        return float(1.0)

    def __smoothfactor_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__smoothfactor_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(1.0)
        if self.__smoothfactor_dflt( self.__globals_( ) ) is not None:
             description = 'smoothing factor in a unit of the beam'
             value = self.__smoothfactor( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'smoothfactor': value},{'smoothfactor': self.__schema['smoothfactor']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('smoothfactor',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __minbeamfrac_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(0.3)
        return None

    def __minbeamfrac( self, glb ):
        if 'minbeamfrac' in glb: return glb['minbeamfrac']
        dflt = self.__minbeamfrac_dflt( glb )
        if dflt is not None: return dflt
        return float(0.3)

    def __minbeamfrac_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__minbeamfrac_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.3)
        if self.__minbeamfrac_dflt( self.__globals_( ) ) is not None:
             description = 'minimum beam fraction for pruning'
             value = self.__minbeamfrac( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'minbeamfrac': value},{'minbeamfrac': self.__schema['minbeamfrac']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('minbeamfrac',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __cutthreshold_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(0.01)
        return None

    def __cutthreshold( self, glb ):
        if 'cutthreshold' in glb: return glb['cutthreshold']
        dflt = self.__cutthreshold_dflt( glb )
        if dflt is not None: return dflt
        return float(0.01)

    def __cutthreshold_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__cutthreshold_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.01)
        if self.__cutthreshold_dflt( self.__globals_( ) ) is not None:
             description = 'threshold to cut the smoothed mask to create a final mask'
             value = self.__cutthreshold( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'cutthreshold': value},{'cutthreshold': self.__schema['cutthreshold']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('cutthreshold',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __growiterations_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return int(75)
        return None

    def __growiterations( self, glb ):
        if 'growiterations' in glb: return glb['growiterations']
        dflt = self.__growiterations_dflt( glb )
        if dflt is not None: return dflt
        return int(75)

    def __growiterations_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__growiterations_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(75)
        if self.__growiterations_dflt( self.__globals_( ) ) is not None:
             description = 'number of binary dilation iterations for growing the mask'
             value = self.__growiterations( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'growiterations': value},{'growiterations': self.__schema['growiterations']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('growiterations',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __dogrowprune_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return bool(True)
        return None

    def __dogrowprune( self, glb ):
        if 'dogrowprune' in glb: return glb['dogrowprune']
        dflt = self.__dogrowprune_dflt( glb )
        if dflt is not None: return dflt
        return True

    def __dogrowprune_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__dogrowprune_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        if self.__dogrowprune_dflt( self.__globals_( ) ) is not None:
             description = 'Do pruning on the grow mask'
             value = self.__dogrowprune( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'dogrowprune': value},{'dogrowprune': self.__schema['dogrowprune']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('dogrowprune',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __minpercentchange_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return float(-1.0)
        return None

    def __minpercentchange( self, glb ):
        if 'minpercentchange' in glb: return glb['minpercentchange']
        dflt = self.__minpercentchange_dflt( glb )
        if dflt is not None: return dflt
        return float(-1.0)

    def __minpercentchange_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__minpercentchange_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(-1.0)
        if self.__minpercentchange_dflt( self.__globals_( ) ) is not None:
             description = 'minimum percentage change in mask size (per channel plane) to trigger updating of mask by automask'
             value = self.__minpercentchange( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'minpercentchange': value},{'minpercentchange': self.__schema['minpercentchange']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('minpercentchange',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __verbose_dflt( self, glb ):
        if self.__usemask( glb ) == "auto-multithresh": return bool(False)
        return None

    def __verbose( self, glb ):
        if 'verbose' in glb: return glb['verbose']
        dflt = self.__verbose_dflt( glb )
        if dflt is not None: return dflt
        return False

    def __verbose_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__verbose_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        if self.__verbose_dflt( self.__globals_( ) ) is not None:
             description = 'True: print more automasking information in the logger'
             value = self.__verbose( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'verbose': value},{'verbose': self.__schema['verbose']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('verbose',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __fastnoise_dflt( self, glb ):
        return True

    def __fastnoise( self, glb ):
        if 'fastnoise' in glb: return glb['fastnoise']
        return True

    def __fastnoise_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__fastnoise_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = 'True: use the faster (old) noise calculation. False: use the new improved noise calculations'
        value = self.__fastnoise( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'fastnoise': value},{'fastnoise': self.__schema['fastnoise']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('fastnoise',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __restart_dflt( self, glb ):
        return True

    def __restart( self, glb ):
        if 'restart' in glb: return glb['restart']
        return True

    def __restart_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__restart_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = 'True : Re-use existing images. False : Increment imagename'
        value = self.__restart( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'restart': value},{'restart': self.__schema['restart']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('restart',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __savemodel_dflt( self, glb ):
        return 'none'

    def __savemodel( self, glb ):
        if 'savemodel' in glb: return glb['savemodel']
        return 'none'

    def __savemodel_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__savemodel_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'none'
        description = 'Options to save model visibilities (none, virtual, modelcolumn)'
        value = self.__savemodel( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'savemodel': value},{'savemodel': self.__schema['savemodel']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('savemodel',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __calcres_dflt( self, glb ):
        return True

    def __calcres( self, glb ):
        if 'calcres' in glb: return glb['calcres']
        return True

    def __calcres_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__calcres_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = 'Calculate initial residual image'
        value = self.__calcres( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'calcres': value},{'calcres': self.__schema['calcres']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('calcres',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    def __calcpsf_dflt( self, glb ):
        return True

    def __calcpsf( self, glb ):
        if 'calcpsf' in glb: return glb['calcpsf']
        return True

    def __calcpsf_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__calcpsf_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = 'Calculate PSF'
        value = self.__calcpsf( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'calcpsf': value},{'calcpsf': self.__schema['calcpsf']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('\x1B[1m\x1B[47m%-23.23s =\x1B[0m %s%-23s%s' % ('calcpsf',pre,self.__to_string_(value),post),description,13+len(pre)+len(post))

    def __psfcutoff_dflt( self, glb ):
        if self.__calcpsf( glb ) == bool(True): return float(0.35)
        return None

    def __psfcutoff( self, glb ):
        if 'psfcutoff' in glb: return glb['psfcutoff']
        dflt = self.__psfcutoff_dflt( glb )
        if dflt is not None: return dflt
        return float(0.35)

    def __psfcutoff_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__psfcutoff_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(0.35)
        if self.__psfcutoff_dflt( self.__globals_( ) ) is not None:
             description = 'All pixels in the main lobe of the PSF above psfcutoff are used to fit a Gaussian beam (the Clean beam).'
             value = self.__psfcutoff( self.__globals_( ) )
             (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'psfcutoff': value},{'psfcutoff': self.__schema['psfcutoff']}) else ('\x1B[91m','\x1B[0m')
             self.__do_inp_output('   \x1B[92m%-20.20s =\x1B[0m %s%-23s%s' % ('psfcutoff',pre,self.__to_string_(value),post),description,9+len(pre)+len(post))

    def __parallel_dflt( self, glb ):
        return False

    def __parallel( self, glb ):
        if 'parallel' in glb: return glb['parallel']
        return False

    def __parallel_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__parallel_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        description = 'Run major cycles in parallel'
        value = self.__parallel( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'parallel': value},{'parallel': self.__schema['parallel']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-23.23s = %s%-23s%s' % ('parallel',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))


    #--------- global default implementation-------------------------------------------
    @static_var('state', __sf__('casa_inp_go_state'))
    def set_global_defaults(self):
        self.set_global_defaults.state['last'] = self
        glb = self.__globals_( )
        if 'vis' in glb: del glb['vis']
        if 'selectdata' in glb: del glb['selectdata']
        if 'field' in glb: del glb['field']
        if 'spw' in glb: del glb['spw']
        if 'timerange' in glb: del glb['timerange']
        if 'uvrange' in glb: del glb['uvrange']
        if 'antenna' in glb: del glb['antenna']
        if 'scan' in glb: del glb['scan']
        if 'observation' in glb: del glb['observation']
        if 'intent' in glb: del glb['intent']
        if 'datacolumn' in glb: del glb['datacolumn']
        if 'imagename' in glb: del glb['imagename']
        if 'imsize' in glb: del glb['imsize']
        if 'cell' in glb: del glb['cell']
        if 'phasecenter' in glb: del glb['phasecenter']
        if 'stokes' in glb: del glb['stokes']
        if 'projection' in glb: del glb['projection']
        if 'startmodel' in glb: del glb['startmodel']
        if 'specmode' in glb: del glb['specmode']
        if 'reffreq' in glb: del glb['reffreq']
        if 'nchan' in glb: del glb['nchan']
        if 'start' in glb: del glb['start']
        if 'width' in glb: del glb['width']
        if 'outframe' in glb: del glb['outframe']
        if 'veltype' in glb: del glb['veltype']
        if 'restfreq' in glb: del glb['restfreq']
        if 'interpolation' in glb: del glb['interpolation']
        if 'perchanweightdensity' in glb: del glb['perchanweightdensity']
        if 'gridder' in glb: del glb['gridder']
        if 'facets' in glb: del glb['facets']
        if 'psfphasecenter' in glb: del glb['psfphasecenter']
        if 'wprojplanes' in glb: del glb['wprojplanes']
        if 'vptable' in glb: del glb['vptable']
        if 'mosweight' in glb: del glb['mosweight']
        if 'aterm' in glb: del glb['aterm']
        if 'psterm' in glb: del glb['psterm']
        if 'wbawp' in glb: del glb['wbawp']
        if 'conjbeams' in glb: del glb['conjbeams']
        if 'cfcache' in glb: del glb['cfcache']
        if 'usepointing' in glb: del glb['usepointing']
        if 'computepastep' in glb: del glb['computepastep']
        if 'rotatepastep' in glb: del glb['rotatepastep']
        if 'pointingoffsetsigdev' in glb: del glb['pointingoffsetsigdev']
        if 'pblimit' in glb: del glb['pblimit']
        if 'normtype' in glb: del glb['normtype']
        if 'deconvolver' in glb: del glb['deconvolver']
        if 'scales' in glb: del glb['scales']
        if 'nterms' in glb: del glb['nterms']
        if 'smallscalebias' in glb: del glb['smallscalebias']
        if 'fusedthreshold' in glb: del glb['fusedthreshold']
        if 'largestscale' in glb: del glb['largestscale']
        if 'restoration' in glb: del glb['restoration']
        if 'restoringbeam' in glb: del glb['restoringbeam']
        if 'pbcor' in glb: del glb['pbcor']
        if 'outlierfile' in glb: del glb['outlierfile']
        if 'weighting' in glb: del glb['weighting']
        if 'robust' in glb: del glb['robust']
        if 'noise' in glb: del glb['noise']
        if 'npixels' in glb: del glb['npixels']
        if 'uvtaper' in glb: del glb['uvtaper']
        if 'niter' in glb: del glb['niter']
        if 'gain' in glb: del glb['gain']
        if 'threshold' in glb: del glb['threshold']
        if 'nsigma' in glb: del glb['nsigma']
        if 'cycleniter' in glb: del glb['cycleniter']
        if 'cyclefactor' in glb: del glb['cyclefactor']
        if 'minpsffraction' in glb: del glb['minpsffraction']
        if 'maxpsffraction' in glb: del glb['maxpsffraction']
        if 'nmajor' in glb: del glb['nmajor']
        if 'usemask' in glb: del glb['usemask']
        if 'mask' in glb: del glb['mask']
        if 'pbmask' in glb: del glb['pbmask']
        if 'sidelobethreshold' in glb: del glb['sidelobethreshold']
        if 'noisethreshold' in glb: del glb['noisethreshold']
        if 'lownoisethreshold' in glb: del glb['lownoisethreshold']
        if 'negativethreshold' in glb: del glb['negativethreshold']
        if 'smoothfactor' in glb: del glb['smoothfactor']
        if 'minbeamfrac' in glb: del glb['minbeamfrac']
        if 'cutthreshold' in glb: del glb['cutthreshold']
        if 'growiterations' in glb: del glb['growiterations']
        if 'dogrowprune' in glb: del glb['dogrowprune']
        if 'minpercentchange' in glb: del glb['minpercentchange']
        if 'verbose' in glb: del glb['verbose']
        if 'fastnoise' in glb: del glb['fastnoise']
        if 'restart' in glb: del glb['restart']
        if 'savemodel' in glb: del glb['savemodel']
        if 'calcres' in glb: del glb['calcres']
        if 'calcpsf' in glb: del glb['calcpsf']
        if 'psfcutoff' in glb: del glb['psfcutoff']
        if 'parallel' in glb: del glb['parallel']

    #--------- inp function -----------------------------------------------------------
    def inp(self):
        print("# iclean -- %s" % self._info_desc_)
        self.term_width, self.term_height = shutil.get_terminal_size(fallback=(80, 24))
        self.__vis_inp( )
        self.__selectdata_inp( )
        self.__field_inp( )
        self.__spw_inp( )
        self.__timerange_inp( )
        self.__uvrange_inp( )
        self.__antenna_inp( )
        self.__scan_inp( )
        self.__observation_inp( )
        self.__intent_inp( )
        self.__datacolumn_inp( )
        self.__imagename_inp( )
        self.__imsize_inp( )
        self.__cell_inp( )
        self.__phasecenter_inp( )
        self.__stokes_inp( )
        self.__projection_inp( )
        self.__startmodel_inp( )
        self.__specmode_inp( )
        self.__reffreq_inp( )
        self.__nchan_inp( )
        self.__start_inp( )
        self.__width_inp( )
        self.__outframe_inp( )
        self.__veltype_inp( )
        self.__restfreq_inp( )
        self.__interpolation_inp( )
        self.__perchanweightdensity_inp( )
        self.__gridder_inp( )
        self.__facets_inp( )
        self.__psfphasecenter_inp( )
        self.__wprojplanes_inp( )
        self.__vptable_inp( )
        self.__mosweight_inp( )
        self.__aterm_inp( )
        self.__psterm_inp( )
        self.__wbawp_inp( )
        self.__conjbeams_inp( )
        self.__cfcache_inp( )
        self.__usepointing_inp( )
        self.__computepastep_inp( )
        self.__rotatepastep_inp( )
        self.__pointingoffsetsigdev_inp( )
        self.__pblimit_inp( )
        self.__normtype_inp( )
        self.__deconvolver_inp( )
        self.__scales_inp( )
        self.__nterms_inp( )
        self.__smallscalebias_inp( )
        self.__fusedthreshold_inp( )
        self.__largestscale_inp( )
        self.__restoration_inp( )
        self.__restoringbeam_inp( )
        self.__pbcor_inp( )
        self.__outlierfile_inp( )
        self.__weighting_inp( )
        self.__robust_inp( )
        self.__noise_inp( )
        self.__npixels_inp( )
        self.__uvtaper_inp( )
        self.__niter_inp( )
        self.__gain_inp( )
        self.__threshold_inp( )
        self.__nsigma_inp( )
        self.__cycleniter_inp( )
        self.__cyclefactor_inp( )
        self.__minpsffraction_inp( )
        self.__maxpsffraction_inp( )
        self.__nmajor_inp( )
        self.__usemask_inp( )
        self.__mask_inp( )
        self.__pbmask_inp( )
        self.__sidelobethreshold_inp( )
        self.__noisethreshold_inp( )
        self.__lownoisethreshold_inp( )
        self.__negativethreshold_inp( )
        self.__smoothfactor_inp( )
        self.__minbeamfrac_inp( )
        self.__cutthreshold_inp( )
        self.__growiterations_inp( )
        self.__dogrowprune_inp( )
        self.__minpercentchange_inp( )
        self.__verbose_inp( )
        self.__fastnoise_inp( )
        self.__restart_inp( )
        self.__savemodel_inp( )
        self.__calcres_inp( )
        self.__calcpsf_inp( )
        self.__psfcutoff_inp( )
        self.__parallel_inp( )

    #--------- tget function ----------------------------------------------------------
    @static_var('state', __sf__('casa_inp_go_state'))
    def tget(self,savefile=None):
        from runpy import run_path
        filename = savefile
        if filename is None:
            filename = "iclean.last" if os.path.isfile("iclean.last") else "iclean.saved"
        if os.path.isfile(filename):
            glob = _find_frame( )
            newglob = run_path( filename, init_globals={ } )
            for i in newglob:
                glob[i] = newglob[i]
            self.tget.state['last'] = self
        else:
            print("could not find last file: %s\nsetting defaults instead..." % filename)
            self.set_global_defaults( )

    #--------- tput function ----------------------------------------------------------
    def tput(self,outfile=None):
        def noobj(s):
           if s.startswith('<') and s.endswith('>'):
               return "None"
           else:
               return s

        _postfile = outfile if outfile is not None else os.path.realpath('iclean.last')

        _invocation_parameters = OrderedDict( )
        _invocation_parameters['vis'] = self.__vis( self.__globals_( ) )
        _invocation_parameters['selectdata'] = self.__selectdata( self.__globals_( ) )
        _invocation_parameters['field'] = self.__field( self.__globals_( ) )
        _invocation_parameters['spw'] = self.__spw( self.__globals_( ) )
        _invocation_parameters['timerange'] = self.__timerange( self.__globals_( ) )
        _invocation_parameters['uvrange'] = self.__uvrange( self.__globals_( ) )
        _invocation_parameters['antenna'] = self.__antenna( self.__globals_( ) )
        _invocation_parameters['scan'] = self.__scan( self.__globals_( ) )
        _invocation_parameters['observation'] = self.__observation( self.__globals_( ) )
        _invocation_parameters['intent'] = self.__intent( self.__globals_( ) )
        _invocation_parameters['datacolumn'] = self.__datacolumn( self.__globals_( ) )
        _invocation_parameters['imagename'] = self.__imagename( self.__globals_( ) )
        _invocation_parameters['imsize'] = self.__imsize( self.__globals_( ) )
        _invocation_parameters['cell'] = self.__cell( self.__globals_( ) )
        _invocation_parameters['phasecenter'] = self.__phasecenter( self.__globals_( ) )
        _invocation_parameters['stokes'] = self.__stokes( self.__globals_( ) )
        _invocation_parameters['projection'] = self.__projection( self.__globals_( ) )
        _invocation_parameters['startmodel'] = self.__startmodel( self.__globals_( ) )
        _invocation_parameters['specmode'] = self.__specmode( self.__globals_( ) )
        _invocation_parameters['reffreq'] = self.__reffreq( self.__globals_( ) )
        _invocation_parameters['nchan'] = self.__nchan( self.__globals_( ) )
        _invocation_parameters['start'] = self.__start( self.__globals_( ) )
        _invocation_parameters['width'] = self.__width( self.__globals_( ) )
        _invocation_parameters['outframe'] = self.__outframe( self.__globals_( ) )
        _invocation_parameters['veltype'] = self.__veltype( self.__globals_( ) )
        _invocation_parameters['restfreq'] = self.__restfreq( self.__globals_( ) )
        _invocation_parameters['interpolation'] = self.__interpolation( self.__globals_( ) )
        _invocation_parameters['perchanweightdensity'] = self.__perchanweightdensity( self.__globals_( ) )
        _invocation_parameters['gridder'] = self.__gridder( self.__globals_( ) )
        _invocation_parameters['facets'] = self.__facets( self.__globals_( ) )
        _invocation_parameters['psfphasecenter'] = self.__psfphasecenter( self.__globals_( ) )
        _invocation_parameters['wprojplanes'] = self.__wprojplanes( self.__globals_( ) )
        _invocation_parameters['vptable'] = self.__vptable( self.__globals_( ) )
        _invocation_parameters['mosweight'] = self.__mosweight( self.__globals_( ) )
        _invocation_parameters['aterm'] = self.__aterm( self.__globals_( ) )
        _invocation_parameters['psterm'] = self.__psterm( self.__globals_( ) )
        _invocation_parameters['wbawp'] = self.__wbawp( self.__globals_( ) )
        _invocation_parameters['conjbeams'] = self.__conjbeams( self.__globals_( ) )
        _invocation_parameters['cfcache'] = self.__cfcache( self.__globals_( ) )
        _invocation_parameters['usepointing'] = self.__usepointing( self.__globals_( ) )
        _invocation_parameters['computepastep'] = self.__computepastep( self.__globals_( ) )
        _invocation_parameters['rotatepastep'] = self.__rotatepastep( self.__globals_( ) )
        _invocation_parameters['pointingoffsetsigdev'] = self.__pointingoffsetsigdev( self.__globals_( ) )
        _invocation_parameters['pblimit'] = self.__pblimit( self.__globals_( ) )
        _invocation_parameters['normtype'] = self.__normtype( self.__globals_( ) )
        _invocation_parameters['deconvolver'] = self.__deconvolver( self.__globals_( ) )
        _invocation_parameters['scales'] = self.__scales( self.__globals_( ) )
        _invocation_parameters['nterms'] = self.__nterms( self.__globals_( ) )
        _invocation_parameters['smallscalebias'] = self.__smallscalebias( self.__globals_( ) )
        _invocation_parameters['fusedthreshold'] = self.__fusedthreshold( self.__globals_( ) )
        _invocation_parameters['largestscale'] = self.__largestscale( self.__globals_( ) )
        _invocation_parameters['restoration'] = self.__restoration( self.__globals_( ) )
        _invocation_parameters['restoringbeam'] = self.__restoringbeam( self.__globals_( ) )
        _invocation_parameters['pbcor'] = self.__pbcor( self.__globals_( ) )
        _invocation_parameters['outlierfile'] = self.__outlierfile( self.__globals_( ) )
        _invocation_parameters['weighting'] = self.__weighting( self.__globals_( ) )
        _invocation_parameters['robust'] = self.__robust( self.__globals_( ) )
        _invocation_parameters['noise'] = self.__noise( self.__globals_( ) )
        _invocation_parameters['npixels'] = self.__npixels( self.__globals_( ) )
        _invocation_parameters['uvtaper'] = self.__uvtaper( self.__globals_( ) )
        _invocation_parameters['niter'] = self.__niter( self.__globals_( ) )
        _invocation_parameters['gain'] = self.__gain( self.__globals_( ) )
        _invocation_parameters['threshold'] = self.__threshold( self.__globals_( ) )
        _invocation_parameters['nsigma'] = self.__nsigma( self.__globals_( ) )
        _invocation_parameters['cycleniter'] = self.__cycleniter( self.__globals_( ) )
        _invocation_parameters['cyclefactor'] = self.__cyclefactor( self.__globals_( ) )
        _invocation_parameters['minpsffraction'] = self.__minpsffraction( self.__globals_( ) )
        _invocation_parameters['maxpsffraction'] = self.__maxpsffraction( self.__globals_( ) )
        _invocation_parameters['nmajor'] = self.__nmajor( self.__globals_( ) )
        _invocation_parameters['usemask'] = self.__usemask( self.__globals_( ) )
        _invocation_parameters['mask'] = self.__mask( self.__globals_( ) )
        _invocation_parameters['pbmask'] = self.__pbmask( self.__globals_( ) )
        _invocation_parameters['sidelobethreshold'] = self.__sidelobethreshold( self.__globals_( ) )
        _invocation_parameters['noisethreshold'] = self.__noisethreshold( self.__globals_( ) )
        _invocation_parameters['lownoisethreshold'] = self.__lownoisethreshold( self.__globals_( ) )
        _invocation_parameters['negativethreshold'] = self.__negativethreshold( self.__globals_( ) )
        _invocation_parameters['smoothfactor'] = self.__smoothfactor( self.__globals_( ) )
        _invocation_parameters['minbeamfrac'] = self.__minbeamfrac( self.__globals_( ) )
        _invocation_parameters['cutthreshold'] = self.__cutthreshold( self.__globals_( ) )
        _invocation_parameters['growiterations'] = self.__growiterations( self.__globals_( ) )
        _invocation_parameters['dogrowprune'] = self.__dogrowprune( self.__globals_( ) )
        _invocation_parameters['minpercentchange'] = self.__minpercentchange( self.__globals_( ) )
        _invocation_parameters['verbose'] = self.__verbose( self.__globals_( ) )
        _invocation_parameters['fastnoise'] = self.__fastnoise( self.__globals_( ) )
        _invocation_parameters['restart'] = self.__restart( self.__globals_( ) )
        _invocation_parameters['savemodel'] = self.__savemodel( self.__globals_( ) )
        _invocation_parameters['calcres'] = self.__calcres( self.__globals_( ) )
        _invocation_parameters['calcpsf'] = self.__calcpsf( self.__globals_( ) )
        _invocation_parameters['psfcutoff'] = self.__psfcutoff( self.__globals_( ) )
        _invocation_parameters['parallel'] = self.__parallel( self.__globals_( ) )

        try:
            with open(_postfile,'w') as _f:
                for _i in _invocation_parameters:
                    _f.write("%-20s = %s\n" % (_i,noobj(repr(_invocation_parameters[_i]))))
                _f.write("#iclean( ")
                count = 0
                for _i in _invocation_parameters:
                    _f.write("%s=%s" % (_i,noobj(repr(_invocation_parameters[_i]))))
                    count += 1
                    if count < len(_invocation_parameters): _f.write(",")
                _f.write(" )\n")
        except: return False
        return True

    def __call__( self, vis=None, selectdata=None, field=None, spw=None, timerange=None, uvrange=None, antenna=None, scan=None, observation=None, intent=None, datacolumn=None, imagename=None, imsize=None, cell=None, phasecenter=None, stokes=None, projection=None, startmodel=None, specmode=None, reffreq=None, nchan=None, start=None, width=None, outframe=None, veltype=None, restfreq=None, interpolation=None, perchanweightdensity=None, gridder=None, facets=None, psfphasecenter=None, wprojplanes=None, vptable=None, mosweight=None, aterm=None, psterm=None, wbawp=None, conjbeams=None, cfcache=None, usepointing=None, computepastep=None, rotatepastep=None, pointingoffsetsigdev=None, pblimit=None, normtype=None, deconvolver=None, scales=None, nterms=None, smallscalebias=None, fusedthreshold=None, largestscale=None, restoration=None, restoringbeam=None, pbcor=None, outlierfile=None, weighting=None, robust=None, noise=None, npixels=None, uvtaper=None, niter=None, gain=None, threshold=None, nsigma=None, cycleniter=None, cyclefactor=None, minpsffraction=None, maxpsffraction=None, nmajor=None, usemask=None, mask=None, pbmask=None, sidelobethreshold=None, noisethreshold=None, lownoisethreshold=None, negativethreshold=None, smoothfactor=None, minbeamfrac=None, cutthreshold=None, growiterations=None, dogrowprune=None, minpercentchange=None, verbose=None, fastnoise=None, restart=None, savemodel=None, calcres=None, calcpsf=None, psfcutoff=None, parallel=None ):
        def noobj(s):
           if s.startswith('<') and s.endswith('>'):
               return "None"
           else:
               return s
        _prefile = os.path.realpath('iclean.pre')
        _postfile = os.path.realpath('iclean.last')
        task_result = None
        _arguments = [vis,selectdata,field,spw,timerange,uvrange,antenna,scan,observation,intent,datacolumn,imagename,imsize,cell,phasecenter,stokes,projection,startmodel,specmode,reffreq,nchan,start,width,outframe,veltype,restfreq,interpolation,perchanweightdensity,gridder,facets,psfphasecenter,wprojplanes,vptable,mosweight,aterm,psterm,wbawp,conjbeams,cfcache,usepointing,computepastep,rotatepastep,pointingoffsetsigdev,pblimit,normtype,deconvolver,scales,nterms,smallscalebias,fusedthreshold,largestscale,restoration,restoringbeam,pbcor,outlierfile,weighting,robust,noise,npixels,uvtaper,niter,gain,threshold,nsigma,cycleniter,cyclefactor,minpsffraction,maxpsffraction,nmajor,usemask,mask,pbmask,sidelobethreshold,noisethreshold,lownoisethreshold,negativethreshold,smoothfactor,minbeamfrac,cutthreshold,growiterations,dogrowprune,minpercentchange,verbose,fastnoise,restart,savemodel,calcres,calcpsf,psfcutoff,parallel,]
        _invocation_parameters = OrderedDict( )
        if any(map(lambda x: x is not None,_arguments)):
            # invoke python style
            # set the non sub-parameters that are not None
            local_global = { }
            if vis is not None: local_global['vis'] = vis
            if selectdata is not None: local_global['selectdata'] = selectdata
            if datacolumn is not None: local_global['datacolumn'] = datacolumn
            if imagename is not None: local_global['imagename'] = imagename
            if imsize is not None: local_global['imsize'] = imsize
            if cell is not None: local_global['cell'] = cell
            if phasecenter is not None: local_global['phasecenter'] = phasecenter
            if stokes is not None: local_global['stokes'] = stokes
            if projection is not None: local_global['projection'] = projection
            if startmodel is not None: local_global['startmodel'] = startmodel
            if specmode is not None: local_global['specmode'] = specmode
            if gridder is not None: local_global['gridder'] = gridder
            if pblimit is not None: local_global['pblimit'] = pblimit
            if deconvolver is not None: local_global['deconvolver'] = deconvolver
            if restoration is not None: local_global['restoration'] = restoration
            if outlierfile is not None: local_global['outlierfile'] = outlierfile
            if weighting is not None: local_global['weighting'] = weighting
            if niter is not None: local_global['niter'] = niter
            if nmajor is not None: local_global['nmajor'] = nmajor
            if usemask is not None: local_global['usemask'] = usemask
            if fastnoise is not None: local_global['fastnoise'] = fastnoise
            if restart is not None: local_global['restart'] = restart
            if savemodel is not None: local_global['savemodel'] = savemodel
            if calcres is not None: local_global['calcres'] = calcres
            if calcpsf is not None: local_global['calcpsf'] = calcpsf
            if parallel is not None: local_global['parallel'] = parallel

            # the invocation parameters for the non-subparameters can now be set - this picks up those defaults
            _invocation_parameters['vis'] = self.__vis( local_global )
            _invocation_parameters['selectdata'] = self.__selectdata( local_global )
            _invocation_parameters['datacolumn'] = self.__datacolumn( local_global )
            _invocation_parameters['imagename'] = self.__imagename( local_global )
            _invocation_parameters['imsize'] = self.__imsize( local_global )
            _invocation_parameters['cell'] = self.__cell( local_global )
            _invocation_parameters['phasecenter'] = self.__phasecenter( local_global )
            _invocation_parameters['stokes'] = self.__stokes( local_global )
            _invocation_parameters['projection'] = self.__projection( local_global )
            _invocation_parameters['startmodel'] = self.__startmodel( local_global )
            _invocation_parameters['specmode'] = self.__specmode( local_global )
            _invocation_parameters['gridder'] = self.__gridder( local_global )
            _invocation_parameters['pblimit'] = self.__pblimit( local_global )
            _invocation_parameters['deconvolver'] = self.__deconvolver( local_global )
            _invocation_parameters['restoration'] = self.__restoration( local_global )
            _invocation_parameters['outlierfile'] = self.__outlierfile( local_global )
            _invocation_parameters['weighting'] = self.__weighting( local_global )
            _invocation_parameters['niter'] = self.__niter( local_global )
            _invocation_parameters['nmajor'] = self.__nmajor( local_global )
            _invocation_parameters['usemask'] = self.__usemask( local_global )
            _invocation_parameters['fastnoise'] = self.__fastnoise( local_global )
            _invocation_parameters['restart'] = self.__restart( local_global )
            _invocation_parameters['savemodel'] = self.__savemodel( local_global )
            _invocation_parameters['calcres'] = self.__calcres( local_global )
            _invocation_parameters['calcpsf'] = self.__calcpsf( local_global )
            _invocation_parameters['parallel'] = self.__parallel( local_global )

            # the sub-parameters can then be set. Use the supplied value if not None, else the function, which gets the appropriate default
            _invocation_parameters['field'] = self.__field( _invocation_parameters ) if field is None else field
            _invocation_parameters['spw'] = self.__spw( _invocation_parameters ) if spw is None else spw
            _invocation_parameters['timerange'] = self.__timerange( _invocation_parameters ) if timerange is None else timerange
            _invocation_parameters['uvrange'] = self.__uvrange( _invocation_parameters ) if uvrange is None else uvrange
            _invocation_parameters['antenna'] = self.__antenna( _invocation_parameters ) if antenna is None else antenna
            _invocation_parameters['scan'] = self.__scan( _invocation_parameters ) if scan is None else scan
            _invocation_parameters['observation'] = self.__observation( _invocation_parameters ) if observation is None else observation
            _invocation_parameters['intent'] = self.__intent( _invocation_parameters ) if intent is None else intent
            _invocation_parameters['reffreq'] = self.__reffreq( _invocation_parameters ) if reffreq is None else reffreq
            _invocation_parameters['nchan'] = self.__nchan( _invocation_parameters ) if nchan is None else nchan
            _invocation_parameters['start'] = self.__start( _invocation_parameters ) if start is None else start
            _invocation_parameters['width'] = self.__width( _invocation_parameters ) if width is None else width
            _invocation_parameters['outframe'] = self.__outframe( _invocation_parameters ) if outframe is None else outframe
            _invocation_parameters['veltype'] = self.__veltype( _invocation_parameters ) if veltype is None else veltype
            _invocation_parameters['restfreq'] = self.__restfreq( _invocation_parameters ) if restfreq is None else restfreq
            _invocation_parameters['interpolation'] = self.__interpolation( _invocation_parameters ) if interpolation is None else interpolation
            _invocation_parameters['perchanweightdensity'] = self.__perchanweightdensity( _invocation_parameters ) if perchanweightdensity is None else perchanweightdensity
            _invocation_parameters['facets'] = self.__facets( _invocation_parameters ) if facets is None else facets
            _invocation_parameters['psfphasecenter'] = self.__psfphasecenter( _invocation_parameters ) if psfphasecenter is None else psfphasecenter
            _invocation_parameters['wprojplanes'] = self.__wprojplanes( _invocation_parameters ) if wprojplanes is None else wprojplanes
            _invocation_parameters['vptable'] = self.__vptable( _invocation_parameters ) if vptable is None else vptable
            _invocation_parameters['mosweight'] = self.__mosweight( _invocation_parameters ) if mosweight is None else mosweight
            _invocation_parameters['aterm'] = self.__aterm( _invocation_parameters ) if aterm is None else aterm
            _invocation_parameters['psterm'] = self.__psterm( _invocation_parameters ) if psterm is None else psterm
            _invocation_parameters['wbawp'] = self.__wbawp( _invocation_parameters ) if wbawp is None else wbawp
            _invocation_parameters['conjbeams'] = self.__conjbeams( _invocation_parameters ) if conjbeams is None else conjbeams
            _invocation_parameters['cfcache'] = self.__cfcache( _invocation_parameters ) if cfcache is None else cfcache
            _invocation_parameters['usepointing'] = self.__usepointing( _invocation_parameters ) if usepointing is None else usepointing
            _invocation_parameters['computepastep'] = self.__computepastep( _invocation_parameters ) if computepastep is None else computepastep
            _invocation_parameters['rotatepastep'] = self.__rotatepastep( _invocation_parameters ) if rotatepastep is None else rotatepastep
            _invocation_parameters['pointingoffsetsigdev'] = self.__pointingoffsetsigdev( _invocation_parameters ) if pointingoffsetsigdev is None else pointingoffsetsigdev
            _invocation_parameters['normtype'] = self.__normtype( _invocation_parameters ) if normtype is None else normtype
            _invocation_parameters['scales'] = self.__scales( _invocation_parameters ) if scales is None else scales
            _invocation_parameters['nterms'] = self.__nterms( _invocation_parameters ) if nterms is None else nterms
            _invocation_parameters['smallscalebias'] = self.__smallscalebias( _invocation_parameters ) if smallscalebias is None else smallscalebias
            _invocation_parameters['fusedthreshold'] = self.__fusedthreshold( _invocation_parameters ) if fusedthreshold is None else fusedthreshold
            _invocation_parameters['largestscale'] = self.__largestscale( _invocation_parameters ) if largestscale is None else largestscale
            _invocation_parameters['restoringbeam'] = self.__restoringbeam( _invocation_parameters ) if restoringbeam is None else restoringbeam
            _invocation_parameters['pbcor'] = self.__pbcor( _invocation_parameters ) if pbcor is None else pbcor
            _invocation_parameters['robust'] = self.__robust( _invocation_parameters ) if robust is None else robust
            _invocation_parameters['noise'] = self.__noise( _invocation_parameters ) if noise is None else noise
            _invocation_parameters['npixels'] = self.__npixels( _invocation_parameters ) if npixels is None else npixels
            _invocation_parameters['uvtaper'] = self.__uvtaper( _invocation_parameters ) if uvtaper is None else uvtaper
            _invocation_parameters['gain'] = self.__gain( _invocation_parameters ) if gain is None else gain
            _invocation_parameters['threshold'] = self.__threshold( _invocation_parameters ) if threshold is None else threshold
            _invocation_parameters['nsigma'] = self.__nsigma( _invocation_parameters ) if nsigma is None else nsigma
            _invocation_parameters['cycleniter'] = self.__cycleniter( _invocation_parameters ) if cycleniter is None else cycleniter
            _invocation_parameters['cyclefactor'] = self.__cyclefactor( _invocation_parameters ) if cyclefactor is None else cyclefactor
            _invocation_parameters['minpsffraction'] = self.__minpsffraction( _invocation_parameters ) if minpsffraction is None else minpsffraction
            _invocation_parameters['maxpsffraction'] = self.__maxpsffraction( _invocation_parameters ) if maxpsffraction is None else maxpsffraction
            _invocation_parameters['mask'] = self.__mask( _invocation_parameters ) if mask is None else mask
            _invocation_parameters['pbmask'] = self.__pbmask( _invocation_parameters ) if pbmask is None else pbmask
            _invocation_parameters['sidelobethreshold'] = self.__sidelobethreshold( _invocation_parameters ) if sidelobethreshold is None else sidelobethreshold
            _invocation_parameters['noisethreshold'] = self.__noisethreshold( _invocation_parameters ) if noisethreshold is None else noisethreshold
            _invocation_parameters['lownoisethreshold'] = self.__lownoisethreshold( _invocation_parameters ) if lownoisethreshold is None else lownoisethreshold
            _invocation_parameters['negativethreshold'] = self.__negativethreshold( _invocation_parameters ) if negativethreshold is None else negativethreshold
            _invocation_parameters['smoothfactor'] = self.__smoothfactor( _invocation_parameters ) if smoothfactor is None else smoothfactor
            _invocation_parameters['minbeamfrac'] = self.__minbeamfrac( _invocation_parameters ) if minbeamfrac is None else minbeamfrac
            _invocation_parameters['cutthreshold'] = self.__cutthreshold( _invocation_parameters ) if cutthreshold is None else cutthreshold
            _invocation_parameters['growiterations'] = self.__growiterations( _invocation_parameters ) if growiterations is None else growiterations
            _invocation_parameters['dogrowprune'] = self.__dogrowprune( _invocation_parameters ) if dogrowprune is None else dogrowprune
            _invocation_parameters['minpercentchange'] = self.__minpercentchange( _invocation_parameters ) if minpercentchange is None else minpercentchange
            _invocation_parameters['verbose'] = self.__verbose( _invocation_parameters ) if verbose is None else verbose
            _invocation_parameters['psfcutoff'] = self.__psfcutoff( _invocation_parameters ) if psfcutoff is None else psfcutoff

        else:
            # invoke with inp/go semantics
            _invocation_parameters['vis'] = self.__vis( self.__globals_( ) )
            _invocation_parameters['selectdata'] = self.__selectdata( self.__globals_( ) )
            _invocation_parameters['field'] = self.__field( self.__globals_( ) )
            _invocation_parameters['spw'] = self.__spw( self.__globals_( ) )
            _invocation_parameters['timerange'] = self.__timerange( self.__globals_( ) )
            _invocation_parameters['uvrange'] = self.__uvrange( self.__globals_( ) )
            _invocation_parameters['antenna'] = self.__antenna( self.__globals_( ) )
            _invocation_parameters['scan'] = self.__scan( self.__globals_( ) )
            _invocation_parameters['observation'] = self.__observation( self.__globals_( ) )
            _invocation_parameters['intent'] = self.__intent( self.__globals_( ) )
            _invocation_parameters['datacolumn'] = self.__datacolumn( self.__globals_( ) )
            _invocation_parameters['imagename'] = self.__imagename( self.__globals_( ) )
            _invocation_parameters['imsize'] = self.__imsize( self.__globals_( ) )
            _invocation_parameters['cell'] = self.__cell( self.__globals_( ) )
            _invocation_parameters['phasecenter'] = self.__phasecenter( self.__globals_( ) )
            _invocation_parameters['stokes'] = self.__stokes( self.__globals_( ) )
            _invocation_parameters['projection'] = self.__projection( self.__globals_( ) )
            _invocation_parameters['startmodel'] = self.__startmodel( self.__globals_( ) )
            _invocation_parameters['specmode'] = self.__specmode( self.__globals_( ) )
            _invocation_parameters['reffreq'] = self.__reffreq( self.__globals_( ) )
            _invocation_parameters['nchan'] = self.__nchan( self.__globals_( ) )
            _invocation_parameters['start'] = self.__start( self.__globals_( ) )
            _invocation_parameters['width'] = self.__width( self.__globals_( ) )
            _invocation_parameters['outframe'] = self.__outframe( self.__globals_( ) )
            _invocation_parameters['veltype'] = self.__veltype( self.__globals_( ) )
            _invocation_parameters['restfreq'] = self.__restfreq( self.__globals_( ) )
            _invocation_parameters['interpolation'] = self.__interpolation( self.__globals_( ) )
            _invocation_parameters['perchanweightdensity'] = self.__perchanweightdensity( self.__globals_( ) )
            _invocation_parameters['gridder'] = self.__gridder( self.__globals_( ) )
            _invocation_parameters['facets'] = self.__facets( self.__globals_( ) )
            _invocation_parameters['psfphasecenter'] = self.__psfphasecenter( self.__globals_( ) )
            _invocation_parameters['wprojplanes'] = self.__wprojplanes( self.__globals_( ) )
            _invocation_parameters['vptable'] = self.__vptable( self.__globals_( ) )
            _invocation_parameters['mosweight'] = self.__mosweight( self.__globals_( ) )
            _invocation_parameters['aterm'] = self.__aterm( self.__globals_( ) )
            _invocation_parameters['psterm'] = self.__psterm( self.__globals_( ) )
            _invocation_parameters['wbawp'] = self.__wbawp( self.__globals_( ) )
            _invocation_parameters['conjbeams'] = self.__conjbeams( self.__globals_( ) )
            _invocation_parameters['cfcache'] = self.__cfcache( self.__globals_( ) )
            _invocation_parameters['usepointing'] = self.__usepointing( self.__globals_( ) )
            _invocation_parameters['computepastep'] = self.__computepastep( self.__globals_( ) )
            _invocation_parameters['rotatepastep'] = self.__rotatepastep( self.__globals_( ) )
            _invocation_parameters['pointingoffsetsigdev'] = self.__pointingoffsetsigdev( self.__globals_( ) )
            _invocation_parameters['pblimit'] = self.__pblimit( self.__globals_( ) )
            _invocation_parameters['normtype'] = self.__normtype( self.__globals_( ) )
            _invocation_parameters['deconvolver'] = self.__deconvolver( self.__globals_( ) )
            _invocation_parameters['scales'] = self.__scales( self.__globals_( ) )
            _invocation_parameters['nterms'] = self.__nterms( self.__globals_( ) )
            _invocation_parameters['smallscalebias'] = self.__smallscalebias( self.__globals_( ) )
            _invocation_parameters['fusedthreshold'] = self.__fusedthreshold( self.__globals_( ) )
            _invocation_parameters['largestscale'] = self.__largestscale( self.__globals_( ) )
            _invocation_parameters['restoration'] = self.__restoration( self.__globals_( ) )
            _invocation_parameters['restoringbeam'] = self.__restoringbeam( self.__globals_( ) )
            _invocation_parameters['pbcor'] = self.__pbcor( self.__globals_( ) )
            _invocation_parameters['outlierfile'] = self.__outlierfile( self.__globals_( ) )
            _invocation_parameters['weighting'] = self.__weighting( self.__globals_( ) )
            _invocation_parameters['robust'] = self.__robust( self.__globals_( ) )
            _invocation_parameters['noise'] = self.__noise( self.__globals_( ) )
            _invocation_parameters['npixels'] = self.__npixels( self.__globals_( ) )
            _invocation_parameters['uvtaper'] = self.__uvtaper( self.__globals_( ) )
            _invocation_parameters['niter'] = self.__niter( self.__globals_( ) )
            _invocation_parameters['gain'] = self.__gain( self.__globals_( ) )
            _invocation_parameters['threshold'] = self.__threshold( self.__globals_( ) )
            _invocation_parameters['nsigma'] = self.__nsigma( self.__globals_( ) )
            _invocation_parameters['cycleniter'] = self.__cycleniter( self.__globals_( ) )
            _invocation_parameters['cyclefactor'] = self.__cyclefactor( self.__globals_( ) )
            _invocation_parameters['minpsffraction'] = self.__minpsffraction( self.__globals_( ) )
            _invocation_parameters['maxpsffraction'] = self.__maxpsffraction( self.__globals_( ) )
            _invocation_parameters['nmajor'] = self.__nmajor( self.__globals_( ) )
            _invocation_parameters['usemask'] = self.__usemask( self.__globals_( ) )
            _invocation_parameters['mask'] = self.__mask( self.__globals_( ) )
            _invocation_parameters['pbmask'] = self.__pbmask( self.__globals_( ) )
            _invocation_parameters['sidelobethreshold'] = self.__sidelobethreshold( self.__globals_( ) )
            _invocation_parameters['noisethreshold'] = self.__noisethreshold( self.__globals_( ) )
            _invocation_parameters['lownoisethreshold'] = self.__lownoisethreshold( self.__globals_( ) )
            _invocation_parameters['negativethreshold'] = self.__negativethreshold( self.__globals_( ) )
            _invocation_parameters['smoothfactor'] = self.__smoothfactor( self.__globals_( ) )
            _invocation_parameters['minbeamfrac'] = self.__minbeamfrac( self.__globals_( ) )
            _invocation_parameters['cutthreshold'] = self.__cutthreshold( self.__globals_( ) )
            _invocation_parameters['growiterations'] = self.__growiterations( self.__globals_( ) )
            _invocation_parameters['dogrowprune'] = self.__dogrowprune( self.__globals_( ) )
            _invocation_parameters['minpercentchange'] = self.__minpercentchange( self.__globals_( ) )
            _invocation_parameters['verbose'] = self.__verbose( self.__globals_( ) )
            _invocation_parameters['fastnoise'] = self.__fastnoise( self.__globals_( ) )
            _invocation_parameters['restart'] = self.__restart( self.__globals_( ) )
            _invocation_parameters['savemodel'] = self.__savemodel( self.__globals_( ) )
            _invocation_parameters['calcres'] = self.__calcres( self.__globals_( ) )
            _invocation_parameters['calcpsf'] = self.__calcpsf( self.__globals_( ) )
            _invocation_parameters['psfcutoff'] = self.__psfcutoff( self.__globals_( ) )
            _invocation_parameters['parallel'] = self.__parallel( self.__globals_( ) )
        try:
            with open(_prefile,'w') as _f:
                for _i in _invocation_parameters:
                    _f.write("%-20s = %s\n" % (_i,noobj(repr(_invocation_parameters[_i]))))
                _f.write("#iclean( ")
                count = 0
                for _i in _invocation_parameters:
                    _f.write("%s=%s" % (_i,noobj(repr(_invocation_parameters[_i]))))
                    count += 1
                    if count < len(_invocation_parameters): _f.write(",")
                _f.write(" )\n")
        except: pass
        try:
            _logging_state_ = None
            assert _pc.validate(_invocation_parameters,self.__schema), create_error_string(_pc.errors)
            _logging_state_ = _start_log( 'iclean', [ 'vis=' + repr(_pc.document['vis']), 'selectdata=' + repr(_pc.document['selectdata']), 'field=' + repr(_pc.document['field']), 'spw=' + repr(_pc.document['spw']), 'timerange=' + repr(_pc.document['timerange']), 'uvrange=' + repr(_pc.document['uvrange']), 'antenna=' + repr(_pc.document['antenna']), 'scan=' + repr(_pc.document['scan']), 'observation=' + repr(_pc.document['observation']), 'intent=' + repr(_pc.document['intent']), 'datacolumn=' + repr(_pc.document['datacolumn']), 'imagename=' + repr(_pc.document['imagename']), 'imsize=' + repr(_pc.document['imsize']), 'cell=' + repr(_pc.document['cell']), 'phasecenter=' + repr(_pc.document['phasecenter']), 'stokes=' + repr(_pc.document['stokes']), 'projection=' + repr(_pc.document['projection']), 'startmodel=' + repr(_pc.document['startmodel']), 'specmode=' + repr(_pc.document['specmode']), 'reffreq=' + repr(_pc.document['reffreq']), 'nchan=' + repr(_pc.document['nchan']), 'start=' + repr(_pc.document['start']), 'width=' + repr(_pc.document['width']), 'outframe=' + repr(_pc.document['outframe']), 'veltype=' + repr(_pc.document['veltype']), 'restfreq=' + repr(_pc.document['restfreq']), 'interpolation=' + repr(_pc.document['interpolation']), 'perchanweightdensity=' + repr(_pc.document['perchanweightdensity']), 'gridder=' + repr(_pc.document['gridder']), 'facets=' + repr(_pc.document['facets']), 'psfphasecenter=' + repr(_pc.document['psfphasecenter']), 'wprojplanes=' + repr(_pc.document['wprojplanes']), 'vptable=' + repr(_pc.document['vptable']), 'mosweight=' + repr(_pc.document['mosweight']), 'aterm=' + repr(_pc.document['aterm']), 'psterm=' + repr(_pc.document['psterm']), 'wbawp=' + repr(_pc.document['wbawp']), 'conjbeams=' + repr(_pc.document['conjbeams']), 'cfcache=' + repr(_pc.document['cfcache']), 'usepointing=' + repr(_pc.document['usepointing']), 'computepastep=' + repr(_pc.document['computepastep']), 'rotatepastep=' + repr(_pc.document['rotatepastep']), 'pointingoffsetsigdev=' + repr(_pc.document['pointingoffsetsigdev']), 'pblimit=' + repr(_pc.document['pblimit']), 'normtype=' + repr(_pc.document['normtype']), 'deconvolver=' + repr(_pc.document['deconvolver']), 'scales=' + repr(_pc.document['scales']), 'nterms=' + repr(_pc.document['nterms']), 'smallscalebias=' + repr(_pc.document['smallscalebias']), 'fusedthreshold=' + repr(_pc.document['fusedthreshold']), 'largestscale=' + repr(_pc.document['largestscale']), 'restoration=' + repr(_pc.document['restoration']), 'restoringbeam=' + repr(_pc.document['restoringbeam']), 'pbcor=' + repr(_pc.document['pbcor']), 'outlierfile=' + repr(_pc.document['outlierfile']), 'weighting=' + repr(_pc.document['weighting']), 'robust=' + repr(_pc.document['robust']), 'noise=' + repr(_pc.document['noise']), 'npixels=' + repr(_pc.document['npixels']), 'uvtaper=' + repr(_pc.document['uvtaper']), 'niter=' + repr(_pc.document['niter']), 'gain=' + repr(_pc.document['gain']), 'threshold=' + repr(_pc.document['threshold']), 'nsigma=' + repr(_pc.document['nsigma']), 'cycleniter=' + repr(_pc.document['cycleniter']), 'cyclefactor=' + repr(_pc.document['cyclefactor']), 'minpsffraction=' + repr(_pc.document['minpsffraction']), 'maxpsffraction=' + repr(_pc.document['maxpsffraction']), 'nmajor=' + repr(_pc.document['nmajor']), 'usemask=' + repr(_pc.document['usemask']), 'mask=' + repr(_pc.document['mask']), 'pbmask=' + repr(_pc.document['pbmask']), 'sidelobethreshold=' + repr(_pc.document['sidelobethreshold']), 'noisethreshold=' + repr(_pc.document['noisethreshold']), 'lownoisethreshold=' + repr(_pc.document['lownoisethreshold']), 'negativethreshold=' + repr(_pc.document['negativethreshold']), 'smoothfactor=' + repr(_pc.document['smoothfactor']), 'minbeamfrac=' + repr(_pc.document['minbeamfrac']), 'cutthreshold=' + repr(_pc.document['cutthreshold']), 'growiterations=' + repr(_pc.document['growiterations']), 'dogrowprune=' + repr(_pc.document['dogrowprune']), 'minpercentchange=' + repr(_pc.document['minpercentchange']), 'verbose=' + repr(_pc.document['verbose']), 'fastnoise=' + repr(_pc.document['fastnoise']), 'restart=' + repr(_pc.document['restart']), 'savemodel=' + repr(_pc.document['savemodel']), 'calcres=' + repr(_pc.document['calcres']), 'calcpsf=' + repr(_pc.document['calcpsf']), 'psfcutoff=' + repr(_pc.document['psfcutoff']), 'parallel=' + repr(_pc.document['parallel']), ] )
            task_result = _iclean_t( vis=_pc.document['vis'],selectdata=_pc.document['selectdata'],field=_pc.document['field'],spw=_pc.document['spw'],timerange=_pc.document['timerange'],uvrange=_pc.document['uvrange'],antenna=_pc.document['antenna'],scan=_pc.document['scan'],observation=_pc.document['observation'],intent=_pc.document['intent'],datacolumn=_pc.document['datacolumn'],imagename=_pc.document['imagename'],imsize=_pc.document['imsize'],cell=_pc.document['cell'],phasecenter=_pc.document['phasecenter'],stokes=_pc.document['stokes'],projection=_pc.document['projection'],startmodel=_pc.document['startmodel'],specmode=_pc.document['specmode'],reffreq=_pc.document['reffreq'],nchan=_pc.document['nchan'],start=_pc.document['start'],width=_pc.document['width'],outframe=_pc.document['outframe'],veltype=_pc.document['veltype'],restfreq=_pc.document['restfreq'],interpolation=_pc.document['interpolation'],perchanweightdensity=_pc.document['perchanweightdensity'],gridder=_pc.document['gridder'],facets=_pc.document['facets'],psfphasecenter=_pc.document['psfphasecenter'],wprojplanes=_pc.document['wprojplanes'],vptable=_pc.document['vptable'],mosweight=_pc.document['mosweight'],aterm=_pc.document['aterm'],psterm=_pc.document['psterm'],wbawp=_pc.document['wbawp'],conjbeams=_pc.document['conjbeams'],cfcache=_pc.document['cfcache'],usepointing=_pc.document['usepointing'],computepastep=_pc.document['computepastep'],rotatepastep=_pc.document['rotatepastep'],pointingoffsetsigdev=_pc.document['pointingoffsetsigdev'],pblimit=_pc.document['pblimit'],normtype=_pc.document['normtype'],deconvolver=_pc.document['deconvolver'],scales=_pc.document['scales'],nterms=_pc.document['nterms'],smallscalebias=_pc.document['smallscalebias'],fusedthreshold=_pc.document['fusedthreshold'],largestscale=_pc.document['largestscale'],restoration=_pc.document['restoration'],restoringbeam=_pc.document['restoringbeam'],pbcor=_pc.document['pbcor'],outlierfile=_pc.document['outlierfile'],weighting=_pc.document['weighting'],robust=_pc.document['robust'],noise=_pc.document['noise'],npixels=_pc.document['npixels'],uvtaper=_pc.document['uvtaper'],niter=_pc.document['niter'],gain=_pc.document['gain'],threshold=_pc.document['threshold'],nsigma=_pc.document['nsigma'],cycleniter=_pc.document['cycleniter'],cyclefactor=_pc.document['cyclefactor'],minpsffraction=_pc.document['minpsffraction'],maxpsffraction=_pc.document['maxpsffraction'],nmajor=_pc.document['nmajor'],usemask=_pc.document['usemask'],mask=_pc.document['mask'],pbmask=_pc.document['pbmask'],sidelobethreshold=_pc.document['sidelobethreshold'],noisethreshold=_pc.document['noisethreshold'],lownoisethreshold=_pc.document['lownoisethreshold'],negativethreshold=_pc.document['negativethreshold'],smoothfactor=_pc.document['smoothfactor'],minbeamfrac=_pc.document['minbeamfrac'],cutthreshold=_pc.document['cutthreshold'],growiterations=_pc.document['growiterations'],dogrowprune=_pc.document['dogrowprune'],minpercentchange=_pc.document['minpercentchange'],verbose=_pc.document['verbose'],fastnoise=_pc.document['fastnoise'],restart=_pc.document['restart'],savemodel=_pc.document['savemodel'],calcres=_pc.document['calcres'],calcpsf=_pc.document['calcpsf'],psfcutoff=_pc.document['psfcutoff'],parallel=_pc.document['parallel'], )
        except Exception as e:
            from traceback import format_exc
            from casatasks import casalog
            casalog.origin('iclean')
            casalog.post("Exception Reported: Error in iclean: %s" % str(e),'SEVERE')
            casalog.post(format_exc( ))
            raise #exception is now raised
            #task_result = False
        finally:
            try:
                os.rename(_prefile,_postfile)
            except: pass
            if _logging_state_:
                task_result = _end_log( _logging_state_, 'iclean', task_result )

        #Added if _iclean_t returns False and does not raise an exception.
        if task_result is False:
            raise

        return task_result #Still needed

iclean = _iclean( )
