########################################################################
#
# Copyright (C) 2024
# Associated Universities, Inc. Washington DC, USA.
#
# This script is free software; you can redistribute it and/or modify it
# under the terms of the GNU Library General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.
#
# This library is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
# License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 675 Massachusetts Ave, Cambridge, MA 02139, USA.
#
# Correspondence concerning AIPS++ should be adressed as follows:
#        Internet email: casa-feedback@nrao.edu.
#        Postal address: AIPS++ Project Office
#                        National Radio Astronomy Observatory
#                        520 Edgemont Road
#                        Charlottesville, VA 22903-2475 USA
#
########################################################################
##################### generated by xml-casa (v2) from createmask.xml
##################### 26fdebc4cbd4e58e368f393b9b7ccde7 ##############################
from __future__ import absolute_import
import numpy
from casatools.typecheck import CasaValidator as _val_ctor
_pc = _val_ctor( )
from casatools.coercetype import coerce as _coerce
from casatools.errors import create_error_string
from casatasks.private.task_logging import start_log as _start_log
from casatasks.private.task_logging import end_log as _end_log
from casatasks.private.task_logging import except_log as _except_log
from cubevis.private.apps import CreateMask

def _createmask_t( *args, **kwargs ):
    cm = CreateMask( *args, **kwargs )
    return cm( )

class _createmask:
    """
    createmask ---- Create mask cubes interactively with a GUI

    Create a mask cube for one or more images using a GUI.
    This task is based upon the same tools that are used to build
    the interactive clean application so the same command keys are
    used for both applications.


    --------- parameter descriptions ---------------------------------------------

    image
    mask
    create

    --------- examples -----------------------------------------------------------




    """

    _info_group_ = """imaging"""
    _info_desc_ = """Create mask cubes interactively with a GUI"""

    def __call__( self, image=[ ], mask=[  ], create=True ):
        schema = { 'image': {'anyof': [{'type': 'cReqPath', 'coerce': _coerce.expand_path}, {'type': 'cReqPathVec', 'coerce': [_coerce.to_list,_coerce.expand_pathvec]}]}, 'mask': {'anyof': [{'type': 'cPath', 'coerce': _coerce.expand_path}, {'type': 'cPathVec', 'coerce': [_coerce.to_list,_coerce.expand_pathvec]}]}, 'create': {'type': 'cBool'},  }
        doc = { 'image': image, 'mask': mask, 'create': create,  }
        assert _pc.validate(doc,schema), create_error_string(_pc.errors)
        _logging_state_ = _start_log( 'createmask', [ 'image=' + repr(_pc.document['image']), 'mask=' + repr(_pc.document['mask']), 'create=' + repr(_pc.document['create']),  ] )
        task_result = None
        try:
            task_result = _createmask_t( image=_pc.document['image'], mask=_pc.document['mask'], create=_pc.document['create'],  )
        except Exception as exc:
            _except_log('createmask', exc)
            raise
        finally:
            task_result = _end_log( _logging_state_, 'createmask', task_result )
        return task_result

createmask = _createmask( )
