/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.DoubleContainer;
import com.carrotsearch.hppcrt.DoublePriorityQueue;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;
import com.carrotsearch.hppcrt.strategies.DoubleComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleHeapPriorityQueue
extends AbstractDoubleCollection
implements DoublePriorityQueue,
Cloneable {
    public double[] buffer;
    protected int elementsCount;
    protected DoubleComparator comparator;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<DoubleCursor, ValueIterator> valueIteratorPool;
    protected double currentOccurenceToBeRemoved;
    protected DoublePredicate removeAllOccurencesPredicate = new DoublePredicate(){

        public final boolean apply(double value) {
            return Double.doubleToLongBits(value) == Double.doubleToLongBits(DoubleHeapPriorityQueue.this.currentOccurenceToBeRemoved);
        }
    };
    protected double defaultValue;

    public DoubleHeapPriorityQueue(DoubleComparator comp, int initialCapacity, ArraySizingStrategy resizer) {
        this.comparator = comp;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = 0;
                obj.size = DoubleHeapPriorityQueue.this.size();
                ValueIterator.access$102(obj, DoubleHeapPriorityQueue.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public DoubleHeapPriorityQueue(DoubleComparator comp) {
        this(comp, 8);
    }

    public DoubleHeapPriorityQueue() {
        this(null, 8);
    }

    public DoubleHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleHeapPriorityQueue(DoubleComparator comp, int initialCapacity) {
        this(comp, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public DoubleHeapPriorityQueue(DoubleContainer container) {
        this(container.size());
        this.addAll(container);
    }

    public static DoubleHeapPriorityQueue from(DoubleContainer container) {
        return new DoubleHeapPriorityQueue(container);
    }

    public static DoubleHeapPriorityQueue from(double ... elements) {
        DoubleHeapPriorityQueue heap = new DoubleHeapPriorityQueue(elements.length);
        for (double elem : elements) {
            heap.add(elem);
        }
        return heap;
    }

    @Override
    public int removeAll(double e1) {
        this.currentOccurenceToBeRemoved = e1;
        return this.removeAll(this.removeAllOccurencesPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(DoublePredicate predicate) {
        int deleted = 0;
        double[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    buffer[pos] = buffer[elementsCount];
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public boolean contains(double element) {
        int size = this.elementsCount;
        double[] buff = this.buffer;
        for (int i = 1; i <= size; ++i) {
            if (Double.doubleToLongBits(element) != Double.doubleToLongBits(buff[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        double[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size; ++i) {
            procedure.apply(buff[i]);
        }
        return procedure;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        double[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size && predicate.apply(buff[i]); ++i) {
        }
        return predicate;
    }

    @Override
    public void add(double element) {
        this.ensureBufferSpace(1);
        ++this.elementsCount;
        this.buffer[this.elementsCount] = element;
        this.swim(this.elementsCount);
    }

    @Override
    public double top() {
        double elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    @Override
    public double popTop() {
        double elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            if (this.elementsCount == 1) {
                this.elementsCount = 0;
            } else {
                this.buffer[1] = this.buffer[this.elementsCount];
                --this.elementsCount;
                this.sink(1);
            }
        }
        return elem;
    }

    public int addAll(DoubleContainer container) {
        return this.addAll((Iterable<? extends DoubleCursor>)container);
    }

    public int addAll(Iterable<? extends DoubleCursor> iterable) {
        int size = 0;
        double[] buff = this.buffer;
        int count = this.elementsCount;
        for (DoubleCursor doubleCursor : iterable) {
            this.ensureBufferSpace(1);
            buff[++count] = doubleCursor.value;
            ++size;
        }
        this.elementsCount = count;
        this.updatePriorities();
        return size;
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        double[] buff = this.buffer;
        for (int i = 1; i <= max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(buff[i]);
        }
        return h2;
    }

    @Override
    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    public DoubleHeapPriorityQueue clone() {
        DoubleHeapPriorityQueue cloned = new DoubleHeapPriorityQueue(this.comparator, 8, this.resizer);
        cloned.buffer = (double[])this.buffer.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DoubleHeapPriorityQueue other = (DoubleHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            ValueIterator it = this.iterator();
            ValueIterator itOther = other.iterator();
            while (it.hasNext()) {
                double myVal = ((DoubleCursor)it.next()).value;
                double otherVal = ((DoubleCursor)itOther.next()).value;
                if (Double.doubleToLongBits(myVal) == Double.doubleToLongBits(otherVal)) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                double[] newBuffer = new double[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public double[] toArray(double[] target) {
        System.arraycopy(this.buffer, 1, target, 0, this.elementsCount);
        return target;
    }

    public DoubleComparator comparator() {
        return this.comparator;
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        double[] buffer = this.buffer;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && Double.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (Double.compare(buffer[k], buffer[child]) <= 0) break;
            double tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        double[] buffer = this.buffer;
        DoubleComparator comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            double tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void swimComparable(int k) {
        double[] buffer = this.buffer;
        while (k > 1 && Double.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            double tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        double[] buffer = this.buffer;
        DoubleComparator comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            double tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();
        private double[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = 0;
            this.size = DoubleHeapPriorityQueue.this.size();
            this.buffer = DoubleHeapPriorityQueue.this.buffer;
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.cursor.index == this.size) {
                return (DoubleCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ double[] access$102(ValueIterator x0, double[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

