/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ByteArrays;
import com.carrotsearch.hppcrt.ByteContainer;
import com.carrotsearch.hppcrt.ByteIndexedContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.ByteLinkedList;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.sorting.ByteSort;
import com.carrotsearch.hppcrt.strategies.ByteComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayList
extends AbstractByteCollection
implements ByteIndexedContainer,
Cloneable {
    public byte[] buffer;
    protected int elementsCount;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ByteCursor, ValueIterator> valueIteratorPool;

    public ByteArrayList() {
        this(8);
    }

    public ByteArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ByteArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.size = ByteArrayList.this.size();
                ValueIterator.access$102(obj, ByteArrayList.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public ByteArrayList(ByteContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(byte e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(byte e1, byte e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(byte[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(byte ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ByteContainer container) {
        return this.addAll((Iterable<? extends ByteCursor>)container);
    }

    public int addAll(Iterable<? extends ByteCursor> iterable) {
        int size = 0;
        for (ByteCursor byteCursor : iterable) {
            this.add(byteCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, byte e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public byte get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        return this.buffer[index];
    }

    @Override
    public byte set(int index, byte e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        byte v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public byte remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        byte v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    @Override
    public int removeFirst(byte e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(byte e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(byte e1) {
        int to = 0;
        byte[] buffer = this.buffer;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == buffer[from]) continue;
            if (to != from) {
                buffer[to] = buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(byte e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(byte e1) {
        byte[] buffer = this.buffer;
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte e1) {
        byte[] buffer = this.buffer;
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            try {
                byte[] newBuffer = new byte[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize >= this.elementsCount) {
                Arrays.fill(this.buffer, this.elementsCount, newSize, (byte)0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = ByteArrays.EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public byte[] toArray(byte[] target) {
        System.arraycopy(this.buffer, 0, target, 0, this.elementsCount);
        return target;
    }

    public ByteArrayList clone() {
        ByteArrayList cloned = new ByteArrayList(8, this.resizer);
        cloned.buffer = (byte[])this.buffer.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        byte[] buffer = this.buffer;
        for (int i = 0; i < max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(buffer[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ByteArrayList) {
                ByteArrayList other = (ByteArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ByteLinkedList) {
                ByteLinkedList other = (ByteLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                ByteLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    byte myVal = ((ByteCursor)it.next()).value;
                    byte otherVal = ((ByteCursor)itOther.next()).value;
                    if (myVal == otherVal) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof ByteIndexedContainer) {
                ByteIndexedContainer other = (ByteIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(byte[] b1, byte[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ByteIndexedContainer b1, ByteIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            byte o2;
            byte o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public <T extends ByteProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    @Override
    public <T extends ByteProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        byte[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(BytePredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        byte[] buffer = this.buffer;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) continue;
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends BytePredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    @Override
    public <T extends BytePredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        byte[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static ByteArrayList newInstance() {
        return new ByteArrayList();
    }

    public static ByteArrayList newInstance(int initialCapacity) {
        return new ByteArrayList(initialCapacity);
    }

    public static ByteArrayList from(byte ... elements) {
        ByteArrayList list = new ByteArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static ByteArrayList from(ByteContainer container) {
        return new ByteArrayList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        ByteSort.quicksort(this.buffer, beginIndex, endIndex);
    }

    public void sort() {
        this.sort(0, this.elementsCount);
    }

    public void sort(int beginIndex, int endIndex, ByteComparator comp) {
        ByteSort.quicksort(this.buffer, beginIndex, endIndex, comp);
    }

    public void sort(ByteComparator comp) {
        this.sort(0, this.elementsCount, comp);
    }

    public void pushLast(byte e1) {
        this.add(e1);
    }

    public void pushLast(byte e1, byte e2) {
        this.add(e1, e2);
    }

    public void pushLast(byte e1, byte e2, byte e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void pushLast(byte e1, byte e2, byte e3, byte e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void pushLast(byte[] elements, int start, int len) {
        this.add(elements, start, len);
    }

    public final void pushLast(byte ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int pushAllLast(ByteContainer container) {
        return this.addAll(container);
    }

    public int pushAllLast(Iterable<? extends ByteCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discardLast(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discardLast() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public byte popLast() {
        assert (this.elementsCount > 0);
        byte v = this.buffer[--this.elementsCount];
        return v;
    }

    public byte peekLast() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.elementsCount) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.elementsCount + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();
        private byte[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = -1;
            this.size = ByteArrayList.this.size();
            this.buffer = ByteArrayList.this.buffer;
        }

        @Override
        protected ByteCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ByteCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ byte[] access$102(ValueIterator x0, byte[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

