/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectIndexedContainer;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.ObjectLinkedList;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import com.carrotsearch.hppcrt.sorting.ObjectSort;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType>,
Cloneable {
    public Object[] buffer;
    protected int elementsCount;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ObjectCursor<KType>, ValueIterator> valueIteratorPool;

    public ObjectArrayList() {
        this(8);
    }

    public ObjectArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.size = ObjectArrayList.this.size();
                ValueIterator.access$102(obj, ObjectArrayList.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
                obj.cursor.value = null;
            }
        });
    }

    public ObjectArrayList(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(KType[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    @Override
    public void add(KType ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ObjectContainer<? extends KType> container) {
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.add((KType)objectCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, KType e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public KType get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        return (KType)this.buffer[index];
    }

    @Override
    public KType set(int index, KType e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        Object v = this.buffer[index];
        this.buffer[index] = e1;
        return (KType)v;
    }

    @Override
    public KType remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        Object v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
        return (KType)v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        ObjectArrays.blankArray(this.buffer, this.elementsCount, this.elementsCount + count);
    }

    @Override
    public int removeFirst(KType e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(KType e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(KType e1) {
        int to = 0;
        Object[] buffer = this.buffer;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == null ? buffer[from] == null : e1.equals(buffer[from])) {
                buffer[from] = null;
                continue;
            }
            if (to != from) {
                buffer[to] = buffer[from];
                buffer[from] = null;
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(KType e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(KType e1) {
        Object[] buffer = this.buffer;
        for (int i = 0; i < this.elementsCount; ++i) {
            if (!(e1 == null ? buffer[i] == null : e1.equals(buffer[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(KType e1) {
        Object[] buffer = this.buffer;
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (!(e1 == null ? buffer[i] == null : e1.equals(buffer[i]))) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            try {
                Object[] newBuffer = new Object[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                ObjectArrays.blankArray(this.buffer, newSize, this.elementsCount);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, null);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        ObjectArrays.blankArray(this.buffer, 0, this.elementsCount);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = ObjectArrays.EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public KType[] toArray(KType[] target) {
        System.arraycopy(this.buffer, 0, target, 0, this.elementsCount);
        return target;
    }

    public ObjectArrayList<KType> clone() {
        ObjectArrayList<KType> cloned = new ObjectArrayList<KType>(8, this.resizer);
        cloned.buffer = (Object[])this.buffer.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        Object[] buffer = this.buffer;
        for (int i = 0; i < max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(buffer[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectArrayList) {
                ObjectArrayList other = (ObjectArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ObjectLinkedList) {
                ObjectLinkedList other = (ObjectLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                ObjectLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    Object myVal = ((ObjectCursor)it.next()).value;
                    Object otherVal = ((ObjectCursor)itOther.next()).value;
                    if (myVal != null ? myVal.equals(otherVal) : otherVal == null) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof ObjectIndexedContainer) {
                ObjectIndexedContainer other = (ObjectIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(Object[] b1, Object[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] != null ? b1[i].equals(b2[i]) : b2[i] == null) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ObjectIndexedContainer<KType> b1, ObjectIndexedContainer<KType> b2, int length) {
        for (int i = 0; i < length; ++i) {
            KType o1 = b1.get(i);
            KType o2 = b2.get(i);
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        Object[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply((Object)buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int from;
        int elementsCount = this.elementsCount;
        Object[] buffer = this.buffer;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = null;
                    continue;
                }
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = null;
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        Object[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply((Object)buffer[i]); ++i) {
        }
        return predicate;
    }

    public static <KType> ObjectArrayList<KType> newInstance() {
        return new ObjectArrayList<KType>();
    }

    public static <KType> ObjectArrayList<KType> newInstance(int initialCapacity) {
        return new ObjectArrayList<KType>(initialCapacity);
    }

    public static <KType> ObjectArrayList<KType> from(KType ... elements) {
        ObjectArrayList<KType> list = new ObjectArrayList<KType>(elements.length);
        list.add(elements);
        return list;
    }

    public static <KType> ObjectArrayList<KType> from(ObjectContainer<KType> container) {
        return new ObjectArrayList<KType>(container);
    }

    public void sort(int beginIndex, int endIndex) {
        ObjectSort.quicksort(this.buffer, beginIndex, endIndex);
    }

    public void sort() {
        this.sort(0, this.elementsCount);
    }

    public void sort(int beginIndex, int endIndex, Comparator<? super KType> comp) {
        ObjectSort.quicksort(this.buffer, beginIndex, endIndex, comp);
    }

    public void sort(Comparator<? super KType> comp) {
        this.sort(0, this.elementsCount, comp);
    }

    public void pushLast(KType e1) {
        this.add(e1);
    }

    public void pushLast(KType e1, KType e2) {
        this.add(e1, e2);
    }

    public void pushLast(KType e1, KType e2, KType e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void pushLast(KType e1, KType e2, KType e3, KType e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void pushLast(KType[] elements, int start, int len) {
        this.add(elements, start, len);
    }

    public final void pushLast(KType ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int pushAllLast(ObjectContainer<? extends KType> container) {
        return this.addAll(container);
    }

    public int pushAllLast(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        return this.addAll(iterable);
    }

    public void discardLast(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, null);
    }

    public void discardLast() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
    }

    public KType popLast() {
        assert (this.elementsCount > 0);
        Object v = this.buffer[--this.elementsCount];
        this.buffer[this.elementsCount] = null;
        return (KType)v;
    }

    public KType peekLast() {
        assert (this.elementsCount > 0);
        return (KType)this.buffer[this.elementsCount - 1];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.elementsCount) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.elementsCount + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();
        private KType[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = -1;
            this.size = ObjectArrayList.this.size();
            this.buffer = ObjectArrayList.this.buffer;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ObjectCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ Object[] access$102(ValueIterator x0, Object[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

