/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ByteArrays;
import com.carrotsearch.hppcrt.ByteContainer;
import com.carrotsearch.hppcrt.ByteIntAssociativeContainer;
import com.carrotsearch.hppcrt.ByteIntMap;
import com.carrotsearch.hppcrt.ByteLookupContainer;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.cursors.ByteIntCursor;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ByteIntPredicate;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.ByteIntProcedure;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.procedures.IntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteIntHashMap
implements ByteIntMap,
Cloneable {
    protected int defaultValue = 0;
    public byte[] keys;
    public int[] values;
    public boolean allocatedDefaultKey = false;
    public int allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ByteIntCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ByteIntHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ByteIntHashMap() {
        this(8);
    }

    public ByteIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ByteIntHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ByteIntHashMap(ByteIntAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int put(byte key, int value) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                int previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                int oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ByteIntAssociativeContainer container) {
        return this.putAll((Iterable<? extends ByteIntCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends ByteIntCursor> iterable) {
        int count = this.size();
        for (ByteIntCursor byteIntCursor : iterable) {
            this.put(byteIntCursor.key, byteIntCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(byte key, int value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(byte key, int putValue, int incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public int addTo(byte key, int incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(byte pendingKey, int pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        byte[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        byte key = 0;
        int value = 0;
        int slot = -1;
        byte[] keys2 = this.keys;
        int[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys2[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            byte[] keys2 = new byte[capacity];
            int[] values2 = new int[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int remove(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                int previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                int value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        byte[] keys2 = this.keys;
        int[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            byte existing = keys2[slot];
            int existingValue = values2[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(ByteContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ByteLookupContainer) {
            if (this.allocatedDefaultKey && other.contains((byte)0)) {
                this.allocatedDefaultKey = false;
            }
            byte[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                byte existing = keys2[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (ByteCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0)) {
            this.allocatedDefaultKey = false;
        }
        byte[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            byte existing = keys2[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ByteIntPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        byte[] keys2 = this.keys;
        int[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            byte existing = keys2[i];
            if (existing != 0 && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int get(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        byte[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(byte key) {
        byte existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        byte[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ByteArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        byte[] keys2 = this.keys;
        int[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            byte existing = keys2[i];
            if (existing == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ByteIntHashMap other = (ByteIntHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ByteIntCursor c = (ByteIntCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                int otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ByteIntProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((byte)0, this.allocatedDefaultKeyValue);
        }
        byte[] keys2 = this.keys;
        int[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            byte existing = keys2[i];
            if (existing == 0) continue;
            procedure.apply(existing, values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ByteIntPredicate> T forEach(T predicate) {
        byte existing;
        if (this.allocatedDefaultKey && !predicate.apply((byte)0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        byte[] keys2 = this.keys;
        int[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing, values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ByteIntHashMap clone() {
        ByteIntHashMap cloned = new ByteIntHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ByteIntHashMap from(byte[] keys2, int[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteIntHashMap map = new ByteIntHashMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static ByteIntHashMap from(ByteIntAssociativeContainer container) {
        return new ByteIntHashMap(container);
    }

    public static ByteIntHashMap newInstance() {
        return new ByteIntHashMap();
    }

    public static ByteIntHashMap newInstance(int initialCapacity, double loadFactor) {
        return new ByteIntHashMap(initialCapacity, loadFactor);
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            if (this.cursor.index == ByteIntHashMap.this.values.length + 1) {
                if (ByteIntHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteIntHashMap.this.values.length;
                    this.cursor.value = ByteIntHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ByteIntHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteIntHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteIntHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractIntCollection {
        private final ByteIntHashMap owner;
        protected final IteratorPool<IntCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ByteIntHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ByteIntHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(int value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            byte[] keys2 = this.owner.keys;
            int[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0 || value != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            byte[] keys2 = this.owner.keys;
            int[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0) continue;
                procedure.apply(values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            byte[] keys2 = this.owner.keys;
            int[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == 0 || predicate.apply(values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(int e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            byte[] keys2 = this.owner.keys;
            int[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && e == values2[slot]) {
                    ByteIntHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            byte[] keys2 = this.owner.keys;
            int[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && predicate.apply(values2[slot])) {
                    ByteIntHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            byte[] keys2 = this.owner.keys;
            int[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == 0) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == ByteIntHashMap.this.keys.length + 1) {
                if (ByteIntHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteIntHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ByteIntHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteIntHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteIntHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteIntHashMap owner;
        protected final IteratorPool<ByteCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ByteIntHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ByteIntHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(byte e) {
            return ByteIntHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply((byte)0);
            }
            byte[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                byte existing = keys2[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            byte existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply((byte)0)) {
                return predicate;
            }
            byte[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public byte[] toArray(byte[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            byte[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                byte existing = keys2[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ByteIntCursor> {
        public final ByteIntCursor cursor = new ByteIntCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteIntCursor fetch() {
            int i;
            if (this.cursor.index == ByteIntHashMap.this.keys.length + 1) {
                if (ByteIntHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ByteIntHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = ByteIntHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ByteIntHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteIntHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ByteIntHashMap.this.keys[i];
            this.cursor.value = ByteIntHashMap.this.values[i];
            return this.cursor;
        }
    }
}

