/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractCharCollection;
import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.FloatArrays;
import com.carrotsearch.hppcrt.FloatCharAssociativeContainer;
import com.carrotsearch.hppcrt.FloatCharMap;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatLookupContainer;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.cursors.FloatCharCursor;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.CharPredicate;
import com.carrotsearch.hppcrt.predicates.FloatCharPredicate;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.CharProcedure;
import com.carrotsearch.hppcrt.procedures.FloatCharProcedure;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatCharHashMap
implements FloatCharMap,
Cloneable {
    protected char defaultValue = '\u0000';
    public float[] keys;
    public char[] values;
    public boolean allocatedDefaultKey = false;
    public char allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<FloatCharCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = FloatCharHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public FloatCharHashMap() {
        this(8);
    }

    public FloatCharHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public FloatCharHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public FloatCharHashMap(FloatCharAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public char put(float key, char value) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                char previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                char oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(FloatCharAssociativeContainer container) {
        return this.putAll((Iterable<? extends FloatCharCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends FloatCharCursor> iterable) {
        int count = this.size();
        for (FloatCharCursor floatCharCursor : iterable) {
            this.put(floatCharCursor.key, floatCharCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(float key, char value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(float key, char putValue, char incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (char)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public char addTo(float key, char incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(float pendingKey, char pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Float.floatToIntBits(pendingKey) != 0);
        float[] oldKeys = this.keys;
        char[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        float key = 0.0f;
        char value = '\u0000';
        int slot = -1;
        float[] keys2 = this.keys;
        char[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Float.floatToIntBits(key) == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (Float.floatToIntBits(keys2[slot]) != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            float[] keys2 = new float[capacity];
            char[] values2 = new char[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public char remove(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                char previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                char value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        char[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            float existing = keys2[slot];
            char existingValue = values2[slot];
            if (Float.floatToIntBits(existing) == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0.0f;
        --this.assigned;
    }

    @Override
    public int removeAll(FloatContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof FloatLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0.0f)) {
                this.allocatedDefaultKey = false;
            }
            float[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                float existing = keys2[i];
                if (Float.floatToIntBits(existing) != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (FloatCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatCharPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys2 = this.keys;
        char[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public char get(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        FloatArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        float[] keys2 = this.keys;
        char[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FloatCharHashMap other = (FloatCharHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                FloatCharCursor c = (FloatCharCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                char otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends FloatCharProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0f, this.allocatedDefaultKeyValue);
        }
        float[] keys2 = this.keys;
        char[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            procedure.apply(existing, values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends FloatCharPredicate> T forEach(T predicate) {
        float existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0f, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        float[] keys2 = this.keys;
        char[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys2[i]) == 0 || predicate.apply(existing, values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public FloatCharHashMap clone() {
        FloatCharHashMap cloned = new FloatCharHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (FloatCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static FloatCharHashMap from(float[] keys2, char[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatCharHashMap map = new FloatCharHashMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static FloatCharHashMap from(FloatCharAssociativeContainer container) {
        return new FloatCharHashMap(container);
    }

    public static FloatCharHashMap newInstance() {
        return new FloatCharHashMap();
    }

    public static FloatCharHashMap newInstance(int initialCapacity, double loadFactor) {
        return new FloatCharHashMap(initialCapacity, loadFactor);
    }

    @Override
    public char getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(char defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        public final CharCursor cursor = new CharCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            if (this.cursor.index == FloatCharHashMap.this.values.length + 1) {
                if (FloatCharHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatCharHashMap.this.values.length;
                    this.cursor.value = FloatCharHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = FloatCharHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatCharHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatCharHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractCharCollection {
        private final FloatCharHashMap owner;
        protected final IteratorPool<CharCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = FloatCharHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = FloatCharHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(char value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            float[] keys2 = this.owner.keys;
            char[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (Float.floatToIntBits(keys2[slot]) == 0 || value != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            float[] keys2 = this.owner.keys;
            char[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (Float.floatToIntBits(keys2[slot]) == 0) continue;
                procedure.apply(values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            float[] keys2 = this.owner.keys;
            char[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (Float.floatToIntBits(keys2[slot]) == 0 || predicate.apply(values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(char e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            float[] keys2 = this.owner.keys;
            char[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (Float.floatToIntBits(keys2[slot]) != 0 && e == values2[slot]) {
                    FloatCharHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            float[] keys2 = this.owner.keys;
            char[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (Float.floatToIntBits(keys2[slot]) != 0 && predicate.apply(values2[slot])) {
                    FloatCharHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public char[] toArray(char[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            float[] keys2 = this.owner.keys;
            char[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (Float.floatToIntBits(keys2[i]) == 0) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == FloatCharHashMap.this.keys.length + 1) {
                if (FloatCharHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatCharHashMap.this.keys.length;
                    this.cursor.value = 0.0f;
                    return this.cursor;
                }
                this.cursor.index = FloatCharHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatCharHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatCharHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractFloatCollection
    implements FloatLookupContainer {
        private final FloatCharHashMap owner;
        protected final IteratorPool<FloatCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = FloatCharHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = FloatCharHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(float e) {
            return FloatCharHashMap.this.containsKey(e);
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0.0f);
            }
            float[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                float existing = keys2[i];
                if (Float.floatToIntBits(existing) == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            float existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0.0f)) {
                return predicate;
            }
            float[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys2[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(float e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0.0f;
            }
            float[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                float existing = keys2[i];
                if (Float.floatToIntBits(existing) == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<FloatCharCursor> {
        public final FloatCharCursor cursor = new FloatCharCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCharCursor fetch() {
            int i;
            if (this.cursor.index == FloatCharHashMap.this.keys.length + 1) {
                if (FloatCharHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = FloatCharHashMap.this.keys.length;
                    this.cursor.key = 0.0f;
                    this.cursor.value = FloatCharHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = FloatCharHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatCharHashMap.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatCharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = FloatCharHashMap.this.keys[i];
            this.cursor.value = FloatCharHashMap.this.values[i];
            return this.cursor;
        }
    }
}

