/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IntArrays;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IntObjectAssociativeContainer;
import com.carrotsearch.hppcrt.IntObjectMap;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.IntObjectCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.IntObjectPredicate;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.IntObjectProcedure;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntObjectHashMap<VType>
implements IntObjectMap<VType>,
Cloneable {
    protected VType defaultValue = null;
    public int[] keys;
    public Object[] values;
    public boolean allocatedDefaultKey = false;
    public VType allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<IntObjectCursor<VType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = IntObjectHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.value = null;
        }
    });

    public IntObjectHashMap() {
        this(8);
    }

    public IntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public IntObjectHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public IntObjectHashMap(IntObjectAssociativeContainer<VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public VType put(int key, VType value) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                VType previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                Object oldValue = this.values[slot];
                this.values[slot] = value;
                return (VType)oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(IntObjectAssociativeContainer<? extends VType> container) {
        return this.putAll((Iterable<? extends IntObjectCursor<? extends VType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends IntObjectCursor<? extends VType>> iterable) {
        int count = this.size();
        for (IntObjectCursor<VType> intObjectCursor : iterable) {
            this.put(intObjectCursor.key, intObjectCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(int key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndPut(int pendingKey, VType pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        int[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        int key = 0;
        Object value = null;
        int slot = -1;
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys2[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            int[] keys2 = new int[capacity];
            Object[] values2 = new Object[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public VType remove(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                VType previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = null;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                Object value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            int existing = keys2[slot];
            Object existingValue = values2[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0;
        values2[gapSlot] = null;
        --this.assigned;
    }

    @Override
    public int removeAll(IntContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof IntLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0)) {
                this.allocatedDefaultKey = false;
                this.allocatedDefaultKeyValue = null;
            }
            int[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                int existing = keys2[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (IntCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0)) {
            this.allocatedDefaultKey = false;
            this.allocatedDefaultKeyValue = null;
        }
        int[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            int existing = keys2[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntObjectPredicate<? super VType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
            this.allocatedDefaultKeyValue = null;
        }
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            int existing = keys2[i];
            if (existing != 0 && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public VType get(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        int[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        this.allocatedDefaultKeyValue = null;
        IntArrays.blankArray(this.keys, 0, this.keys.length);
        ObjectArrays.blankArray(this.values, 0, this.values.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            int existing = keys2[i];
            if (existing == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            IntObjectHashMap other = (IntObjectHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                IntObjectCursor c = (IntObjectCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                VType otherValue = other.get(c.key);
                if (c.value != null ? c.value.equals(otherValue) : otherValue == null) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends IntObjectProcedure<? super VType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0, this.allocatedDefaultKeyValue);
        }
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            int existing = keys2[i];
            if (existing == 0) continue;
            procedure.apply(existing, (Object)values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends IntObjectPredicate<? super VType>> T forEach(T predicate) {
        int existing;
        if (this.allocatedDefaultKey && !predicate.apply(0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing, (Object)values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public IntObjectHashMap<VType> clone() {
        IntObjectHashMap<VType> cloned = new IntObjectHashMap<VType>(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntObjectCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> IntObjectHashMap<VType> from(int[] keys2, VType[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntObjectHashMap<VType> map = new IntObjectHashMap<VType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static <VType> IntObjectHashMap<VType> from(IntObjectAssociativeContainer<VType> container) {
        return new IntObjectHashMap<VType>(container);
    }

    public static <VType> IntObjectHashMap<VType> newInstance() {
        return new IntObjectHashMap<VType>();
    }

    public static <VType> IntObjectHashMap<VType> newInstance(int initialCapacity, double loadFactor) {
        return new IntObjectHashMap<VType>(initialCapacity, loadFactor);
    }

    @Override
    public VType getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(VType defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        public final ObjectCursor<VType> cursor = new ObjectCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int i;
            if (this.cursor.index == IntObjectHashMap.this.values.length + 1) {
                if (IntObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntObjectHashMap.this.values.length;
                    this.cursor.value = IntObjectHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = IntObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntObjectHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntObjectHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractObjectCollection<VType> {
        private final IntObjectHashMap<VType> owner;
        protected final IteratorPool<ObjectCursor<VType>, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = IntObjectHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = IntObjectHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(VType value) {
            if (this.owner.allocatedDefaultKey && (value == null ? this.owner.allocatedDefaultKeyValue == null : value.equals(this.owner.allocatedDefaultKeyValue))) {
                return true;
            }
            int[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0 || !(value == null ? values2[slot] == null : value.equals(values2[slot]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            int[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0) continue;
                procedure.apply((Object)values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            int[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == 0 || predicate.apply((Object)values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(VType e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && (e == null ? this.owner.allocatedDefaultKeyValue == null : e.equals(this.owner.allocatedDefaultKeyValue))) {
                this.owner.allocatedDefaultKey = false;
                this.owner.allocatedDefaultKeyValue = null;
            }
            int[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && (e == null ? values2[slot] == null : e.equals(values2[slot]))) {
                    IntObjectHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
                this.owner.allocatedDefaultKeyValue = null;
            }
            int[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && predicate.apply(values2[slot])) {
                    IntObjectHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public VType[] toArray(VType[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            int[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == 0) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            if (this.cursor.index == IntObjectHashMap.this.keys.length + 1) {
                if (IntObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntObjectHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = IntObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntObjectHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntObjectHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntObjectHashMap<VType> owner;
        protected final IteratorPool<IntCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = IntObjectHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = IntObjectHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(int e) {
            return IntObjectHashMap.this.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0);
            }
            int[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                int existing = keys2[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0)) {
                return predicate;
            }
            int[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            int[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                int existing = keys2[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntObjectCursor<VType>> {
        public final IntObjectCursor<VType> cursor = new IntObjectCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntObjectCursor<VType> fetch() {
            int i;
            if (this.cursor.index == IntObjectHashMap.this.keys.length + 1) {
                if (IntObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntObjectHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = IntObjectHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = IntObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntObjectHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = IntObjectHashMap.this.keys[i];
            this.cursor.value = IntObjectHashMap.this.values[i];
            return this.cursor;
        }
    }
}

