/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongArrays;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongLookupContainer;
import com.carrotsearch.hppcrt.LongObjectAssociativeContainer;
import com.carrotsearch.hppcrt.LongObjectMap;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.cursors.LongObjectCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.LongObjectPredicate;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.LongObjectProcedure;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongObjectHashMap<VType>
implements LongObjectMap<VType>,
Cloneable {
    protected VType defaultValue = null;
    public long[] keys;
    public Object[] values;
    public boolean allocatedDefaultKey = false;
    public VType allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<LongObjectCursor<VType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = LongObjectHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.value = null;
        }
    });

    public LongObjectHashMap() {
        this(8);
    }

    public LongObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public LongObjectHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public LongObjectHashMap(LongObjectAssociativeContainer<VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public VType put(long key, VType value) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                VType previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                Object oldValue = this.values[slot];
                this.values[slot] = value;
                return (VType)oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(LongObjectAssociativeContainer<? extends VType> container) {
        return this.putAll((Iterable<? extends LongObjectCursor<? extends VType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends LongObjectCursor<? extends VType>> iterable) {
        int count = this.size();
        for (LongObjectCursor<VType> longObjectCursor : iterable) {
            this.put(longObjectCursor.key, longObjectCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(long key, VType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    private void expandAndPut(long pendingKey, VType pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0L);
        long[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        long key = 0L;
        Object value = null;
        int slot = -1;
        long[] keys2 = this.keys;
        Object[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0L) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys2[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            long[] keys2 = new long[capacity];
            Object[] values2 = new Object[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public VType remove(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                VType previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = null;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                Object value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        Object[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            long existing = keys2[slot];
            Object existingValue = values2[slot];
            if (existing == 0L) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0L;
        values2[gapSlot] = null;
        --this.assigned;
    }

    @Override
    public int removeAll(LongContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof LongLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0L)) {
                this.allocatedDefaultKey = false;
                this.allocatedDefaultKeyValue = null;
            }
            long[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                long existing = keys2[i];
                if (existing != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L)) {
            this.allocatedDefaultKey = false;
            this.allocatedDefaultKeyValue = null;
        }
        long[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            long existing = keys2[i];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongObjectPredicate<? super VType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
            this.allocatedDefaultKeyValue = null;
        }
        long[] keys2 = this.keys;
        Object[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            long existing = keys2[i];
            if (existing != 0L && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public VType get(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        this.allocatedDefaultKeyValue = null;
        LongArrays.blankArray(this.keys, 0, this.keys.length);
        ObjectArrays.blankArray(this.values, 0, this.values.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        long[] keys2 = this.keys;
        Object[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            long existing = keys2[i];
            if (existing == 0L) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LongObjectHashMap other = (LongObjectHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                LongObjectCursor c = (LongObjectCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                VType otherValue = other.get(c.key);
                if (c.value != null ? c.value.equals(otherValue) : otherValue == null) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends LongObjectProcedure<? super VType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0L, this.allocatedDefaultKeyValue);
        }
        long[] keys2 = this.keys;
        Object[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            long existing = keys2[i];
            if (existing == 0L) continue;
            procedure.apply(existing, (Object)values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends LongObjectPredicate<? super VType>> T forEach(T predicate) {
        long existing;
        if (this.allocatedDefaultKey && !predicate.apply(0L, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        long[] keys2 = this.keys;
        Object[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0L || predicate.apply(existing, (Object)values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public LongObjectHashMap<VType> clone() {
        LongObjectHashMap<VType> cloned = new LongObjectHashMap<VType>(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongObjectCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <VType> LongObjectHashMap<VType> from(long[] keys2, VType[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongObjectHashMap<VType> map = new LongObjectHashMap<VType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static <VType> LongObjectHashMap<VType> from(LongObjectAssociativeContainer<VType> container) {
        return new LongObjectHashMap<VType>(container);
    }

    public static <VType> LongObjectHashMap<VType> newInstance() {
        return new LongObjectHashMap<VType>();
    }

    public static <VType> LongObjectHashMap<VType> newInstance(int initialCapacity, double loadFactor) {
        return new LongObjectHashMap<VType>(initialCapacity, loadFactor);
    }

    @Override
    public VType getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(VType defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        public final ObjectCursor<VType> cursor = new ObjectCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int i;
            if (this.cursor.index == LongObjectHashMap.this.values.length + 1) {
                if (LongObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongObjectHashMap.this.values.length;
                    this.cursor.value = LongObjectHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = LongObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongObjectHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongObjectHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractObjectCollection<VType> {
        private final LongObjectHashMap<VType> owner;
        protected final IteratorPool<ObjectCursor<VType>, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = LongObjectHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = LongObjectHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(VType value) {
            if (this.owner.allocatedDefaultKey && (value == null ? this.owner.allocatedDefaultKeyValue == null : value.equals(this.owner.allocatedDefaultKeyValue))) {
                return true;
            }
            long[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0L || !(value == null ? values2[slot] == null : value.equals(values2[slot]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            long[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0L) continue;
                procedure.apply((Object)values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            long[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == 0L || predicate.apply((Object)values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(VType e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && (e == null ? this.owner.allocatedDefaultKeyValue == null : e.equals(this.owner.allocatedDefaultKeyValue))) {
                this.owner.allocatedDefaultKey = false;
                this.owner.allocatedDefaultKeyValue = null;
            }
            long[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0L && (e == null ? values2[slot] == null : e.equals(values2[slot]))) {
                    LongObjectHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
                this.owner.allocatedDefaultKeyValue = null;
            }
            long[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0L && predicate.apply(values2[slot])) {
                    LongObjectHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public VType[] toArray(VType[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            long[] keys2 = this.owner.keys;
            Object[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == 0L) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == LongObjectHashMap.this.keys.length + 1) {
                if (LongObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongObjectHashMap.this.keys.length;
                    this.cursor.value = 0L;
                    return this.cursor;
                }
                this.cursor.index = LongObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongObjectHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongObjectHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongObjectHashMap<VType> owner;
        protected final IteratorPool<LongCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = LongObjectHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = LongObjectHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(long e) {
            return LongObjectHashMap.this.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0L);
            }
            long[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                long existing = keys2[i];
                if (existing == 0L) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            long existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0L)) {
                return predicate;
            }
            long[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0L || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public long[] toArray(long[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0L;
            }
            long[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                long existing = keys2[i];
                if (existing == 0L) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        public final LongObjectCursor<VType> cursor = new LongObjectCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongObjectCursor<VType> fetch() {
            int i;
            if (this.cursor.index == LongObjectHashMap.this.keys.length + 1) {
                if (LongObjectHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongObjectHashMap.this.keys.length;
                    this.cursor.key = 0L;
                    this.cursor.value = LongObjectHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = LongObjectHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongObjectHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = LongObjectHashMap.this.keys[i];
            this.cursor.value = LongObjectHashMap.this.values[i];
            return this.cursor;
        }
    }
}

