/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongArrays;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongLookupContainer;
import com.carrotsearch.hppcrt.LongShortAssociativeContainer;
import com.carrotsearch.hppcrt.LongShortMap;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.cursors.LongShortCursor;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.predicates.LongShortPredicate;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.procedures.LongShortProcedure;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongShortHashMap
implements LongShortMap,
Cloneable {
    protected short defaultValue = 0;
    public long[] keys;
    public short[] values;
    public boolean allocatedDefaultKey = false;
    public short allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<LongShortCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = LongShortHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public LongShortHashMap() {
        this(8);
    }

    public LongShortHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public LongShortHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public LongShortHashMap(LongShortAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public short put(long key, short value) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                short previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                short oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(LongShortAssociativeContainer container) {
        return this.putAll((Iterable<? extends LongShortCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends LongShortCursor> iterable) {
        int count = this.size();
        for (LongShortCursor longShortCursor : iterable) {
            this.put(longShortCursor.key, longShortCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(long key, short value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(long key, short putValue, short incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (short)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public short addTo(long key, short incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(long pendingKey, short pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0L);
        long[] oldKeys = this.keys;
        short[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        long key = 0L;
        short value = 0;
        int slot = -1;
        long[] keys2 = this.keys;
        short[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0L) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys2[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            long[] keys2 = new long[capacity];
            short[] values2 = new short[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public short remove(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                short previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                short value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        short[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            long existing = keys2[slot];
            short existingValue = values2[slot];
            if (existing == 0L) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0L;
        --this.assigned;
    }

    @Override
    public int removeAll(LongContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof LongLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0L)) {
                this.allocatedDefaultKey = false;
            }
            long[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                long existing = keys2[i];
                if (existing != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L)) {
            this.allocatedDefaultKey = false;
        }
        long[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            long existing = keys2[i];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongShortPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0L, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        long[] keys2 = this.keys;
        short[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            long existing = keys2[i];
            if (existing != 0L && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public short get(long key) {
        long existing;
        if (key == 0L) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        long[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0L) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        LongArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        long[] keys2 = this.keys;
        short[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            long existing = keys2[i];
            if (existing == 0L) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            LongShortHashMap other = (LongShortHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                LongShortCursor c = (LongShortCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                short otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends LongShortProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0L, this.allocatedDefaultKeyValue);
        }
        long[] keys2 = this.keys;
        short[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            long existing = keys2[i];
            if (existing == 0L) continue;
            procedure.apply(existing, values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends LongShortPredicate> T forEach(T predicate) {
        long existing;
        if (this.allocatedDefaultKey && !predicate.apply(0L, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        long[] keys2 = this.keys;
        short[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0L || predicate.apply(existing, values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public LongShortHashMap clone() {
        LongShortHashMap cloned = new LongShortHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongShortCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static LongShortHashMap from(long[] keys2, short[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongShortHashMap map = new LongShortHashMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static LongShortHashMap from(LongShortAssociativeContainer container) {
        return new LongShortHashMap(container);
    }

    public static LongShortHashMap newInstance() {
        return new LongShortHashMap();
    }

    public static LongShortHashMap newInstance(int initialCapacity, double loadFactor) {
        return new LongShortHashMap(initialCapacity, loadFactor);
    }

    @Override
    public short getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(short defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            if (this.cursor.index == LongShortHashMap.this.values.length + 1) {
                if (LongShortHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongShortHashMap.this.values.length;
                    this.cursor.value = LongShortHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = LongShortHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongShortHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongShortHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractShortCollection {
        private final LongShortHashMap owner;
        protected final IteratorPool<ShortCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = LongShortHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = LongShortHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(short value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            long[] keys2 = this.owner.keys;
            short[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0L || value != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            long[] keys2 = this.owner.keys;
            short[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0L) continue;
                procedure.apply(values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            long[] keys2 = this.owner.keys;
            short[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == 0L || predicate.apply(values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(short e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            long[] keys2 = this.owner.keys;
            short[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0L && e == values2[slot]) {
                    LongShortHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            long[] keys2 = this.owner.keys;
            short[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0L && predicate.apply(values2[slot])) {
                    LongShortHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public short[] toArray(short[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            long[] keys2 = this.owner.keys;
            short[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == 0L) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == LongShortHashMap.this.keys.length + 1) {
                if (LongShortHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongShortHashMap.this.keys.length;
                    this.cursor.value = 0L;
                    return this.cursor;
                }
                this.cursor.index = LongShortHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongShortHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = LongShortHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongShortHashMap owner;
        protected final IteratorPool<LongCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = LongShortHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = LongShortHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(long e) {
            return LongShortHashMap.this.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0L);
            }
            long[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                long existing = keys2[i];
                if (existing == 0L) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            long existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0L)) {
                return predicate;
            }
            long[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0L || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public long[] toArray(long[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0L;
            }
            long[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                long existing = keys2[i];
                if (existing == 0L) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<LongShortCursor> {
        public final LongShortCursor cursor = new LongShortCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongShortCursor fetch() {
            int i;
            if (this.cursor.index == LongShortHashMap.this.keys.length + 1) {
                if (LongShortHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = LongShortHashMap.this.keys.length;
                    this.cursor.key = 0L;
                    this.cursor.value = LongShortHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = LongShortHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && LongShortHashMap.this.keys[i] == 0L; --i) {
            }
            if (i == -1) {
                return (LongShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = LongShortHashMap.this.keys[i];
            this.cursor.value = LongShortHashMap.this.values[i];
            return this.cursor;
        }
    }
}

