/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectByteAssociativeContainer;
import com.carrotsearch.hppcrt.ObjectByteMap;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectLookupContainer;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.cursors.ObjectByteCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.predicates.ObjectBytePredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectByteProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectByteHashMap<KType>
implements ObjectByteMap<KType>,
Cloneable {
    protected byte defaultValue = 0;
    public Object[] keys;
    public byte[] values;
    protected int[] hash_cache;
    public boolean allocatedDefaultKey = false;
    public byte allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ObjectByteCursor<KType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ObjectByteHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.key = null;
        }
    });

    protected int hashKey(KType key) {
        return key.hashCode();
    }

    protected boolean equalKeys(KType a, KType b) {
        return a.equals(b);
    }

    public ObjectByteHashMap() {
        this(8);
    }

    public ObjectByteHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ObjectByteHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ObjectByteHashMap(ObjectByteAssociativeContainer<KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(KType key, byte value) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                byte previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        byte[] values2 = this.values;
        int[] cached = this.hash_cache;
        int initial_slot = slot;
        int dist = 0;
        int existing_distance = 0;
        while ((existing = keys2[slot]) != null) {
            existing_distance = this.probe_distance(slot, cached);
            if (dist <= existing_distance && this.equalKeys(key, existing)) {
                byte oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            if (dist > existing_distance) {
                Object tmpKey = keys2[slot];
                keys2[slot] = key;
                key = tmpKey;
                int tmpAllocated = cached[slot];
                cached[slot] = initial_slot;
                initial_slot = tmpAllocated;
                byte tmpValue = values2[slot];
                values2[slot] = value;
                value = tmpValue;
                dist = existing_distance;
            }
            slot = slot + 1 & mask;
            ++dist;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            cached[slot] = initial_slot;
            keys2[slot] = key;
            values2[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ObjectByteAssociativeContainer<? extends KType> container) {
        return this.putAll((Iterable<? extends ObjectByteCursor<? extends KType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends ObjectByteCursor<? extends KType>> iterable) {
        int count = this.size();
        for (ObjectByteCursor<KType> objectByteCursor : iterable) {
            this.put(objectByteCursor.key, objectByteCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(KType key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(KType key, byte putValue, byte incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (byte)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public byte addTo(KType key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(KType pendingKey, byte pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != null);
        Object[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        Object key = null;
        byte value = 0;
        int slot = -1;
        Object[] keys2 = this.keys;
        byte[] values2 = this.values;
        int[] cached = this.hash_cache;
        Object tmpKey = null;
        byte tmpValue = 0;
        int tmpAllocated = -1;
        int initial_slot = -1;
        int dist = -1;
        int existing_distance = -1;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == null) continue;
            value = oldValues[i];
            initial_slot = slot = BitMixer.mix(this.hashKey(key), perturb) & mask;
            dist = 0;
            while (keys2[slot] != null) {
                existing_distance = this.probe_distance(slot, cached);
                if (dist > existing_distance) {
                    tmpKey = keys2[slot];
                    keys2[slot] = key;
                    key = tmpKey;
                    tmpAllocated = cached[slot];
                    cached[slot] = initial_slot;
                    initial_slot = tmpAllocated;
                    tmpValue = values2[slot];
                    values2[slot] = value;
                    value = tmpValue;
                    dist = existing_distance;
                }
                slot = slot + 1 & mask;
                ++dist;
            }
            cached[slot] = initial_slot;
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            Object[] keys2 = new Object[capacity];
            byte[] values2 = new byte[capacity];
            int[] cached = new int[capacity];
            this.keys = keys2;
            this.values = values2;
            this.hash_cache = cached;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public byte remove(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                byte previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys2[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                byte value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        byte[] values2 = this.values;
        int[] cached = this.hash_cache;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            Object existing = keys2[slot];
            byte existingValue = values2[slot];
            if (existing == null) break;
            int idealSlotModMask = cached[slot];
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            cached[gapSlot] = idealSlotModMask;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = null;
        --this.assigned;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.allocatedDefaultKey && other.contains(null)) {
                this.allocatedDefaultKey = false;
            }
            Object[] keys2 = this.keys;
            boolean bl = false;
            while (var4_6 < keys2.length) {
                Object existing = keys2[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            Object existing = keys2[i];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectBytePredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys2 = this.keys;
        byte[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            Object existing = keys2[i];
            if (existing != null && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public byte get(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys2[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(KType key) {
        Object existing;
        if (key == null) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys2[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ObjectArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        Object[] keys2 = this.keys;
        byte[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            Object existing = keys2[i];
            if (existing == null) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ObjectByteHashMap other = (ObjectByteHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ObjectByteCursor c = (ObjectByteCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                byte otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectByteProcedure<? super KType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(null, this.allocatedDefaultKeyValue);
        }
        Object[] keys2 = this.keys;
        byte[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            Object existing = keys2[i];
            if (existing == null) continue;
            procedure.apply((Object)existing, values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectBytePredicate<? super KType>> T forEach(T predicate) {
        Object existing;
        if (this.allocatedDefaultKey && !predicate.apply(null, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        Object[] keys2 = this.keys;
        byte[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == null || predicate.apply((Object)existing, values2[i])); --i) {
        }
        return predicate;
    }

    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ObjectByteHashMap<KType> clone() {
        ObjectByteHashMap<KType> cloned = new ObjectByteHashMap<KType>(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType> ObjectByteHashMap<KType> from(KType[] keys2, byte[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectByteHashMap<KType> map = new ObjectByteHashMap<KType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static <KType> ObjectByteHashMap<KType> from(ObjectByteAssociativeContainer<KType> container) {
        return new ObjectByteHashMap<KType>(container);
    }

    public static <KType> ObjectByteHashMap<KType> newInstance() {
        return new ObjectByteHashMap<KType>();
    }

    public static <KType> ObjectByteHashMap<KType> newInstance(int initialCapacity, double loadFactor) {
        return new ObjectByteHashMap<KType>(initialCapacity, loadFactor);
    }

    @Override
    public byte getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(byte defaultValue) {
        this.defaultValue = defaultValue;
    }

    private int probe_distance(int slot, int[] cache) {
        int rh = cache[slot];
        if (slot < rh) {
            return slot - rh + cache.length;
        }
        return slot - rh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == ObjectByteHashMap.this.values.length + 1) {
                if (ObjectByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectByteHashMap.this.values.length;
                    this.cursor.value = ObjectByteHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ObjectByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectByteHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectByteHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractByteCollection {
        private final ObjectByteHashMap<KType> owner;
        protected final IteratorPool<ByteCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ObjectByteHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ObjectByteHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(byte value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            Object[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == null || value != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            Object[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == null) continue;
                procedure.apply(values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            Object[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == null || predicate.apply(values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(byte e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            Object[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != null && e == values2[slot]) {
                    ObjectByteHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            Object[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != null && predicate.apply(values2[slot])) {
                    ObjectByteHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public byte[] toArray(byte[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            Object[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == null) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectByteHashMap.this.keys.length + 1) {
                if (ObjectByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectByteHashMap.this.keys.length;
                    this.cursor.value = null;
                    return this.cursor;
                }
                this.cursor.index = ObjectByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectByteHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectByteHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectByteHashMap<KType> owner;
        protected final IteratorPool<ObjectCursor<KType>, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ObjectByteHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ObjectByteHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public boolean contains(KType e) {
            return ObjectByteHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(null);
            }
            Object[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                Object existing = keys2[i];
                if (existing == null) continue;
                procedure.apply((Object)existing);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            Object existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(null)) {
                return predicate;
            }
            Object[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == null || predicate.apply((Object)existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public KType[] toArray(KType[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = null;
            }
            Object[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                Object existing = keys2[i];
                if (existing == null) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ObjectByteCursor<KType>> {
        public final ObjectByteCursor<KType> cursor = new ObjectByteCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectByteCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectByteHashMap.this.keys.length + 1) {
                if (ObjectByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectByteHashMap.this.keys.length;
                    this.cursor.key = null;
                    this.cursor.value = ObjectByteHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ObjectByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectByteHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ObjectByteHashMap.this.keys[i];
            this.cursor.value = ObjectByteHashMap.this.values[i];
            return this.cursor;
        }
    }
}

