/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ShortArrays;
import com.carrotsearch.hppcrt.ShortByteAssociativeContainer;
import com.carrotsearch.hppcrt.ShortByteMap;
import com.carrotsearch.hppcrt.ShortContainer;
import com.carrotsearch.hppcrt.ShortLookupContainer;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.cursors.ShortByteCursor;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.predicates.ShortBytePredicate;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;
import com.carrotsearch.hppcrt.procedures.ShortByteProcedure;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortByteHashMap
implements ShortByteMap,
Cloneable {
    protected byte defaultValue = 0;
    public short[] keys;
    public byte[] values;
    public boolean allocatedDefaultKey = false;
    public byte allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ShortByteCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ShortByteHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ShortByteHashMap() {
        this(8);
    }

    public ShortByteHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ShortByteHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ShortByteHashMap(ShortByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(short key, byte value) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                byte previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                byte oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ShortByteAssociativeContainer container) {
        return this.putAll((Iterable<? extends ShortByteCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends ShortByteCursor> iterable) {
        int count = this.size();
        for (ShortByteCursor shortByteCursor : iterable) {
            this.put(shortByteCursor.key, shortByteCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(short key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(short key, byte putValue, byte incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (byte)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public byte addTo(short key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(short pendingKey, byte pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        short[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        short key = 0;
        byte value = 0;
        int slot = -1;
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys2[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            short[] keys2 = new short[capacity];
            byte[] values2 = new byte[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public byte remove(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                byte previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                byte value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            short existing = keys2[slot];
            byte existingValue = values2[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(ShortContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ShortLookupContainer) {
            if (this.allocatedDefaultKey && other.contains((short)0)) {
                this.allocatedDefaultKey = false;
            }
            short[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                short existing = keys2[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            short existing = keys2[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortBytePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            short existing = keys2[i];
            if (existing != 0 && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public byte get(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(short key) {
        short existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ShortArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            short existing = keys2[i];
            if (existing == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ShortByteHashMap other = (ShortByteHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ShortByteCursor c = (ShortByteCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                byte otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ShortByteProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((short)0, this.allocatedDefaultKeyValue);
        }
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            short existing = keys2[i];
            if (existing == 0) continue;
            procedure.apply(existing, values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortBytePredicate> T forEach(T predicate) {
        short existing;
        if (this.allocatedDefaultKey && !predicate.apply((short)0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing, values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ShortByteHashMap clone() {
        ShortByteHashMap cloned = new ShortByteHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ShortByteHashMap from(short[] keys2, byte[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortByteHashMap map = new ShortByteHashMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static ShortByteHashMap from(ShortByteAssociativeContainer container) {
        return new ShortByteHashMap(container);
    }

    public static ShortByteHashMap newInstance() {
        return new ShortByteHashMap();
    }

    public static ShortByteHashMap newInstance(int initialCapacity, double loadFactor) {
        return new ShortByteHashMap(initialCapacity, loadFactor);
    }

    @Override
    public byte getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(byte defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == ShortByteHashMap.this.values.length + 1) {
                if (ShortByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortByteHashMap.this.values.length;
                    this.cursor.value = ShortByteHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ShortByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortByteHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortByteHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractByteCollection {
        private final ShortByteHashMap owner;
        protected final IteratorPool<ByteCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ShortByteHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ShortByteHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(byte value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            short[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0 || value != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            short[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0) continue;
                procedure.apply(values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            short[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == 0 || predicate.apply(values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(byte e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            short[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && e == values2[slot]) {
                    ShortByteHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            short[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && predicate.apply(values2[slot])) {
                    ShortByteHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public byte[] toArray(byte[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            short[] keys2 = this.owner.keys;
            byte[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == 0) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            if (this.cursor.index == ShortByteHashMap.this.keys.length + 1) {
                if (ShortByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortByteHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ShortByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortByteHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortByteHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortByteHashMap owner;
        protected final IteratorPool<ShortCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ShortByteHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ShortByteHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(short e) {
            return ShortByteHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply((short)0);
            }
            short[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                short existing = keys2[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply((short)0)) {
                return predicate;
            }
            short[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public short[] toArray(short[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            short[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                short existing = keys2[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ShortByteCursor> {
        public final ShortByteCursor cursor = new ShortByteCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortByteCursor fetch() {
            int i;
            if (this.cursor.index == ShortByteHashMap.this.keys.length + 1) {
                if (ShortByteHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortByteHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = ShortByteHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ShortByteHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortByteHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ShortByteHashMap.this.keys[i];
            this.cursor.value = ShortByteHashMap.this.values[i];
            return this.cursor;
        }
    }
}

