/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ShortArrays;
import com.carrotsearch.hppcrt.ShortContainer;
import com.carrotsearch.hppcrt.ShortLongAssociativeContainer;
import com.carrotsearch.hppcrt.ShortLongMap;
import com.carrotsearch.hppcrt.ShortLookupContainer;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.cursors.ShortLongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.predicates.ShortLongPredicate;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.procedures.ShortLongProcedure;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortLongHashMap
implements ShortLongMap,
Cloneable {
    protected long defaultValue = 0L;
    public short[] keys;
    public long[] values;
    public boolean allocatedDefaultKey = false;
    public long allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ShortLongCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ShortLongHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ShortLongHashMap() {
        this(8);
    }

    public ShortLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ShortLongHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ShortLongHashMap(ShortLongAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public long put(short key, long value) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                long previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                long oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ShortLongAssociativeContainer container) {
        return this.putAll((Iterable<? extends ShortLongCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends ShortLongCursor> iterable) {
        int count = this.size();
        for (ShortLongCursor shortLongCursor : iterable) {
            this.put(shortLongCursor.key, shortLongCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(short key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(short key, long putValue, long incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public long addTo(short key, long incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(short pendingKey, long pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        short[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        short key = 0;
        long value = 0L;
        int slot = -1;
        short[] keys2 = this.keys;
        long[] values2 = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys2[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
            values2[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            short[] keys2 = new short[capacity];
            long[] values2 = new long[capacity];
            this.keys = keys2;
            this.values = values2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public long remove(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                long previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                long value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        long[] values2 = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            short existing = keys2[slot];
            long existingValue = values2[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(ShortContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ShortLookupContainer) {
            if (this.allocatedDefaultKey && other.contains((short)0)) {
                this.allocatedDefaultKey = false;
            }
            short[] keys2 = this.keys;
            int i = 0;
            while (i < keys2.length) {
                short existing = keys2[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            short existing = keys2[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortLongPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys2 = this.keys;
        long[] values2 = this.values;
        int i = 0;
        while (i < keys2.length) {
            short existing = keys2[i];
            if (existing != 0 && predicate.apply(existing, values2[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public long get(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(short key) {
        short existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        short[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ShortArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        short[] keys2 = this.keys;
        long[] values2 = this.values;
        int i = keys2.length;
        while (--i >= 0) {
            short existing = keys2[i];
            if (existing == 0) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values2[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ShortLongHashMap other = (ShortLongHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ShortLongCursor c = (ShortLongCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                long otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ShortLongProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((short)0, this.allocatedDefaultKeyValue);
        }
        short[] keys2 = this.keys;
        long[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0; --i) {
            short existing = keys2[i];
            if (existing == 0) continue;
            procedure.apply(existing, values2[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortLongPredicate> T forEach(T predicate) {
        short existing;
        if (this.allocatedDefaultKey && !predicate.apply((short)0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        short[] keys2 = this.keys;
        long[] values2 = this.values;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing, values2[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ShortLongHashMap clone() {
        ShortLongHashMap cloned = new ShortLongHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ShortLongHashMap from(short[] keys2, long[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortLongHashMap map = new ShortLongHashMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    public static ShortLongHashMap from(ShortLongAssociativeContainer container) {
        return new ShortLongHashMap(container);
    }

    public static ShortLongHashMap newInstance() {
        return new ShortLongHashMap();
    }

    public static ShortLongHashMap newInstance(int initialCapacity, double loadFactor) {
        return new ShortLongHashMap(initialCapacity, loadFactor);
    }

    @Override
    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == ShortLongHashMap.this.values.length + 1) {
                if (ShortLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortLongHashMap.this.values.length;
                    this.cursor.value = ShortLongHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ShortLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortLongHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortLongHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractLongCollection {
        private final ShortLongHashMap owner;
        protected final IteratorPool<LongCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ShortLongHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ShortLongHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(long value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            short[] keys2 = this.owner.keys;
            long[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0 || value != values2[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            short[] keys2 = this.owner.keys;
            long[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length; ++slot) {
                if (keys2[slot] == 0) continue;
                procedure.apply(values2[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            short[] keys2 = this.owner.keys;
            long[] values2 = this.owner.values;
            for (int slot = 0; slot < keys2.length && (keys2[slot] == 0 || predicate.apply(values2[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(long e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            short[] keys2 = this.owner.keys;
            long[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && e == values2[slot]) {
                    ShortLongHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            short[] keys2 = this.owner.keys;
            long[] values2 = this.owner.values;
            int slot = 0;
            while (slot < keys2.length) {
                if (keys2[slot] != 0 && predicate.apply(values2[slot])) {
                    ShortLongHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public long[] toArray(long[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            short[] keys2 = this.owner.keys;
            long[] values2 = this.owner.values;
            for (int i = 0; i < values2.length; ++i) {
                if (keys2[i] == 0) continue;
                target[count++] = values2[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            if (this.cursor.index == ShortLongHashMap.this.keys.length + 1) {
                if (ShortLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortLongHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ShortLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortLongHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortLongHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortLongHashMap owner;
        protected final IteratorPool<ShortCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ShortLongHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ShortLongHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(short e) {
            return ShortLongHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply((short)0);
            }
            short[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0; --i) {
                short existing = keys2[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            short existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply((short)0)) {
                return predicate;
            }
            short[] keys2 = this.owner.keys;
            for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public short[] toArray(short[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            short[] keys2 = this.owner.keys;
            for (int i = 0; i < keys2.length; ++i) {
                short existing = keys2[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ShortLongCursor> {
        public final ShortLongCursor cursor = new ShortLongCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortLongCursor fetch() {
            int i;
            if (this.cursor.index == ShortLongHashMap.this.keys.length + 1) {
                if (ShortLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ShortLongHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = ShortLongHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ShortLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortLongHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortLongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ShortLongHashMap.this.keys[i];
            this.cursor.value = ShortLongHashMap.this.values[i];
            return this.cursor;
        }
    }
}

