/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.FloatArrays;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatLookupContainer;
import com.carrotsearch.hppcrt.FloatSet;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatHashSet
extends AbstractFloatCollection
implements FloatLookupContainer,
FloatSet,
Cloneable {
    public float[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<FloatCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = FloatHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public FloatHashSet() {
        this(8, 0.75);
    }

    public FloatHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public FloatHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public FloatHashSet(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys2[slot] = key;
        }
        return true;
    }

    public int add(float e1, float e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(float ... elements) {
        int count = 0;
        for (float e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(FloatContainer container) {
        return this.addAll((Iterable<? extends FloatCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int count = 0;
        for (FloatCursor floatCursor : iterable) {
            if (!this.add(floatCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(float pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Float.floatToIntBits(pendingKey) != 0);
        float[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        float key = 0.0f;
        int slot = -1;
        float[] keys2 = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Float.floatToIntBits(key) == 0) continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (Float.floatToIntBits(keys2[slot]) != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            float[] keys2 = new float[capacity];
            this.keys = keys2;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(float key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        float existing;
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while (Float.floatToIntBits(existing = keys2[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0.0f;
        --this.assigned;
    }

    @Override
    public boolean contains(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        float[] keys2 = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Float.floatToIntBits(existing = keys2[slot]) != 0) {
            if (Float.floatToIntBits(key) == Float.floatToIntBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        FloatArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h2 = 0;
        float[] keys2 = this.keys;
        int i = keys2.length;
        while (--i >= 0) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            h2 += BitMixer.mix(existing);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((FloatCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0f);
        }
        float[] keys2 = this.keys;
        for (int i = keys2.length - 1; i >= 0; --i) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public float[] toArray(float[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = 0.0f;
        }
        float[] keys2 = this.keys;
        for (int i = 0; i < keys2.length; ++i) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public FloatHashSet clone() {
        FloatHashSet cloned = new FloatHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        float existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0f)) {
            return predicate;
        }
        float[] keys2 = this.keys;
        for (int i = keys2.length - 1; i >= 0 && (Float.floatToIntBits(existing = keys2[i]) == 0 || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0f)) {
            this.allocatedDefaultKey = false;
        }
        float[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            float existing = keys2[i];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static FloatHashSet from(float ... elements) {
        FloatHashSet set = new FloatHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static FloatHashSet from(FloatContainer container) {
        return new FloatHashSet(container);
    }

    public static FloatHashSet newInstance() {
        return new FloatHashSet();
    }

    public static FloatHashSet newInstance(int initialCapacity, double loadFactor) {
        return new FloatHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == FloatHashSet.this.keys.length + 1) {
                if (FloatHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = FloatHashSet.this.keys.length;
                    this.cursor.value = 0.0f;
                    return this.cursor;
                }
                this.cursor.index = FloatHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Float.floatToIntBits(FloatHashSet.this.keys[i]) == 0; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = FloatHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

