/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectLookupContainer;
import com.carrotsearch.hppcrt.ObjectSet;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHashSet<KType>
extends AbstractObjectCollection<KType>
implements ObjectLookupContainer<KType>,
ObjectSet<KType>,
Cloneable {
    public Object[] keys;
    protected int[] hash_cache;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ObjectCursor<KType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ObjectHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.value = null;
        }
    });

    protected int hashKey(KType key) {
        return key.hashCode();
    }

    protected boolean equalKeys(KType a, KType b) {
        return a.equals(b);
    }

    public ObjectHashSet() {
        this(8, 0.75);
    }

    public ObjectHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ObjectHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ObjectHashSet(ObjectContainer<KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        int initial_slot = slot;
        int dist = 0;
        int existing_distance = 0;
        while ((existing = keys2[slot]) != null) {
            existing_distance = this.probe_distance(slot, cached);
            if (dist <= existing_distance && this.equalKeys(key, existing)) {
                return false;
            }
            if (dist > existing_distance) {
                Object tmpKey = keys2[slot];
                keys2[slot] = key;
                key = tmpKey;
                int tmpAllocated = cached[slot];
                cached[slot] = initial_slot;
                initial_slot = tmpAllocated;
                dist = existing_distance;
            }
            slot = slot + 1 & mask;
            ++dist;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            cached[slot] = initial_slot;
            keys2[slot] = key;
        }
        return true;
    }

    public int add(KType e1, KType e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(KType ... elements) {
        int count = 0;
        for (KType e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(ObjectContainer<? extends KType> container) {
        return this.addAll((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    @Override
    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int count = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            if (!this.add((KType)objectCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(KType pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != null);
        Object[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        Object key = null;
        int slot = -1;
        Object[] keys2 = this.keys;
        int[] cached = this.hash_cache;
        Object tmpKey = null;
        int tmpAllocated = -1;
        int initial_slot = -1;
        int dist = -1;
        int existing_distance = -1;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == null) continue;
            initial_slot = slot = BitMixer.mix(this.hashKey(key), perturb) & mask;
            dist = 0;
            while (keys2[slot] != null) {
                existing_distance = this.probe_distance(slot, cached);
                if (dist > existing_distance) {
                    tmpKey = keys2[slot];
                    keys2[slot] = key;
                    key = tmpKey;
                    tmpAllocated = cached[slot];
                    cached[slot] = initial_slot;
                    initial_slot = tmpAllocated;
                    dist = existing_distance;
                }
                slot = slot + 1 & mask;
                ++dist;
            }
            cached[slot] = initial_slot;
            keys2[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            Object[] keys2 = new Object[capacity];
            int[] allocated = new int[capacity];
            this.keys = keys2;
            this.hash_cache = allocated;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(KType key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys2[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        Object existing;
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int[] cached = this.hash_cache;
        int distance = 0;
        while ((existing = keys2[slot = gapSlot + ++distance & mask]) != null) {
            int idealSlotModMask = cached[slot];
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            cached[gapSlot] = idealSlotModMask;
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = null;
        --this.assigned;
    }

    @Override
    public boolean contains(KType key) {
        Object existing;
        if (key == null) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        Object[] keys2 = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys2[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ObjectArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h2 = 0;
        Object[] keys2 = this.keys;
        int i = keys2.length;
        while (--i >= 0) {
            Object existing = keys2[i];
            if (existing == null) continue;
            h2 += BitMixer.mix(existing);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ObjectSet other = (ObjectSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((ObjectCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(null);
        }
        Object[] keys2 = this.keys;
        for (int i = keys2.length - 1; i >= 0; --i) {
            Object existing = keys2[i];
            if (existing == null) continue;
            procedure.apply((Object)existing);
        }
        return procedure;
    }

    @Override
    public KType[] toArray(KType[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = null;
        }
        Object[] keys2 = this.keys;
        for (int i = 0; i < keys2.length; ++i) {
            Object existing = keys2[i];
            if (existing == null) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public ObjectHashSet<KType> clone() {
        ObjectHashSet<KType> cloned = new ObjectHashSet<KType>(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        Object existing;
        if (this.allocatedDefaultKey && !predicate.apply(null)) {
            return predicate;
        }
        Object[] keys2 = this.keys;
        for (int i = keys2.length - 1; i >= 0 && ((existing = keys2[i]) == null || predicate.apply((Object)existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys2 = this.keys;
        int i = 0;
        while (i < keys2.length) {
            Object existing = keys2[i];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static <KType> ObjectHashSet<KType> from(KType ... elements) {
        ObjectHashSet<KType> set = new ObjectHashSet<KType>(elements.length);
        set.add(elements);
        return set;
    }

    public static <KType> ObjectHashSet<KType> from(ObjectContainer<KType> container) {
        return new ObjectHashSet<KType>(container);
    }

    public static <KType> ObjectHashSet<KType> newInstance() {
        return new ObjectHashSet<KType>();
    }

    public static <KType> ObjectHashSet<KType> newInstance(int initialCapacity, double loadFactor) {
        return new ObjectHashSet<KType>(initialCapacity, loadFactor);
    }

    private int probe_distance(int slot, int[] cached) {
        int rh = cached[slot];
        if (slot < rh) {
            return slot - rh + cached.length;
        }
        return slot - rh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectHashSet.this.keys.length + 1) {
                if (ObjectHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectHashSet.this.keys.length;
                    this.cursor.value = null;
                    return this.cursor;
                }
                this.cursor.index = ObjectHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectHashSet.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

