/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.impl.NQuadRDFParser;
import com.github.jsonldjava.impl.NQuadTripleCallback;
import com.github.jsonldjava.utils.Obj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonLdProcessor {
    private static Map<String, RDFParser> rdfParsers = new LinkedHashMap<String, RDFParser>(){
        {
            this.put("application/n-quads", new NQuadRDFParser());
        }
    };

    public static Map<String, Object> compact(Object input, Object context, JsonLdOptions opts) throws JsonLdError {
        List<Object> expanded = JsonLdProcessor.expand(input, opts);
        if (context instanceof Map && ((Map)context).containsKey("@context")) {
            context = ((Map)context).get("@context");
        }
        Context activeCtx = new Context(opts);
        Map<String, Object> compacted = new JsonLdApi(opts).compact(activeCtx = activeCtx.parse(context), null, expanded, opts.getCompactArrays());
        if (compacted instanceof List) {
            if (((List)((Object)compacted)).isEmpty()) {
                compacted = Obj.newMap();
            } else {
                Map<String, Object> tmp = Obj.newMap();
                tmp.put(activeCtx.compactIri("@graph", true), compacted);
                compacted = tmp;
            }
        }
        if (compacted != null && context != null && (context instanceof Map && !((Map)context).isEmpty() || context instanceof List && !((List)context).isEmpty())) {
            if (context instanceof List && ((List)context).size() == 1 && opts.getCompactArrays().booleanValue()) {
                compacted.put("@context", ((List)context).get(0));
            } else {
                compacted.put("@context", context);
            }
        }
        return compacted;
    }

    public static List<Object> expand(Object input, JsonLdOptions opts) throws JsonLdError {
        ArrayList<Object> expanded;
        if (input instanceof String && ((String)input).contains(":")) {
            try {
                RemoteDocument tmp = opts.getDocumentLoader().loadDocument((String)input);
                input = tmp.getDocument();
            }
            catch (Exception e) {
                throw new JsonLdError(JsonLdError.Error.LOADING_DOCUMENT_FAILED, (Throwable)e);
            }
            if (opts.getBase() == null) {
                opts.setBase((String)input);
            }
        }
        Context activeCtx = new Context(opts);
        if (opts.getExpandContext() != null) {
            Object exCtx = opts.getExpandContext();
            if (exCtx instanceof Map && ((Map)exCtx).containsKey("@context")) {
                exCtx = ((Map)exCtx).get("@context");
            }
            activeCtx = activeCtx.parse(exCtx);
        }
        if ((expanded = new JsonLdApi(opts).expand(activeCtx, input)) instanceof Map && ((Map)((Object)expanded)).containsKey("@graph") && ((Map)((Object)expanded)).size() == 1) {
            expanded = ((Map)((Object)expanded)).get("@graph");
        } else if (expanded == null) {
            expanded = new ArrayList();
        }
        if (!(expanded instanceof List)) {
            ArrayList tmp = new ArrayList();
            tmp.add(expanded);
            expanded = tmp;
        }
        return expanded;
    }

    public static List<Object> expand(Object input) throws JsonLdError {
        return JsonLdProcessor.expand(input, new JsonLdOptions(""));
    }

    public static Object flatten(Object input, Object context, JsonLdOptions opts) throws JsonLdError {
        List<Object> expanded = JsonLdProcessor.expand(input, opts);
        if (context instanceof Map && ((Map)context).containsKey("@context")) {
            context = ((Map)context).get("@context");
        }
        Map<String, Object> nodeMap = Obj.newMap();
        nodeMap.put("@default", Obj.newMap());
        new JsonLdApi(opts).generateNodeMap(expanded, nodeMap);
        Map defaultGraph = (Map)nodeMap.remove("@default");
        for (String graphName : nodeMap.keySet()) {
            Map entry;
            Map graph = (Map)nodeMap.get(graphName);
            if (!defaultGraph.containsKey(graphName)) {
                entry = Obj.newMap();
                entry.put("@id", graphName);
                defaultGraph.put(graphName, entry);
            } else {
                entry = (Map)defaultGraph.get(graphName);
            }
            if (!entry.containsKey("@graph")) {
                entry.put("@graph", new ArrayList());
            }
            ArrayList keys2 = new ArrayList(graph.keySet());
            Collections.sort(keys2);
            for (String id : keys2) {
                Map node = (Map)graph.get(id);
                if (node.containsKey("@id") && node.size() == 1) continue;
                ((List)entry.get("@graph")).add(node);
            }
        }
        ArrayList<Map> flattened = new ArrayList<Map>();
        ArrayList keys3 = new ArrayList(defaultGraph.keySet());
        Collections.sort(keys3);
        for (String id : keys3) {
            Map node = (Map)defaultGraph.get(id);
            if (node.containsKey("@id") && node.size() == 1) continue;
            flattened.add(node);
        }
        if (context != null && !flattened.isEmpty()) {
            Context activeCtx = new Context(opts);
            ArrayList compacted = new JsonLdApi(opts).compact(activeCtx = activeCtx.parse(context), null, flattened, opts.getCompactArrays());
            if (!(compacted instanceof List)) {
                ArrayList tmp = new ArrayList();
                tmp.add(compacted);
                compacted = tmp;
            }
            String alias = activeCtx.compactIri("@graph");
            Map<String, Object> rval = activeCtx.serialize();
            rval.put(alias, compacted);
            return rval;
        }
        return flattened;
    }

    public static Object flatten(Object input, JsonLdOptions opts) throws JsonLdError {
        return JsonLdProcessor.flatten(input, null, opts);
    }

    public static Map<String, Object> frame(Object input, Object frame, JsonLdOptions opts) throws JsonLdError {
        boolean addGraph;
        if (frame instanceof Map) {
            frame = JsonLdUtils.clone(frame);
        }
        List<Object> expandedInput = JsonLdProcessor.expand(input, opts);
        Object savedExpandedContext = opts.getExpandContext();
        opts.setExpandContext(null);
        opts.setFrameExpansion(true);
        List<Object> expandedFrame = JsonLdProcessor.expand(frame, opts);
        opts.setExpandContext(savedExpandedContext);
        JsonLdApi api = new JsonLdApi(expandedInput, opts);
        Context activeCtx = api.context.parse(((Map)frame).get("@context"));
        List<Object> framed = api.frame(expandedInput, expandedFrame);
        if (opts.getPruneBlankNodeIdentifiers().booleanValue()) {
            JsonLdUtils.pruneBlankNodes(framed);
        }
        ArrayList compacted = api.compact(activeCtx, null, framed, opts.getCompactArrays());
        Map<String, Object> rval = activeCtx.serialize();
        boolean bl = addGraph = !(compacted instanceof List) && opts.getOmitGraph() == false;
        if (addGraph && !(compacted instanceof List)) {
            ArrayList tmp = new ArrayList();
            tmp.add(compacted);
            compacted = tmp;
        }
        if (addGraph || compacted instanceof List) {
            String alias = activeCtx.compactIri("@graph");
            rval.put(alias, compacted);
        } else if (!addGraph && compacted instanceof Map) {
            rval.putAll((Map)((Object)compacted));
        }
        JsonLdUtils.removePreserve(activeCtx, rval, opts);
        return rval;
    }

    public static void registerRDFParser(String format, RDFParser parser) {
        rdfParsers.put(format, parser);
    }

    public static void removeRDFParser(String format) {
        rdfParsers.remove(format);
    }

    public static Object fromRDF(Object dataset, JsonLdOptions options) throws JsonLdError {
        RDFParser parser = null;
        if (options.format == null && dataset instanceof String) {
            options.format = "application/n-quads";
        }
        if (!rdfParsers.containsKey(options.format)) {
            throw new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT, options.format);
        }
        parser = rdfParsers.get(options.format);
        return JsonLdProcessor.fromRDF(dataset, options, parser);
    }

    public static Object fromRDF(Object dataset) throws JsonLdError {
        return JsonLdProcessor.fromRDF(dataset, new JsonLdOptions(""));
    }

    public static Object fromRDF(Object input, JsonLdOptions options, RDFParser parser) throws JsonLdError {
        RDFDataset dataset = parser.parse(input);
        List<Object> rval = new JsonLdApi(options).fromRDF(dataset);
        if (options.outputForm != null) {
            if ("expanded".equals(options.outputForm)) {
                return rval;
            }
            if ("compacted".equals(options.outputForm)) {
                return JsonLdProcessor.compact(rval, dataset.getContext(), options);
            }
            if ("flattened".equals(options.outputForm)) {
                return JsonLdProcessor.flatten(rval, dataset.getContext(), options);
            }
            throw new JsonLdError(JsonLdError.Error.UNKNOWN_ERROR, "Output form was unknown: " + options.outputForm);
        }
        return rval;
    }

    public static Object fromRDF(Object input, RDFParser parser) throws JsonLdError {
        return JsonLdProcessor.fromRDF(input, new JsonLdOptions(""), parser);
    }

    public static Object toRDF(Object input, JsonLdTripleCallback callback, JsonLdOptions options) throws JsonLdError {
        List<Object> expandedInput = JsonLdProcessor.expand(input, options);
        JsonLdApi api = new JsonLdApi(expandedInput, options);
        RDFDataset dataset = api.toRDF();
        if (options.useNamespaces.booleanValue()) {
            ArrayList<Map> _input;
            if (input instanceof List) {
                _input = (ArrayList<Map>)input;
            } else {
                _input = new ArrayList<Map>();
                _input.add((Map)input);
            }
            for (Map e : _input) {
                if (!e.containsKey("@context")) continue;
                dataset.parseContext(e.get("@context"));
            }
        }
        if (callback != null) {
            return callback.call(dataset);
        }
        if (options.format != null) {
            if ("application/n-quads".equals(options.format)) {
                return new NQuadTripleCallback().call(dataset);
            }
            throw new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT, options.format);
        }
        return dataset;
    }

    public static Object toRDF(Object input, JsonLdOptions options) throws JsonLdError {
        return JsonLdProcessor.toRDF(input, null, options);
    }

    public static Object toRDF(Object input, JsonLdTripleCallback callback) throws JsonLdError {
        return JsonLdProcessor.toRDF(input, callback, new JsonLdOptions(""));
    }

    public static Object toRDF(Object input) throws JsonLdError {
        return JsonLdProcessor.toRDF(input, new JsonLdOptions(""));
    }

    public static Object normalize(Object input, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions opts = options.copy();
        opts.format = null;
        RDFDataset dataset = (RDFDataset)JsonLdProcessor.toRDF(input, opts);
        return new JsonLdApi(options).normalize(dataset);
    }

    public static Object normalize(Object input) throws JsonLdError {
        return JsonLdProcessor.normalize(input, new JsonLdOptions(""));
    }
}

