/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.ClassPath;
import edu.utah.blulab.domainontology.DomainOntology;
import edu.utah.blulab.domainontology.LogicExpression;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;

public class Anchor {
    private String uri;
    private DomainOntology domain;

    public Anchor() {
    }

    public Anchor(String clsURI, DomainOntology domain) {
        this.uri = clsURI;
        this.domain = domain;
    }

    public String getURI() {
        return this.uri;
    }

    public String getPrefTerm() {
        return this.domain.getAnnotationString(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#preferredTerm")));
    }

    public void setPrefTerm(String prefTerm) throws Exception {
        this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#preferredTerm")), prefTerm);
    }

    public String getPrefCode() {
        return this.domain.getAnnotationString(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#code")));
    }

    public void setPrefCode(String prefCode) throws Exception {
        this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#code")), prefCode);
    }

    public ArrayList<String> getSynonym() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#synonym")));
    }

    public void setSynonym(List<String> synonyms) throws Exception {
        for (String syn : synonyms) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#synonym")), syn);
        }
    }

    public ArrayList<String> getMisspelling() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#misspelling")));
    }

    public void setMisspelling(List<String> misspellings) throws Exception {
        for (String str : misspellings) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#misspelling")), str);
        }
    }

    public ArrayList<String> getAbbreviation() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#abbreviation")));
    }

    public void setAbbreviation(List<String> abbreviations) throws Exception {
        for (String str : abbreviations) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#abbreviation")), str);
        }
    }

    public ArrayList<String> getSubjExp() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#subjectiveExpression")));
    }

    public void setSubjExpression(List<String> subjExpressions) throws Exception {
        for (String str : subjExpressions) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#subjectiveExpression")), str);
        }
    }

    public ArrayList<String> getRegex() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#regex")));
    }

    public void setRegex(List<String> regex) throws Exception {
        for (String str : regex) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#regex")), str);
        }
    }

    public ArrayList<String> getAltCode() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#alternateCode")));
    }

    public void setAltCode(List<String> altCodes) throws Exception {
        for (String str : altCodes) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#alternateCode")), str);
        }
    }

    public ArrayList<String> getSemanticType() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#semanticType")));
    }

    public void setSemanticType(List<String> semanticTypes) throws Exception {
        for (String str : semanticTypes) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#semanticType")), str);
        }
    }

    public ArrayList<Anchor> getPseudos() {
        ArrayList<Anchor> pseudos = new ArrayList<Anchor>();
        ArrayList<OWLClass> pseudoList = this.domain.getObjectPropertyFillerList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#hasPseudo")));
        for (OWLClass pseudo : pseudoList) {
            pseudos.add(new Anchor(pseudo.getIRI().toString(), this.domain));
        }
        return pseudos;
    }

    public void setPseudo(LogicExpression<String> pseudoValues) throws Exception {
        this.domain.setObjectProperty(pseudoValues, this.domain.getClass(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#hasPseudo")));
    }

    public ArrayList<String> getDefinition() {
        return this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#definition")));
    }

    public void setDefinition(List<String> definitions) throws Exception {
        for (String str : definitions) {
            this.domain.setAnnotation(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#definition")), str);
        }
    }

    public ArrayList<Anchor> getDirectParents() {
        ArrayList<Anchor> parents = new ArrayList<Anchor>();
        ArrayList<String> clsStrings = this.domain.getDirectSuperClasses(this.domain.getClass(this.uri));
        for (String str : clsStrings) {
            if (this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) continue;
            parents.add(new Anchor(str, this.domain));
        }
        return parents;
    }

    public ArrayList<Anchor> getDirectChildren() {
        ArrayList<Anchor> children = new ArrayList<Anchor>();
        ArrayList<String> clsStrings = this.domain.getDirectSubClasses(this.domain.getClass(this.uri));
        for (String str : clsStrings) {
            if (this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) continue;
            children.add(new Anchor(str, this.domain));
        }
        return children;
    }

    public ArrayList<String> getAllParents() {
        ArrayList<String> parentAncestry = new ArrayList();
        parentAncestry = this.domain.getAllSuperClasses(this.domain.getClass(this.uri), false);
        return parentAncestry;
    }

    public List<ClassPath> getClassPaths() {
        return DomainOntology.getRootClassPaths(this.domain.getClass(this.uri));
    }

    public String toString() {
        return "Anchor [prefTerm=" + this.getPrefTerm() + ", prefCode=" + this.getPrefCode() + ", pseudos=" + this.getPseudos() + "]";
    }
}

