/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.Anchor;
import edu.utah.blulab.domainontology.DomainOntology;
import edu.utah.blulab.domainontology.LogicExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public class CompoundAnchor
extends Anchor {
    private String uri;
    private DomainOntology domain;

    public CompoundAnchor(String uri, DomainOntology domain) {
        this.uri = uri;
        this.domain = domain;
    }

    public boolean isOrdered() {
        return false;
    }

    public ArrayList<LogicExpression<Anchor>> getOrderedArgumentList() {
        ArrayList<LogicExpression<Anchor>> arguments = new ArrayList<LogicExpression<Anchor>>();
        Set clsExpressions = this.domain.getClass(this.uri).getEquivalentClasses(this.domain.getOntology());
        for (OWLClassExpression exp : clsExpressions) {
            LogicExpression<Anchor> arg1 = this.getArgumentExpression("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasCompoundArgument1", exp);
            LogicExpression<Anchor> arg2 = this.getArgumentExpression("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasCompoundArgument2", exp);
            LogicExpression<Anchor> arg3 = this.getArgumentExpression("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasCompoundArgument3", exp);
            LogicExpression<Anchor> arg4 = this.getArgumentExpression("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasCompoundArgument4", exp);
            LogicExpression<Anchor> arg5 = this.getArgumentExpression("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasCompoundArgument5", exp);
            if (arg1 != null || !arg1.isEmpty()) {
                arguments.add(0, arg1);
            }
            if (arg2 != null || !arg2.isEmpty()) {
                arguments.add(1, arg2);
            }
            if (arg3 != null || !arg3.isEmpty()) {
                arguments.add(2, arg3);
            }
            if (arg4 != null || !arg4.isEmpty()) {
                arguments.add(3, arg4);
            }
            if (arg5 == null && arg5.isEmpty()) continue;
            arguments.add(4, arg5);
        }
        return arguments;
    }

    public LogicExpression<Anchor> getArgumentExpression(String objProp, OWLClassExpression exp) {
        OWLObjectSomeValuesFrom someValuesFrom;
        LogicExpression<Anchor> value = null;
        OWLObjectProperty hasArgument = this.domain.getFactory().getOWLObjectProperty(IRI.create(objProp));
        if (exp.getClassExpressionType().equals(ClassExpressionType.OBJECT_SOME_VALUES_FROM) && hasArgument.equals(((OWLObjectPropertyExpression)(someValuesFrom = (OWLObjectSomeValuesFrom)exp).getProperty()).asOWLObjectProperty())) {
            OWLClassExpression fillerExpression = (OWLClassExpression)someValuesFrom.getFiller();
            if (fillerExpression.getClassExpressionType().equals(ClassExpressionType.OWL_CLASS)) {
                value = new LogicExpression<Anchor>("SINGLE");
                value.add(new Anchor(fillerExpression.asOWLClass().getIRI().toString(), this.domain));
            } else if (fillerExpression.getClassExpressionType().equals(ClassExpressionType.OBJECT_UNION_OF)) {
                OWLObjectUnionOf objectUnionOf = (OWLObjectUnionOf)fillerExpression;
                value = new LogicExpression("OR");
                List objectFiller = objectUnionOf.getOperandsAsList();
                for (OWLClassExpression clsExp : objectFiller) {
                    value.add(new Anchor(clsExp.asOWLClass().getIRI().toString(), this.domain));
                }
            }
        }
        return value;
    }

    public ArrayList<LogicExpression<Anchor>> getArgumentList() {
        ArrayList<LogicExpression<Anchor>> arguments = new ArrayList<LogicExpression<Anchor>>();
        Set clsExpressions = this.domain.getClass(this.uri).getEquivalentClasses(this.domain.getOntology());
        for (OWLClassExpression exp : clsExpressions) {
            LogicExpression<Anchor> argument = this.getArgumentExpression("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasCompoundArgument", exp);
            if (argument == null && argument.isEmpty()) continue;
            arguments.add(argument);
        }
        return arguments;
    }

    @Override
    public String toString() {
        return "CompoundAnchor:  isOrdered = " + this.isOrdered() + " unordered arguments = " + this.getArgumentList().toString() + "]";
    }
}

