/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.Anchor;
import edu.utah.blulab.domainontology.ClassPath;
import edu.utah.blulab.domainontology.CompoundAnchor;
import edu.utah.blulab.domainontology.LogicExpression;
import edu.utah.blulab.domainontology.Modifier;
import edu.utah.blulab.domainontology.Variable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class DomainOntology {
    private static OWLOntologyManager manager;
    private static OWLOntology ontology;
    private static OWLDataFactory factory;
    private File ontFile;
    private static ArrayList<OWLObjectProperty> propertyList;
    private static ArrayList<OWLObjectProperty> lingPropList;
    private static ArrayList<OWLObjectProperty> semPropList;
    private static ArrayList<OWLObjectProperty> numPropList;
    private static ArrayList<OWLObjectProperty> relationsList;
    private static ArrayList<OWLClass> schemaClassList;

    public DomainOntology(String fileLocation, boolean useLocalFiles) throws Exception {
        manager = OWLManager.createOWLOntologyManager();
        factory = manager.getOWLDataFactory();
        this.ontFile = new File(fileLocation);
        if (useLocalFiles) {
            File directory = this.ontFile.getParentFile();
            AutoIRIMapper autoIRIMapper = new AutoIRIMapper(directory, false);
            manager.addIRIMapper(autoIRIMapper);
        }
        ontology = manager.loadOntologyFromOntologyDocument(this.ontFile);
        propertyList = new ArrayList();
        lingPropList = new ArrayList();
        semPropList = new ArrayList();
        numPropList = new ArrayList();
        relationsList = new ArrayList();
        schemaClassList = this.getSchemaClasses();
        ArrayList<OWLObjectProperty> lingList = new ArrayList<OWLObjectProperty>();
        this.getObjectPropertyHierarchy(factory.getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasLinguisticModifier")), new ArrayList<OWLObjectProperty>(), lingList);
        for (OWLObjectProperty oWLObjectProperty : lingList) {
            lingPropList.add(oWLObjectProperty);
            propertyList.add(oWLObjectProperty);
        }
        ArrayList<OWLObjectProperty> semList = new ArrayList<OWLObjectProperty>();
        this.getObjectPropertyHierarchy(factory.getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasSemanticModifier")), new ArrayList<OWLObjectProperty>(), semList);
        for (OWLObjectProperty oWLObjectProperty : semList) {
            semPropList.add(oWLObjectProperty);
            propertyList.add(oWLObjectProperty);
        }
        ArrayList<OWLObjectProperty> arrayList = new ArrayList<OWLObjectProperty>();
        this.getObjectPropertyHierarchy(factory.getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasNumericModifier")), new ArrayList<OWLObjectProperty>(), arrayList);
        for (OWLObjectProperty prop : arrayList) {
            numPropList.add(prop);
            propertyList.add(prop);
        }
        ArrayList<OWLObjectProperty> arrayList2 = new ArrayList<OWLObjectProperty>();
        this.getObjectPropertyHierarchy(factory.getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasRelation")), new ArrayList<OWLObjectProperty>(), arrayList2);
        for (OWLObjectProperty prop : arrayList2) {
            relationsList.add(prop);
        }
        System.out.println("Loaded ontology:" + ontology.getOntologyID().getOntologyIRI().toString());
        System.out.println("Loaded imports: ");
        for (OWLOntology ont : ontology.getImports()) {
            System.out.println(ont.getOntologyID().getOntologyIRI().toString());
        }
    }

    public File getOntFile() {
        return this.ontFile;
    }

    public OWLOntology getOntology() {
        return ontology;
    }

    public ArrayList<OWLClass> getSchemaClassList() {
        return schemaClassList;
    }

    public ArrayList<OWLObjectProperty> getPropertyList() {
        return propertyList;
    }

    public ArrayList<OWLObjectProperty> getNumericPropertyList() {
        return numPropList;
    }

    public ArrayList<OWLObjectProperty> getRelationsList() {
        return relationsList;
    }

    public ArrayList<OWLObjectProperty> getNonNumericPropertyList() {
        ArrayList<OWLObjectProperty> propList = new ArrayList<OWLObjectProperty>();
        propList.addAll(lingPropList);
        propList.addAll(semPropList);
        return propList;
    }

    public Variable getVariable(String clsDisplayName) {
        String domainURI = ontology.getOntologyID().getOntologyIRI().toString();
        return new Variable(domainURI + "#" + clsDisplayName, this);
    }

    public Variable getVariable(OWLClass cls) {
        return new Variable(cls.getIRI().toString(), this);
    }

    public ArrayList<Variable> getAllVariables() {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        ArrayList<OWLClass> elements = new ArrayList<OWLClass>();
        this.getSubClassHierarchy(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Annotation")), new ArrayList<OWLClass>(), elements, true);
        for (OWLClass cls : elements) {
            variables.add(this.getVariable(cls));
        }
        return variables;
    }

    public HashMap<String, ArrayList<String>> getClassDefinition(OWLClass cls) {
        HashMap<String, ArrayList<String>> definitions = new HashMap<String, ArrayList<String>>();
        ArrayList<String> clsList = new ArrayList<String>();
        Set superDef = cls.getEquivalentClasses(ontology);
        for (OWLClassExpression exp : superDef) {
            if (!exp.getClassExpressionType().equals(ClassExpressionType.OBJECT_COMPLEMENT_OF)) continue;
            String listType = "COMPLEMENT";
            OWLObjectComplementOf complement = (OWLObjectComplementOf)exp;
            OWLClassExpression filler = ((OWLObjectComplementOf)exp).getOperand();
            if (!filler.isAnonymous()) {
                clsList.add(filler.asOWLClass().getIRI().toString());
            } else if (filler.getClassExpressionType().equals(ClassExpressionType.OBJECT_UNION_OF)) {
                OWLObjectUnionOf union = (OWLObjectUnionOf)filler;
                Set<OWLClassExpression> unionSet = union.getOperands();
                for (OWLClassExpression expression : unionSet) {
                    if (expression.isAnonymous()) continue;
                    clsList.add(expression.asOWLClass().getIRI().toString());
                }
            }
            definitions.put(listType, clsList);
        }
        return definitions;
    }

    private void getSubClassHierarchy(OWLClass cls, ArrayList<OWLClass> visitedCls, ArrayList<OWLClass> clsList, boolean ignoreImports) {
        if (cls == null || visitedCls.contains(cls)) {
            return;
        }
        Set subExp = cls.getSubClasses(manager.getOntologies());
        for (OWLClassExpression subCls : subExp) {
            if (!visitedCls.contains(cls.asOWLClass())) {
                visitedCls.add(cls.asOWLClass());
            }
            if (ignoreImports) {
                if (!subCls.asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") && !subCls.asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) {
                    clsList.add(subCls.asOWLClass());
                }
            } else if (!subCls.asOWLClass().isAnonymous()) {
                clsList.add(subCls.asOWLClass());
            }
            this.getSubClassHierarchy(subCls.asOWLClass(), visitedCls, clsList, ignoreImports);
        }
    }

    private void getSuperClassHierarchy(OWLClass cls, ArrayList<OWLClass> visitedCls, ArrayList<OWLClass> clsList, boolean ignoreImports) {
        if (!cls.isAnonymous()) {
            if (cls == null || visitedCls.contains(cls) || cls.equals(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#AnnotationOntology")))) {
                return;
            }
            Set superExp = cls.getSuperClasses(manager.getOntologies());
            for (OWLClassExpression superCls : superExp) {
                if (superCls.isAnonymous()) continue;
                if (!visitedCls.contains(cls.asOWLClass())) {
                    visitedCls.add(cls.asOWLClass());
                }
                if (ignoreImports) {
                    if (!(superCls.asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || superCls.asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#") || superCls.equals(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#AnnotationOntology"))))) {
                        clsList.add(superCls.asOWLClass());
                    }
                } else if (!superCls.equals(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#AnnotationOntology")))) {
                    clsList.add(superCls.asOWLClass());
                }
                this.getSuperClassHierarchy(superCls.asOWLClass(), visitedCls, clsList, ignoreImports);
            }
        }
    }

    public OWLClass getEquivalentObjectPropertyFiller(OWLClass cls, OWLObjectProperty prop) {
        OWLClass filler = null;
        Set exp = cls.getEquivalentClasses(ontology);
        for (OWLClassExpression ce : exp) {
            OWLObjectSomeValuesFrom obj;
            OWLObjectPropertyExpression propExp;
            if (ce.getClassExpressionType().compareTo(ClassExpressionType.OBJECT_SOME_VALUES_FROM) != 0 || !(propExp = (OWLObjectPropertyExpression)(obj = (OWLObjectSomeValuesFrom)ce).getProperty()).asOWLObjectProperty().equals(prop)) continue;
            OWLClassExpression fillerClass = (OWLClassExpression)obj.getFiller();
            filler = fillerClass.asOWLClass();
        }
        return filler;
    }

    public String getObjectPropertyFiller(OWLIndividual indiv, OWLObjectProperty prop) {
        String item;
        block0: {
            item = null;
            OWLObjectProperty exp = prop;
            Set enActions = indiv.asOWLNamedIndividual().getObjectPropertyValues(exp, ontology);
            Iterator iter = enActions.iterator();
            if (!iter.hasNext()) break block0;
            OWLIndividual in = (OWLIndividual)iter.next();
            item = in.asOWLNamedIndividual().getIRI().toString();
        }
        return item;
    }

    public void setObjectPropertyFiller(OWLIndividual indiv, OWLObjectProperty prop) {
    }

    public ArrayList<String> getEquivalentDataPropertyFiller(OWLClass cls, OWLDataProperty prop) {
        ArrayList<String> filler = new ArrayList<String>();
        Set equivClassExp = cls.getEquivalentClasses(ontology);
        for (OWLClassExpression equiv : equivClassExp) {
            OWLDataSomeValuesFrom axiom;
            if (!equiv.getClassExpressionType().equals(ClassExpressionType.DATA_SOME_VALUES_FROM) || !((OWLDataRange)(axiom = (OWLDataSomeValuesFrom)equiv).getFiller()).getDataRangeType().equals(DataRangeType.DATA_ONE_OF)) continue;
            OWLDataOneOf dataFiller = (OWLDataOneOf)axiom.getFiller();
            Set<OWLLiteral> fillerLiterals = dataFiller.getValues();
            for (OWLLiteral lit : fillerLiterals) {
                filler.add(lit.getLiteral());
            }
        }
        return filler;
    }

    public ArrayList<String> getDataPropertyFiller(OWLClass cls, OWLDataProperty prop) {
        ArrayList<String> filler = new ArrayList<String>();
        Set subclassExp = cls.getSuperClasses(ontology);
        subclassExp.addAll(cls.getEquivalentClasses(ontology));
        for (OWLClassExpression sub : subclassExp) {
            OWLDataSomeValuesFrom axiom;
            if (!sub.getClassExpressionType().equals(ClassExpressionType.DATA_SOME_VALUES_FROM) || !((OWLDataRange)(axiom = (OWLDataSomeValuesFrom)sub).getFiller()).getDataRangeType().equals(DataRangeType.DATATYPE_RESTRICTION) || !((OWLDataPropertyExpression)axiom.getProperty()).equals(prop)) continue;
            OWLDatatypeRestriction dataRestriction = (OWLDatatypeRestriction)axiom.getFiller();
            Set<OWLFacetRestriction> facets = dataRestriction.getFacetRestrictions();
            for (OWLFacetRestriction facet : facets) {
                String temp = "";
                if (facet.getFacet().equals(OWLFacet.MIN_INCLUSIVE)) {
                    temp = temp + ">=";
                    if (facet.getFacetValue().isFloat()) {
                        temp = temp + facet.getFacetValue().parseFloat();
                    }
                    if (facet.getFacetValue().isDouble()) {
                        temp = temp + facet.getFacetValue().parseDouble();
                    }
                    if (facet.getFacetValue().isInteger()) {
                        temp = temp + facet.getFacetValue().parseInteger();
                    }
                }
                if (facet.getFacet().equals(OWLFacet.MIN_EXCLUSIVE)) {
                    temp = temp + ">";
                    if (facet.getFacetValue().isFloat()) {
                        temp = temp + facet.getFacetValue().parseFloat();
                    }
                    if (facet.getFacetValue().isDouble()) {
                        temp = temp + facet.getFacetValue().parseDouble();
                    }
                    if (facet.getFacetValue().isInteger()) {
                        temp = temp + facet.getFacetValue().parseInteger();
                    }
                }
                if (facet.getFacet().equals(OWLFacet.MAX_INCLUSIVE)) {
                    temp = temp + "<=";
                    if (facet.getFacetValue().isFloat()) {
                        temp = temp + facet.getFacetValue().parseFloat();
                    }
                    if (facet.getFacetValue().isDouble()) {
                        temp = temp + facet.getFacetValue().parseDouble();
                    }
                    if (facet.getFacetValue().isInteger()) {
                        temp = temp + facet.getFacetValue().parseInteger();
                    }
                }
                if (facet.getFacet().equals(OWLFacet.MAX_EXCLUSIVE)) {
                    temp = temp + "<";
                    if (facet.getFacetValue().isFloat()) {
                        temp = temp + facet.getFacetValue().parseFloat();
                    }
                    if (facet.getFacetValue().isDouble()) {
                        temp = temp + facet.getFacetValue().parseDouble();
                    }
                    if (facet.getFacetValue().isInteger()) {
                        temp = temp + facet.getFacetValue().parseInteger();
                    }
                }
                filler.add(temp);
            }
        }
        return filler;
    }

    public void setDataPropertyFiller(OWLIndividual indiv, String str) {
    }

    public HashMap<String, ArrayList<OWLClassExpression>> getEquivalentObjectPropertyFillerMap(OWLClass cls, ArrayList<OWLObjectProperty> props) {
        HashMap<String, ArrayList<OWLClassExpression>> map = new HashMap<String, ArrayList<OWLClassExpression>>();
        Set exp = cls.getEquivalentClasses(ontology);
        for (OWLClassExpression ce : exp) {
            OWLObjectSomeValuesFrom obj;
            OWLObjectPropertyExpression propExp;
            ArrayList<OWLClassExpression> filler = new ArrayList<OWLClassExpression>();
            if (ce.getClassExpressionType().compareTo(ClassExpressionType.OBJECT_SOME_VALUES_FROM) != 0 || !props.contains((propExp = (OWLObjectPropertyExpression)(obj = (OWLObjectSomeValuesFrom)ce).getProperty()).asOWLObjectProperty())) continue;
            OWLClassExpression fillerClass = (OWLClassExpression)obj.getFiller();
            filler.add(fillerClass);
            map.put(propExp.asOWLObjectProperty().getIRI().toString(), filler);
        }
        return map;
    }

    public ArrayList<OWLClassExpression> getEquivalentObjectPropertyFillerList(OWLClass cls, ArrayList<OWLObjectProperty> props) {
        ArrayList<OWLClassExpression> filler = new ArrayList<OWLClassExpression>();
        for (OWLObjectProperty prop : props) {
            filler.addAll(this.getEquivalentObjectPropertyFillerList(cls, prop));
        }
        return filler;
    }

    public ArrayList<OWLClassExpression> getEquivalentObjectPropertyFillerList(OWLClass cls, OWLObjectProperty property) {
        ArrayList<OWLObjectProperty> props = new ArrayList<OWLObjectProperty>();
        props.add(property);
        ArrayList<OWLClassExpression> filler = new ArrayList<OWLClassExpression>();
        Set exp = cls.getEquivalentClasses(ontology);
        for (OWLClassExpression ce : exp) {
            OWLObjectSomeValuesFrom obj;
            OWLObjectPropertyExpression propExp;
            if (ce.getClassExpressionType().compareTo(ClassExpressionType.OBJECT_SOME_VALUES_FROM) != 0 || !props.contains((propExp = (OWLObjectPropertyExpression)(obj = (OWLObjectSomeValuesFrom)ce).getProperty()).asOWLObjectProperty())) continue;
            OWLClassExpression fillerClass = (OWLClassExpression)obj.getFiller();
            filler.add(fillerClass);
        }
        return filler;
    }

    public ArrayList<OWLClass> getObjectPropertyFillerList(OWLClass cls, OWLObjectProperty prop) {
        ArrayList<OWLClass> filler = new ArrayList<OWLClass>();
        Set superCls = cls.getSuperClasses(ontology);
        for (OWLClassExpression ce : superCls) {
            OWLClassExpression fillerClass;
            OWLObjectSomeValuesFrom obj;
            OWLObjectPropertyExpression propExp;
            if (ce.getClassExpressionType().compareTo(ClassExpressionType.OBJECT_SOME_VALUES_FROM) != 0 || !prop.equals((propExp = (OWLObjectPropertyExpression)(obj = (OWLObjectSomeValuesFrom)ce).getProperty()).asOWLObjectProperty()) || (fillerClass = (OWLClassExpression)obj.getFiller()).isAnonymous()) continue;
            filler.add(fillerClass.asOWLClass());
        }
        return filler;
    }

    public String getAnnotationString(OWLClass cls, OWLAnnotationProperty annotationProperty) {
        String str;
        block0: {
            Iterator iter;
            str = "";
            Set labels = cls.getAnnotations(ontology, annotationProperty);
            if (labels.isEmpty() || !(iter = labels.iterator()).hasNext()) break block0;
            OWLAnnotation label = (OWLAnnotation)iter.next();
            String temp = label.getValue().toString();
            str = temp = temp.substring(temp.indexOf("\"") + 1, temp.lastIndexOf("\""));
        }
        return str;
    }

    public String getAnnotationString(OWLIndividual ind, OWLAnnotationProperty annotationProperty, String lang) {
        String str = "";
        Set labels = ind.asOWLNamedIndividual().getAnnotations(ontology, annotationProperty);
        if (!labels.isEmpty()) {
            for (OWLAnnotation label : labels) {
                OWLLiteral literal = (OWLLiteral)label.getValue();
                if (!literal.getLang().equals(lang)) continue;
                str = literal.getLiteral();
                break;
            }
        }
        return str;
    }

    public String getAnnotationString(OWLIndividual ind, OWLAnnotationProperty annotationProperty) {
        String str;
        block0: {
            Iterator iter;
            str = "";
            Set labels = ind.asOWLNamedIndividual().getAnnotations(ontology, annotationProperty);
            if (labels.isEmpty() || !(iter = labels.iterator()).hasNext()) break block0;
            OWLAnnotation label = (OWLAnnotation)iter.next();
            OWLLiteral literal = (OWLLiteral)label.getValue();
            str = literal.getLiteral();
        }
        return str;
    }

    public ArrayList<String> getAnnotationList(OWLClass cls, OWLAnnotationProperty annotationProperty) {
        ArrayList<String> labelSet = new ArrayList<String>();
        Set annotations = cls.getAnnotations(ontology, annotationProperty);
        if (!annotations.isEmpty()) {
            for (OWLAnnotation ann : annotations) {
                String temp = ann.getValue().toString();
                temp = temp.substring(temp.indexOf("\"") + 1, temp.lastIndexOf("\""));
                labelSet.add(temp);
            }
        }
        return labelSet;
    }

    public void setAnnotationList(OWLClass cls, OWLAnnotationProperty annotationProperty, ArrayList<String> list) throws Exception {
        for (String item : list) {
            this.setAnnotation(cls, annotationProperty, item);
        }
    }

    public void setAnnotation(OWLClass cls, OWLAnnotationProperty annotationProperty, String item) throws Exception {
        OWLLiteral literal = factory.getOWLLiteral(item);
        OWLAnnotation annotation = factory.getOWLAnnotation(annotationProperty, literal);
        OWLAnnotationAssertionAxiom annotationAssertionAxiom = factory.getOWLAnnotationAssertionAxiom(cls.getIRI(), annotation);
        manager.addAxiom(ontology, annotationAssertionAxiom);
        manager.saveOntology(ontology);
    }

    public void setAnnotationList(OWLNamedIndividual ind, OWLAnnotationProperty annotationProperty, ArrayList<String> list) throws Exception {
        for (String item : list) {
            this.setAnnotation(ind, annotationProperty, item);
        }
    }

    public void setAnnotation(OWLNamedIndividual ind, OWLAnnotationProperty annotationProperty, String item) throws Exception {
        OWLLiteral literal = factory.getOWLLiteral(item);
        OWLAnnotation annotation = factory.getOWLAnnotation(annotationProperty, literal);
        OWLAnnotationAssertionAxiom annotationAssertionAxiom = factory.getOWLAnnotationAssertionAxiom(ind.getIRI(), annotation);
        manager.addAxiom(ontology, annotationAssertionAxiom);
        manager.saveOntology(ontology);
    }

    public void createClass(String classURI, String parentURI) throws Exception {
        OWLClass parentClass = factory.getOWLClass(IRI.create(parentURI));
        OWLClass childClass = factory.getOWLClass(IRI.create(classURI));
        OWLSubClassOfAxiom subclassAxiom = factory.getOWLSubClassOfAxiom(childClass, parentClass);
        manager.addAxiom(ontology, subclassAxiom);
        manager.saveOntology(ontology);
    }

    public void createIndividual(String indURI, String clsURI) throws Exception {
        OWLNamedIndividual individual = factory.getOWLNamedIndividual(IRI.create(indURI));
        OWLClass cls = factory.getOWLClass(IRI.create(clsURI));
        OWLClassAssertionAxiom classAssertionAxiom = factory.getOWLClassAssertionAxiom(cls, individual);
        manager.addAxiom(ontology, classAssertionAxiom);
        manager.saveOntology(ontology);
    }

    public void setObjectProperty(LogicExpression<String> propValues, OWLClass cls, OWLObjectProperty prop) throws Exception {
        if (propValues.isSingleExpression()) {
            OWLClass valueClass = factory.getOWLClass(IRI.create((String)propValues.get(0)));
            OWLObjectSomeValuesFrom someValuesFrom = factory.getOWLObjectSomeValuesFrom(prop, valueClass);
            OWLSubClassOfAxiom hasPropAxiom = factory.getOWLSubClassOfAxiom(cls, someValuesFrom);
            manager.addAxiom(ontology, hasPropAxiom);
            manager.saveOntology(ontology);
        } else if (propValues.isOrExpression()) {
            HashSet<OWLClass> values2 = new HashSet<OWLClass>();
            for (String str : propValues) {
                OWLClass valueClass = factory.getOWLClass(IRI.create(str));
                values2.add(valueClass);
            }
            OWLObjectUnionOf union = factory.getOWLObjectUnionOf(values2);
            OWLSubClassOfAxiom unionAxiom = factory.getOWLSubClassOfAxiom(cls, union);
            manager.addAxiom(ontology, unionAxiom);
            manager.saveOntology(ontology);
        }
    }

    public void saveDomainOntology() throws Exception {
        manager.saveOntology(ontology);
    }

    public Anchor createAnchor(String anchorURI, String parentURI) throws Exception {
        this.createClass(anchorURI, parentURI);
        Anchor newAnchor = new Anchor(anchorURI, this);
        return newAnchor;
    }

    public Anchor createAnchor(String anchorURI) throws Exception {
        return this.createAnchor(anchorURI, "https://blulab-utah.github.io/ontologies/v2/Schema.owl#Anchor");
    }

    public ArrayList<String> getAnnotationStringList(OWLIndividual ind, OWLAnnotationProperty annotationProperty, String lang) {
        ArrayList<String> list = new ArrayList<String>();
        Set labels = ind.asOWLNamedIndividual().getAnnotations(ontology, annotationProperty);
        if (!labels.isEmpty()) {
            for (OWLAnnotation label : labels) {
                OWLLiteral literal = (OWLLiteral)label.getValue();
                if (!literal.getLang().equals(lang)) continue;
                list.add(literal.getLiteral());
            }
        }
        return list;
    }

    public ArrayList<Anchor> createAnchorDictionary() {
        ArrayList<Anchor> clsList = new ArrayList<Anchor>();
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Anchor")), false)) {
            clsList.add(new Anchor(cls.getIRI().toString(), this));
        }
        return clsList;
    }

    public ArrayList<CompoundAnchor> createCompoundAnchorDictionary() {
        ArrayList<CompoundAnchor> clsList = new ArrayList<CompoundAnchor>();
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#CompoundAnchor")), false)) {
            clsList.add(new CompoundAnchor(cls.getIRI().toString(), this));
        }
        return clsList;
    }

    public ArrayList<Modifier> createModifierDictionary() throws Exception {
        ArrayList<Modifier> allMods = new ArrayList<Modifier>();
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#LinguisticModifier")), true)) {
            allMods.add(new Modifier(cls.getIRI().toString(), this));
        }
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#SemanticModifier")), true)) {
            allMods.add(new Modifier(cls.getIRI().toString(), this));
        }
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#NumericModifier")), true)) {
            allMods.add(new Modifier(cls.getIRI().toString(), this));
        }
        return allMods;
    }

    public HashMap<String, ArrayList<Modifier>> createModifierTypeMap() throws Exception {
        HashMap<String, ArrayList<Modifier>> modifierMap = new HashMap<String, ArrayList<Modifier>>();
        ArrayList<Modifier> linguistic = new ArrayList<Modifier>();
        ArrayList<Modifier> semantic = new ArrayList<Modifier>();
        ArrayList<Modifier> numeric = new ArrayList<Modifier>();
        for (Modifier mod : this.createModifierDictionary()) {
            if (mod.getModifierType().equals("Linguistic")) {
                linguistic.add(mod);
                continue;
            }
            if (mod.getModifierType().equals("Semantic")) {
                semantic.add(mod);
                continue;
            }
            if (!mod.getModifierType().equals("Numeric")) continue;
            numeric.add(mod);
        }
        modifierMap.put("Linguistic", linguistic);
        modifierMap.put("Semantic", semantic);
        modifierMap.put("Numeric", numeric);
        return modifierMap;
    }

    public ArrayList<Modifier> createClosureDictionary() {
        ArrayList<Modifier> clsList = new ArrayList<Modifier>();
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#Closure")), false)) {
            clsList.add(new Modifier(cls.getIRI().toString(), this));
        }
        return clsList;
    }

    public ArrayList<Modifier> createPseudoModifierDictionary() {
        ArrayList<Modifier> clsList = new ArrayList<Modifier>();
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#PseudoModifier")), false)) {
            clsList.add(new Modifier(cls.getIRI().toString(), this));
        }
        return clsList;
    }

    public ArrayList<Anchor> createPseudoAnchorDictionary() {
        ArrayList<Anchor> clsList = new ArrayList<Anchor>();
        for (OWLClass cls : this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#PseudoAnchor")), false)) {
            clsList.add(new Anchor(cls.getIRI().toString(), this));
        }
        return clsList;
    }

    private void getObjectPropertyHierarchy(OWLObjectProperty prop, ArrayList<OWLObjectProperty> visitedProp, ArrayList<OWLObjectProperty> propList) {
        if (prop == null || visitedProp.contains(prop)) {
            return;
        }
        Set subExp = prop.getSubProperties(manager.getOntologies());
        for (OWLObjectPropertyExpression subProp : subExp) {
            if (!visitedProp.contains(prop.asOWLObjectProperty())) {
                visitedProp.add(prop.asOWLObjectProperty());
            }
            propList.add(subProp.asOWLObjectProperty());
            this.getObjectPropertyHierarchy(subProp.asOWLObjectProperty(), visitedProp, propList);
        }
    }

    public OWLClass getClass(String uri) {
        return factory.getOWLClass(IRI.create(uri));
    }

    public String getClassURIString(OWLClass cls) {
        return cls.asOWLClass().getIRI().toURI().toString();
    }

    public OWLIndividual getIndividual(String uri) {
        return factory.getOWLNamedIndividual(IRI.create(uri));
    }

    public OWLDataFactory getFactory() {
        return factory;
    }

    public ArrayList<OWLClass> getSchemaClasses() {
        ArrayList<OWLClass> list = new ArrayList<OWLClass>();
        ArrayList<OWLClass> schemaClassList = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#AnnotationOntology")), false);
        for (OWLClass cls : schemaClassList) {
            if (!cls.getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#")) continue;
            list.add(cls);
        }
        return list;
    }

    public ArrayList<OWLClass> getAllSubClasses(OWLClass cls, boolean ignoreImports) {
        ArrayList<OWLClass> list = new ArrayList<OWLClass>();
        this.getSubClassHierarchy(cls, new ArrayList<OWLClass>(), list, ignoreImports);
        return list;
    }

    public ArrayList<String> getAllSuperClasses(OWLClass cls, boolean ignoreImports) {
        ArrayList<OWLClass> list = new ArrayList<OWLClass>();
        ArrayList<String> superList = new ArrayList<String>();
        this.getSuperClassHierarchy(cls, new ArrayList<OWLClass>(), list, ignoreImports);
        for (OWLClass superCls : list) {
            superList.add(superCls.getIRI().toString());
        }
        return superList;
    }

    public ArrayList<Variable> getAllEvents() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Event")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllConditions() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Condition")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllDiseaseDisorders() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#DiseaseDisorder")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllSignSymptoms() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#SignSymptom")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllFindings() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Finding")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllEncounters() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Encounter")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllMedications() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#MedicationStatement")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllObservations() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Observation")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllProcedures() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Procedure")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllDianosticProcedures() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#DiagnosticProcedure")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllTherapeuticProcedures() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#TherapeuticProcedure")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllEntities() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Entity")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllPatients() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#Patient")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<Variable> getAllAllergies() {
        ArrayList<Variable> events = new ArrayList<Variable>();
        ArrayList<OWLClass> list = this.getAllSubClasses(factory.getOWLClass(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#AllergyIntolerance")), true);
        for (OWLClass cls : list) {
            if (schemaClassList.contains(cls)) continue;
            events.add(new Variable(cls.getIRI().toString(), this));
        }
        return events;
    }

    public ArrayList<String> getAllIndividualURIs(OWLClass cls) {
        ArrayList<String> indURIs = new ArrayList<String>();
        Set list = cls.getIndividuals(ontology);
        for (OWLIndividual ind : list) {
            indURIs.add(ind.asOWLNamedIndividual().getIRI().toString());
        }
        return indURIs;
    }

    public String getDisplayName(String iri) {
        if (iri != null) {
            IRI fullIRI = IRI.create(iri);
            return fullIRI.getShortForm();
        }
        return null;
    }

    public ArrayList<String> getDirectSuperClasses(OWLClass cls) {
        ArrayList<String> list = new ArrayList<String>();
        Set<OWLOntology> ontologySet = ontology.getImports();
        ontologySet.add(ontology);
        Set superList = cls.getSuperClasses(ontologySet);
        for (OWLClassExpression c : superList) {
            if (c.isAnonymous()) continue;
            list.add(c.asOWLClass().getIRI().toString());
        }
        return list;
    }

    public ArrayList<String> getDirectSubClasses(OWLClass cls) {
        ArrayList<String> list = new ArrayList<String>();
        Set<OWLOntology> ontologySet = ontology.getImports();
        ontologySet.add(ontology);
        Set subList = cls.getSubClasses(ontologySet);
        for (OWLClassExpression c : subList) {
            list.add(c.asOWLClass().getIRI().toString());
        }
        return list;
    }

    public ArrayList<String> getSWRLRules() {
        ArrayList<String> ruleStrings = new ArrayList<String>();
        for (SWRLRule rule : ontology.getAxioms(AxiomType.SWRL_RULE)) {
            ruleStrings.add(rule.toString());
        }
        return ruleStrings;
    }

    public String getDomainURI() {
        return ontology.getOntologyID().getOntologyIRI().toString();
    }

    public void setDataProperty(OWLIndividual indiv, String dataPropertyURI, String value) throws OWLOntologyStorageException {
        OWLDataProperty prop = factory.getOWLDataProperty(IRI.create(dataPropertyURI));
        OWLLiteral literal = factory.getOWLLiteral(value);
        OWLDataPropertyAssertionAxiom axiom = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)prop, indiv, literal);
        manager.addAxiom(ontology, axiom);
        manager.saveOntology(ontology);
    }

    public void createVariable() {
    }

    private static void getPath(OWLClass cls, ClassPath path, List<ClassPath> paths) {
        if (!paths.contains(path)) {
            paths.add(path);
        }
        path.add(0, cls);
        ArrayList<OWLClass> parents = new ArrayList<OWLClass>();
        for (OWLClassExpression clsExp : cls.getSuperClasses(manager.getOntologies())) {
            if (!clsExp.getClassExpressionType().equals(ClassExpressionType.OWL_CLASS)) continue;
            parents.add(clsExp.asOWLClass());
        }
        if (parents.size() == 1) {
            DomainOntology.getPath((OWLClass)parents.get(0), path, paths);
        } else if (parents.size() > 1) {
            for (int i = 1; i < parents.size(); ++i) {
                DomainOntology.getPath((OWLClass)parents.get(i), new ClassPath(path), paths);
            }
            DomainOntology.getPath((OWLClass)parents.get(0), path, paths);
        }
    }

    public static List<ClassPath> getRootClassPaths(OWLClass cls) {
        if (cls != null) {
            ArrayList<ClassPath> paths = new ArrayList<ClassPath>();
            DomainOntology.getPath(cls, new ClassPath(), paths);
            return paths;
        }
        return Collections.EMPTY_LIST;
    }
}

