/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.DomainOntology;
import java.util.ArrayList;
import org.semanticweb.owlapi.model.IRI;

public class LexicalItem {
    private DomainOntology domain;
    private String uri;
    private String actionEn;
    private String actionSv;
    private String actionDe;
    private String prefTermEn;
    private int windowSize;

    public LexicalItem(String itemURI, DomainOntology domain) {
        this.uri = itemURI;
        this.domain = domain;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPrefTerm() {
        return this.domain.getAnnotationString(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#preferredTerm")), "en");
    }

    public ArrayList<String> getPrefCode() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#code")), "en");
    }

    public ArrayList<String> getSynonym() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#synonym")), "en");
    }

    public ArrayList<String> getMisspelling() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#misspelling")), "en");
    }

    public ArrayList<String> getAbbreviation() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#abbreviation")), "en");
    }

    public ArrayList<String> getSubjExp() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#subjectiveExpression")), "en");
    }

    public ArrayList<String> getRegex() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#regex")), "en");
    }

    public ArrayList<String> getAltCode() {
        return this.domain.getAnnotationStringList(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/TermMapping.owl#alternateCode")), "en");
    }

    public String getActionEn(boolean returnDisplayName) {
        String str = this.domain.getObjectPropertyFiller(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#hasActionEn")));
        if (returnDisplayName) {
            str = this.domain.getDisplayName(str);
        }
        return str;
    }

    public String getActionSv() {
        return this.actionSv;
    }

    public String getActionDe() {
        return this.actionDe;
    }

    public int getWindowSize() {
        String str = this.domain.getAnnotationString(this.domain.getIndividual(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#windowSize")));
        if (str.isEmpty() || str.equals(null)) {
            return 8;
        }
        return Integer.parseInt(str);
    }

    public String toString() {
        return "LexicalItem [uri=" + this.uri + ", prefLabel=" + this.getPrefTerm() + ", regex=" + this.getRegex() + ", altLabel=" + this.getSynonym() + ", windowSize=" + this.getWindowSize() + ", actionEn=" + this.getActionEn(true) + "]";
    }
}

