/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.ClassPath;
import edu.utah.blulab.domainontology.DomainOntology;
import edu.utah.blulab.domainontology.LexicalItem;
import edu.utah.blulab.domainontology.LogicExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;

public class Modifier {
    private String uri;
    private DomainOntology domain;
    public static final String LINGUISTIC = "Linguistic";
    public static final String SEMANTIC = "Semantic";
    public static final String NUMERIC = "Numeric";

    public Modifier(String clsURI, DomainOntology domain) {
        this.uri = clsURI;
        this.domain = domain;
    }

    public String getModifierType() {
        String type = "";
        for (ClassPath path : this.getClassPaths()) {
            if (path.contains(this.domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#LinguisticModifier"))) {
                return LINGUISTIC;
            }
            if (path.contains(this.domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#NumericModifier"))) {
                return NUMERIC;
            }
            if (!path.contains(this.domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#SemanticModifier"))) continue;
            return SEMANTIC;
        }
        return type;
    }

    public String getModName() {
        return this.domain.getClass(this.uri).getIRI().getShortForm();
    }

    public String getUri() {
        return this.uri;
    }

    public ArrayList<LexicalItem> getItems() {
        ArrayList<LexicalItem> items = new ArrayList<LexicalItem>();
        for (String item : this.domain.getAllIndividualURIs(this.domain.getClass(this.uri))) {
            items.add(new LexicalItem(item, this.domain));
        }
        return items;
    }

    public ArrayList<Modifier> getClosures() {
        ArrayList<Modifier> list = new ArrayList<Modifier>();
        ArrayList<OWLClass> clsList = this.domain.getObjectPropertyFillerList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#hasTermination")));
        for (OWLClass cls : clsList) {
            list.add(new Modifier(cls.getIRI().toString(), this.domain));
        }
        return list;
    }

    public ArrayList<Modifier> getPseudos() {
        ArrayList<Modifier> list = new ArrayList<Modifier>();
        ArrayList<OWLClass> clsList = this.domain.getObjectPropertyFillerList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/ConText.owl#hasPseudo")));
        for (OWLClass cls : clsList) {
            list.add(new Modifier(cls.getIRI().toString(), this.domain));
        }
        return list;
    }

    public ArrayList<Modifier> getDirectParents() {
        ArrayList<Modifier> parents = new ArrayList<Modifier>();
        ArrayList<String> clsStrings = this.domain.getDirectSuperClasses(this.domain.getClass(this.uri));
        for (String str : clsStrings) {
            if (this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) continue;
            parents.add(new Modifier(str, this.domain));
        }
        return parents;
    }

    public ArrayList<Modifier> getDirectChildren() {
        ArrayList<Modifier> children = new ArrayList<Modifier>();
        ArrayList<String> clsStrings = this.domain.getDirectSubClasses(this.domain.getClass(this.uri));
        for (String str : clsStrings) {
            if (this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) continue;
            children.add(new Modifier(str, this.domain));
        }
        return children;
    }

    public boolean isDefault() {
        boolean bool = false;
        LogicExpression<LogicExpression<Modifier>> list = this.getDefaultDefintion();
        for (LogicExpression logicExpression : list) {
            if (logicExpression.isEmpty()) continue;
            bool = true;
        }
        return bool;
    }

    public LogicExpression<LogicExpression<Modifier>> getDefaultDefintion() {
        LogicExpression<LogicExpression<Modifier>> defaultDef = new LogicExpression<LogicExpression<Modifier>>();
        LogicExpression<Modifier> defValues = new LogicExpression<Modifier>();
        HashMap<String, ArrayList<String>> defs = this.domain.getClassDefinition(this.domain.getClass(this.uri));
        for (Map.Entry<String, ArrayList<String>> entry : defs.entrySet()) {
            defaultDef.setType(entry.getKey());
            ArrayList<String> list = entry.getValue();
            if (list.size() > 1) {
                defValues.setType("OR");
            } else {
                defValues.setType("SINGLE");
            }
            for (String str : list) {
                defValues.add(new Modifier(str, this.domain));
            }
        }
        defaultDef.add(defValues);
        return defaultDef;
    }

    public ArrayList<String> getAllChildren() {
        ArrayList<String> childDescendents = new ArrayList<String>();
        ArrayList<OWLClass> allChildren = this.domain.getAllSubClasses(this.domain.getClass(this.uri), false);
        for (OWLClass cls : allChildren) {
            childDescendents.add(cls.getIRI().toString());
        }
        return childDescendents;
    }

    public ArrayList<String> getAllParents() {
        ArrayList<String> parentAncestry = new ArrayList();
        parentAncestry = this.domain.getAllSuperClasses(this.domain.getClass(this.uri), false);
        return parentAncestry;
    }

    public List<ClassPath> getClassPaths() {
        return DomainOntology.getRootClassPaths(this.domain.getClass(this.uri));
    }

    public String toString() {
        return "\n\tModifier: " + this.getModName() + ", uri=" + this.uri + ", type= " + this.getModifierType() + ", classPath= " + this.getClassPaths() + "]";
    }
}

