/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.ClassPath;
import edu.utah.blulab.domainontology.DomainOntology;
import edu.utah.blulab.domainontology.Modifier;
import java.util.ArrayList;
import org.semanticweb.owlapi.model.IRI;

public class NumericModifier
extends Modifier {
    private String type;
    private DomainOntology domain;
    private String uri;
    public final String QUANTITY = "Quantity";
    public final String RANGE = "RangeModifier";
    public final String RATIO = "Ratio";
    public final String DIMENSIONAL = "DimensionalMeasurement";
    public final String UNIT = "Unit";

    public NumericModifier(String clsURI, DomainOntology domain) {
        super(clsURI, domain);
        this.domain = domain;
        this.uri = clsURI;
        for (ClassPath path : this.getClassPaths()) {
            if (path.contains(domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#Quantity"))) {
                this.type = "Quantity";
            }
            if (path.contains(domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#RangeModifier"))) {
                this.type = "RangeModifier";
            }
            if (path.contains(domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#Ratio"))) {
                this.type = "Ratio";
            }
            if (path.contains(domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#DimensionalMeasurement"))) {
                this.type = "DimensionalMeasurement";
            }
            if (!path.contains(domain.getClass("https://blulab-utah.github.io/ontologies/v2/ConText.owl#Unit"))) continue;
            this.type = "Unit";
        }
    }

    public String getType() {
        return this.type;
    }

    public ArrayList<String> getQuantityValueRange() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("Quantity")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasQuantityValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> getHighRangeValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("RangeModifier")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasHighValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> getLowRangeValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("RangeModifier")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasLowValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> getNumeratorValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("Ratio")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasNumeratorValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> getDenominatorValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("Ratio")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasDenominatorValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> get1DimensionValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("DimensionalMeasurement")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#has1DimensionValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> get2DimensionValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("DimensionalMeasurement")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#has2DimensionValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    public ArrayList<String> get3DimensionValues() {
        ArrayList<String> values2 = new ArrayList<String>();
        if (this.equals("DimensionalMeasurement")) {
            values2 = this.domain.getDataPropertyFiller(this.domain.getClass(this.uri), this.domain.getFactory().getOWLDataProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#has3DimensionValue")));
        } else {
            System.err.println("Numeric modifier is not type " + this.getType());
        }
        return values2;
    }

    @Override
    public String toString() {
        return "Numeric Value: " + this.getModName() + ", uri= " + this.getUri() + ", type= " + this.getType() + ", values= " + this.getQuantityValueRange();
    }
}

