/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.blulab.domainontology;

import edu.utah.blulab.domainontology.Anchor;
import edu.utah.blulab.domainontology.ClassPath;
import edu.utah.blulab.domainontology.DomainOntology;
import edu.utah.blulab.domainontology.LogicExpression;
import edu.utah.blulab.domainontology.Modifier;
import edu.utah.blulab.domainontology.NumericModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public class Variable {
    private String uri;
    private DomainOntology domain;
    private ArrayList<String> relationships;
    private ArrayList<String> rules;

    public Variable(String clsURI, DomainOntology domain) {
        this.domain = domain;
        this.uri = clsURI;
        this.relationships = new ArrayList();
        this.rules = new ArrayList();
    }

    public String getVarID() {
        return this.domain.getClassURIString(this.domain.getClass(this.uri));
    }

    public String getVarName() {
        return this.domain.getAnnotationString(this.domain.getClass(this.uri), this.domain.getFactory().getRDFSLabel());
    }

    public String getURI() {
        return this.uri;
    }

    public String getVariableType() {
        String type = "";
        ArrayList<OWLClassExpression> types = this.domain.getEquivalentObjectPropertyFillerList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasAnnotationType")));
        if (!types.isEmpty()) {
            type = types.get(0).asOWLClass().getIRI().getShortForm();
        }
        return type;
    }

    public ArrayList<String> getSemanticCategory() {
        return this.domain.getDirectSuperClasses(this.domain.getFactory().getOWLClass(IRI.create(this.uri)));
    }

    public ArrayList<String> getSectionHeadings() {
        ArrayList<String> headings = this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#sectionHeader")));
        return headings;
    }

    public ArrayList<String> getReportTypes() {
        ArrayList<String> types = this.domain.getAnnotationList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLAnnotationProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#documentType")));
        return types;
    }

    public ArrayList<LogicExpression<Anchor>> getAnchor() {
        ArrayList<LogicExpression<Anchor>> anchorList = new ArrayList<LogicExpression<Anchor>>();
        ArrayList<OWLClassExpression> list = this.domain.getEquivalentObjectPropertyFillerList(this.domain.getClass(this.uri), this.domain.getFactory().getOWLObjectProperty(IRI.create("https://blulab-utah.github.io/ontologies/v2/Schema.owl#hasAnchor")));
        for (OWLClassExpression cls : list) {
            LogicExpression<Anchor> anchorExp;
            if (!cls.isAnonymous()) {
                anchorExp = new LogicExpression<Anchor>("SINGLE");
                anchorExp.add(new Anchor(cls.asOWLClass().getIRI().toString(), this.domain));
                anchorList.add(anchorExp);
                continue;
            }
            if (!cls.getClassExpressionType().equals(ClassExpressionType.OBJECT_UNION_OF)) continue;
            anchorExp = new LogicExpression("OR");
            OWLObjectUnionOf union = (OWLObjectUnionOf)cls;
            List filler = union.getOperandsAsList();
            for (OWLClassExpression c : filler) {
                if (c.isAnonymous()) continue;
                anchorExp.add(new Anchor(c.asOWLClass().getIRI().toString(), this.domain));
            }
            anchorList.add(anchorExp);
        }
        return anchorList;
    }

    public HashMap<String, LogicExpression<Modifier>> getModifiers() {
        HashMap<String, LogicExpression<Modifier>> mods = new HashMap<String, LogicExpression<Modifier>>();
        HashMap<String, ArrayList<OWLClassExpression>> list = this.domain.getEquivalentObjectPropertyFillerMap(this.domain.getClass(this.uri), this.domain.getNonNumericPropertyList());
        for (Map.Entry<String, ArrayList<OWLClassExpression>> entry : list.entrySet()) {
            String property = entry.getKey();
            ArrayList<OWLClassExpression> expList = entry.getValue();
            for (OWLClassExpression cls : expList) {
                LogicExpression<Modifier> modifierList;
                if (!cls.isAnonymous()) {
                    modifierList = new LogicExpression<Modifier>("SINGLE");
                    modifierList.add(new Modifier(cls.asOWLClass().getIRI().toString(), this.domain));
                    mods.put(property, modifierList);
                    continue;
                }
                if (!cls.getClassExpressionType().equals(ClassExpressionType.OBJECT_UNION_OF)) continue;
                modifierList = new LogicExpression("OR");
                OWLObjectUnionOf union = (OWLObjectUnionOf)cls;
                List filler = union.getOperandsAsList();
                for (OWLClassExpression c : filler) {
                    if (c.isAnonymous()) continue;
                    modifierList.add(new Modifier(c.asOWLClass().getIRI().toString(), this.domain));
                }
                mods.put(property, modifierList);
            }
        }
        return mods;
    }

    public HashMap<String, Variable> getRelationships() {
        HashMap<String, Variable> relations = new HashMap<String, Variable>();
        for (OWLObjectProperty prop : this.domain.getRelationsList()) {
            ArrayList<OWLClass> list = this.domain.getObjectPropertyFillerList(this.domain.getClass(this.uri), prop);
            for (OWLClass cls : list) {
                relations.put(prop.asOWLObjectProperty().getIRI().getShortForm(), new Variable(cls.getIRI().toString(), this.domain));
            }
        }
        return relations;
    }

    public ArrayList<NumericModifier> getNumericModifiers() {
        ArrayList<NumericModifier> mods = new ArrayList<NumericModifier>();
        ArrayList<OWLClassExpression> list = this.domain.getEquivalentObjectPropertyFillerList(this.domain.getClass(this.uri), this.domain.getNumericPropertyList());
        for (OWLClassExpression cls : list) {
            if (cls.isAnonymous()) continue;
            mods.add(new NumericModifier(cls.asOWLClass().getIRI().toString(), this.domain));
        }
        return mods;
    }

    public boolean hasNumericModifiers() {
        return !this.getNumericModifiers().isEmpty();
    }

    public ArrayList<Variable> getDirectParents() {
        ArrayList<Variable> parents = new ArrayList<Variable>();
        ArrayList<String> clsStrings = this.domain.getDirectSuperClasses(this.domain.getClass(this.uri));
        for (String str : clsStrings) {
            if (this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) continue;
            parents.add(new Variable(str, this.domain));
        }
        return parents;
    }

    public ArrayList<Variable> getDirectChildren() {
        ArrayList<Variable> children = new ArrayList<Variable>();
        ArrayList<String> clsStrings = this.domain.getDirectSubClasses(this.domain.getClass(this.uri));
        for (String str : clsStrings) {
            if (this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/Schema.owl#") || this.domain.getClass(str).asOWLClass().getIRI().getNamespace().equalsIgnoreCase("https://blulab-utah.github.io/ontologies/v2/ConText.owl#")) continue;
            children.add(new Variable(str, this.domain));
        }
        return children;
    }

    public ArrayList<String> getAllParents() {
        ArrayList<String> parentAncestry = new ArrayList();
        parentAncestry = this.domain.getAllSuperClasses(this.domain.getClass(this.uri), false);
        return parentAncestry;
    }

    public List<ClassPath> getClassPaths() {
        return DomainOntology.getRootClassPaths(this.domain.getClass(this.uri));
    }

    public String toString() {
        return "Variable [varID=" + this.getVarID() + ", varName=" + this.getVarName() + ", type= " + this.getVariableType() + ", anchor=" + this.getAnchor().toString() + "\n\t, modifiers=" + this.getModifiers() + "\n\t, numerics=" + this.getNumericModifiers() + "]";
    }
}

