/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.compiler;

import edu.utah.bmi.nlp.compiler.MemoryJavaFileManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.io.FileUtils;

public class ClassOutputBuffer
extends SimpleJavaFileObject {
    private String name;
    private Map<String, byte[]> classBytes;
    private File rootDir;

    ClassOutputBuffer(String name, Map<String, byte[]> classBytes, File rootDir) {
        super(MemoryJavaFileManager.toURI(name), JavaFileObject.Kind.CLASS);
        this.name = name;
        this.classBytes = classBytes;
        this.rootDir = rootDir;
    }

    @Override
    public OutputStream openOutputStream() {
        return new FilterOutputStream(new ByteArrayOutputStream()){

            @Override
            public void close() throws IOException {
                this.out.close();
                ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                ClassOutputBuffer.this.classBytes.put(ClassOutputBuffer.this.name, bos.toByteArray());
                if (ClassOutputBuffer.this.rootDir != null) {
                    File outputFile = new File(ClassOutputBuffer.this.rootDir, ClassOutputBuffer.this.name.replace(".", "/") + ".class");
                    if (!outputFile.getParentFile().exists()) {
                        FileUtils.forceMkdir(outputFile.getParentFile());
                    }
                    FileOutputStream outputStream = new FileOutputStream(outputFile);
                    bos.writeTo(outputStream);
                    outputStream.close();
                }
            }
        };
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }
}

