/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryClassLoader
extends URLClassLoader {
    public static String CURRENT_LOADER_NAME = "uima";
    public static final String DEFAULT_LOADER_NAME = "uima";
    private Map<String, byte[]> classBytes;
    private static final ConcurrentHashMap<String, MemoryClassLoader> mcLoaders = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Class> classCache = new ConcurrentHashMap();

    public static MemoryClassLoader getInstance(String name) {
        if (mcLoaders.containsKey(name)) {
            return mcLoaders.get(name);
        }
        return null;
    }

    public static MemoryClassLoader getInstance(String name, Map<String, byte[]> classBytes, String classPath, ClassLoader parent) {
        if (!mcLoaders.containsKey(name)) {
            mcLoaders.put(name, new MemoryClassLoader(classBytes, classPath, parent));
        }
        return mcLoaders.get(name);
    }

    public static MemoryClassLoader getInstance(String name, Map<String, byte[]> classBytes, String classPath) {
        return MemoryClassLoader.getInstance(name, classBytes, classPath, ClassLoader.getSystemClassLoader());
    }

    public static MemoryClassLoader getInstance(String name, Map<String, byte[]> classBytes) {
        return MemoryClassLoader.getInstance(name, classBytes, null, ClassLoader.getSystemClassLoader());
    }

    public MemoryClassLoader(Map<String, byte[]> classBytes, String classPath, ClassLoader parent) {
        super(MemoryClassLoader.toURLs(classPath, parent), parent);
        this.classBytes = classBytes;
    }

    public MemoryClassLoader(Map<String, byte[]> classBytes, String classPath) {
        this(classBytes, classPath, ClassLoader.getSystemClassLoader());
    }

    public MemoryClassLoader(Map<String, byte[]> classBytes) {
        this(classBytes, null, ClassLoader.getSystemClassLoader());
    }

    public MemoryClassLoader(Map<String, byte[]> classBytes, ClassLoader parent) {
        this(classBytes, null, parent);
    }

    public Class load(String className) throws ClassNotFoundException {
        if (!this.classCache.containsKey(className)) {
            this.classCache.put(className, this.loadClass(className));
        }
        return this.classCache.get(className);
    }

    public Iterable<Class> loadAll() throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>(this.classBytes.size());
        for (String name : this.classBytes.keySet()) {
            classes.add(this.loadClass(name));
        }
        return classes;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        byte[] buf = this.classBytes.get(className);
        if (buf != null) {
            this.classBytes.put(className, null);
            return this.defineClass(className, buf, 0, buf.length);
        }
        return super.findClass(className);
    }

    private static URL[] toURLs(String classPath, ClassLoader parent) {
        if (classPath == null) {
            return new URL[0];
        }
        URL url = null;
        URL[] res = null;
        try {
            url = new File(classPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        res = new URL[]{url};
        return res;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public static void resetLoaderName() {
        CURRENT_LOADER_NAME = DEFAULT_LOADER_NAME;
    }
}

