/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.compiler;

import edu.utah.bmi.nlp.compiler.MemoryClassLoader;
import edu.utah.bmi.nlp.compiler.MemoryJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class MemoryJavaCompiler {
    private JavaCompiler tool;
    private StandardJavaFileManager stdManager;
    private File outputDir = new File("target/classes");
    private MemoryJavaFileManager fileManager;
    private List<JavaFileObject> compUnits;
    private Map<String, Class> compiledClasses;

    public MemoryJavaCompiler(Object ... paras) {
        if (paras != null && paras.length > 0) {
            this.outputDir = (File)paras[0];
        }
        if (paras != null && paras.length > 1 && paras[1] instanceof Map) {
            this.compiledClasses = (Map)paras[1];
        }
        this.tool = ToolProvider.getSystemJavaCompiler();
        if (this.tool == null) {
            throw new RuntimeException("Could not get Java compiler. Please, ensure that JDK is used instead of JRE.");
        }
        this.stdManager = this.tool.getStandardFileManager(null, null, null);
        this.fileManager = this.outputDir != null ? new MemoryJavaFileManager(this.stdManager, this.outputDir) : new MemoryJavaFileManager(this.stdManager, new Object[0]);
        this.compUnits = new ArrayList<JavaFileObject>();
        this.compiledClasses = new HashMap<String, Class>();
    }

    public Class compileClass(String className, String source) throws ClassNotFoundException {
        Map<String, byte[]> classBytes = this.compile(className + ".java", source);
        MemoryClassLoader classLoader = new MemoryClassLoader(classBytes);
        Class<?> clazz = classLoader.loadClass(className);
        return clazz;
    }

    public Method compileStaticMethod(String methodName, String className, String source) throws ClassNotFoundException {
        Method[] methods;
        Map<String, byte[]> classBytes = this.compile(className + ".java", source);
        MemoryClassLoader classLoader = new MemoryClassLoader(classBytes);
        Class<?> clazz = classLoader.loadClass(className);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        throw new NoSuchMethodError(methodName);
    }

    public Map<String, byte[]> compile(String fileName, String source) {
        return this.compile(fileName, source, (Writer)new PrintWriter(System.err), null, null);
    }

    private String readPackageName(String src) {
        int begin = src.indexOf("\npackage ") + 8;
        int end = src.indexOf(";", begin);
        return src.substring(begin, end).trim();
    }

    private String readClassName(String src) {
        int begin = src.indexOf("\npublic class ") + 13;
        int end = src.indexOf("\n", begin);
        src = src.substring(begin, end).trim();
        end = src.indexOf(" ");
        return src.substring(0, end);
    }

    public void addClassSrc(String source) {
        String classCanonicalName = "";
        String packageName = this.readPackageName(source);
        classCanonicalName = this.readClassName(source);
        if (packageName.length() > 0) {
            classCanonicalName = packageName + "." + classCanonicalName;
        }
        this.compUnits.add(MemoryJavaFileManager.makeStringSource(classCanonicalName + ".java", source));
    }

    public void addClassSrc(String classCanonicalName, String source) {
        this.compUnits.add(MemoryJavaFileManager.makeStringSource(classCanonicalName + ".java", source));
    }

    public Map<String, Class> compileBatch() {
        return this.compileBatch("uima");
    }

    public Map<String, Class> compileBatch(String compilerName) {
        Map<String, byte[]> batchClassBytes = this.compile(this.compUnits, this.fileManager, (Writer)new PrintWriter(System.err), null, null);
        MemoryClassLoader classLoader = MemoryClassLoader.getInstance(compilerName, batchClassBytes);
        try {
            classLoader.addURL(this.outputDir.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        for (String className : batchClassBytes.keySet()) {
            try {
                if (this.compiledClasses.containsKey(className)) continue;
                this.compiledClasses.put(className, classLoader.load(className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.compiledClasses;
    }

    public Map<String, Class> compileBatchToSystem() {
        return this.compileBatchToSystem(MemoryClassLoader.CURRENT_LOADER_NAME);
    }

    public Map<String, Class> compileBatchToSystem(String compilerName) {
        Map<String, byte[]> batchClassBytes = this.compile(this.compUnits, this.fileManager, (Writer)new PrintWriter(System.err), null, null);
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        MemoryClassLoader classLoader = MemoryClassLoader.getInstance(compilerName, batchClassBytes, this.outputDir.getPath(), systemLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
        for (String className : batchClassBytes.keySet()) {
            try {
                if (this.compiledClasses.containsKey(className)) continue;
                this.compiledClasses.put(className, classLoader.load(className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.compiledClasses;
    }

    public void addClassPath() {
        ClassLoader systemLoader = Thread.currentThread().getContextClassLoader();
        MemoryClassLoader classLoader = new MemoryClassLoader(new HashMap<String, byte[]>(), this.outputDir.getPath(), systemLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
        compUnits.add(MemoryJavaFileManager.makeStringSource(fileName, source));
        return this.compile(compUnits, this.fileManager, err, sourcePath, classPath);
    }

    private Map<String, byte[]> compile(List<JavaFileObject> compUnits, MemoryJavaFileManager fileManager, Writer err, String sourcePath, String classPath) {
        JavaCompiler.CompilationTask task;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:all");
        options.add("-deprecation");
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(sourcePath);
        }
        if (classPath != null) {
            options.add("-classpath");
            options.add(classPath);
        }
        if (!(task = this.tool.getTask(err, fileManager, diagnostics, options, null, compUnits)).call().booleanValue()) {
            PrintWriter perr = new PrintWriter(err);
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                perr.println(diagnostic);
            }
            perr.flush();
            return null;
        }
        Map<String, byte[]> classBytes = fileManager.getClassBytes();
        try {
            fileManager.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classBytes;
    }
}

