/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.compiler;

import edu.utah.bmi.nlp.compiler.ClassOutputBuffer;
import edu.utah.bmi.nlp.compiler.StringInputBuffer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

final class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private static final String EXT = ".java";
    private static File rootDir = null;
    private Map<String, byte[]> classBytes = new HashMap<String, byte[]>();

    public MemoryJavaFileManager(JavaFileManager fileManager, Object ... paras) {
        super(fileManager);
        if (paras.length > 0) {
            if (paras[0] instanceof File) {
                rootDir = (File)paras[0];
            } else {
                throw new RuntimeException("The 1st parameter should be a File class");
            }
        }
        if (paras.length > 1) {
            if (paras[1] instanceof Map) {
                this.classBytes = (Map)paras[1];
            } else {
                throw new RuntimeException("The 2nd parameter should be a Map<String, byte[]>");
            }
        }
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classBytes;
    }

    @Override
    public void close() throws IOException {
        this.classBytes = null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            ClassOutputBuffer classOutputBuffer = new ClassOutputBuffer(className, this.classBytes, rootDir);
            return classOutputBuffer;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    static JavaFileObject makeStringSource(String fileName, String code) {
        return new StringInputBuffer(fileName, code);
    }

    static URI toURI(String name) {
        File file = new File(name);
        if (file.exists()) {
            return file.toURI();
        }
        try {
            StringBuilder newUri = new StringBuilder();
            newUri.append("mfm:///");
            newUri.append(name.replace('.', '/'));
            if (name.endsWith(EXT)) {
                newUri.replace(newUri.length() - EXT.length(), newUri.length(), EXT);
            }
            return URI.create(newUri.toString());
        }
        catch (Exception exp) {
            return URI.create("mfm:///com/sun/script/java/java_source");
        }
    }
}

