/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

import edu.utah.bmi.nlp.core.TypeDefinition;
import java.util.LinkedHashMap;

public class AnnotationDefinition
extends TypeDefinition {
    public LinkedHashMap<String, Object> featureValues = new LinkedHashMap();

    public AnnotationDefinition(String typeName, String superTypeName) {
        super(typeName, superTypeName);
    }

    public AnnotationDefinition(String typeName, String superTypeName, LinkedHashMap<String, Object> newFeatureValues) {
        super(typeName, superTypeName);
        this.featureValues = newFeatureValues;
        this.updateLegacyFeatureValues(newFeatureValues);
    }

    public AnnotationDefinition(TypeDefinition typeDefinition) {
        super(typeDefinition.fullTypeName, typeDefinition.fullSuperTypeName, (LinkedHashMap)typeDefinition.getFeatureValuePairs().clone());
        for (String featureName : this.featureDefaultValues.keySet()) {
            this.featureValues.put(featureName, this.featureDefaultValues.get(featureName));
        }
    }

    private void updateLegacyFeatureValues(LinkedHashMap<String, Object> newFeatureValues) {
        for (String featureName : newFeatureValues.keySet()) {
            Object value = newFeatureValues.get(featureName);
            if (!(value instanceof String)) continue;
            this.featureDefaultValues.put(featureName, (String)value);
        }
    }

    public LinkedHashMap<String, Object> getFullFeatureValuePairs() {
        return this.featureValues;
    }

    public void setFeatureValues(LinkedHashMap<String, Object> featureValues) {
        this.featureValues = featureValues;
        this.updateLegacyFeatureValues(featureValues);
    }

    public void setFeatureValue(String feature, Object value) {
        this.featureValues.put(feature, value);
        if (value instanceof String) {
            this.featureDefaultValues.put(feature, (String)value);
        }
    }

    public Object getFeatureValue(String feature) {
        return this.featureValues.getOrDefault(feature, null);
    }

    @Override
    public AnnotationDefinition clone() {
        return new AnnotationDefinition(this.fullTypeName, this.fullSuperTypeName, (LinkedHashMap)this.featureValues.clone());
    }
}

