/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.Rule;
import edu.utah.bmi.nlp.core.TypeDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class IOUtil {
    public ArrayList<ArrayList<String>> ruleCells;
    public ArrayList<ArrayList<String>> initiations;
    public char splitter;
    protected StringBuilder concatenatedRuleStr = new StringBuilder();
    public LinkedHashMap<String, String> settings;

    public IOUtil() {
    }

    public IOUtil(String ruleStr, boolean includeLineNumber) {
        this.readCells(ruleStr, includeLineNumber);
    }

    public IOUtil(String ruleStr) {
        this.readCells(ruleStr, true);
    }

    public ArrayList<ArrayList<String>> getRuleCells() {
        return this.ruleCells;
    }

    public ArrayList<ArrayList<String>> getInitiations() {
        return this.initiations;
    }

    public LinkedHashMap<String, String> getSettings() {
        return this.settings;
    }

    public String getSetting(String settingName) {
        return this.settings.getOrDefault(settingName, "");
    }

    public void readCells(String ruleStr, boolean includeLineNumber) {
        this.ruleCells = new ArrayList();
        this.settings = new LinkedHashMap();
        this.initiations = new ArrayList();
        String extensionName = ruleStr.substring(ruleStr.length() - 5).toLowerCase();
        try {
            if (extensionName.endsWith(".xlsx")) {
                this.readExcel(ruleStr, includeLineNumber);
            } else {
                this.readCSV(ruleStr, extensionName, includeLineNumber);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCSV(String ruleStr, String extensionName, boolean includeLineNumber) throws IOException {
        LineIterator lineIterator;
        int lineNumber = 0;
        CSVParser recordsIterator = null;
        if (extensionName.endsWith(".csv")) {
            this.settings.put("splitter", ",");
            lineIterator = FileUtils.lineIterator(new File(ruleStr));
        } else if (extensionName.endsWith(".tsv") || extensionName.endsWith(".txt")) {
            this.settings.put("splitter", "\t");
            lineIterator = FileUtils.lineIterator(new File(ruleStr));
        } else {
            if (ruleStr.indexOf("@splitter") == -1 && ruleStr.indexOf("&splitter") == -1) {
                this.settings.put("splitter", "\t");
            }
            lineIterator = IOUtils.lineIterator(new StringReader(ruleStr));
        }
        while (lineIterator.hasNext()) {
            ++lineNumber;
            String line = (String)lineIterator.next();
            if ((line.startsWith("@") || line.startsWith("&")) && Character.isLowerCase(line.charAt(1))) {
                String[] settingValue = line.substring(1).split(":");
                String value = "";
                if (settingValue.length > 1) {
                    value = settingValue[1];
                }
                if (value.length() > 1) {
                    value = value.trim();
                }
                if (!value.equals("") || !settingValue[0].trim().equals("splitter")) {
                    this.settings.put(settingValue[0].trim(), value);
                    continue;
                }
                this.settings.put("splitter", "\t");
                continue;
            }
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith("\"#")) continue;
            recordsIterator = CSVParser.parse(line, CSVFormat.newFormat(this.settings.get("splitter").charAt(0)));
            CSVRecord row = (CSVRecord)recordsIterator.iterator().next();
            ArrayList<String> cellsInRow = new ArrayList<String>();
            if (includeLineNumber) {
                cellsInRow.add(lineNumber + "");
            }
            for (String cell : row) {
                cellsInRow.add(cell);
            }
            if (includeLineNumber) {
                this.saveCellsInRow(cellsInRow, 1, lineNumber);
                continue;
            }
            this.saveCellsInRow(cellsInRow, 0, lineNumber);
        }
    }

    private void readExcel(String fileName, boolean includeLineNumber) throws IOException {
        int lineNumber = 0;
        FileInputStream inputStream = new FileInputStream(new File(fileName));
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        Sheet firstSheet = workbook.getSheetAt(0);
        Iterator iterator2 = firstSheet.iterator();
        while (iterator2.hasNext()) {
            ++lineNumber;
            Row nextRow = (Row)iterator2.next();
            ArrayList<String> cellsInRow = new ArrayList<String>();
            if (includeLineNumber) {
                cellsInRow.add(lineNumber + "");
            }
            int blankCellPos = -1;
            int lastCellId = nextRow.getLastCellNum();
            for (int i = 0; i < lastCellId; ++i) {
                Cell cell = nextRow.getCell(i);
                String value = "";
                if (cell != null) {
                    cell.setCellType(CellType.STRING);
                    value = cell.getStringCellValue();
                }
                if (value.startsWith("#")) break;
                if (value.trim().length() == 0) {
                    if (blankCellPos == -1) {
                        blankCellPos = cellsInRow.size();
                    }
                } else if (blankCellPos > -1) {
                    blankCellPos = -1;
                }
                cellsInRow.add(value);
            }
            if (blankCellPos > -1 && cellsInRow.size() > blankCellPos) {
                for (int j = cellsInRow.size() - 1; j >= blankCellPos; --j) {
                    cellsInRow.remove(j);
                }
            }
            if (includeLineNumber) {
                if (cellsInRow.size() <= 1) continue;
                this.saveCellsInRow(cellsInRow, 1, lineNumber);
                continue;
            }
            if (cellsInRow.size() <= 0) continue;
            this.saveCellsInRow(cellsInRow, 0, lineNumber);
        }
    }

    public String getConcatenatedRuleStr() {
        return this.concatenatedRuleStr.toString();
    }

    private void saveCellsInRow(ArrayList<String> cellsInRow, int offset, int lineNumber) {
        if (cellsInRow.size() == offset) {
            return;
        }
        if (cellsInRow.get(offset).startsWith("@") || cellsInRow.get(offset).startsWith("&")) {
            if (Character.isLowerCase(cellsInRow.get(offset).charAt(1))) {
                String[] settingValue = cellsInRow.get(offset).substring(1).split(":");
                String value = "";
                if (settingValue.length > 1) {
                    value = settingValue[1];
                }
                if (value.length() > 1) {
                    value = value.trim();
                }
                this.settings.put(settingValue[0].trim(), value);
            } else {
                this.initiations.add(cellsInRow);
            }
        } else {
            this.concatenatedRuleStr.append(cellsInRow.get(offset)).append("\n");
            this.ruleCells.add(cellsInRow);
        }
    }

    @Deprecated
    public ArrayList<ArrayList<String>> getCellsInList(String ruleStr) {
        return this.getCellsInList(ruleStr, 3, true);
    }

    @Deprecated
    public ArrayList<ArrayList<String>> getCellsInList(String ruleStr, int firstNLineAsSetting, boolean includeLineNumber) {
        ArrayList<ArrayList<String>> cells = new ArrayList<ArrayList<String>>();
        this.getCellsInList(ruleStr, 3, true, cells);
        return cells;
    }

    @Deprecated
    public void getCellsInList(String ruleStr, int firstNLineAsSetting, boolean includeLineNumber, ArrayList<ArrayList<String>> cells) {
        int lineNumber = firstNLineAsSetting;
        for (CSVRecord csvRecord : this.getCells(ruleStr, firstNLineAsSetting)) {
            ArrayList<String> cellinRow = new ArrayList<String>();
            ++lineNumber;
            if (csvRecord.get(0).startsWith("#") || csvRecord.get(0).startsWith("\"#") || csvRecord.get(0).trim().length() == 0) continue;
            if (includeLineNumber) {
                cellinRow.add(lineNumber + "");
            }
            for (String cell : csvRecord) {
                cellinRow.add(cell);
            }
            cells.add(cellinRow);
        }
    }

    @Deprecated
    public Iterable<CSVRecord> getCells(String ruleStr, int firstNLineAsSetting) {
        this.settings = new LinkedHashMap();
        CSVParser recordsIterator = null;
        String extensionName = ruleStr.substring(ruleStr.length() - 5).toLowerCase();
        if (extensionName.endsWith(".csv") || extensionName.endsWith(".tsv")) {
            try {
                ruleStr = FileUtils.readFileToString(new File(ruleStr));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int begin = this.readFirstNLines(ruleStr, firstNLineAsSetting, this.settings);
        String splitterStr = this.settings.get("splitter:");
        this.splitter = (char)(splitterStr == null || splitterStr.length() == 0 ? 9 : (int)splitterStr.charAt(0));
        try {
            recordsIterator = CSVParser.parse(ruleStr.substring(begin), CSVFormat.newFormat(this.splitter));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return recordsIterator;
    }

    @Deprecated
    private int readFirstNLines(String ruleStr, int n, LinkedHashMap<String, String> settings) {
        int i;
        int lineNumber = 0;
        char[] ruleChars = ruleStr.toCharArray();
        StringBuilder tmp = new StringBuilder();
        String key = "";
        boolean startRule = false;
        boolean tabed = false;
        block7: for (i = 0; i < ruleChars.length && lineNumber < n; ++i) {
            char thisChar = ruleChars[i];
            switch (thisChar) {
                case '\n': {
                    if (key.length() > 0) {
                        settings.put(key, tmp.toString());
                        key = "";
                        tmp.setLength(0);
                        startRule = false;
                        tabed = false;
                        ++lineNumber;
                        continue block7;
                    }
                    if (tabed || tmp.length() <= 0) continue block7;
                    key = tmp.toString().trim();
                    settings.put(key, "\t");
                    tmp.setLength(0);
                    startRule = false;
                    ++lineNumber;
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '\t': {
                    if (tmp.length() > 0) {
                        key = tmp.toString().trim();
                        tmp.setLength(0);
                    }
                    tabed = true;
                    continue block7;
                }
                case '&': 
                case '@': {
                    if (startRule) continue block7;
                    startRule = true;
                    continue block7;
                }
                case '#': {
                    continue block7;
                }
                default: {
                    if (!startRule) continue block7;
                    tmp.append(thisChar);
                }
            }
        }
        return i;
    }

    @Deprecated
    public static HashMap<Integer, Rule> parseRuleStr(String ruleStr, String splitter, boolean caseSensitive) {
        HashMap<Integer, Rule> rules = new HashMap<Integer, Rule>();
        int strLength = ruleStr.trim().length();
        String testFileStr = ruleStr.trim().substring(strLength - 4).toLowerCase();
        boolean[] thisRuleType = new boolean[]{false, false, false};
        LinkedHashMap<String, TypeDefinition> typeDefinition = new LinkedHashMap<String, TypeDefinition>();
        thisRuleType = testFileStr.equals(".tsv") || testFileStr.equals(".csv") || testFileStr.equals("xlsx") || testFileStr.equals(".owl") ? IOUtil.readAgnosticFile(ruleStr, rules, typeDefinition, caseSensitive) : IOUtil.readCSVString(ruleStr, rules, typeDefinition, splitter, caseSensitive, thisRuleType);
        return rules;
    }

    @Deprecated
    public static boolean[] readAgnosticFile(String agnosticFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive) {
        boolean[] thisRuleType = new boolean[]{false, false, false, false};
        IOUtil.readAgnosticFile(agnosticFileName, rules, typeDefinition, caseSensitive, thisRuleType);
        return thisRuleType;
    }

    @Deprecated
    public static String readAgnosticString(String inputStr) {
        File agnosticFile = new File(inputStr);
        if (agnosticFile.exists()) {
            String extension = FilenameUtils.getExtension(inputStr).toLowerCase();
            try {
                switch (extension) {
                    case "csv": {
                        inputStr = FileUtils.readFileToString(agnosticFile);
                        break;
                    }
                    case "tsv": {
                        inputStr = FileUtils.readFileToString(agnosticFile);
                        break;
                    }
                    case "txt": {
                        inputStr = FileUtils.readFileToString(agnosticFile);
                        break;
                    }
                    default: {
                        System.err.println("File format not supported: " + agnosticFile.getAbsolutePath());
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return inputStr;
    }

    @Deprecated
    public static boolean[] readAgnosticFile(String agnosticFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] thisRuleType) {
        File agnosticFile = new File(agnosticFileName);
        if (agnosticFile.exists()) {
            if (FilenameUtils.getExtension(agnosticFileName).equals("csv")) {
                thisRuleType = IOUtil.readCSVFile(agnosticFileName, rules, typeDefinition, CSVFormat.DEFAULT, caseSensitive, thisRuleType);
            } else if (FilenameUtils.getExtension(agnosticFileName).equals("tsv")) {
                thisRuleType = IOUtil.readCSVFile(agnosticFileName, rules, typeDefinition, CSVFormat.TDF, caseSensitive, thisRuleType);
            }
        }
        return thisRuleType;
    }

    @Deprecated
    public static boolean[] readCSVFile(String csvFileName, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, CSVFormat csvFormat, boolean caseSensitive, boolean[] ruleSupports) {
        try {
            CSVParser recordsIterator = CSVParser.parse(new File(csvFileName), StandardCharsets.UTF_8, csvFormat);
            ruleSupports = IOUtil.readCSV(recordsIterator, rules, typeDefinition, caseSensitive, ruleSupports);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ruleSupports;
    }

    @Deprecated
    public static boolean[] readCSVString(String csvString, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, String splitter, boolean caseSensitive, boolean[] ruleSupports) {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        if (splitter.equals("\t")) {
            csvFormat = CSVFormat.TDF;
        }
        ruleSupports = IOUtil.readCSVString(csvString, rules, typeDefinition, csvFormat, caseSensitive, ruleSupports);
        return ruleSupports;
    }

    @Deprecated
    public static boolean[] readCSVString(String csvString, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, CSVFormat csvFormat, boolean caseSensitive, boolean[] ruleSupports) {
        try {
            CSVParser recordsIterator = CSVParser.parse(csvString, csvFormat);
            ruleSupports = IOUtil.readCSV(recordsIterator, rules, typeDefinition, caseSensitive, ruleSupports);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ruleSupports;
    }

    @Deprecated
    private static boolean[] readCSV(Iterable<CSVRecord> recordsIterator, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] ruleSupports) {
        int id = 0;
        for (CSVRecord record : recordsIterator) {
            ArrayList<String> cells = new ArrayList<String>();
            for (String cell : record) {
                cells.add(cell);
            }
            ruleSupports = IOUtil.parseCells(cells, id, rules, typeDefinition, caseSensitive, ruleSupports);
            ++id;
        }
        return ruleSupports;
    }

    @Deprecated
    private static boolean[] parseCells(ArrayList<String> cells, int id, HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, boolean caseSensitive, boolean[] ruleSupports) {
        if (cells.get(0).startsWith("#") || cells.get(0).startsWith("\"#") || cells.get(0).trim().length() == 0) {
            return ruleSupports;
        }
        if (cells.get(0).startsWith("@") || cells.get(0).startsWith("&")) {
            if (cells.size() == 1) {
                ruleSupports[0] = IOUtil.checkFastCRule(cells.get(0));
            } else if (cells.size() > 1) {
                cells.set(0, cells.get(0).substring(1));
                typeDefinition.put(DeterminantValueSet.getShortName(cells.get(0)), new TypeDefinition(cells));
            }
            return ruleSupports;
        }
        if (cells.size() > 2) {
            String rule = cells.get(0);
            String conceptShortName = DeterminantValueSet.getShortName(cells.get(2).trim());
            if (!typeDefinition.containsKey(conceptShortName)) {
                typeDefinition.put(conceptShortName, new TypeDefinition(cells.get(2).trim(), DeterminantValueSet.defaultSuperTypeName, new ArrayList<String>()));
            }
            ruleSupports = IOUtil.addRule(rules, typeDefinition, new Rule(id, caseSensitive ? rule : rule.toLowerCase(), cells.get(2).trim(), Double.parseDouble(cells.get(1)), cells.size() > 3 ? DeterminantValueSet.Determinants.valueOf(cells.get(3)) : DeterminantValueSet.Determinants.ACTUAL), ruleSupports);
        } else {
            System.out.println("Definition format error: line " + id + "\t\t" + cells);
        }
        return ruleSupports;
    }

    @Deprecated
    public static HashMap<Integer, Rule> readCRuleString(String ruleString, String splitter) {
        int id = 0;
        HashMap<Integer, Rule> rules = new HashMap<Integer, Rule>();
        for (String rule : ruleString.split("\n")) {
            rule = rule.trim();
            ++id;
            if (rule.length() < 1 || rule.startsWith("#") || rule.startsWith("\"#")) continue;
            String[] definition = rule.split(splitter);
            DeterminantValueSet.Determinants determinant = DeterminantValueSet.Determinants.ACTUAL;
            if (definition.length > 3) {
                determinant = DeterminantValueSet.Determinants.valueOf(definition[3]);
            }
            if (definition.length > 2) {
                definition[2] = DeterminantValueSet.checkNameSpace(definition[2]);
            } else if (!rule.trim().startsWith("#")) {
                System.out.println("Definition format error: line " + id + "\t\t" + rule);
                continue;
            }
            rules.put(id, new Rule(id, definition[0], definition[2].trim(), Double.parseDouble(definition[1]), determinant));
        }
        return rules;
    }

    @Deprecated
    private static boolean[] addRule(HashMap<Integer, Rule> rules, LinkedHashMap<String, TypeDefinition> typeDefinition, Rule rule, boolean[] ruleSupports) {
        if (!ruleSupports[1] && rule.rule.indexOf("(") != -1) {
            ruleSupports[1] = true;
        }
        if (!ruleSupports[2] && rule.rule.indexOf("[") != -1) {
            ruleSupports[2] = true;
        }
        if (!ruleSupports[3] && rule.rule.indexOf("+") != -1) {
            ruleSupports[3] = true;
        }
        rules.put(rule.id, rule);
        return ruleSupports;
    }

    @Deprecated
    private static boolean checkFastCRule(String ruleString) {
        int end;
        int begin = ruleString.indexOf("@");
        if (begin == -1) {
            begin = ruleString.indexOf("&");
        }
        String definition = ruleString.substring(begin, (end = ruleString.indexOf("\n", begin)) == -1 ? ruleString.length() : end).toLowerCase();
        return definition.indexOf("fastc") != -1;
    }

    @Deprecated
    public static LinkedHashMap<String, TypeDefinition> readTypeDefinitions(ArrayList<ArrayList<String>> cells) {
        return IOUtil.readTypeDefinitions(cells, new HashMap<String, String>());
    }

    @Deprecated
    public static LinkedHashMap<String, TypeDefinition> readTypeDefinitions(ArrayList<ArrayList<String>> cells, HashMap<String, String> valueFeatureMap) {
        LinkedHashMap<String, TypeDefinition> typeDefinitions = new LinkedHashMap<String, TypeDefinition>();
        for (ArrayList<String> row : cells) {
            String[] featureValuePair;
            int i;
            TypeDefinition typeDefinition;
            String superTypeName;
            String typeName;
            if (!row.get(1).startsWith("@") && !row.get(1).startsWith("&")) break;
            if (row.get(1).substring(1).startsWith("CONCEPT_FEATURES")) {
                typeName = row.get(2).substring(1);
                superTypeName = row.get(3);
                typeDefinition = new TypeDefinition(typeName, superTypeName, new ArrayList<String>());
                if (row.size() > 4) {
                    for (i = 4; i < row.size(); ++i) {
                        featureValuePair = row.get(i).split(":");
                        typeDefinition.addFeatureDefaultValue(featureValuePair[0].trim(), featureValuePair[1].trim());
                    }
                }
                typeDefinitions.put(typeDefinition.shortTypeName, typeDefinition);
                continue;
            }
            if (row.get(1).substring(1).startsWith("FEATURE_VALUES")) {
                String featureName = row.get(2);
                for (int i2 = 3; i2 < row.size(); ++i2) {
                    String value = row.get(i2);
                    if (valueFeatureMap.containsKey(value)) {
                        System.err.println("You have more than one features have the value: " + value + ". You won't be able to use the value alone to define the conditions.Instead, you will need to use 'FeatureName:value' format.");
                        continue;
                    }
                    valueFeatureMap.put(value, featureName);
                }
                continue;
            }
            typeName = row.get(1).substring(1);
            superTypeName = row.get(2);
            typeDefinition = new TypeDefinition(typeName, superTypeName, new ArrayList<String>());
            if (row.size() > 3) {
                for (i = 3; i < row.size(); ++i) {
                    featureValuePair = row.get(i).split(":");
                    typeDefinition.addFeatureDefaultValue(featureValuePair[0].trim(), featureValuePair[1].trim());
                }
            }
            typeDefinitions.put(typeDefinition.shortTypeName, typeDefinition);
        }
        return typeDefinitions;
    }

    @Deprecated
    public LinkedHashMap<String, TypeDefinition> readTypeDefinitions(String ruleStr, int firstNLineAsSetting, boolean includeLineNumber) {
        ArrayList<ArrayList<String>> cells = this.getCellsInList(ruleStr, firstNLineAsSetting, includeLineNumber);
        LinkedHashMap<String, TypeDefinition> typeDefinitions = IOUtil.readTypeDefinitions(cells);
        return typeDefinitions;
    }

    public static Logger getLogger(String className) {
        Logger logger = Logger.getLogger(className);
        try {
            if (new File("logging.properties").exists()) {
                if (System.getProperty("java.util.logging.config.file") == null) {
                    System.setProperty("java.util.logging.config.file", "logging.properties");
                }
                LogManager.getLogManager().readConfiguration(new FileInputStream(new File("logging.properties")));
            } else {
                LogManager.getLogManager().readConfiguration();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return logger;
    }

    public static Logger getLogger(Class cls) {
        return IOUtil.getLogger(cls.getCanonicalName());
    }
}

