/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

public class Interval1D
implements Comparable<Interval1D> {
    public final int min;
    public final int max;

    public Interval1D(int min2, int max) {
        if (min2 > max) {
            throw new RuntimeException("Illegal interval");
        }
        this.min = min2;
        this.max = max;
    }

    public boolean intersects(Interval1D that) {
        if (that.max < this.min) {
            return false;
        }
        return this.max >= that.min;
    }

    public boolean contains(int x) {
        return this.min <= x && x <= this.max;
    }

    @Override
    public int compareTo(Interval1D that) {
        if (this.min < that.min) {
            return -1;
        }
        if (this.min > that.min) {
            return 1;
        }
        if (this.max < that.max) {
            return -1;
        }
        if (this.max > that.max) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Interval1D && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

