/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.core;

import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import java.util.LinkedList;
import java.util.logging.Logger;

public class IntervalST<Value> {
    private static Logger logger = IOUtil.getLogger(IntervalST.class);
    private Node root;
    @Deprecated
    public boolean debug = false;

    public boolean contains(Interval1D interval) {
        return this.get(interval) != null;
    }

    public Value get(Interval1D interval) {
        return this.get(this.root, interval);
    }

    private Value get(Node x, Interval1D interval) {
        while (x != null) {
            if (interval.intersects(x.interval)) {
                return x.value;
            }
            if (x.left == null) {
                x = x.right;
                continue;
            }
            if (x.left.max < interval.min) {
                x = x.right;
                continue;
            }
            x = x.left;
        }
        return null;
    }

    public void put(Interval1D interval, Value value) {
        if (this.contains(interval)) {
            logger.fine("duplicate interval, remove the older one");
            this.remove(interval);
        }
        this.root = this.randomizedInsert(this.root, interval, value);
    }

    public void put(int min2, int max, Value value) {
        Interval1D interval = new Interval1D(min2, max);
        this.put(interval, value);
    }

    private Node randomizedInsert(Node x, Interval1D interval, Value value) {
        if (x == null) {
            return new Node(interval, value);
        }
        if (Math.random() * (double)this.size(x) < 1.0) {
            return this.rootInsert(x, interval, value);
        }
        int cmp = interval.compareTo(x.interval);
        if (cmp < 0) {
            x.left = this.randomizedInsert(x.left, interval, value);
        } else {
            x.right = this.randomizedInsert(x.right, interval, value);
        }
        this.fix(x);
        return x;
    }

    private Node rootInsert(Node x, Interval1D interval, Value value) {
        if (x == null) {
            return new Node(interval, value);
        }
        int cmp = interval.compareTo(x.interval);
        if (cmp < 0) {
            x.left = this.rootInsert(x.left, interval, value);
            x = this.rotR(x);
        } else {
            x.right = this.rootInsert(x.right, interval, value);
            x = this.rotL(x);
        }
        return x;
    }

    private Node joinLR(Node a, Node b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Math.random() * (double)(this.size(a) + this.size(b)) < (double)this.size(a)) {
            a.right = this.joinLR(a.right, b);
            this.fix(a);
            return a;
        }
        b.left = this.joinLR(a, b.left);
        this.fix(b);
        return b;
    }

    public Value remove(Interval1D interval) {
        Value value = this.get(interval);
        this.root = this.remove(this.root, interval);
        return value;
    }

    private Node remove(Node h2, Interval1D interval) {
        if (h2 == null) {
            return null;
        }
        int cmp = interval.compareTo(h2.interval);
        if (cmp < 0) {
            h2.left = this.remove(h2.left, interval);
        } else if (cmp > 0) {
            h2.right = this.remove(h2.right, interval);
        } else {
            h2 = this.joinLR(h2.left, h2.right);
        }
        this.fix(h2);
        return h2;
    }

    public Interval1D search(Interval1D interval) {
        return this.search(this.root, interval);
    }

    public Interval1D search(Node x, Interval1D interval) {
        while (x != null) {
            if (interval.intersects(x.interval)) {
                return x.interval;
            }
            if (x.left == null) {
                x = x.right;
                continue;
            }
            if (x.left.max < interval.min) {
                x = x.right;
                continue;
            }
            x = x.left;
        }
        return null;
    }

    public Iterable<Value> getAll(Interval1D interval) {
        LinkedList list = new LinkedList();
        this.getAll(this.root, interval, list);
        return list;
    }

    public LinkedList<Value> getAllAsList(Interval1D interval) {
        LinkedList list = new LinkedList();
        this.getAll(this.root, interval, list);
        return list;
    }

    public boolean getAll(Node x, Interval1D interval, LinkedList<Value> list) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        if (x == null) {
            return false;
        }
        if (interval.intersects(x.interval)) {
            list.add(x.value);
            found1 = true;
        }
        if (x.left != null && x.left.max >= interval.min) {
            found2 = this.getAll(x.left, interval, list);
        }
        if (found2 || x.left == null || x.left.max < interval.min) {
            found3 = this.getAll(x.right, interval, list);
        }
        return found1 || found2 || found3;
    }

    public Iterable<Interval1D> searchAll(Interval1D interval) {
        LinkedList<Interval1D> list = new LinkedList<Interval1D>();
        this.searchAll(this.root, interval, list);
        return list;
    }

    public LinkedList<Interval1D> searchAllAsList(Interval1D interval) {
        LinkedList<Interval1D> list = new LinkedList<Interval1D>();
        this.searchAll(this.root, interval, list);
        return list;
    }

    public boolean searchAll(Node x, Interval1D interval, LinkedList<Interval1D> list) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        if (x == null) {
            return false;
        }
        if (interval.intersects(x.interval)) {
            list.add(x.interval);
            found1 = true;
        }
        if (x.left != null && x.left.max >= interval.min) {
            found2 = this.searchAll(x.left, interval, list);
        }
        if (found2 || x.left == null || x.left.max < interval.min) {
            found3 = this.searchAll(x.right, interval, list);
        }
        return found1 || found2 || found3;
    }

    public int size() {
        return this.size(this.root);
    }

    private int size(Node x) {
        if (x == null) {
            return 0;
        }
        return x.N;
    }

    public int height() {
        return this.height(this.root);
    }

    private int height(Node x) {
        if (x == null) {
            return 0;
        }
        return 1 + Math.max(this.height(x.left), this.height(x.right));
    }

    private void fix(Node x) {
        if (x == null) {
            return;
        }
        x.N = 1 + this.size(x.left) + this.size(x.right);
        x.max = this.max3(x.interval.max, this.max(x.left), this.max(x.right));
    }

    private int max(Node x) {
        if (x == null) {
            return Integer.MIN_VALUE;
        }
        return x.max;
    }

    private int max3(int a, int b, int c) {
        return Math.max(a, Math.max(b, c));
    }

    private Node rotR(Node h2) {
        Node x = h2.left;
        h2.left = x.right;
        x.right = h2;
        this.fix(h2);
        this.fix(x);
        return x;
    }

    private Node rotL(Node h2) {
        Node x = h2.right;
        h2.right = x.left;
        x.left = h2;
        this.fix(h2);
        this.fix(x);
        return x;
    }

    public boolean check() {
        return this.checkCount() && this.checkMax();
    }

    private boolean checkCount() {
        return this.checkCount(this.root);
    }

    private boolean checkCount(Node x) {
        if (x == null) {
            return true;
        }
        return this.checkCount(x.left) && this.checkCount(x.right) && x.N == 1 + this.size(x.left) + this.size(x.right);
    }

    private boolean checkMax() {
        return this.checkMax(this.root);
    }

    private boolean checkMax(Node x) {
        if (x == null) {
            return true;
        }
        return x.max == this.max3(x.interval.max, this.max(x.left), this.max(x.right));
    }

    public String toString() {
        return this.root.toString();
    }

    private class Node {
        Interval1D interval;
        Value value;
        Node left;
        Node right;
        int N;
        int max;

        Node(Interval1D interval, Value value) {
            this.interval = interval;
            this.value = value;
            this.N = 1;
            this.max = interval.max;
        }

        public String toString(int level) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Inv(%d, %d, d=%s)", this.interval.min, this.interval.max, this.value));
            sb.append("\n");
            if (this.left != null) {
                sb.append("l: " + String.format("%" + (level + 1) * 2 + "s", "") + this.left.toString(level + 1));
            }
            if (this.right != null) {
                sb.append("r: " + String.format("%" + (level + 1) * 2 + "s", "") + this.right.toString(level + 1));
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString(0);
        }
    }
}

